/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayRemainBeanInterface;
import jp.mosp.time.bean.PaidHolidayTransactionReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayTransactionReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayRemainDto;
import jp.mosp.time.utils.TimeUtility;

public class PaidHolidayRemainBean
extends PlatformBean
implements PaidHolidayRemainBeanInterface {
    protected PaidHolidayDataReferenceBeanInterface paidHolidayDataRefer;
    protected PaidHolidayDataGrantBeanInterface paidHolidayDataGrant;
    protected PaidHolidayTransactionReferenceBeanInterface paidHolidayTransactionRefer;
    protected StockHolidayDataReferenceBeanInterface stockHolidayDataRefer;
    protected StockHolidayTransactionReferenceBeanInterface stockHolidayTransactionRefer;
    protected HolidayRequestReferenceBeanInterface holidayRequestRefer;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.paidHolidayDataRefer = (PaidHolidayDataReferenceBeanInterface)this.createBeanInstance(PaidHolidayDataReferenceBeanInterface.class);
        this.paidHolidayDataGrant = (PaidHolidayDataGrantBeanInterface)this.createBeanInstance(PaidHolidayDataGrantBeanInterface.class);
        this.paidHolidayTransactionRefer = (PaidHolidayTransactionReferenceBeanInterface)this.createBeanInstance(PaidHolidayTransactionReferenceBeanInterface.class);
        this.stockHolidayDataRefer = (StockHolidayDataReferenceBeanInterface)this.createBeanInstance(StockHolidayDataReferenceBeanInterface.class);
        this.stockHolidayTransactionRefer = (StockHolidayTransactionReferenceBeanInterface)this.createBeanInstance(StockHolidayTransactionReferenceBeanInterface.class);
        this.holidayRequestRefer = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
    }

    public List<HolidayRemainDto> getPaidHolidayRemainsForRequest(String personalId, Date targetDate) throws MospException {
        ArrayList<HolidayRemainDto> remains = new ArrayList<HolidayRemainDto>();
        Set statuses = WorkflowUtility.getAppliedStatuses();
        List dtos = this.paidHolidayDataRefer.getPaidHolidayDataForDate(personalId, targetDate);
        for (PaidHolidayDataDtoInterface dto : dtos) {
            remains.add(this.getPaidHolidayRemain(dto, targetDate, statuses, targetDate, null));
        }
        return remains;
    }

    public List<HolidayRemainDto> getPaidHolidayRemainsForView(String personalId, Date targetDate) throws MospException {
        ArrayList<HolidayRemainDto> remains = new ArrayList<HolidayRemainDto>();
        Set statuses = WorkflowUtility.getAppliedStatuses();
        List dtos = this.paidHolidayDataRefer.getPaidHolidayDataForDate(personalId, targetDate);
        dtos.addAll(this.paidHolidayDataRefer.findForNextInfoList(personalId, targetDate));
        for (PaidHolidayDataDtoInterface dto : dtos) {
            remains.add(this.getPaidHolidayRemain(dto, targetDate, statuses, targetDate, null));
        }
        return remains;
    }

    public List<HolidayRemainDto> getPaidHolidayRemainsForList(String personalId, Date targetDate) throws MospException {
        ArrayList<HolidayRemainDto> remains = new ArrayList<HolidayRemainDto>();
        Set statuses = WorkflowUtility.getAppliedStatuses();
        List dtos = this.paidHolidayDataRefer.getPaidHolidayDataForDate(personalId, targetDate);
        for (PaidHolidayDataDtoInterface dto : dtos) {
            remains.add(this.getPaidHolidayRemain(dto, targetDate, statuses, targetDate, targetDate));
        }
        return remains;
    }

    public HolidayRemainDto getPaidHolidayRemainForYear(String personalId, Date targetDate, int targetYear) throws MospException {
        Date firstDate = MonthUtility.getFiscalYearFirstDate((int)targetYear, (MospParams)this.mospParams);
        Date lastDate = MonthUtility.getFiscalYearLastDate((int)targetYear, (MospParams)this.mospParams);
        Set statuses = WorkflowUtility.getEffectiveStatuses();
        HolidayRemainDto remain = TimeUtility.getBarePaidHolidayRemain((Date)firstDate, (Date)targetDate);
        List dtos = this.paidHolidayDataRefer.getPaidHolidayDatas(personalId, targetDate, targetDate, firstDate);
        for (PaidHolidayDataDtoInterface dto : dtos) {
            this.setPaidHolidayRemain(remain, dto, targetDate, firstDate, lastDate, statuses);
        }
        return remain;
    }

    public Optional<HolidayRemainDto> getPaidHolidayRemainForStock(String personalId, Date targetDate) throws MospException {
        PaidHolidayDataDtoInterface paidHolidayData = this.paidHolidayDataRefer.getPaidHolidayDataForExpiration(personalId, targetDate).orElse(null);
        if (MospUtility.isEmpty((Object[])new Object[]{paidHolidayData})) {
            return Optional.ofNullable(null);
        }
        Date limitDate = paidHolidayData.getLimitDate();
        Set statuses = WorkflowUtility.getEffectiveStatuses();
        HolidayRemainDto remain = TimeUtility.getBarePaidHolidayRemain((Date)limitDate, (Date)limitDate);
        List dtos = this.paidHolidayDataRefer.getExpiredPaidHolidayDatas(personalId, limitDate);
        for (PaidHolidayDataDtoInterface dto : dtos) {
            HolidayRemainDto remainForData = this.getPaidHolidayRemain(dto, limitDate, statuses, null, null);
            remain.setRemainDays(remain.getRemainDays() + remainForData.getRemainDays());
            remain.setRemainHours(remain.getRemainHours() + remainForData.getRemainHours());
        }
        return Optional.ofNullable(remain);
    }

    public double getCarryoverDays(String personalId, Date targetDate, Date acquisitionDate) throws MospException {
        Set statuses = WorkflowUtility.getCompletedStatuses();
        Set remains = this.getCarryoverRemains(personalId, targetDate, acquisitionDate, statuses);
        return TimeUtility.getRemainDays((Collection)remains);
    }

    public int getCarryoverHours(String personalId, Date targetDate, Date acquisitionDate) throws MospException {
        Set statuses = WorkflowUtility.getCompletedStatuses();
        Set remains = this.getCarryoverRemains(personalId, targetDate, acquisitionDate, statuses);
        return TimeUtility.getRemainHours((Collection)remains);
    }

    protected void setPaidHolidayRemain(HolidayRemainDto remain, PaidHolidayDataDtoInterface dto, Date targetDate, Date firstDate, Date lastDate, Set<String> statuses) throws MospException {
        HolidayRemainDto remainForTargetDate = this.getPaidHolidayRemain(dto, targetDate, statuses, targetDate, lastDate);
        remain.setRemainDays(remain.getRemainDays() + remainForTargetDate.getRemainDays());
        remain.setRemainHours(remain.getRemainHours() + remainForTargetDate.getRemainHours());
        if (dto.getAcquisitionDate().after(firstDate)) {
            return;
        }
        Date beforeDate = DateUtility.addDay((Date)firstDate, (int)-1);
        HolidayRemainDto remainForFirstDate = this.getPaidHolidayRemain(dto, targetDate, statuses, targetDate, beforeDate);
        remain.setGivenDays(remain.getGivenDays() + remainForFirstDate.getRemainDays());
        remain.setGivenHours(remain.getGivenHours() + remainForFirstDate.getRemainHours());
    }

    protected Set<HolidayRemainDto> getCarryoverRemains(String personalId, Date targetDate, Date acquisitionDate, Set<String> statuses) throws MospException {
        int grtantTimes = this.paidHolidayDataGrant.getGrantTimes(personalId, acquisitionDate);
        Date thisAcquisitionDate = this.paidHolidayDataGrant.getGrantDate(personalId, grtantTimes);
        if (MospUtility.isEmpty((Object[])new Object[]{thisAcquisitionDate})) {
            return Collections.emptySet();
        }
        Date beforeAcquisitionDate = DateUtility.addDay((Date)thisAcquisitionDate, (int)-1);
        List dtos = this.paidHolidayDataRefer.getPaidHolidayDatas(personalId, targetDate, beforeAcquisitionDate, thisAcquisitionDate);
        return this.getPaidHolidayRemains((Collection)dtos, targetDate, statuses, targetDate, beforeAcquisitionDate);
    }

    protected Set<HolidayRemainDto> getPaidHolidayRemains(Collection<PaidHolidayDataDtoInterface> dtos, Date targetDate, Set<String> statuses, Date manualTargetDate, Date requestTargetDate) throws MospException {
        LinkedHashSet<HolidayRemainDto> remains = new LinkedHashSet<HolidayRemainDto>();
        for (PaidHolidayDataDtoInterface dto : dtos) {
            remains.add(this.getPaidHolidayRemain(dto, targetDate, statuses, manualTargetDate, requestTargetDate));
        }
        return remains;
    }

    protected HolidayRemainDto getPaidHolidayRemain(PaidHolidayDataDtoInterface dto, Date targetDate, Set<String> statuses, Date manualTargetDate, Date requestTargetDate) throws MospException {
        String personalId = dto.getPersonalId();
        Date acquisitionDate = dto.getAcquisitionDate();
        int hoursPerDay = this.timeMaster.getPaidHolidayHoursPerDay(personalId, targetDate);
        Collection transactions = this.getPaidHolidayTransactions(personalId, acquisitionDate, manualTargetDate);
        double manualDays = TimeUtility.getPaidHolidayManualDays((Collection)transactions);
        int manualHours = TimeUtility.getPaidHolidayManualHours((Collection)transactions);
        Set requests = this.getHolidayRequests(personalId, "1", acquisitionDate, statuses, requestTargetDate);
        double useDays = TimeUtility.getHolidayUseDays((Collection)requests);
        int useHours = TimeUtility.getHolidayUseHours((Collection)requests);
        return TimeUtility.getPaidHolidayRemain((PaidHolidayDataDtoInterface)dto, (double)manualDays, (int)manualHours, (double)useDays, (int)useHours, (int)hoursPerDay);
    }

    protected Collection<PaidHolidayTransactionDtoInterface> getPaidHolidayTransactions(String personalId, Date acquisitionDate, Date targetDate) throws MospException {
        return this.paidHolidayTransactionRefer.findForList(personalId, acquisitionDate, null, targetDate);
    }

    protected Set<HolidayRequestDtoInterface> getHolidayRequests(String personalId, String holidayType2, Date acquisitionDate, Set<String> statuses, Date targetDate) throws MospException {
        return this.holidayRequestRefer.getRequestsForAcquisitionDate(personalId, 1, holidayType2, acquisitionDate, statuses, targetDate);
    }

    public List<HolidayRemainDto> getStockHolidayRemainsForRequest(String personalId, Date targetDate) throws MospException {
        ArrayList<HolidayRemainDto> remains = new ArrayList<HolidayRemainDto>();
        Set statuses = WorkflowUtility.getAppliedStatuses();
        List dtos = this.stockHolidayDataRefer.getStockHolidayDataForDate(personalId, targetDate);
        for (StockHolidayDataDtoInterface dto : dtos) {
            remains.add(this.getStockHolidayRemain(dto, targetDate, statuses, targetDate, null));
        }
        return remains;
    }

    public double getStockHolidayRemainDaysForView(String personalId, Date targetDate) throws MospException {
        double remainDays = 0.0;
        List remains = this.getStockHolidayRemainsForRequest(personalId, targetDate);
        for (HolidayRemainDto remain : remains) {
            remainDays += remain.getRemainDays();
        }
        return remainDays;
    }

    public double getStockHolidayRemainDaysForList(String personalId, Date targetDate) throws MospException {
        double remainDays = 0.0;
        Set statuses = WorkflowUtility.getAppliedStatuses();
        List dtos = this.stockHolidayDataRefer.getStockHolidayDataForDate(personalId, targetDate);
        for (StockHolidayDataDtoInterface dto : dtos) {
            remainDays += this.getStockHolidayRemain(dto, targetDate, statuses, targetDate, targetDate).getRemainDays();
        }
        return remainDays;
    }

    public HolidayRemainDto getStockHolidayRemainForYear(String personalId, Date targetDate, int targetYear) throws MospException {
        Date firstDate = MonthUtility.getFiscalYearFirstDate((int)targetYear, (MospParams)this.mospParams);
        Date lastDate = MonthUtility.getFiscalYearLastDate((int)targetYear, (MospParams)this.mospParams);
        Set statuses = WorkflowUtility.getEffectiveStatuses();
        HolidayRemainDto remain = TimeUtility.getBareStockHolidayRemain((Date)firstDate, (Date)targetDate);
        List dtos = this.stockHolidayDataRefer.getStockHolidayDatas(personalId, targetDate, targetDate, firstDate);
        for (StockHolidayDataDtoInterface dto : dtos) {
            this.setStockHolidayRemain(remain, dto, targetDate, firstDate, lastDate, statuses);
        }
        return remain;
    }

    protected void setStockHolidayRemain(HolidayRemainDto remain, StockHolidayDataDtoInterface dto, Date targetDate, Date firstDate, Date lastDate, Set<String> statuses) throws MospException {
        HolidayRemainDto remainForTargetDate = this.getStockHolidayRemain(dto, targetDate, statuses, targetDate, lastDate);
        remain.setRemainDays(remain.getRemainDays() + remainForTargetDate.getRemainDays());
        if (dto.getAcquisitionDate().after(firstDate)) {
            return;
        }
        Date beforeDate = DateUtility.addDay((Date)firstDate, (int)-1);
        HolidayRemainDto remainForFirstDate = this.getStockHolidayRemain(dto, targetDate, statuses, firstDate, beforeDate);
        remain.setGivenDays(remain.getGivenDays() + remainForFirstDate.getRemainDays());
    }

    protected HolidayRemainDto getStockHolidayRemain(StockHolidayDataDtoInterface dto, Date targetDate, Set<String> statuses, Date manualTargetDate, Date requestTargetDate) throws MospException {
        String personalId = dto.getPersonalId();
        Date acquisitionDate = dto.getAcquisitionDate();
        Collection transactions = this.getStockHolidayTransactions(personalId, acquisitionDate, manualTargetDate);
        double manualDays = TimeUtility.getStockHolidayManualDays((Collection)transactions);
        Set requests = this.getHolidayRequests(personalId, "2", acquisitionDate, statuses, requestTargetDate);
        double useDays = TimeUtility.getHolidayUseDays((Collection)requests);
        return TimeUtility.getStockHolidayRemain((StockHolidayDataDtoInterface)dto, (double)manualDays, (double)useDays);
    }

    protected Collection<StockHolidayTransactionDtoInterface> getStockHolidayTransactions(String personalId, Date acquisitionDate, Date targetDate) throws MospException {
        return this.stockHolidayTransactionRefer.findForList(personalId, acquisitionDate, null, targetDate);
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
    }
}

