/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.PaidHolidayRegistBeanInterface;
import jp.mosp.time.dao.settings.ApplicationDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmPaidHolidayDto;

public class PaidHolidayRegistBean
extends PlatformBean
implements PaidHolidayRegistBeanInterface {
    protected PaidHolidayDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (PaidHolidayDaoInterface)this.createDaoInstance(PaidHolidayDaoInterface.class);
    }

    public PaidHolidayDtoInterface getInitDto() {
        return new TmmPaidHolidayDto();
    }

    public void insert(PaidHolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmPaidHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(PaidHolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmPaidHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(PaidHolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmPaidHolidayId());
        dto.setTmmPaidHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            PaidHolidayDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    PfMessageUtility.addErrorCodeNotExistBeforeDate((MospParams)this.mospParams, (String)code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setTmmPaidHolidayId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmPaidHolidayId());
            dto.setTmmPaidHolidayId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(PaidHolidayDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmPaidHolidayId());
    }

    protected void checkInsert(PaidHolidayDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPaidHolidayCode()));
    }

    protected void checkAdd(PaidHolidayDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getPaidHolidayCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPaidHolidayCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List appList = this.getApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getPaidHolidayCode(), appList);
    }

    protected void checkDelete(PaidHolidayDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmPaidHolidayId());
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmPaidHolidayId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPaidHolidayCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List appList = this.getApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getPaidHolidayCode(), appList);
    }

    protected void checkUpdate(PaidHolidayDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmPaidHolidayId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmPaidHolidayId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getPaidHolidayCode());
        List appList = this.getApplicationListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getPaidHolidayCode(), appList);
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            PaidHolidayDtoInterface dto = (PaidHolidayDtoInterface)this.dao.findForKey(id, false);
            list.add(dto.getPaidHolidayCode());
        }
        return list;
    }

    protected void validate(PaidHolidayDtoInterface dto) {
    }

    protected void checkCodeIsUsed(String code, List<ApplicationDtoInterface> list) {
        String codeAdded = "";
        for (ApplicationDtoInterface dto : list) {
            if (!code.equals(dto.getPaidHolidayCode()) || !this.isDtoActivate((BaseDtoInterface)dto) || codeAdded.equals(dto.getApplicationCode())) continue;
            this.addCodeIsUsedMessage(code, dto);
            codeAdded = dto.getApplicationCode();
        }
    }

    protected void addCodeIsUsedMessage(String code, ApplicationDtoInterface dto) {
        String columnName = this.mospParams.getName("PaidVacation") + this.mospParams.getName("Set");
        String[] aryRep = new String[]{code, dto.getApplicationCode(), columnName};
        this.mospParams.addErrorMessage("TMW0226", aryRep);
    }

    protected List<ApplicationDtoInterface> getApplicationListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        ApplicationDaoInterface appDao = (ApplicationDaoInterface)this.createDaoInstance(ApplicationDaoInterface.class);
        List appList = appDao.findForActivateDate(dto.getActivateDate());
        appList.addAll(appDao.findForCheckTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return appList;
    }
}

