/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.dao.settings.PaidHolidayDaoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;

public class PaidHolidayReferenceBean
extends PlatformBean
implements PaidHolidayReferenceBeanInterface {
    protected PaidHolidayDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (PaidHolidayDaoInterface)this.createDaoInstance(PaidHolidayDaoInterface.class);
    }

    public PaidHolidayDtoInterface getPaidHolidayInfo(String paidHolidayCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(paidHolidayCode, targetDate);
    }

    public List<PaidHolidayDtoInterface> getPaidHolidayHistory(String paidHolidayCode) throws MospException {
        return this.dao.findForHistory(paidHolidayCode);
    }

    public String getPaidHolidayAbbr(String paidHolidayCode, Date targetDate) throws MospException {
        PaidHolidayDtoInterface dto = this.getPaidHolidayInfo(paidHolidayCode, targetDate);
        if (dto == null) {
            return paidHolidayCode;
        }
        return dto.getPaidHolidayAbbr();
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank) throws MospException {
        return this.getSelectArray(targetDate, needBlank, true, true);
    }

    public PaidHolidayDtoInterface findForKey(String paidHolidayCode, Date activateDate) throws MospException {
        return this.dao.findForKey(paidHolidayCode, activateDate);
    }

    protected String[][] getSelectArray(Date targetDate, boolean needBlank, boolean isName, boolean viewCode) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        int length = this.getMaxCodeLength(list, viewCode);
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (PaidHolidayDtoInterface dto : list) {
            array[idx][0] = dto.getPaidHolidayCode();
            if (isName && viewCode) {
                array[idx++][1] = this.getCodedName(dto.getPaidHolidayCode(), dto.getPaidHolidayName(), length);
                continue;
            }
            if (isName) {
                array[idx++][1] = dto.getPaidHolidayName();
                continue;
            }
            if (viewCode) {
                array[idx++][1] = this.getCodedName(dto.getPaidHolidayCode(), dto.getPaidHolidayAbbr(), length);
                continue;
            }
            array[idx++][1] = dto.getPaidHolidayAbbr();
        }
        return array;
    }

    protected int getMaxCodeLength(List<PaidHolidayDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (PaidHolidayDtoInterface dto : list) {
            if (dto.getPaidHolidayCode().length() <= length) continue;
            length = dto.getPaidHolidayCode().length();
        }
        return length;
    }

    public void chkExistPaidHoliday(PaidHolidayDtoInterface dto, Date targetDate) {
        if (dto != null) {
            return;
        }
        String stringDate = this.getStringDate(this.getSystemDate());
        if (targetDate != null) {
            stringDate = this.getStringDate(targetDate);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("Salaried"));
        sb.append(this.mospParams.getName("Holiday"));
        sb.append(this.mospParams.getName("Information"));
        this.mospParams.addErrorMessage("TMW0246", new String[]{stringDate, sb.toString()});
    }

    public String[][] getSelectArray(Date targetDate, boolean needBlank) throws MospException {
        return this.getSelectArray(targetDate, needBlank, false, false);
    }
}

