/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.TransStringUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.PaidHolidayFirstYearReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayRemainBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dao.settings.PaidHolidayEntranceDateDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayPointDateDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayTransactionDaoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayEntranceDateDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayFirstYearDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayPointDateDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayRemainDto;
import jp.mosp.time.entity.HolidayRequestEntityInterface;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class PaidHolidayInfoReferenceBean
extends TimeApplicationBean
implements PaidHolidayInfoReferenceBeanInterface {
    protected PaidHolidayTransactionDaoInterface paidHolidayTransactionDao;
    protected HolidayRequestReferenceBeanInterface holidayRequest;
    protected PaidHolidayPointDateDaoInterface paidHolidayPointDao;
    protected PaidHolidayEntranceDateDaoInterface paidHolidayEntranceDateDao;
    protected PaidHolidayFirstYearReferenceBeanInterface paidHolidayFirstYearReference;
    protected EntranceReferenceBeanInterface entranceRefer;
    protected PaidHolidayDataGrantBeanInterface paidHolidayDataGrant;
    protected PaidHolidayRemainBeanInterface paidHolidayRemain;
    protected TimeMasterBeanInterface timeMaster;
    protected Date entranceDate;

    public void initBean() throws MospException {
        super.initBean();
        this.paidHolidayTransactionDao = (PaidHolidayTransactionDaoInterface)this.createDaoInstance(PaidHolidayTransactionDaoInterface.class);
        this.paidHolidayPointDao = (PaidHolidayPointDateDaoInterface)this.createDaoInstance(PaidHolidayPointDateDaoInterface.class);
        this.paidHolidayEntranceDateDao = (PaidHolidayEntranceDateDaoInterface)this.createDaoInstance(PaidHolidayEntranceDateDaoInterface.class);
        this.paidHolidayFirstYearReference = (PaidHolidayFirstYearReferenceBeanInterface)this.createBeanInstance(PaidHolidayFirstYearReferenceBeanInterface.class);
        this.entranceRefer = (EntranceReferenceBeanInterface)this.createBeanInstance(EntranceReferenceBeanInterface.class);
        this.paidHolidayDataGrant = (PaidHolidayDataGrantBeanInterface)this.createBeanInstance(PaidHolidayDataGrantBeanInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
        this.paidHolidayRemain = (PaidHolidayRemainBeanInterface)this.createBeanInstance(PaidHolidayRemainBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.paidHolidayRemain.setTimeMaster(this.timeMaster);
    }

    public Map<String, Object> getPaidHolidayInfo(String personalId, Date targetDate) throws MospException {
        return this.getPaidHolidayInfo(personalId, targetDate, DateUtility.getDefaultTime(), targetDate);
    }

    public Map<String, Object> getPaidHolidayReferenceInfo(String personalId, Date firstDate, Date lastDate) throws MospException {
        return this.getPaidHolidayInfo(personalId, lastDate, firstDate, lastDate);
    }

    protected Map<String, Object> getPaidHolidayInfo(String personalId, Date targetDate, Date firstDate, Date lastDate) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        double previousRemainDays = 0.0;
        int previousRemainHours = 0;
        double currentRemainDays = 0.0;
        int currentRemainHours = 0;
        double givingDays = 0.0;
        int givingHours = 0;
        double cancelDays = 0.0;
        int cancelHours = 0;
        double useDays = 0.0;
        int useHours = 0;
        map.put("FormerYearDay", previousRemainDays);
        map.put("FormerTime", previousRemainHours);
        map.put("CurrentYearDay", currentRemainDays);
        map.put("CurrentTime", currentRemainHours);
        map.put("GivingDay", givingDays);
        map.put("GivingTime", givingHours);
        map.put("CancelDay", cancelDays);
        map.put("CancelTime", cancelHours);
        map.put("UseDay", useDays);
        map.put("UseTime", useHours);
        if (MospUtility.isEmpty((Object[])new Object[]{this.timeMaster.getPaidHolidayForPersonalId(personalId, targetDate).orElse(null)})) {
            return map;
        }
        int grantTimes = this.paidHolidayDataGrant.getGrantTimes(personalId, targetDate);
        Date currentAcquisitionDate = this.paidHolidayDataGrant.getGrantDate(personalId, targetDate, grantTimes);
        if (MospUtility.isEmpty((Object[])new Object[]{currentAcquisitionDate})) {
            return map;
        }
        List remains = this.paidHolidayRemain.getPaidHolidayRemainsForList(personalId, targetDate);
        for (HolidayRemainDto remain : remains) {
            Date acquisitionDate = remain.getAcquisitionDate();
            List paidHolidayTransactions = this.paidHolidayTransactionDao.findForList(personalId, acquisitionDate, firstDate, lastDate);
            givingDays += TimeUtility.getPaidHolidayManualGivingDays((Collection)paidHolidayTransactions);
            givingHours += TimeUtility.getPaidHolidayManualGivingHours((Collection)paidHolidayTransactions);
            cancelDays += TimeUtility.getPaidHolidayManualCancelDays((Collection)paidHolidayTransactions);
            cancelHours += TimeUtility.getPaidHolidayManualCancelHours((Collection)paidHolidayTransactions);
            Map requestMap = this.holidayRequest.getRequestDayHour(personalId, acquisitionDate, 1, "1", firstDate, lastDate);
            useDays += MospUtility.getDouble(requestMap.get("requestDay"));
            useHours += MospUtility.getInt(requestMap.get("requestHour"));
            if (acquisitionDate.before(currentAcquisitionDate)) {
                previousRemainDays += remain.getRemainDays();
                previousRemainHours += remain.getRemainHours();
                continue;
            }
            currentRemainDays += remain.getRemainDays();
            currentRemainHours += remain.getRemainHours();
        }
        map.put("FormerYearDay", previousRemainDays);
        map.put("FormerTime", previousRemainHours);
        map.put("CurrentYearDay", currentRemainDays);
        map.put("CurrentTime", currentRemainHours);
        map.put("GivingDay", givingDays);
        map.put("GivingTime", givingHours);
        map.put("CancelDay", cancelDays);
        map.put("CancelTime", cancelHours);
        map.put("UseDay", useDays);
        map.put("UseTime", useHours);
        return map;
    }

    public List<Map<String, Object>> getPaidHolidayDataListForView(String personalId, Date targetDate) throws MospException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int grantTimes = this.paidHolidayDataGrant.getGrantTimes(personalId, targetDate);
        Date firstGrant = this.paidHolidayDataGrant.getGrantDate(personalId, targetDate, 1);
        Date previousGrant = null;
        if (grantTimes >= 2) {
            previousGrant = this.paidHolidayDataGrant.getGrantDate(personalId, targetDate, grantTimes - 1);
        }
        Date currentGrant = this.paidHolidayDataGrant.getGrantDate(personalId, targetDate, grantTimes);
        double totalGrantDays = 0.0;
        int totalGrantHours = 0;
        double totalRemainDays = 0.0;
        int totalRemainHours = 0;
        List dtos = this.paidHolidayRemain.getPaidHolidayRemainsForView(personalId, targetDate);
        for (HolidayRemainDto dto : dtos) {
            Date acquisitionDate = dto.getAcquisitionDate();
            String fiscalYearString = this.getFiscalYearString(acquisitionDate, firstGrant, previousGrant, currentGrant);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("PaidLeaveFiscalYear", fiscalYearString);
            map.put("PaidLeaveGrantDate", acquisitionDate);
            map.put("PaidLeaveExpirationDate", dto.getHolidayLimitDate());
            map.put("PaidLeaveGrantDays", dto.getGivenDays());
            map.put("PaidLeaveGrantHours", dto.getGivenHours());
            map.put("PaidLeaveRemainDays", dto.getRemainDays());
            map.put("PaidLeaveRemainHours", dto.getRemainHours());
            list.add(map);
            if (acquisitionDate.after(targetDate)) continue;
            totalGrantDays += dto.getGivenDays();
            totalGrantHours += dto.getGivenHours();
            totalRemainDays += dto.getRemainDays();
            totalRemainHours += dto.getRemainHours();
        }
        HashMap<String, Object> totalMap = new HashMap<String, Object>();
        totalMap.put("PaidLeaveFiscalYear", TimeNamingUtility.currentTotalRemainDays((MospParams)this.mospParams));
        totalMap.put("PaidLeaveGrantDays", totalGrantDays);
        totalMap.put("PaidLeaveGrantHours", totalGrantHours);
        totalMap.put("PaidLeaveRemainDays", totalRemainDays);
        totalMap.put("PaidLeaveRemainHours", totalRemainHours);
        list.add(totalMap);
        return list;
    }

    protected String getFiscalYearString(Date acquisitionDate, Date firstGrantDate, Date previousGrantDate, Date currentGrantDate) {
        String fiscalYear = "";
        if (DateUtility.isSame((Date)acquisitionDate, (Date)firstGrantDate)) {
            fiscalYear = TimeNamingUtility.firstFiscalYear((MospParams)this.mospParams);
        }
        if (DateUtility.isSame((Date)acquisitionDate, (Date)previousGrantDate)) {
            fiscalYear = TimeNamingUtility.previousFiscalYear((MospParams)this.mospParams);
        }
        if (DateUtility.isSame((Date)acquisitionDate, (Date)currentGrantDate)) {
            fiscalYear = TimeNamingUtility.thisFiscalYear((MospParams)this.mospParams);
        }
        return fiscalYear;
    }

    protected PaidHolidayFirstYearDtoInterface getPaidHolidayFirstYearDto(String personalId, Date targetDate) throws MospException {
        this.entranceDate = this.entranceRefer.getEntranceDate(personalId);
        if (this.entranceDate == null) {
            PfMessageUtility.addErrorEmployeeNotJoin((MospParams)this.mospParams);
            return null;
        }
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            return null;
        }
        PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.paidHolidayFirstYearReference.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), DateUtility.getMonth((Date)this.entranceDate));
        return paidHolidayFirstYearDto;
    }

    public Map<String, Object> getNextGivingInfo(String personalId) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextPlanGivingDate", null);
        map.put("NextPlantYearDay", 0.0);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", null);
        PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.getPaidHolidayFirstYearDto(personalId, this.getSystemDate());
        if (this.entranceDate == null) {
            return null;
        }
        if (this.paidHolidayDto == null) {
            return null;
        }
        int paidHolidayType = this.paidHolidayDto.getPaidHolidayType();
        if (paidHolidayType == 0) {
            return this.getStandardDay(map, paidHolidayFirstYearDto, personalId, this.entranceDate);
        }
        if (paidHolidayType == 1) {
            return null;
        }
        if (paidHolidayType == 2) {
            return this.getEntranceDay(map, paidHolidayFirstYearDto, personalId);
        }
        if (paidHolidayType == 4) {
            return this.getProportionallyDay(map, personalId, this.getSystemDate());
        }
        return map;
    }

    protected Date getFirstYearGivingDate(String personalId, Date targetDate) throws MospException {
        PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto = this.getPaidHolidayFirstYearDto(personalId, targetDate);
        return this.getFirstYearGivingDate(paidHolidayFirstYearDto, targetDate);
    }

    protected Date getFirstYearGivingDate(PaidHolidayFirstYearDtoInterface dto, Date date) throws MospException {
        if (dto == null) {
            return null;
        }
        if (dto.getGivingAmount() <= 0) {
            return null;
        }
        return this.addDay(DateUtility.addMonth((Date)MonthUtility.getTargetYearMonth((Date)this.entranceDate, (MospParams)this.mospParams), (int)dto.getGivingMonth()), this.paidHolidayDto.getPointDateDay() - 1);
    }

    protected Map<String, Object> getStandardDay(Map<String, Object> map, PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto, String personalId, Date entranceDate) throws MospException {
        Date firstYearGivingDate = this.getFirstYearGivingDate(personalId, this.getSystemDate());
        if (firstYearGivingDate != null && this.getSystemDate().before(firstYearGivingDate)) {
            map.put("NextPlanGivingDate", firstYearGivingDate);
            map.put("NextPlantYearDay", paidHolidayFirstYearDto.getGivingAmount());
            map.put("NextPlanTime", 0);
            map.put("NextPlanLimitDate", this.addDay(DateUtility.addMonth((Date)firstYearGivingDate, (int)paidHolidayFirstYearDto.getGivingLimit()), -1));
            return map;
        }
        Date nextYearGivingDate = null;
        double nextYearDay = -1.0;
        Date nextYearLimitDate = null;
        int pointMonth = this.paidHolidayDto.getPointDateMonth();
        int pointDay = this.paidHolidayDto.getPointDateDay();
        Date pointDate = DateUtility.getDate((int)DateUtility.getYear((Date)entranceDate), (int)pointMonth, (int)pointDay);
        if (!entranceDate.before(pointDate)) {
            pointDate = DateUtility.addYear((Date)pointDate, (int)1);
        }
        if (firstYearGivingDate != null && !firstYearGivingDate.before(pointDate)) {
            pointDate = DateUtility.addYear((Date)pointDate, (int)1);
        }
        int count = 2;
        while (!pointDate.after(this.getSystemDate())) {
            pointDate = DateUtility.addYear((Date)pointDate, (int)1);
            ++count;
        }
        nextYearGivingDate = pointDate;
        int maxCarryOverYear = this.paidHolidayDto.getMaxCarryOverYear();
        if (maxCarryOverYear == 0) {
            nextYearLimitDate = this.addDay(DateUtility.addYear((Date)nextYearGivingDate, (int)2), -1);
        } else if (maxCarryOverYear == 1) {
            nextYearLimitDate = this.addDay(DateUtility.addYear((Date)nextYearGivingDate, (int)1), -1);
        }
        PaidHolidayPointDateDtoInterface paidHolidayPointDateDto = this.paidHolidayPointDao.findForKey(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate(), count);
        nextYearDay = paidHolidayPointDateDto == null ? (double)this.paidHolidayDto.getGeneralPointAmount() : (double)paidHolidayPointDateDto.getPointDateAmount();
        map.put("NextPlanGivingDate", nextYearGivingDate);
        map.put("NextPlantYearDay", nextYearDay);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", nextYearLimitDate);
        return map;
    }

    protected Map<String, Object> getEntranceDay(Map<String, Object> map, PaidHolidayFirstYearDtoInterface paidHolidayFirstYearDto, String personalId) throws MospException {
        int amount;
        Date nextYearGivingDate = null;
        double nextYearDay = -1.0;
        Date nextYearLimitDate = null;
        Date firstYearGivingDate = null;
        if (paidHolidayFirstYearDto != null && (amount = paidHolidayFirstYearDto.getGivingAmount()) > 0) {
            firstYearGivingDate = DateUtility.addMonth((Date)this.entranceDate, (int)paidHolidayFirstYearDto.getGivingMonth());
            if (this.getSystemDate().before(firstYearGivingDate)) {
                nextYearGivingDate = firstYearGivingDate;
                nextYearLimitDate = this.addDay(DateUtility.addMonth((Date)nextYearGivingDate, (int)paidHolidayFirstYearDto.getGivingLimit()), -1);
                nextYearDay = amount;
            }
        }
        Date givingDate = null;
        int amount2 = 0;
        Date maxDate = this.entranceDate;
        int maxCarryOverYear = this.paidHolidayDto.getMaxCarryOverYear();
        List list = this.paidHolidayEntranceDateDao.findForList(this.paidHolidayDto.getPaidHolidayCode(), this.paidHolidayDto.getActivateDate());
        for (PaidHolidayEntranceDateDtoInterface paidHolidayEntranceDateDto : list) {
            Date workDate = DateUtility.addMonth((Date)this.entranceDate, (int)paidHolidayEntranceDateDto.getWorkMonth());
            if (firstYearGivingDate != null && !firstYearGivingDate.before(workDate)) continue;
            if (maxDate.before(workDate)) {
                maxDate = workDate;
            }
            if (!workDate.after(this.getSystemDate()) || givingDate != null && !givingDate.after(workDate)) continue;
            givingDate = workDate;
            amount2 = paidHolidayEntranceDateDto.getJoiningDateAmount();
        }
        if (givingDate == null) {
            int generalJoiningMonth = this.paidHolidayDto.getGeneralJoiningMonth();
            if (generalJoiningMonth == 0) {
                return null;
            }
            if (nextYearDay == -1.0) {
                nextYearDay = this.paidHolidayDto.getGeneralJoiningAmount();
            }
            while (!maxDate.after(this.getSystemDate())) {
                maxDate = DateUtility.addMonth((Date)maxDate, (int)generalJoiningMonth);
            }
            if (nextYearGivingDate == null) {
                nextYearGivingDate = maxDate;
            }
            if (nextYearLimitDate == null) {
                if (maxCarryOverYear == 0) {
                    nextYearLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextYearGivingDate, (int)2), (int)-1);
                } else if (maxCarryOverYear == 1) {
                    nextYearLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextYearGivingDate, (int)1), (int)-1);
                }
            }
        }
        if (nextYearDay == -1.0) {
            nextYearDay = amount2;
        }
        if (nextYearGivingDate == null) {
            nextYearGivingDate = givingDate;
        }
        if (nextYearLimitDate == null) {
            if (maxCarryOverYear == 0) {
                nextYearLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextYearGivingDate, (int)2), (int)-1);
            } else if (maxCarryOverYear == 1) {
                nextYearLimitDate = DateUtility.addDay((Date)DateUtility.addYear((Date)nextYearGivingDate, (int)1), (int)-1);
            }
        }
        map.put("NextPlanGivingDate", nextYearGivingDate);
        map.put("NextPlantYearDay", nextYearDay);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", nextYearLimitDate);
        return map;
    }

    protected Map<String, Object> getProportionallyDay(Map<String, Object> map, String personalId, Date targetDate) throws MospException {
        int grantTimes = this.paidHolidayDataGrant.getGrantTimes(personalId, targetDate);
        Date nextYearGivingDate = this.paidHolidayDataGrant.getGrantDate(personalId, grantTimes + 1);
        double nextYearDay = this.paidHolidayDataGrant.getGrantDaysForProportionally(personalId, nextYearGivingDate, grantTimes + 1);
        Date nextYearLimitDate = this.paidHolidayDataGrant.getExpirationDate(personalId, nextYearGivingDate, grantTimes + 1);
        map.put("NextPlanGivingDate", nextYearGivingDate);
        map.put("NextPlantYearDay", nextYearDay);
        map.put("NextPlanTime", 0);
        map.put("NextPlanLimitDate", nextYearLimitDate);
        return map;
    }

    public Date getNextManualGivingDate(String personalId) throws MospException {
        List list = this.paidHolidayTransactionDao.findForNextGiving(personalId, this.getSystemDate());
        if (list.isEmpty()) {
            return null;
        }
        return ((PaidHolidayTransactionDtoInterface)list.get(0)).getActivateDate();
    }

    public String getNextManualGivingDaysAndHours(String personalId) throws MospException {
        Date activateDate = this.getNextManualGivingDate(personalId);
        if (activateDate == null) {
            return null;
        }
        List list = this.paidHolidayTransactionDao.findForList(personalId, activateDate);
        double givingDays = 0.0;
        int givingHours = 0;
        for (PaidHolidayTransactionDtoInterface dto : list) {
            givingDays += dto.getGivingDay();
            givingDays -= dto.getCancelDay();
            givingHours += dto.getGivingHour();
            givingHours -= dto.getCancelHour();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TransStringUtility.getDoubleTimes((MospParams)this.mospParams, (Double)givingDays, (boolean)false, (boolean)false));
        sb.append(PfNameUtility.day((MospParams)this.mospParams));
        if (givingHours != 0) {
            sb.append(givingHours);
            sb.append(PfNameUtility.time((MospParams)this.mospParams));
        }
        return sb.toString();
    }

    public int[] getHolidayTimeUnitLimit(String personalId, Date targetDate, boolean isCompleted, HolidayRequestDtoInterface holidayRequestDto) throws MospException {
        int[] limitDayTime = new int[]{0, 0, 0};
        if (!this.hasPaidHolidaySettings(personalId, targetDate)) {
            this.mospParams.addErrorMessage("TMW0214", new String[]{this.mospParams.getName("PaidVacation", new String[]{"Set"})});
            return limitDayTime;
        }
        Date firstDate = DateUtility.getDate((int)DateUtility.getYear((Date)targetDate), (int)this.paidHolidayDto.getPointDateMonth(), (int)this.paidHolidayDto.getPointDateDay());
        if (firstDate.after(targetDate)) {
            firstDate = DateUtility.addYear((Date)firstDate, (int)-1);
        }
        Date lastDate = this.addDay(DateUtility.addYear((Date)firstDate, (int)1), -1);
        int limitDay = this.paidHolidayDto.getTimeAcquisitionLimitDays();
        int limitTime = this.paidHolidayDto.getTimeAcquisitionLimitTimes();
        if (this.paidHolidayDto.getTimelyPaidHolidayFlag() != 0) {
            return limitDayTime;
        }
        int time = limitDay * limitTime;
        HolidayRequestEntityInterface entity = this.holidayRequest.getHolidayRequestEntity(personalId, firstDate, lastDate);
        long recordId = 0L;
        if (holidayRequestDto != null) {
            recordId = holidayRequestDto.getRecordId();
        }
        int count = entity.countHourlyPaidHolidays(isCompleted, recordId);
        limitDayTime[0] = (time -= count) / limitTime;
        limitDayTime[1] = time % limitTime;
        limitDayTime[2] = limitTime;
        return limitDayTime;
    }
}

