/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.PaidHolidayHistorySearchBeanInterface;
import jp.mosp.time.dao.settings.PaidHolidayTransactionDaoInterface;
import jp.mosp.time.dao.settings.StockHolidayTransactionDaoInterface;
import jp.mosp.time.dto.settings.PaidHolidayHistoryListDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.impl.PaidHolidayHistoryListDto;

public class PaidHolidayHistorySearchBean
extends TimeApplicationBean
implements PaidHolidayHistorySearchBeanInterface {
    private HumanSearchBeanInterface humanSearch;
    private PaidHolidayTransactionDaoInterface paidHolidayTransactionDao;
    private StockHolidayTransactionDaoInterface stockHolidayTransactionDao;
    private Date activateDate;
    private String employeeCode;
    private String employeeName;
    private String workPlaceCode;
    private String employmentCode;
    private String sectionCode;
    private String positionCode;
    private String inactivateFlag;

    public void initBean() throws MospException {
        super.initBean();
        this.humanSearch = (HumanSearchBeanInterface)this.createBeanInstance(HumanSearchBeanInterface.class);
        this.paidHolidayTransactionDao = (PaidHolidayTransactionDaoInterface)this.createDaoInstance(PaidHolidayTransactionDaoInterface.class);
        this.stockHolidayTransactionDao = (StockHolidayTransactionDaoInterface)this.createDaoInstance(StockHolidayTransactionDaoInterface.class);
    }

    public List<PaidHolidayHistoryListDtoInterface> getSearchList() throws MospException {
        this.humanSearch.setTargetDate(this.activateDate);
        this.humanSearch.setEmployeeCode(this.employeeCode);
        this.humanSearch.setEmployeeCodeType("forward");
        this.humanSearch.setEmployeeName(this.employeeName);
        this.humanSearch.setWorkPlaceCode(this.workPlaceCode);
        this.humanSearch.setEmploymentContractCode(this.employmentCode);
        this.humanSearch.setPositionCode(this.positionCode);
        this.humanSearch.setSectionCode(this.sectionCode);
        this.humanSearch.setStateType("presence");
        List list = this.humanSearch.search();
        ArrayList<PaidHolidayHistoryListDtoInterface> paidHolidayHistoryList = new ArrayList<PaidHolidayHistoryListDtoInterface>();
        for (HumanDtoInterface dto : list) {
            String personalId = dto.getPersonalId();
            PaidHolidayHistoryListDto paidHolidayHistoryListDto = new PaidHolidayHistoryListDto();
            paidHolidayHistoryListDto.setEmployeeCode(dto.getEmployeeCode());
            paidHolidayHistoryListDto.setPersonalId(dto.getPersonalId());
            paidHolidayHistoryListDto.setLastName(dto.getLastName());
            paidHolidayHistoryListDto.setFirstName(dto.getFirstName());
            paidHolidayHistoryListDto.setSectionCode(dto.getSectionCode());
            paidHolidayHistoryListDto.setFormerDate(0.0);
            paidHolidayHistoryListDto.setFormerTime(0);
            paidHolidayHistoryListDto.setDate(0.0);
            paidHolidayHistoryListDto.setTime(0);
            Date previousAcquisitionDate = null;
            Date currentAcquisitionDate = null;
            Date nextAcquisitionDate = null;
            if (this.hasPaidHolidaySettings(personalId, this.activateDate)) {
                currentAcquisitionDate = DateUtility.getDate((int)DateUtility.getYear((Date)this.activateDate), (int)this.paidHolidayDto.getPointDateMonth(), (int)this.paidHolidayDto.getPointDateDay());
                nextAcquisitionDate = DateUtility.addYear((Date)currentAcquisitionDate, (int)1);
                previousAcquisitionDate = DateUtility.addYear((Date)currentAcquisitionDate, (int)-1);
                if (this.activateDate.before(currentAcquisitionDate)) {
                    nextAcquisitionDate = currentAcquisitionDate;
                    currentAcquisitionDate = previousAcquisitionDate;
                    previousAcquisitionDate = DateUtility.addYear((Date)previousAcquisitionDate, (int)-1);
                }
            }
            if (currentAcquisitionDate == null || nextAcquisitionDate == null || previousAcquisitionDate == null) continue;
            List paidHolidayTransactionDtoList = this.paidHolidayTransactionDao.findForInfoList(personalId, this.activateDate, this.inactivateFlag);
            for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionDtoList) {
                Date acquisitionDate = paidHolidayTransactionDto.getAcquisitionDate();
                paidHolidayHistoryListDto.setActivateDate(paidHolidayTransactionDto.getActivateDate());
                paidHolidayHistoryListDto.setInactivateFlag(paidHolidayTransactionDto.getInactivateFlag());
                if (!acquisitionDate.before(currentAcquisitionDate) && acquisitionDate.before(nextAcquisitionDate)) {
                    paidHolidayHistoryListDto.setDate(paidHolidayTransactionDto.getGivingDay() - paidHolidayTransactionDto.getCancelDay());
                    paidHolidayHistoryListDto.setTime(paidHolidayTransactionDto.getGivingHour() - paidHolidayTransactionDto.getCancelHour());
                    continue;
                }
                if (!acquisitionDate.before(currentAcquisitionDate) || acquisitionDate.before(previousAcquisitionDate)) continue;
                paidHolidayHistoryListDto.setFormerDate(paidHolidayTransactionDto.getGivingDay() - paidHolidayTransactionDto.getCancelDay());
                paidHolidayHistoryListDto.setFormerTime(paidHolidayTransactionDto.getGivingHour() - paidHolidayTransactionDto.getCancelHour());
            }
            double givingDay = 0.0;
            double cancelDay = 0.0;
            StockHolidayTransactionDtoInterface stockHolidayTransactionDto = this.stockHolidayTransactionDao.findForKey(personalId, this.activateDate, this.inactivateFlag);
            if (null == stockHolidayTransactionDto) continue;
            paidHolidayHistoryListDto.setStockDate((givingDay += stockHolidayTransactionDto.getGivingDay()) - (cancelDay += stockHolidayTransactionDto.getCancelDay()));
            if (paidHolidayTransactionDtoList.size() <= 0) continue;
            paidHolidayHistoryList.add((PaidHolidayHistoryListDtoInterface)paidHolidayHistoryListDto);
        }
        return paidHolidayHistoryList;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = this.getDateClone(activateDate);
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setEmploymentCode(String employmentCode) {
        this.employmentCode = employmentCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }

    public void setInactivateFlag(String inactivateFlag) {
        this.inactivateFlag = inactivateFlag;
    }
}

