/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.AttendanceTransactionReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataSearchBeanInterface;
import jp.mosp.time.bean.PaidHolidayGrantReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayGrantRegistBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.dto.settings.AttendanceTransactionDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataGrantListDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayGrantDtoInterface;
import jp.mosp.time.dto.settings.impl.PaidHolidayDataGrantListDto;
import jp.mosp.time.utils.TimeUtility;

public class PaidHolidayDataSearchBean
extends TimeApplicationBean
implements PaidHolidayDataSearchBeanInterface {
    protected HumanSearchBeanInterface humanSearch;
    protected EntranceReferenceBeanInterface entranceReference;
    protected PaidHolidayGrantReferenceBeanInterface paidHolidayGrantReference;
    protected PaidHolidayGrantRegistBeanInterface paidHolidayGrantRegist;
    protected PaidHolidayDataReferenceBeanInterface paidHolidayDataReference;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected PaidHolidayDataGrantBeanInterface paidHolidayDataGrant;
    protected AttendanceTransactionReferenceBeanInterface attendanceTransactionReference;
    protected Date activateDate;
    private Date entranceFromDate;
    private Date entranceToDate;
    private String employeeCode;
    private String employeeName;
    private String workPlaceCode;
    private String employmentCode;
    private String sectionCode;
    private String positionCode;
    private String paidHolidayCode;
    private String grant;
    protected boolean calcAttendanceRate;
    private Set<String> personalIdSet;
    public static final int NOT_CALCULATED = 1;
    public static final int NOT_GRANTED_BUT_CALC = 2;
    public static final int NOT_GRANTED = 0;
    public static final int GRANTED = 3;

    public void initBean() throws MospException {
        super.initBean();
        this.humanSearch = (HumanSearchBeanInterface)this.createBeanInstance(HumanSearchBeanInterface.class);
        this.entranceReference = (EntranceReferenceBeanInterface)this.createBeanInstance(EntranceReferenceBeanInterface.class);
        this.paidHolidayGrantReference = (PaidHolidayGrantReferenceBeanInterface)this.createBeanInstance(PaidHolidayGrantReferenceBeanInterface.class);
        this.paidHolidayGrantRegist = (PaidHolidayGrantRegistBeanInterface)this.createBeanInstance(PaidHolidayGrantRegistBeanInterface.class);
        this.paidHolidayDataReference = (PaidHolidayDataReferenceBeanInterface)this.createBeanInstance(PaidHolidayDataReferenceBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.paidHolidayDataGrant = (PaidHolidayDataGrantBeanInterface)this.createBeanInstance(PaidHolidayDataGrantBeanInterface.class);
        this.attendanceTransactionReference = (AttendanceTransactionReferenceBeanInterface)this.createBeanInstance(AttendanceTransactionReferenceBeanInterface.class);
    }

    public List<PaidHolidayDataGrantListDtoInterface> getSearchList() throws MospException {
        ArrayList<PaidHolidayDataGrantListDtoInterface> list = new ArrayList<PaidHolidayDataGrantListDtoInterface>();
        List humanList = this.getHumanList();
        for (HumanDtoInterface humanDto : humanList) {
            PaidHolidayDataGrantListDtoInterface dto = this.getDto(humanDto);
            if (dto == null) continue;
            list.add(dto);
            this.paidHolidayGrantRegist(dto);
        }
        return list;
    }

    protected List<HumanDtoInterface> getHumanList() throws MospException {
        this.humanSearch.setTargetDate(this.activateDate);
        this.humanSearch.setEmployeeCode(this.employeeCode);
        this.humanSearch.setEmployeeCodeType("forward");
        this.humanSearch.setEmployeeName(this.employeeName);
        this.humanSearch.setWorkPlaceCode(this.workPlaceCode);
        this.humanSearch.setEmploymentContractCode(this.employmentCode);
        this.humanSearch.setPositionCode(this.positionCode);
        this.humanSearch.setSectionCode(this.sectionCode);
        this.humanSearch.setStateType("presence");
        return this.humanSearch.search();
    }

    protected PaidHolidayDataGrantListDtoInterface getDto(HumanDtoInterface dto) throws MospException {
        if (!this.searchPersonalId(dto)) {
            return null;
        }
        if (!this.searchEntranceDate(dto)) {
            return null;
        }
        if (!this.hasPaidHolidaySettings(dto.getPersonalId(), this.activateDate)) {
            return null;
        }
        if (this.isPaidHolidayTypeNot()) {
            return null;
        }
        if (!this.searchPaidHoliday()) {
            return null;
        }
        int grantTimes = this.paidHolidayDataGrant.getGrantTimes(dto.getPersonalId(), this.activateDate);
        Date grantDate = this.paidHolidayDataGrant.getGrantDate(dto.getPersonalId(), this.activateDate, grantTimes);
        PaidHolidayDataDtoInterface paidHolidayDataDto = this.paidHolidayDataReference.findForKey(dto.getPersonalId(), grantDate, grantDate);
        if (!this.searchGrant(paidHolidayDataDto, dto.getPersonalId(), grantDate)) {
            return null;
        }
        return this.getDto(dto, paidHolidayDataDto, grantDate, grantTimes);
    }

    protected PaidHolidayDataGrantListDtoInterface getDto(HumanDtoInterface dto, PaidHolidayDataDtoInterface paidHolidayDataDto, Date grantDate, int grantTimes) throws MospException {
        PaidHolidayDataGrantListDto paidHolidayDataGrantListDto = new PaidHolidayDataGrantListDto();
        Date startDate = this.getStartDate(dto, grantTimes, grantDate);
        Date endDate = this.getEndDate(startDate, grantTimes);
        this.setAttendanceRate((PaidHolidayDataGrantListDtoInterface)paidHolidayDataGrantListDto, dto, grantDate, startDate, endDate);
        this.setDto((PaidHolidayDataGrantListDtoInterface)paidHolidayDataGrantListDto, dto, paidHolidayDataDto, grantDate, startDate, endDate);
        return paidHolidayDataGrantListDto;
    }

    protected boolean searchPersonalId(HumanDtoInterface dto) {
        return this.searchPersonalId(dto.getPersonalId());
    }

    protected boolean searchPersonalId(String personalId) {
        if (this.personalIdSet == null) {
            return true;
        }
        return this.personalIdSet.contains(personalId);
    }

    protected boolean searchEntranceDate(HumanDtoInterface dto) throws MospException {
        return this.searchEntranceDate(dto.getPersonalId());
    }

    protected boolean searchEntranceDate(String personalId) throws MospException {
        if (this.entranceFromDate == null) {
            return true;
        }
        Date date = this.entranceReference.getEntranceDate(personalId);
        if (date == null) {
            return false;
        }
        return DateUtility.isTermContain((Date)date, (Date)this.entranceFromDate, (Date)this.entranceToDate);
    }

    protected boolean isPaidHolidayTypeNot() {
        return this.paidHolidayDto.getPaidHolidayType() == 3;
    }

    protected boolean searchPaidHoliday() {
        if (this.paidHolidayCode.isEmpty()) {
            return true;
        }
        return this.paidHolidayCode.equals(this.paidHolidayDto.getPaidHolidayCode());
    }

    protected boolean searchGrant(PaidHolidayDataDtoInterface dto, String personalId, Date grantDate) throws MospException {
        if (MospUtility.isEmpty((String[])new String[]{this.grant})) {
            return true;
        }
        PaidHolidayGrantDtoInterface paidHolidayGrantDto = this.paidHolidayGrantReference.findForKey(personalId, grantDate);
        int intGrant = MospUtility.getInt((Object)this.grant);
        if (intGrant == 1) {
            return this.isNotCalclated(dto, paidHolidayGrantDto);
        }
        if (intGrant == 2) {
            return this.isNotGrantedButCalc(dto, paidHolidayGrantDto);
        }
        if (intGrant == 0) {
            return this.isNotGranted(dto, paidHolidayGrantDto);
        }
        if (intGrant == 3) {
            return this.isGranted(dto, paidHolidayGrantDto);
        }
        return false;
    }

    protected boolean isNotCalclated(PaidHolidayDataDtoInterface dto, PaidHolidayGrantDtoInterface grantDto) {
        if (dto != null) {
            return false;
        }
        if (grantDto == null) {
            return true;
        }
        return grantDto.getGrantStatus() == 1;
    }

    protected boolean isNotGrantedButCalc(PaidHolidayDataDtoInterface dto, PaidHolidayGrantDtoInterface grantDto) {
        if (dto != null) {
            return false;
        }
        if (grantDto == null) {
            return false;
        }
        return grantDto.getGrantStatus() == 2;
    }

    protected boolean isGranted(PaidHolidayDataDtoInterface dto, PaidHolidayGrantDtoInterface grantDto) {
        if (dto != null) {
            return true;
        }
        if (grantDto == null) {
            return false;
        }
        return grantDto.getGrantStatus() == 3;
    }

    protected boolean isNotGranted(PaidHolidayDataDtoInterface dto, PaidHolidayGrantDtoInterface grantDto) {
        return !this.isGranted(dto, grantDto);
    }

    protected void setDto(PaidHolidayDataGrantListDtoInterface dto, HumanDtoInterface humanDto, PaidHolidayDataDtoInterface paidHolidayDataDto, Date grantDate, Date firstDate, Date lastDate) {
        dto.setPersonalId(humanDto.getPersonalId());
        dto.setEmployeeCode(humanDto.getEmployeeCode());
        dto.setLastName(humanDto.getLastName());
        dto.setFirstName(humanDto.getFirstName());
        dto.setGrantDate(grantDate);
        dto.setFirstDate(firstDate);
        dto.setLastDate(lastDate);
        dto.setAccomplish(this.mospParams.getName("Ram", new String[]{"Accomplish"}));
        if (this.isAccomplished(dto.getAttendanceRate())) {
            dto.setAccomplish(this.mospParams.getName("Accomplish"));
        }
        if (grantDate == null) {
            dto.setAccomplish(this.mospParams.getName("Hyphen"));
        }
        if (dto.getAttendanceRate() == null) {
            dto.setAccomplish(this.mospParams.getName("Hyphen"));
        }
        if (!dto.getError().isEmpty()) {
            dto.setAccomplish(this.mospParams.getName("Hyphen"));
        }
        dto.setGrant(this.mospParams.getName("Ram", new String[]{"Giving"}));
        dto.setActivateDate(null);
        dto.setGrantDays(null);
        if (paidHolidayDataDto != null) {
            dto.setGrant(this.mospParams.getName("Giving", new String[]{"Finish"}));
            dto.setActivateDate(paidHolidayDataDto.getActivateDate());
            dto.setGrantDays(Double.valueOf(paidHolidayDataDto.getHoldDay()));
        }
    }

    protected boolean isAccomplished(Double attendanceRate) {
        if (this.paidHolidayDto.getWorkRatio() <= 0) {
            return true;
        }
        if (attendanceRate == null) {
            return false;
        }
        return Double.compare(attendanceRate * 100.0, this.paidHolidayDto.getWorkRatio()) >= 0;
    }

    protected void paidHolidayGrantRegist(PaidHolidayDataGrantListDtoInterface dto) throws MospException {
        if (dto.getAttendanceRate() == null) {
            return;
        }
        this.paidHolidayGrantRegist(dto.getPersonalId(), dto.getGrantDate());
    }

    protected void paidHolidayGrantRegist(String personalId, Date grantDate) throws MospException {
        PaidHolidayGrantDtoInterface dto = this.paidHolidayGrantReference.findForKey(personalId, grantDate);
        if (dto != null && dto.getGrantStatus() == 3) {
            return;
        }
        if (dto == null) {
            dto = this.paidHolidayGrantRegist.getInitDto();
            dto.setPersonalId(personalId);
            dto.setGrantDate(grantDate);
        }
        dto.setGrantStatus(2);
        this.paidHolidayGrantRegist.regist(dto);
    }

    protected Date getStartDate(HumanDtoInterface dto, int grantTimes, Date grantDate) throws MospException {
        return this.getStartDate(dto.getPersonalId(), grantTimes, grantDate);
    }

    public Date getStartDate(String personalId, int grantTimes, Date grantDate) throws MospException {
        Date entranceDate = this.entranceReference.getEntranceDate(personalId);
        if (grantTimes <= 0) {
            return null;
        }
        if (grantTimes == 1) {
            return entranceDate;
        }
        Date startDate = this.paidHolidayDataGrant.getGrantDate(personalId, this.activateDate, grantTimes - 1, entranceDate);
        if (grantTimes >= 3) {
            return startDate;
        }
        if (startDate != null) {
            return startDate;
        }
        Date targetDate = DateUtility.addYear((Date)grantDate, (int)-1);
        if (targetDate.after(entranceDate)) {
            return targetDate;
        }
        return entranceDate;
    }

    public Date getEndDate(Date startDate, int grantTimes) {
        if (startDate == null) {
            return null;
        }
        if (grantTimes <= 0) {
            return null;
        }
        if (grantTimes == 1) {
            return this.addDay(DateUtility.addMonth((Date)startDate, (int)6), -1);
        }
        return this.addDay(DateUtility.addYear((Date)startDate, (int)1), -1);
    }

    protected void setAttendanceRate(PaidHolidayDataGrantListDtoInterface dto, HumanDtoInterface humanDto, Date grantDate, Date startDate, Date endDate) throws MospException {
        this.setAttendanceRate(dto, humanDto.getPersonalId(), grantDate, startDate, endDate);
    }

    protected void setAttendanceRate(PaidHolidayDataGrantListDtoInterface dto, String personalId, Date grantDate, Date startDate, Date endDate) throws MospException {
        AttendanceTransactionDtoInterface attendanceTransactionDto;
        dto.setWorkDays(null);
        dto.setTotalWorkDays(null);
        dto.setAttendanceRate(null);
        dto.setError("");
        if (startDate == null) {
            return;
        }
        if (!this.calcAttendanceRate) {
            return;
        }
        int attendanceDays = 0;
        int totalWorkDays = 0;
        Date firstDate = startDate;
        Date lastDate = this.addDay(grantDate, -1);
        Set set = this.attendanceTransactionReference.findForMilliseconds(personalId, firstDate, lastDate);
        if (this.getNumberOfDays(firstDate, lastDate) != set.size()) {
            int milliseconds = 86400000;
            long firstTime = firstDate.getTime();
            long lastTime = lastDate.getTime();
            for (long i = firstTime; i <= lastTime; i += (long)milliseconds) {
                if (set.contains(i)) continue;
                Date date = new Date(i);
                String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCodeNoMessage(personalId, date);
                if (MospUtility.isEmpty((String[])new String[]{workTypeCode}) || TimeUtility.isHoliday((String)workTypeCode)) continue;
                ++totalWorkDays;
            }
        }
        if ((attendanceTransactionDto = this.attendanceTransactionReference.sum(personalId, firstDate, lastDate)) != null) {
            attendanceDays += attendanceTransactionDto.getNumerator();
            totalWorkDays += attendanceTransactionDto.getDenominator();
        }
        int days = this.getNumberOfDays(grantDate, endDate);
        dto.setWorkDays(Integer.valueOf(attendanceDays += days));
        dto.setTotalWorkDays(Integer.valueOf(totalWorkDays += days));
        dto.setAttendanceRate(Double.valueOf(this.getAttendanceRate(attendanceDays, totalWorkDays)));
    }

    protected double getAttendanceRate(int workDays, int totalWorkDays) {
        if (totalWorkDays <= 0) {
            return 0.0;
        }
        BigDecimal dividend = new BigDecimal(workDays);
        BigDecimal divisor = new BigDecimal(totalWorkDays);
        BigDecimal quotient = dividend.divide(divisor, 3, 3);
        return quotient.doubleValue();
    }

    protected int getNumberOfDays(Date firstDate, Date lastDate) {
        long difference = lastDate.getTime() - firstDate.getTime();
        if (difference < 0L) {
            return 0;
        }
        long quotient = difference / 86400000L;
        return (int)quotient + 1;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = this.getDateClone(activateDate);
    }

    public void setEntranceFromDate(Date entranceFromDate) {
        this.entranceFromDate = this.getDateClone(entranceFromDate);
    }

    public void setEntranceToDate(Date entranceToDate) {
        this.entranceToDate = this.getDateClone(entranceToDate);
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setEmploymentCode(String employmentCode) {
        this.employmentCode = employmentCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }

    public void setPaidHolidayCode(String paidHolidayCode) {
        this.paidHolidayCode = paidHolidayCode;
    }

    public void setGrant(String grant) {
        this.grant = grant;
    }

    public void setCalcAttendanceRate(boolean calcAttendanceRate) {
        this.calcAttendanceRate = calcAttendanceRate;
    }

    public void setPersonalIdSet(Set<String> personalIdSet) {
        this.personalIdSet = personalIdSet;
    }
}

