/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.InputCheckUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayTransactionReferenceBeanInterface;
import jp.mosp.time.dao.settings.PaidHolidayDataDaoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdPaidHolidayDataDto;
import jp.mosp.time.utils.TimeInputCheckUtility;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;

public class PaidHolidayDataRegistBean
extends PlatformBean
implements PaidHolidayDataRegistBeanInterface {
    protected PaidHolidayDataDaoInterface dao;
    protected PaidHolidayTransactionReferenceBeanInterface paidHolidayTransactionReference;
    protected HolidayRequestReferenceBeanInterface holidayRequestReference;

    public void initBean() throws MospException {
        this.dao = (PaidHolidayDataDaoInterface)this.createDaoInstance(PaidHolidayDataDaoInterface.class);
        this.paidHolidayTransactionReference = (PaidHolidayTransactionReferenceBeanInterface)this.createBeanInstance(PaidHolidayTransactionReferenceBeanInterface.class);
        this.holidayRequestReference = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
    }

    public PaidHolidayDataDtoInterface getInitDto() {
        return new TmdPaidHolidayDataDto();
    }

    public void insert(PaidHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        PaidHolidayDataDtoInterface paidHolidayDataDto = this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
        if (paidHolidayDataDto != null) {
            this.validate(paidHolidayDataDto);
            this.checkUpdate(paidHolidayDataDto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, paidHolidayDataDto.getTmdPaidHolidayId());
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdPaidHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(PaidHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdPaidHolidayId());
        dto.setTmdPaidHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void regist(PaidHolidayDataDtoInterface dto, Integer row) throws MospException {
        this.validate(dto, row);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String personalId = dto.getPersonalId();
        Date activateDate = dto.getActivateDate();
        Date acquisitionDate = dto.getAcquisitionDate();
        PaidHolidayDataDtoInterface registeredDto = this.dao.findForKey(personalId, activateDate, acquisitionDate);
        if (MospUtility.isEmpty((Object[])new Object[]{registeredDto})) {
            this.insert(dto);
            return;
        }
        this.update(dto);
    }

    public void delete(PaidHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdPaidHolidayId());
    }

    protected void checkInsert(PaidHolidayDataDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate()));
    }

    protected void checkUpdate(PaidHolidayDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdPaidHolidayId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmdPaidHolidayId(), true))) {
            return;
        }
    }

    protected void checkDelete(PaidHolidayDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdPaidHolidayId());
    }

    public void checkModify(PaidHolidayDataDtoInterface dto) throws MospException {
        int hour;
        Date endDate = dto.getLimitDate();
        List list = this.dao.findForHistory(dto.getPersonalId(), dto.getAcquisitionDate());
        for (int i = 0; i < list.size(); ++i) {
            PaidHolidayDataDtoInterface paidHolidayDataDto = (PaidHolidayDataDtoInterface)list.get(i);
            if (!paidHolidayDataDto.getActivateDate().equals(dto.getActivateDate())) continue;
            if (list.size() <= i + 1) break;
            endDate = this.addDay(((PaidHolidayDataDtoInterface)list.get(i + 1)).getActivateDate(), -1);
            break;
        }
        if (dto.getActivateDate().after(endDate)) {
            endDate = dto.getActivateDate();
        }
        double givingDay = 0.0;
        int givingHour = 0;
        double cancelDay = 0.0;
        int cancelHour = 0;
        List paidHolidayTransactionList = this.paidHolidayTransactionReference.findForList(dto.getPersonalId(), dto.getAcquisitionDate(), dto.getActivateDate(), endDate);
        for (PaidHolidayTransactionDtoInterface paidHolidayTransactionDto : paidHolidayTransactionList) {
            givingDay += paidHolidayTransactionDto.getGivingDay();
            givingHour += paidHolidayTransactionDto.getGivingHour();
            cancelDay += paidHolidayTransactionDto.getCancelDay();
            cancelHour += paidHolidayTransactionDto.getCancelHour();
        }
        Map map = this.holidayRequestReference.getRequestDayHour(dto.getPersonalId(), dto.getAcquisitionDate(), 1, Integer.toString(1), dto.getActivateDate(), endDate);
        double useDay = (Double)map.get("requestDay");
        int useHour = (Integer)map.get("requestHour");
        double day = dto.getHoldDay() + givingDay - cancelDay - useDay;
        if (dto.getDenominatorDayHour() > 0) {
            for (hour = dto.getHoldHour() + givingHour - cancelHour - useHour; day >= 1.0 && hour < 0; day -= 1.0, hour += dto.getDenominatorDayHour()) {
            }
        }
        if (day >= 0.0 && hour >= 0) {
            return;
        }
        TimeMessageUtility.addErrorDoAfterRocess((MospParams)this.mospParams, (String)TimeNamingUtility.holidayRequest((MospParams)this.mospParams), (String)PfNameUtility.insert((MospParams)this.mospParams));
    }

    protected void validate(PaidHolidayDataDtoInterface dto, Integer row) {
        String codeKey = "import_tmd_paid_holiday";
        String employeeCodeName = this.getCodeName("employee_code", codeKey);
        String activateDateName = this.getCodeName("activate_date", codeKey);
        String acquisitionDateName = this.getCodeName("acquisition_date", codeKey);
        String limitDateName = this.getCodeName("limit_date", codeKey);
        String holdDayName = this.getCodeName("hold_day", codeKey);
        String holdHourName = this.getCodeName("hold_hour", codeKey);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)dto.getPersonalId(), (String)employeeCodeName);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)dto.getActivateDate(), (String)activateDateName);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)dto.getAcquisitionDate(), (String)acquisitionDateName);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)dto.getAcquisitionDate(), (String)limitDateName);
        InputCheckUtility.checDecimal((MospParams)this.mospParams, (double)dto.getHoldDay(), (int)2, (int)1, (String)holdDayName, (Integer)row);
        TimeInputCheckUtility.checHolidayTimes((MospParams)this.mospParams, (double)dto.getHoldDay(), (String)holdDayName, (Integer)row);
        InputCheckUtility.checkMaxDigit((MospParams)this.mospParams, (int)dto.getHoldHour(), (int)2, (String)holdHourName, (Integer)row);
    }

    protected void validate(PaidHolidayDataDtoInterface dto) {
        this.validate(dto, null);
    }

    public void checkDeleteConfirm(PaidHolidayDataDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        Date acquisitionDate = dto.getAcquisitionDate();
        boolean isDelete = this.isDleteConfirm(dto);
        Set statuses = WorkflowUtility.getAppliedStatuses();
        Set requests = this.holidayRequestReference.getRequestsForAcquisitionDate(personalId, 1, "1", acquisitionDate, statuses);
        for (HolidayRequestDtoInterface holidayDto : requests) {
            if (isDelete) continue;
            TimeMessageUtility.addErrorNoDeleteForHolidayRequest((MospParams)this.mospParams, (Date)acquisitionDate, (Date)holidayDto.getRequestStartDate());
        }
        List transacList = this.paidHolidayTransactionReference.findForAcquisitionList(personalId, acquisitionDate);
        for (PaidHolidayTransactionDtoInterface transacDto : transacList) {
            if (isDelete) continue;
            TimeMessageUtility.addErrorNoDeleteForPaidHolidayTransaction((MospParams)this.mospParams, (Date)acquisitionDate, (Date)transacDto.getActivateDate());
        }
    }

    protected boolean isDleteConfirm(PaidHolidayDataDtoInterface dto) throws MospException {
        List list = this.dao.findForHistory(dto.getPersonalId(), dto.getAcquisitionDate());
        return list.size() != 1 && dto.getActivateDate().compareTo(dto.getAcquisitionDate()) != 0;
    }
}

