/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.bean.workflow.impl.WorkflowReferenceBean;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.OvertimeRequestReferenceBeanInterface;
import jp.mosp.time.bean.OvertimeRequestRegistAddonBeanInterface;
import jp.mosp.time.bean.OvertimeRequestRegistBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdOvertimeRequestDto;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.utils.TimeNamingUtility;

public class OvertimeRequestRegistBean
extends TimeBean
implements OvertimeRequestRegistBeanInterface {
    protected OvertimeRequestDaoInterface dao;
    protected OvertimeRequestReferenceBeanInterface overtimeReference;
    protected WorkflowRegistBeanInterface workflowRegist;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected WorkflowReferenceBeanInterface workflowReference;
    protected WorkflowCommentRegistBeanInterface workflowCommentRegist;
    private ApprovalInfoReferenceBeanInterface approvalInfoReference;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected TimeMasterBeanInterface timeMaster;
    protected List<OvertimeRequestRegistAddonBeanInterface> addonBeans;
    protected static final String CODE_KEY_ADDONS = "OvertimeRequestRegistAddons";

    public void initBean() throws MospException {
        this.dao = (OvertimeRequestDaoInterface)this.createDaoInstance(OvertimeRequestDaoInterface.class);
        this.overtimeReference = (OvertimeRequestReferenceBeanInterface)this.createBeanInstance(OvertimeRequestReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBeanInstance(WorkflowReferenceBean.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBeanInstance(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBeanInstance(WorkflowCommentRegistBeanInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBeanInstance(ApprovalInfoReferenceBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBeanInstance(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBeanInstance(RetirementReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBeanInstance(CutoffUtilBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.addonBeans = this.getAddonBeans();
        this.setTimeMaster((TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class));
    }

    public OvertimeRequestDtoInterface getInitDto() {
        TmdOvertimeRequestDto dto = new TmdOvertimeRequestDto();
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            dto = addonBean.getInitDto((OvertimeRequestDtoInterface)dto);
        }
        return dto;
    }

    protected void insert(OvertimeRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdOvertimeRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.insert(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void update(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBean(WorkflowRegistBeanInterface.class);
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            OvertimeRequestDtoInterface dto = (OvertimeRequestDtoInterface)baseDto;
            this.checkAppli(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(dto.getWorkflow());
            this.workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Object object = this.addonBeans.iterator();
        while (object.hasNext()) {
            OvertimeRequestRegistAddonBeanInterface addonBean = (OvertimeRequestRegistAddonBeanInterface)object.next();
            addonBean.update(idArray);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void regist(OvertimeRequestDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getTmdOvertimeRequestId(), false) == null) {
            this.insert(dto);
        } else {
            this.add(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.regist(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void add(OvertimeRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdOvertimeRequestId());
        dto.setTmdOvertimeRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.add(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void delete(OvertimeRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdOvertimeRequestId());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.delete(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void withdrawn(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            OvertimeRequestDtoInterface dto = (OvertimeRequestDtoInterface)baseDto;
            this.checkWithdrawn(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if ((workflowDto = this.workflowRegist.withdrawn(workflowDto)) == null) continue;
            this.workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getWithdrawSucceed((MospParams)this.mospParams));
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Object object = this.addonBeans.iterator();
        while (object.hasNext()) {
            OvertimeRequestRegistAddonBeanInterface addonBean = (OvertimeRequestRegistAddonBeanInterface)object.next();
            addonBean.withdrawn(idArray);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkInsert(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestDate(), dto.getOvertimeType()));
    }

    protected void checkAdd(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdOvertimeRequestId());
    }

    public void validate(OvertimeRequestDtoInterface dto) throws MospException {
        this.overtimeReference.chkBasicInfo(dto.getPersonalId(), dto.getRequestDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.validate(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkSetRequestDate(OvertimeRequestDtoInterface dto) throws MospException {
        RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        localRequestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        this.checkSetRequestDate(dto, localRequestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkSetRequestDate(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkSetRequestDate(OvertimeRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil) throws MospException {
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSuspended(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTemporaryClosingFinal(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkType(dto, localRequestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequest(dto, localRequestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkOvertimeOverlap(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(dto, localRequestUtil);
    }

    public void checkDraft(OvertimeRequestDtoInterface dto) throws MospException {
        RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        localRequestUtil.setRequests(dto.getPersonalId(), dto.getRequestDate());
        this.checkSetRequestDate(dto, localRequestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkDraft(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkAppli(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkDraft(dto);
        this.checkPeriod(dto);
        this.checkRequired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkAppli(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkCancelAppli(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        if (this.approvalInfoReference.isExistAttendanceTargetDate(dto.getPersonalId(), dto.getRequestDate())) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("WorkManage"));
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkCancelAppli(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkWithdrawn(OvertimeRequestDtoInterface dto) throws MospException {
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkWithdrawn(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkApproval(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkApproval(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkCancelApproval(OvertimeRequestDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkCancelApproval(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkCancel(OvertimeRequestDtoInterface dto) throws MospException {
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkCancel(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkRequired(OvertimeRequestDtoInterface dto) throws MospException {
        if (dto.getRequestTime() == 0) {
            String fieldName = TimeNamingUtility.applicationTime((MospParams)this.mospParams);
            String type = PfNameUtility.time((MospParams)this.mospParams);
            PfMessageUtility.addErrorCheckGeneral((MospParams)this.mospParams, (String)fieldName, (String)type);
        }
        if (dto.getRequestReason().isEmpty()) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)TimeNamingUtility.overtimeReason((MospParams)this.mospParams));
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkRequired(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkRequest(OvertimeRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil) throws MospException {
        if (localRequestUtil.isHolidayAllDay(false)) {
            this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getRequestDate()), this.getNameApplicationDay()});
        }
    }

    public void checkOvertimeOverlap(OvertimeRequestDtoInterface dto) throws MospException {
        List list = this.dao.findForList(dto.getPersonalId(), dto.getRequestDate());
        for (OvertimeRequestDtoInterface requestDto : list) {
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(requestDto.getWorkflow());
            if (workflowDto == null || "5".equals(workflowDto.getWorkflowStatus()) || dto.getWorkflow() == workflowDto.getWorkflow() || dto.getOvertimeType() != requestDto.getOvertimeType()) continue;
            this.addOvertimeTargetDateOvertimeErrorMessage(dto.getRequestDate());
            break;
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkOvertimeOverlap(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void checkPeriod(OvertimeRequestDtoInterface dto) throws MospException {
        if (dto.getRequestDate().after(DateUtility.addMonth((Date)this.getSystemDate(), (int)1))) {
            this.addOvertimePeriodErrorMessage();
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkPeriod(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkAttendance(OvertimeRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil) throws MospException {
        AttendanceDtoInterface attendanceDto = localRequestUtil.getApplicatedAttendance();
        if (attendanceDto == null) {
            return;
        }
        CutoffEntityInterface cutoff = this.timeMaster.getCutoffForPersonalId(dto.getPersonalId(), dto.getRequestDate());
        if (cutoff.getNoApproval() != 2) {
            return;
        }
        this.addOvertimeTargetWorkDateAttendanceRequestErrorMessage(dto.getRequestDate());
    }

    protected void checkWorkType(OvertimeRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil) throws MospException {
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), dto.getRequestDate(), localRequestUtil);
        if (workTypeCode == null || workTypeCode.isEmpty()) {
            this.addOvertimeTargetWorkDateHolidayErrorMessage(dto.getRequestDate());
            return;
        }
        if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
            this.addOvertimeTargetWorkDateHolidayErrorMessage(dto.getRequestDate());
            return;
        }
        if ("work_on_legal".equals(workTypeCode) || "work_on_prescribed".equals(workTypeCode)) {
            this.addOthersRequestErrorMessage(dto.getRequestDate(), this.mospParams.getName("WorkingHoliday"));
        }
    }

    protected void checkEntered(OvertimeRequestDtoInterface dto) throws MospException {
        if (!this.isEntered(dto.getPersonalId(), dto.getRequestDate())) {
            PfMessageUtility.addErrorEmployeeNotJoin((MospParams)this.mospParams);
        }
    }

    protected void checkRetired(OvertimeRequestDtoInterface dto) throws MospException {
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getRequestDate())) {
            PfMessageUtility.addErrorEmployeeRetired((MospParams)this.mospParams);
        }
    }

    protected void checkSuspended(OvertimeRequestDtoInterface dto) throws MospException {
        if (this.suspensionReference.isSuspended(dto.getPersonalId(), dto.getRequestDate())) {
            PfMessageUtility.addErrorEmployeeSuspended((MospParams)this.mospParams);
        }
    }

    public void checkTemporaryClosingFinal(OvertimeRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestDate(), this.getNameApplicationDay());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (OvertimeRequestRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkTemporaryClosingFinal(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected String getNameApplicationDay() {
        return this.mospParams.getName("OvertimeWork") + this.mospParams.getName("Year") + this.mospParams.getName("Month") + this.mospParams.getName("Day");
    }

    protected List<OvertimeRequestRegistAddonBeanInterface> getAddonBeans() throws MospException {
        ArrayList<OvertimeRequestRegistAddonBeanInterface> addonBeans = new ArrayList<OvertimeRequestRegistAddonBeanInterface>();
        for (String[] addon : this.mospParams.getProperties().getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            OvertimeRequestRegistAddonBeanInterface bean = (OvertimeRequestRegistAddonBeanInterface)this.createBean(addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
        this.scheduleUtil.setTimeMaster(timeMaster);
        this.cutoffUtil.setTimeMaster(timeMaster);
    }
}

