/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.time.bean.LimitStandardRegistBeanInterface;
import jp.mosp.time.dao.settings.LimitStandardDaoInterface;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmLimitStandardDto;
import jp.mosp.time.utils.TimeNamingUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class LimitStandardRegistBean
extends PlatformBean
implements LimitStandardRegistBeanInterface {
    protected LimitStandardDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (LimitStandardDaoInterface)this.createDaoInstance(LimitStandardDaoInterface.class);
    }

    public LimitStandardDtoInterface getInitDto() {
        return new TmmLimitStandardDto();
    }

    public void regist(Collection<LimitStandardDtoInterface> dtos) throws MospException {
        for (LimitStandardDtoInterface dto : dtos) {
            this.regist(dto, null);
        }
    }

    public void copy(String workSettingCode, Date activateDate, Date copiedActivateDate) throws MospException {
        List dtos = this.dao.findForSearch(workSettingCode, copiedActivateDate);
        for (LimitStandardDtoInterface dto : dtos) {
            dto.setActivateDate(activateDate);
            this.regist(dto, null);
        }
    }

    protected void regist(LimitStandardDtoInterface dto, Integer row) throws MospException {
        String term;
        Date activateDate;
        this.validate(dto, row);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String workSettingCode = dto.getWorkSettingCode();
        LimitStandardDtoInterface current = this.dao.findForKey(workSettingCode, activateDate = dto.getActivateDate(), term = dto.getTerm());
        if (current != null) {
            if (LimitStandardRegistBean.isAllTimeSame((LimitStandardDtoInterface)dto, (LimitStandardDtoInterface)current)) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, current.getTmmLimitStandardId());
        }
        if (this.isAllTimeZero(dto)) {
            return;
        }
        dto.setTmmLimitStandardId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(String workSettingCode, Date activateDate) throws MospException {
        for (LimitStandardDtoInterface dto : this.dao.findForSearch(workSettingCode, activateDate)) {
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmLimitStandardId());
        }
    }

    protected boolean isAllTimeZero(LimitStandardDtoInterface dto) {
        return dto.getLimitTime() == 0 && dto.getAttentionTime() == 0 && dto.getWarningTime() == 0;
    }

    public static boolean isAllTimeSame(LimitStandardDtoInterface dto1, LimitStandardDtoInterface dto2) {
        return dto1.getLimitTime() == dto2.getLimitTime() && dto1.getAttentionTime() == dto2.getAttentionTime() && dto1.getWarningTime() == dto2.getWarningTime();
    }

    protected void validate(LimitStandardDtoInterface dto, Integer row) throws MospException {
        String workSettingCode = dto.getWorkSettingCode();
        Date activateDate = dto.getActivateDate();
        String term = dto.getTerm();
        int deleteFlag = dto.getDeleteFlag();
        String nameWorkSettingCode = TimeNamingUtility.timeSettingCode((MospParams)this.mospParams);
        String nameActivateDate = PfNameUtility.activateDate((MospParams)this.mospParams);
        String nameTerm = PfNameUtility.term((MospParams)this.mospParams);
        this.checkRequired((Object)workSettingCode, nameWorkSettingCode, row);
        this.checkRequired((Object)activateDate, nameActivateDate, row);
        this.checkRequired((Object)term, nameTerm, row);
        this.checkTypeCode(workSettingCode, nameWorkSettingCode, row);
        this.checkDeleteFlag(deleteFlag, row);
    }
}

