/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dao.file.ImportDaoInterface;
import jp.mosp.platform.dao.file.ImportFieldDaoInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.InputCheckUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.ImportTableReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeTransactionReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeImportAddonBeanInterface;
import jp.mosp.time.bean.WorkTypeItemReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeItemRegistBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayDataDaoInterface;
import jp.mosp.time.dao.settings.StockHolidayDataDaoInterface;
import jp.mosp.time.dao.settings.TotalTimeDataDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdAttendanceDto;
import jp.mosp.time.dto.settings.impl.TmdHolidayDataDto;
import jp.mosp.time.dto.settings.impl.TmdPaidHolidayDataDto;
import jp.mosp.time.dto.settings.impl.TmdStockHolidayDto;
import jp.mosp.time.dto.settings.impl.TmdTotalTimeDataDto;
import jp.mosp.time.dto.settings.impl.TmmWorkTypeDto;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class ImportTableReferenceBean
extends PlatformBean
implements ImportTableReferenceBeanInterface {
    public static final int MAX_LENGTH_TIME_COMMENT = 50;
    protected static final String CODE_KEY_WORKTYPE_ADDONS = "WorkTypeImportAddons";
    protected ImportDaoInterface importDao;
    protected ImportFieldDaoInterface importFieldDao;
    protected HumanDaoInterface humanDao;
    private AttendanceDaoInterface attendanceDao;
    private TotalTimeDataDaoInterface totalTimeDataDao;
    private HolidayDaoInterface holidayDao;
    private HolidayDataDaoInterface holidayDataDao;
    private PaidHolidayDataDaoInterface paidHolidayDataDao;
    private StockHolidayDataDaoInterface stockHolidayDataDao;
    protected WorkTypeDaoInterface workTypeDao;
    private WorkflowDaoInterface workflowDao;
    private ApplicationReferenceBeanInterface application;
    protected PaidHolidayReferenceBeanInterface paidHolidayReference;
    private TotalTimeTransactionReferenceBeanInterface totalTimeTransaction;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected WorkTypeItemRegistBeanInterface workTypeItemRegist;
    protected WorkTypeItemReferenceBeanInterface workTypeItemRefer;
    protected TimeMasterBeanInterface timeMaster;
    protected List<WorkTypeImportAddonBeanInterface> workTypeAddonBeans;

    public void initBean() throws MospException {
        this.importDao = (ImportDaoInterface)this.createDaoInstance(ImportDaoInterface.class);
        this.importFieldDao = (ImportFieldDaoInterface)this.createDaoInstance(ImportFieldDaoInterface.class);
        this.humanDao = (HumanDaoInterface)this.createDaoInstance(HumanDaoInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDaoInstance(AttendanceDaoInterface.class);
        this.totalTimeDataDao = (TotalTimeDataDaoInterface)this.createDaoInstance(TotalTimeDataDaoInterface.class);
        this.holidayDao = (HolidayDaoInterface)this.createDaoInstance(HolidayDaoInterface.class);
        this.holidayDataDao = (HolidayDataDaoInterface)this.createDaoInstance(HolidayDataDaoInterface.class);
        this.paidHolidayDataDao = (PaidHolidayDataDaoInterface)this.createDaoInstance(PaidHolidayDataDaoInterface.class);
        this.stockHolidayDataDao = (StockHolidayDataDaoInterface)this.createDaoInstance(StockHolidayDataDaoInterface.class);
        this.workTypeDao = (WorkTypeDaoInterface)this.createDaoInstance(WorkTypeDaoInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDaoInstance(WorkflowDaoInterface.class);
        this.application = (ApplicationReferenceBeanInterface)this.createBeanInstance(ApplicationReferenceBeanInterface.class);
        this.paidHolidayReference = (PaidHolidayReferenceBeanInterface)this.createBeanInstance(PaidHolidayReferenceBeanInterface.class);
        this.totalTimeTransaction = (TotalTimeTransactionReferenceBeanInterface)this.createBeanInstance(TotalTimeTransactionReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.workTypeItemRegist = (WorkTypeItemRegistBeanInterface)this.createBeanInstance(WorkTypeItemRegistBeanInterface.class);
        this.workTypeItemRefer = (WorkTypeItemReferenceBeanInterface)this.createBeanInstance(WorkTypeItemReferenceBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.workTypeAddonBeans = null;
    }

    public List<AttendanceDtoInterface> getAttendanceList(String importCode, List<String[]> list) throws MospException {
        ImportDtoInterface importDto = this.importDao.findForKey(importCode);
        if (importDto == null) {
            return null;
        }
        List importFieldDtoList = this.importFieldDao.findForList(importCode);
        if (importFieldDtoList == null || importFieldDtoList.isEmpty()) {
            return null;
        }
        ArrayList<AttendanceDtoInterface> attendanceList = new ArrayList<AttendanceDtoInterface>();
        int i = 0;
        for (String[] csvArray : list) {
            if (importDto.getHeader() == 1 && i == 0) {
                if (!this.checkHeader(importDto, importFieldDtoList, csvArray)) {
                    this.addInvalidHeaderErrorMessage();
                    return null;
                }
            } else {
                WorkflowDtoInterface workflowDto;
                AttendanceDtoInterface attendanceDto;
                boolean hasError = false;
                String employeeCode = "";
                TmdAttendanceDto dto = new TmdAttendanceDto();
                dto.setTimesWork(1);
                dto.setLateReason("");
                dto.setLateCertificate("");
                dto.setLateComment("");
                dto.setLeaveEarlyReason("");
                dto.setLeaveEarlyCertificate("");
                dto.setLeaveEarlyComment("");
                dto.setTimeComment("");
                dto.setRemarks("");
                for (ImportFieldDtoInterface importFieldDto : importFieldDtoList) {
                    int fieldOrder = importFieldDto.getFieldOrder();
                    if (csvArray.length <= fieldOrder - 1) continue;
                    String value = csvArray[fieldOrder - 1];
                    String fieldName = importFieldDto.getFieldName();
                    if (fieldName.equals("employee_code")) {
                        employeeCode = value;
                        continue;
                    }
                    if (fieldName.equals("work_date")) {
                        Date workDate = this.getDate(value);
                        if (workDate == null) {
                            hasError = true;
                            break;
                        }
                        dto.setWorkDate(workDate);
                        continue;
                    }
                    if (fieldName.equals("times_work")) {
                        int timesWork = 0;
                        try {
                            timesWork = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesWork != 1) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesWork(timesWork);
                        continue;
                    }
                    if (fieldName.equals("work_type_code")) {
                        dto.setWorkTypeCode(value);
                        continue;
                    }
                    if (fieldName.equals("direct_start")) {
                        int directStart = 0;
                        try {
                            directStart = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (directStart != 0 && directStart != 1) {
                            hasError = true;
                            break;
                        }
                        dto.setDirectStart(directStart);
                        continue;
                    }
                    if (fieldName.equals("direct_end")) {
                        int directEnd = 0;
                        try {
                            directEnd = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (directEnd != 0 && directEnd != 1) {
                            hasError = true;
                            break;
                        }
                        dto.setDirectEnd(directEnd);
                        continue;
                    }
                    if (fieldName.equals("start_time")) {
                        dto.setStartTime(this.getTimestamp(value));
                        continue;
                    }
                    if (fieldName.equals("actual_start_time")) {
                        dto.setActualStartTime(this.getTimestamp(value));
                        continue;
                    }
                    if (fieldName.equals("end_time")) {
                        dto.setEndTime(this.getTimestamp(value));
                        continue;
                    }
                    if (fieldName.equals("actual_end_time")) {
                        dto.setActualEndTime(this.getTimestamp(value));
                        continue;
                    }
                    if (fieldName.equals("late_days")) {
                        int lateDays = 0;
                        try {
                            lateDays = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateDays < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateDays(lateDays);
                        continue;
                    }
                    if (fieldName.equals("late_thirty_minutes_or_more")) {
                        int lateThirtyMinutesOrMore = 0;
                        try {
                            lateThirtyMinutesOrMore = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateThirtyMinutesOrMore < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateThirtyMinutesOrMore(lateThirtyMinutesOrMore);
                        continue;
                    }
                    if (fieldName.equals("late_less_than_thirty_minutes")) {
                        int lateLessThanThirtyMinutes = 0;
                        try {
                            lateLessThanThirtyMinutes = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateLessThanThirtyMinutes < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateLessThanThirtyMinutes(lateLessThanThirtyMinutes);
                        continue;
                    }
                    if (fieldName.equals("late_time")) {
                        int lateTime = 0;
                        try {
                            lateTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateTime(lateTime);
                        continue;
                    }
                    if (fieldName.equals("late_thirty_minutes_or_more_time")) {
                        int lateThirtyMinutesOrMoreTime = 0;
                        try {
                            lateThirtyMinutesOrMoreTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateThirtyMinutesOrMoreTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateThirtyMinutesOrMoreTime(lateThirtyMinutesOrMoreTime);
                        continue;
                    }
                    if (fieldName.equals("late_less_than_thirty_minutes_time")) {
                        int lateLessThanThirtyMinutesTime = 0;
                        try {
                            lateLessThanThirtyMinutesTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateLessThanThirtyMinutesTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateLessThanThirtyMinutesTime(lateLessThanThirtyMinutesTime);
                        continue;
                    }
                    if (fieldName.equals("late_reason")) {
                        if (value.isEmpty()) {
                            dto.setLateReason("");
                            continue;
                        }
                        if ("individu".equals(value) || "bad_health".equals(value) || "others".equals(value) || "train".equals(value) || "company".equals(value)) {
                            dto.setLateReason(value);
                            continue;
                        }
                        hasError = true;
                        break;
                    }
                    if (fieldName.equals("late_certificate")) {
                        if (value.isEmpty()) {
                            dto.setLateCertificate("");
                            continue;
                        }
                        if ("0".equals(value) || "1".equals(value)) {
                            dto.setLateCertificate(value);
                            continue;
                        }
                        hasError = true;
                        break;
                    }
                    if (fieldName.equals("late_comment")) {
                        this.checkLength(value, 50, "\u9045\u523b\u30b3\u30e1\u30f3\u30c8", Integer.valueOf(fieldOrder));
                        if (this.mospParams.hasErrorMessage()) {
                            hasError = true;
                            break;
                        }
                        dto.setLateComment(value);
                        continue;
                    }
                    if (fieldName.equals("leave_early_days")) {
                        int leaveEarlyDays = 0;
                        try {
                            leaveEarlyDays = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyDays < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyDays(leaveEarlyDays);
                        continue;
                    }
                    if (fieldName.equals("leave_early_thirty_minutes_or_more")) {
                        int leaveEarlyThirtyMinutesOrMore = 0;
                        try {
                            leaveEarlyThirtyMinutesOrMore = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyThirtyMinutesOrMore < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyThirtyMinutesOrMore(leaveEarlyThirtyMinutesOrMore);
                        continue;
                    }
                    if (fieldName.equals("leave_early_less_than_thirty_minutes")) {
                        int leaveEarlyLessThanThirtyMinutes = 0;
                        try {
                            leaveEarlyLessThanThirtyMinutes = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyLessThanThirtyMinutes < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyLessThanThirtyMinutes(leaveEarlyLessThanThirtyMinutes);
                        continue;
                    }
                    if (fieldName.equals("leave_early_time")) {
                        int leaveEarlyTime = 0;
                        try {
                            leaveEarlyTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyTime(leaveEarlyTime);
                        continue;
                    }
                    if (fieldName.equals("leave_early_thirty_minutes_or_more_time")) {
                        int leaveEarlyThirtyMinutesOrMoreTime = 0;
                        try {
                            leaveEarlyThirtyMinutesOrMoreTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyThirtyMinutesOrMoreTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyThirtyMinutesOrMoreTime(leaveEarlyThirtyMinutesOrMoreTime);
                        continue;
                    }
                    if (fieldName.equals("leave_early_less_than_thirty_minutes_time")) {
                        int leaveEarlyLessThanThirtyMinutesTime = 0;
                        try {
                            leaveEarlyLessThanThirtyMinutesTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyLessThanThirtyMinutesTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyLessThanThirtyMinutesTime(leaveEarlyLessThanThirtyMinutesTime);
                        continue;
                    }
                    if (fieldName.equals("leave_early_reason")) {
                        if (value.isEmpty()) {
                            dto.setLeaveEarlyReason("");
                            continue;
                        }
                        if ("individu".equals(value) || "bad_health".equals(value) || "others".equals(value) || "company".equals(value)) {
                            dto.setLeaveEarlyReason(value);
                            continue;
                        }
                        hasError = true;
                        break;
                    }
                    if (fieldName.equals("leave_early_certificate")) {
                        if (value.isEmpty()) {
                            dto.setLeaveEarlyCertificate("");
                            continue;
                        }
                        if ("0".equals(value) || "1".equals(value)) {
                            dto.setLeaveEarlyCertificate(value);
                            continue;
                        }
                        hasError = true;
                        break;
                    }
                    if (fieldName.equals("leave_early_comment")) {
                        this.checkLength(value, 50, "\u65e9\u9000\u30b3\u30e1\u30f3\u30c8", Integer.valueOf(fieldOrder));
                        if (this.mospParams.hasErrorMessage()) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyComment(value);
                        continue;
                    }
                    if (fieldName.equals("work_time")) {
                        int workTime = 0;
                        try {
                            workTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (workTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWorkTime(workTime);
                        continue;
                    }
                    if (fieldName.equals("general_work_time")) {
                        int generalWorkTime = 0;
                        try {
                            generalWorkTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (generalWorkTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setGeneralWorkTime(generalWorkTime);
                        continue;
                    }
                    if (fieldName.equals("work_time_within_prescribed_work_time")) {
                        int workTimeWithinPrescribedWorkTime = 0;
                        try {
                            workTimeWithinPrescribedWorkTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (workTimeWithinPrescribedWorkTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWorkTimeWithinPrescribedWorkTime(workTimeWithinPrescribedWorkTime);
                        continue;
                    }
                    if (fieldName.equals("contract_work_time")) {
                        int contractWorkTime = 0;
                        try {
                            contractWorkTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (contractWorkTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setContractWorkTime(contractWorkTime);
                        continue;
                    }
                    if (fieldName.equals("short_unpaid")) {
                        int shortUnpaid = 0;
                        try {
                            shortUnpaid = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (shortUnpaid < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setShortUnpaid(shortUnpaid);
                        continue;
                    }
                    if (fieldName.equals("rest_time")) {
                        int restTime = 0;
                        try {
                            restTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (restTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setRestTime(restTime);
                        continue;
                    }
                    if (fieldName.equals("over_rest_time")) {
                        int overRestTime = 0;
                        try {
                            overRestTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overRestTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOverRestTime(overRestTime);
                        continue;
                    }
                    if (fieldName.equals("night_rest_time")) {
                        int nightRestTime = 0;
                        try {
                            nightRestTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (nightRestTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setNightRestTime(nightRestTime);
                        continue;
                    }
                    if (fieldName.equals("legal_holiday_rest_time")) {
                        int legalHolidayRestTime = 0;
                        try {
                            legalHolidayRestTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (legalHolidayRestTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLegalHolidayRestTime(legalHolidayRestTime);
                        continue;
                    }
                    if (fieldName.equals("prescribed_holiday_rest_time")) {
                        int prescribedHolidayRestTime = 0;
                        try {
                            prescribedHolidayRestTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (prescribedHolidayRestTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrescribedHolidayRestTime(prescribedHolidayRestTime);
                        continue;
                    }
                    if (fieldName.equals("public_time")) {
                        int publicTime = 0;
                        try {
                            publicTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (publicTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPublicTime(publicTime);
                        continue;
                    }
                    if (fieldName.equals("private_time")) {
                        int privateTime = 0;
                        try {
                            privateTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (privateTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrivateTime(privateTime);
                        continue;
                    }
                    if (fieldName.equals("times_overtime")) {
                        int timesOvertime = 0;
                        try {
                            timesOvertime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesOvertime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesOvertime(timesOvertime);
                        continue;
                    }
                    if (fieldName.equals("overtime")) {
                        int overtime = 0;
                        try {
                            overtime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertime(overtime);
                        continue;
                    }
                    if ("overtime_before".equals(fieldName)) {
                        int overtimeBefore = 0;
                        try {
                            overtimeBefore = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeBefore < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeBefore(overtimeBefore);
                        continue;
                    }
                    if ("overtime_after".equals(fieldName)) {
                        int overtimeAfter = 0;
                        try {
                            overtimeAfter = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeAfter < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeAfter(overtimeAfter);
                        continue;
                    }
                    if (fieldName.equals("overtime_in")) {
                        int overtimeIn = 0;
                        try {
                            overtimeIn = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeIn < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeIn(overtimeIn);
                        continue;
                    }
                    if (fieldName.equals("overtime_out")) {
                        int overtimeOut = 0;
                        try {
                            overtimeOut = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeOut < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeOut(overtimeOut);
                        continue;
                    }
                    if (fieldName.equals("workday_overtime_in")) {
                        int workdayOvertimeIn = 0;
                        try {
                            workdayOvertimeIn = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (workdayOvertimeIn < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWorkdayOvertimeIn(workdayOvertimeIn);
                        continue;
                    }
                    if (fieldName.equals("workday_overtime_out")) {
                        int workdayOvertimeOut = 0;
                        try {
                            workdayOvertimeOut = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (workdayOvertimeOut < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWorkdayOvertimeOut(workdayOvertimeOut);
                        continue;
                    }
                    if (fieldName.equals("prescribed_holiday_overtime_in")) {
                        int prescribedHolidayOvertimeIn = 0;
                        try {
                            prescribedHolidayOvertimeIn = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (prescribedHolidayOvertimeIn < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrescribedHolidayOvertimeIn(prescribedHolidayOvertimeIn);
                        continue;
                    }
                    if (fieldName.equals("prescribed_holiday_overtime_out")) {
                        int prescribedHolidayOvertimeOut = 0;
                        try {
                            prescribedHolidayOvertimeOut = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (prescribedHolidayOvertimeOut < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrescribedHolidayOvertimeOut(prescribedHolidayOvertimeOut);
                        continue;
                    }
                    if (fieldName.equals("late_night_time")) {
                        int lateNightTime = 0;
                        try {
                            lateNightTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateNightTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateNightTime(lateNightTime);
                        continue;
                    }
                    if (fieldName.equals("night_work_within_prescribed_work")) {
                        int nightWorkWithinPrescribedWork = 0;
                        try {
                            nightWorkWithinPrescribedWork = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (nightWorkWithinPrescribedWork < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setNightWorkWithinPrescribedWork(nightWorkWithinPrescribedWork);
                        continue;
                    }
                    if (fieldName.equals("night_overtime_work")) {
                        int nightOvertimeWork = 0;
                        try {
                            nightOvertimeWork = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (nightOvertimeWork < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setNightOvertimeWork(nightOvertimeWork);
                        continue;
                    }
                    if (fieldName.equals("night_work_on_holiday")) {
                        int nightWorkOnHoliday = 0;
                        try {
                            nightWorkOnHoliday = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (nightWorkOnHoliday < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setNightWorkOnHoliday(nightWorkOnHoliday);
                        continue;
                    }
                    if (fieldName.equals("specific_work_time")) {
                        int specificWorkTime = 0;
                        try {
                            specificWorkTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (specificWorkTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setSpecificWorkTime(specificWorkTime);
                        continue;
                    }
                    if (fieldName.equals("legal_work_time")) {
                        int legalWorkTime = 0;
                        try {
                            legalWorkTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (legalWorkTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLegalWorkTime(legalWorkTime);
                        continue;
                    }
                    if (fieldName.equals("decrease_time")) {
                        int decreaseTime = 0;
                        try {
                            decreaseTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (decreaseTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setDecreaseTime(decreaseTime);
                        continue;
                    }
                    if (fieldName.equals("time_comment")) {
                        dto.setTimeComment(value);
                        continue;
                    }
                    if (fieldName.equals("work_days")) {
                        double workDays = 0.0;
                        try {
                            workDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (workDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setWorkDays(workDays);
                        continue;
                    }
                    if (fieldName.equals("work_days_for_paid_leave")) {
                        int workDaysForPaidLeave = 0;
                        try {
                            workDaysForPaidLeave = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (workDaysForPaidLeave < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWorkDaysForPaidLeave(workDaysForPaidLeave);
                        continue;
                    }
                    if (fieldName.equals("total_work_days_for_paid_leave")) {
                        int totalWorkDaysForPaidLeave = 0;
                        try {
                            totalWorkDaysForPaidLeave = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (totalWorkDaysForPaidLeave < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTotalWorkDaysForPaidLeave(totalWorkDaysForPaidLeave);
                        continue;
                    }
                    if (fieldName.equals("times_holiday_work")) {
                        int timesHolidayWork = 0;
                        try {
                            timesHolidayWork = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesHolidayWork < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesHolidayWork(timesHolidayWork);
                        continue;
                    }
                    if (fieldName.equals("times_legal_holiday_work")) {
                        int timesLegalHolidayWork = 0;
                        try {
                            timesLegalHolidayWork = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesLegalHolidayWork < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesLegalHolidayWork(timesLegalHolidayWork);
                        continue;
                    }
                    if (fieldName.equals("times_prescribed_holiday_work")) {
                        int timesPrescribedHolidayWork = 0;
                        try {
                            timesPrescribedHolidayWork = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesPrescribedHolidayWork < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesPrescribedHolidayWork(timesPrescribedHolidayWork);
                        continue;
                    }
                    if (fieldName.equals("paid_leave_days")) {
                        double paidLeaveDays = 0.0;
                        try {
                            paidLeaveDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (paidLeaveDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setPaidLeaveDays(paidLeaveDays);
                        continue;
                    }
                    if (fieldName.equals("paid_leave_hours")) {
                        int paidLeaveHours = 0;
                        try {
                            paidLeaveHours = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (paidLeaveHours < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPaidLeaveHours(paidLeaveHours);
                        continue;
                    }
                    if (fieldName.equals("stock_leave_days")) {
                        double stockLeaveDays = 0.0;
                        try {
                            stockLeaveDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (stockLeaveDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setStockLeaveDays(stockLeaveDays);
                        continue;
                    }
                    if (fieldName.equals("compensation_days")) {
                        double compensationDays = 0.0;
                        try {
                            compensationDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (compensationDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setCompensationDays(compensationDays);
                        continue;
                    }
                    if (fieldName.equals("legal_compensation_days")) {
                        double legalCompensationDays = 0.0;
                        try {
                            legalCompensationDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (legalCompensationDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setLegalCompensationDays(legalCompensationDays);
                        continue;
                    }
                    if (fieldName.equals("prescribed_compensation_days")) {
                        double prescribedCompensationDays = 0.0;
                        try {
                            prescribedCompensationDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (prescribedCompensationDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrescribedCompensationDays(prescribedCompensationDays);
                        continue;
                    }
                    if (fieldName.equals("night_compensation_days")) {
                        double nightCompensationDays = 0.0;
                        try {
                            nightCompensationDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (nightCompensationDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setNightCompensationDays(nightCompensationDays);
                        continue;
                    }
                    if (fieldName.equals("special_leave_days")) {
                        double specialLeaveDays = 0.0;
                        try {
                            specialLeaveDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (specialLeaveDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setSpecialLeaveDays(specialLeaveDays);
                        continue;
                    }
                    if (fieldName.equals("special_leave_hours")) {
                        int specialLeaveHours = 0;
                        try {
                            specialLeaveHours = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (specialLeaveHours < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setSpecialLeaveHours(specialLeaveHours);
                        continue;
                    }
                    if (fieldName.equals("other_leave_days")) {
                        double otherLeaveDays = 0.0;
                        try {
                            otherLeaveDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (otherLeaveDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setOtherLeaveDays(otherLeaveDays);
                        continue;
                    }
                    if (fieldName.equals("other_leave_hours")) {
                        int otherLeaveHours = 0;
                        try {
                            otherLeaveHours = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (otherLeaveHours < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOtherLeaveHours(otherLeaveHours);
                        continue;
                    }
                    if (fieldName.equals("absence_days")) {
                        double absenceDays = 0.0;
                        try {
                            absenceDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (absenceDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setAbsenceDays(absenceDays);
                        continue;
                    }
                    if (fieldName.equals("absence_hours")) {
                        int absenceHours = 0;
                        try {
                            absenceHours = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (absenceHours < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setAbsenceHours(absenceHours);
                        continue;
                    }
                    if (fieldName.equals("granted_legal_compensation_days")) {
                        double grantedLegalCompensationDays = 0.0;
                        try {
                            grantedLegalCompensationDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (grantedLegalCompensationDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setGrantedLegalCompensationDays(grantedLegalCompensationDays);
                        continue;
                    }
                    if (fieldName.equals("granted_prescribed_compensation_days")) {
                        double grantedPrescribedCompensationDays = 0.0;
                        try {
                            grantedPrescribedCompensationDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (grantedPrescribedCompensationDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setGrantedPrescribedCompensationDays(grantedPrescribedCompensationDays);
                        continue;
                    }
                    if (fieldName.equals("granted_night_compensation_days")) {
                        double grantedNightCompensationDays = 0.0;
                        try {
                            grantedNightCompensationDays = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (grantedNightCompensationDays < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setGrantedNightCompensationDays(grantedNightCompensationDays);
                        continue;
                    }
                    if (fieldName.equals("legal_holiday_work_time_with_compensation_day")) {
                        int legalHolidayWorkTimeWithCompensationDay = 0;
                        try {
                            legalHolidayWorkTimeWithCompensationDay = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (legalHolidayWorkTimeWithCompensationDay < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLegalHolidayWorkTimeWithCompensationDay(legalHolidayWorkTimeWithCompensationDay);
                        continue;
                    }
                    if (fieldName.equals("legal_holiday_work_time_without_compensation_day")) {
                        int legalHolidayWorkTimeWithoutCompensationDay = 0;
                        try {
                            legalHolidayWorkTimeWithoutCompensationDay = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (legalHolidayWorkTimeWithoutCompensationDay < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLegalHolidayWorkTimeWithoutCompensationDay(legalHolidayWorkTimeWithoutCompensationDay);
                        continue;
                    }
                    if (fieldName.equals("prescribed_holiday_work_time_with_compensation_day")) {
                        int prescribedHolidayWorkTimeWithCompensationDay = 0;
                        try {
                            prescribedHolidayWorkTimeWithCompensationDay = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (prescribedHolidayWorkTimeWithCompensationDay < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrescribedHolidayWorkTimeWithCompensationDay(prescribedHolidayWorkTimeWithCompensationDay);
                        continue;
                    }
                    if (fieldName.equals("prescribed_holiday_work_time_without_compensation_day")) {
                        int prescribedHolidayWorkTimeWithoutCompensationDay = 0;
                        try {
                            prescribedHolidayWorkTimeWithoutCompensationDay = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (prescribedHolidayWorkTimeWithoutCompensationDay < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrescribedHolidayWorkTimeWithoutCompensationDay(prescribedHolidayWorkTimeWithoutCompensationDay);
                        continue;
                    }
                    if (fieldName.equals("overtime_in_with_compensation_day")) {
                        int overtimeInWithCompensationDay = 0;
                        try {
                            overtimeInWithCompensationDay = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeInWithCompensationDay < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeInWithCompensationDay(overtimeInWithCompensationDay);
                        continue;
                    }
                    if (fieldName.equals("overtime_in_without_compensation_day")) {
                        int overtimeInWithoutCompensationDay = 0;
                        try {
                            overtimeInWithoutCompensationDay = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeInWithoutCompensationDay < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeInWithoutCompensationDay(overtimeInWithoutCompensationDay);
                        continue;
                    }
                    if (fieldName.equals("overtime_out_with_compensation_day")) {
                        int overtimeOutWithCompensationDay = 0;
                        try {
                            overtimeOutWithCompensationDay = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeOutWithCompensationDay < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeOutWithCompensationDay(overtimeOutWithCompensationDay);
                        continue;
                    }
                    if (fieldName.equals("overtime_out_without_compensation_day")) {
                        int overtimeOutWithoutCompensationDay = 0;
                        try {
                            overtimeOutWithoutCompensationDay = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeOutWithoutCompensationDay < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeOutWithoutCompensationDay(overtimeOutWithoutCompensationDay);
                        continue;
                    }
                    if (fieldName.equals("statutory_holiday_work_time_in")) {
                        int statutoryHolidayWorkTimeIn = 0;
                        try {
                            statutoryHolidayWorkTimeIn = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (statutoryHolidayWorkTimeIn < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setStatutoryHolidayWorkTimeIn(statutoryHolidayWorkTimeIn);
                        continue;
                    }
                    if (fieldName.equals("statutory_holiday_work_time_out")) {
                        int statutoryHolidayWorkTimeOut = 0;
                        try {
                            statutoryHolidayWorkTimeOut = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (statutoryHolidayWorkTimeOut < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setStatutoryHolidayWorkTimeOut(statutoryHolidayWorkTimeOut);
                        continue;
                    }
                    if (fieldName.equals("prescribed_holiday_work_time_in")) {
                        int prescribedHolidayWorkTimeIn = 0;
                        try {
                            prescribedHolidayWorkTimeIn = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (prescribedHolidayWorkTimeIn < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrescribedHolidayWorkTimeIn(prescribedHolidayWorkTimeIn);
                        continue;
                    }
                    if (!fieldName.equals("prescribed_holiday_work_time_out")) continue;
                    int prescribedHolidayWorkTimeOut = 0;
                    try {
                        prescribedHolidayWorkTimeOut = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        hasError = true;
                        break;
                    }
                    if (prescribedHolidayWorkTimeOut < 0) {
                        hasError = true;
                        break;
                    }
                    dto.setPrescribedHolidayWorkTimeOut(prescribedHolidayWorkTimeOut);
                }
                if (!hasError && employeeCode.isEmpty()) {
                    hasError = true;
                }
                if (!hasError && dto.getWorkDate() == null) {
                    hasError = true;
                }
                if (!hasError) {
                    HumanDtoInterface humanDto = this.humanDao.findForEmployeeCode(employeeCode, dto.getWorkDate());
                    if (humanDto == null || humanDto.getPersonalId() == null || humanDto.getPersonalId().isEmpty()) {
                        hasError = true;
                    } else {
                        dto.setPersonalId(humanDto.getPersonalId());
                    }
                }
                if (!hasError) {
                    if (dto.getWorkTypeCode() == null || dto.getWorkTypeCode().isEmpty()) {
                        hasError = true;
                    } else {
                        WorkTypeDtoInterface workTypeDto = this.workTypeDao.findForInfo(dto.getWorkTypeCode(), dto.getWorkDate());
                        if (workTypeDto == null) {
                            hasError = true;
                        }
                    }
                }
                if (hasError) {
                    this.addInvalidDataErrorMessage(i);
                } else {
                    for (AttendanceDtoInterface attendanceDto2 : attendanceList) {
                        if (!attendanceDto2.getPersonalId().equals(dto.getPersonalId()) || !attendanceDto2.getWorkDate().equals(dto.getWorkDate()) || attendanceDto2.getTimesWork() != dto.getTimesWork()) continue;
                        this.addDuplicateDataErrorMessage(i);
                        hasError = true;
                        break;
                    }
                }
                if (!hasError && (attendanceDto = this.attendanceDao.findForKey(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork())) != null && (workflowDto = this.workflowDao.findForKey(attendanceDto.getWorkflow())) != null) {
                    if ("0".equals(workflowDto.getWorkflowStatus())) {
                        dto.setTmdAttendanceId(attendanceDto.getTmdAttendanceId());
                        dto.setWorkflow(attendanceDto.getWorkflow());
                    } else if ("1".equals(workflowDto.getWorkflowStatus()) || "2".equals(workflowDto.getWorkflowStatus()) || "3".equals(workflowDto.getWorkflowStatus()) || "4".equals(workflowDto.getWorkflowStatus()) || "9".equals(workflowDto.getWorkflowStatus()) || this.workflowIntegrate.isCancelApprovable(workflowDto)) {
                        this.addAlreadyRegisteredDataErrorMessage(i);
                        hasError = true;
                        break;
                    }
                }
                if (!hasError) {
                    attendanceList.add((AttendanceDtoInterface)dto);
                }
            }
            ++i;
        }
        return attendanceList;
    }

    public List<TotalTimeDataDtoInterface> getTotalTimeList(String importCode, List<String[]> list) throws MospException {
        ImportDtoInterface importDto = this.importDao.findForKey(importCode);
        if (importDto == null) {
            return null;
        }
        List importFieldDtoList = this.importFieldDao.findForList(importCode);
        if (importFieldDtoList == null || importFieldDtoList.isEmpty()) {
            return null;
        }
        ArrayList<TotalTimeDataDtoInterface> totaltimeList = new ArrayList<TotalTimeDataDtoInterface>();
        int i = 0;
        for (String[] csvArray : list) {
            if (importDto.getHeader() == 1 && i == 0) {
                if (!this.checkHeader(importDto, importFieldDtoList, csvArray)) {
                    this.addInvalidHeaderErrorMessage();
                    return null;
                }
            } else {
                TotalTimeDataDtoInterface totalTimeDataDto;
                boolean hasError = false;
                String employeeCode = "";
                TmdTotalTimeDataDto dto = new TmdTotalTimeDataDto();
                for (ImportFieldDtoInterface importFieldDto : importFieldDtoList) {
                    int fieldOrder = importFieldDto.getFieldOrder();
                    if (csvArray.length <= fieldOrder - 1) continue;
                    String value = csvArray[fieldOrder - 1];
                    String fieldName = importFieldDto.getFieldName();
                    if (fieldName.equals("employee_code")) {
                        employeeCode = value;
                        continue;
                    }
                    if (fieldName.equals("calculation_year")) {
                        InputCheckUtility.checkYear((MospParams)this.mospParams, (String)value, (String)fieldName);
                        if (this.mospParams.hasErrorMessage()) {
                            hasError = true;
                            break;
                        }
                        dto.setCalculationYear(MospUtility.getInt((Object)value));
                        continue;
                    }
                    if (fieldName.equals("calculation_month")) {
                        InputCheckUtility.checkMonth((MospParams)this.mospParams, (String)value, (String)fieldName);
                        if (this.mospParams.hasErrorMessage()) {
                            hasError = true;
                            break;
                        }
                        dto.setCalculationMonth(MospUtility.getInt((Object)value));
                        continue;
                    }
                    if (fieldName.equals("calculation_date")) {
                        Date calculationDate = this.getDate(value);
                        if (calculationDate == null) {
                            hasError = true;
                            break;
                        }
                        dto.setCalculationDate(calculationDate);
                        continue;
                    }
                    if (fieldName.equals("work_time")) {
                        int workTime = 0;
                        try {
                            workTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (workTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWorkTime(workTime);
                        continue;
                    }
                    if ("specific_work_time".equals(fieldName)) {
                        int specificWorkTime = 0;
                        try {
                            specificWorkTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (specificWorkTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setSpecificWorkTime(specificWorkTime);
                        continue;
                    }
                    if ("short_unpaid".equals(fieldName)) {
                        int shortUnpaid = 0;
                        try {
                            shortUnpaid = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (shortUnpaid < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setShortUnpaid(shortUnpaid);
                        continue;
                    }
                    if (fieldName.equals("times_work_date")) {
                        double timesWorkDate = 0.0;
                        try {
                            timesWorkDate = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesWorkDate < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesWorkDate(timesWorkDate);
                        continue;
                    }
                    if (fieldName.equals("times_work")) {
                        int timesWork = 0;
                        try {
                            timesWork = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesWork < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesWork(timesWork);
                        continue;
                    }
                    if (fieldName.equals("legal_work_on_holiday")) {
                        double legalWorkOnHoliday = 0.0;
                        try {
                            legalWorkOnHoliday = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (legalWorkOnHoliday < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setLegalWorkOnHoliday(legalWorkOnHoliday);
                        continue;
                    }
                    if (fieldName.equals("specific_work_on_holiday")) {
                        double specificWorkOnHoliday = 0.0;
                        try {
                            specificWorkOnHoliday = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (specificWorkOnHoliday < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setSpecificWorkOnHoliday(specificWorkOnHoliday);
                        continue;
                    }
                    if (fieldName.equals("times_achievement")) {
                        int timesAchievement = 0;
                        try {
                            timesAchievement = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesAchievement < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesAchievement(timesAchievement);
                        continue;
                    }
                    if (fieldName.equals("times_total_work_date")) {
                        int timesTotalWorkDate = 0;
                        try {
                            timesTotalWorkDate = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesTotalWorkDate < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesTotalWorkDate(timesTotalWorkDate);
                        continue;
                    }
                    if (fieldName.equals("direct_start")) {
                        int directStart = 0;
                        try {
                            directStart = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (directStart < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setDirectStart(directStart);
                        continue;
                    }
                    if (fieldName.equals("direct_end")) {
                        int directEnd = 0;
                        try {
                            directEnd = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (directEnd < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setDirectEnd(directEnd);
                        continue;
                    }
                    if (fieldName.equals("rest_time")) {
                        int restTime = 0;
                        try {
                            restTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (restTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setRestTime(restTime);
                        continue;
                    }
                    if (fieldName.equals("rest_late_night")) {
                        int restLateNight = 0;
                        try {
                            restLateNight = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (restLateNight < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setRestLateNight(restLateNight);
                        continue;
                    }
                    if (fieldName.equals("rest_work_on_specific_holiday")) {
                        int restWorkOnSpecificHoliday = 0;
                        try {
                            restWorkOnSpecificHoliday = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (restWorkOnSpecificHoliday < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setRestWorkOnSpecificHoliday(restWorkOnSpecificHoliday);
                        continue;
                    }
                    if (fieldName.equals("rest_work_on_holiday")) {
                        int restWorkOnHoliday = 0;
                        try {
                            restWorkOnHoliday = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (restWorkOnHoliday < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setRestWorkOnHoliday(restWorkOnHoliday);
                        continue;
                    }
                    if (fieldName.equals("public_time")) {
                        int publicTime = 0;
                        try {
                            publicTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (publicTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPublicTime(publicTime);
                        continue;
                    }
                    if (fieldName.equals("private_time")) {
                        int privateTime = 0;
                        try {
                            privateTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (privateTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrivateTime(privateTime);
                        continue;
                    }
                    if ("overtime".equals(fieldName)) {
                        int overtime = 0;
                        try {
                            overtime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertime(overtime);
                        continue;
                    }
                    if ("overtime_in".equals(fieldName)) {
                        int overtimeIn = 0;
                        try {
                            overtimeIn = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeIn < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeIn(overtimeIn);
                        continue;
                    }
                    if (fieldName.equals("overtime_out")) {
                        int overtimeOut = 0;
                        try {
                            overtimeOut = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeOut < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeOut(overtimeOut);
                        continue;
                    }
                    if (fieldName.equals("late_night")) {
                        int lateNight = 0;
                        try {
                            lateNight = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateNight < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateNight(lateNight);
                        continue;
                    }
                    if (fieldName.equals("night_work_within_prescribed_work")) {
                        int nightWorkWithinPrescribedWork = 0;
                        try {
                            nightWorkWithinPrescribedWork = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (nightWorkWithinPrescribedWork < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setNightWorkWithinPrescribedWork(nightWorkWithinPrescribedWork);
                        continue;
                    }
                    if (fieldName.equals("night_overtime_work")) {
                        int nightOvertimeWork = 0;
                        try {
                            nightOvertimeWork = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (nightOvertimeWork < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setNightOvertimeWork(nightOvertimeWork);
                        continue;
                    }
                    if (fieldName.equals("night_work_on_holiday")) {
                        int nightWorkOnHoliday = 0;
                        try {
                            nightWorkOnHoliday = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (nightWorkOnHoliday < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setNightWorkOnHoliday(nightWorkOnHoliday);
                        continue;
                    }
                    if (fieldName.equals("work_on_specific_holiday")) {
                        int workOnSpecificHoliday = 0;
                        try {
                            workOnSpecificHoliday = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (workOnSpecificHoliday < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWorkOnSpecificHoliday(workOnSpecificHoliday);
                        continue;
                    }
                    if (fieldName.equals("work_on_holiday")) {
                        int workOnHoliday = 0;
                        try {
                            workOnHoliday = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (workOnHoliday < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWorkOnHoliday(workOnHoliday);
                        continue;
                    }
                    if (fieldName.equals("decrease_time")) {
                        int decreaseTime = 0;
                        try {
                            decreaseTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (decreaseTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setDecreaseTime(decreaseTime);
                        continue;
                    }
                    if (fieldName.equals("forty_five_hour_overtime")) {
                        int fortyFiveHourOvertime = 0;
                        try {
                            fortyFiveHourOvertime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (fortyFiveHourOvertime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setFortyFiveHourOvertime(fortyFiveHourOvertime);
                        continue;
                    }
                    if (fieldName.equals("times_overtime")) {
                        int timesOvertime = 0;
                        try {
                            timesOvertime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesOvertime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesOvertime(timesOvertime);
                        continue;
                    }
                    if (fieldName.equals("times_working_holiday")) {
                        int timesWorkingHoliday = 0;
                        try {
                            timesWorkingHoliday = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesWorkingHoliday < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesWorkingHoliday(timesWorkingHoliday);
                        continue;
                    }
                    if ("late_days".equals(fieldName)) {
                        int lateDays = 0;
                        try {
                            lateDays = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateDays < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateDays(lateDays);
                        continue;
                    }
                    if ("late_thirty_minutes_or_more".equals(fieldName)) {
                        int lateThirtyMinutesOrMore = 0;
                        try {
                            lateThirtyMinutesOrMore = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateThirtyMinutesOrMore < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateThirtyMinutesOrMore(lateThirtyMinutesOrMore);
                        continue;
                    }
                    if ("late_less_than_thirty_minutes".equals(fieldName)) {
                        int lateLessThanThirtyMinutes = 0;
                        try {
                            lateLessThanThirtyMinutes = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateLessThanThirtyMinutes < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateLessThanThirtyMinutes(lateLessThanThirtyMinutes);
                        continue;
                    }
                    if ("late_time".equals(fieldName)) {
                        int lateTime = 0;
                        try {
                            lateTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateTime(lateTime);
                        continue;
                    }
                    if ("late_thirty_minutes_or_more_time".equals(fieldName)) {
                        int lateThirtyMinutesOrMoreTime = 0;
                        try {
                            lateThirtyMinutesOrMoreTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateThirtyMinutesOrMoreTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateThirtyMinutesOrMoreTime(lateThirtyMinutesOrMoreTime);
                        continue;
                    }
                    if ("late_less_than_thirty_minutes_time".equals(fieldName)) {
                        int lateLessThanThirtyMinutesTime = 0;
                        try {
                            lateLessThanThirtyMinutesTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateLessThanThirtyMinutesTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateLessThanThirtyMinutesTime(lateLessThanThirtyMinutesTime);
                        continue;
                    }
                    if ("times_late".equals(fieldName)) {
                        int timesLate = 0;
                        try {
                            timesLate = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesLate < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesLate(timesLate);
                        continue;
                    }
                    if ("leave_early_days".equals(fieldName)) {
                        int leaveEarlyDays = 0;
                        try {
                            leaveEarlyDays = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyDays < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyDays(leaveEarlyDays);
                        continue;
                    }
                    if ("leave_early_thirty_minutes_or_more".equals(fieldName)) {
                        int leaveEarlyThirtyMinutesOrMore = 0;
                        try {
                            leaveEarlyThirtyMinutesOrMore = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyThirtyMinutesOrMore < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyThirtyMinutesOrMore(leaveEarlyThirtyMinutesOrMore);
                        continue;
                    }
                    if ("leave_early_less_than_thirty_minutes".equals(fieldName)) {
                        int leaveEarlyLessThanThirtyMinutes = 0;
                        try {
                            leaveEarlyLessThanThirtyMinutes = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyLessThanThirtyMinutes < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyLessThanThirtyMinutes(leaveEarlyLessThanThirtyMinutes);
                        continue;
                    }
                    if ("leave_early_time".equals(fieldName)) {
                        int leaveEarlyTime = 0;
                        try {
                            leaveEarlyTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyTime(leaveEarlyTime);
                        continue;
                    }
                    if ("leave_early_thirty_minutes_or_more_time".equals(fieldName)) {
                        int leaveEarlyThirtyMinutesOrMoreTime = 0;
                        try {
                            leaveEarlyThirtyMinutesOrMoreTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyThirtyMinutesOrMoreTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyThirtyMinutesOrMoreTime(leaveEarlyThirtyMinutesOrMoreTime);
                        continue;
                    }
                    if ("leave_early_less_than_thirty_minutes_time".equals(fieldName)) {
                        int leaveEarlyLessThanThirtyMinutesTime = 0;
                        try {
                            leaveEarlyLessThanThirtyMinutesTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (leaveEarlyLessThanThirtyMinutesTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setLeaveEarlyLessThanThirtyMinutesTime(leaveEarlyLessThanThirtyMinutesTime);
                        continue;
                    }
                    if ("times_leave_early".equals(fieldName)) {
                        int timesLeaveEarly = 0;
                        try {
                            timesLeaveEarly = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesLeaveEarly < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesLeaveEarly(timesLeaveEarly);
                        continue;
                    }
                    if (fieldName.equals("times_holiday")) {
                        int timesHoliday = 0;
                        try {
                            timesHoliday = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesHoliday < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesHoliday(timesHoliday);
                        continue;
                    }
                    if (fieldName.equals("times_legal_holiday")) {
                        int timesLegalHoliday = 0;
                        try {
                            timesLegalHoliday = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesLegalHoliday < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesLegalHoliday(timesLegalHoliday);
                        continue;
                    }
                    if (fieldName.equals("times_specific_holiday")) {
                        int timesSpecificHoliday = 0;
                        try {
                            timesSpecificHoliday = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesSpecificHoliday < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesSpecificHoliday(timesSpecificHoliday);
                        continue;
                    }
                    if (fieldName.equals("times_paid_holiday")) {
                        double timesPaidHoliday = 0.0;
                        try {
                            timesPaidHoliday = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesPaidHoliday < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesPaidHoliday(timesPaidHoliday);
                        continue;
                    }
                    if (fieldName.equals("paid_holiday_hour")) {
                        int paidHolidayHour = 0;
                        try {
                            paidHolidayHour = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (paidHolidayHour < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPaidHolidayHour(paidHolidayHour);
                        continue;
                    }
                    if (fieldName.equals("times_stock_holiday")) {
                        double timesStockHoliday = 0.0;
                        try {
                            timesStockHoliday = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesStockHoliday < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesStockHoliday(timesStockHoliday);
                        continue;
                    }
                    if (fieldName.equals("times_compensation")) {
                        double timesCompensation = 0.0;
                        try {
                            timesCompensation = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesCompensation < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesCompensation(timesCompensation);
                        continue;
                    }
                    if (fieldName.equals("times_legal_compensation")) {
                        double timesLegalCompensation = 0.0;
                        try {
                            timesLegalCompensation = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesLegalCompensation < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesLegalCompensation(timesLegalCompensation);
                        continue;
                    }
                    if (fieldName.equals("times_specific_compensation")) {
                        double timesSpecificCompensation = 0.0;
                        try {
                            timesSpecificCompensation = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesSpecificCompensation < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesSpecificCompensation(timesSpecificCompensation);
                        continue;
                    }
                    if (fieldName.equals("times_late_compensation")) {
                        double timesLateCompensation = 0.0;
                        try {
                            timesLateCompensation = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesLateCompensation < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesLateCompensation(timesLateCompensation);
                        continue;
                    }
                    if (fieldName.equals("times_holiday_substitute")) {
                        double timesHolidaySubstitute = 0.0;
                        try {
                            timesHolidaySubstitute = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesHolidaySubstitute < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesHolidaySubstitute(timesHolidaySubstitute);
                        continue;
                    }
                    if (fieldName.equals("times_legal_holiday_substitute")) {
                        double timesLegalHolidaySubstitute = 0.0;
                        try {
                            timesLegalHolidaySubstitute = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesLegalHolidaySubstitute < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesLegalHolidaySubstitute(timesLegalHolidaySubstitute);
                        continue;
                    }
                    if (fieldName.equals("times_specific_holiday_substitute")) {
                        double timesSpecificHolidaySubstitute = 0.0;
                        try {
                            timesSpecificHolidaySubstitute = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesSpecificHolidaySubstitute < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesSpecificHolidaySubstitute(timesSpecificHolidaySubstitute);
                        continue;
                    }
                    if (fieldName.equals("total_special_holiday")) {
                        double totalSpecialHoliday = 0.0;
                        try {
                            totalSpecialHoliday = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (totalSpecialHoliday < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTotalSpecialHoliday(totalSpecialHoliday);
                        continue;
                    }
                    if (fieldName.equals("special_holiday_hour")) {
                        int specialHolidayHour = 0;
                        try {
                            specialHolidayHour = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (specialHolidayHour < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setSpecialHolidayHour(specialHolidayHour);
                        continue;
                    }
                    if (fieldName.equals("total_other_holiday")) {
                        double totalOtherHoliday = 0.0;
                        try {
                            totalOtherHoliday = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (totalOtherHoliday < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTotalOtherHoliday(totalOtherHoliday);
                        continue;
                    }
                    if (fieldName.equals("other_holiday_hour")) {
                        int otherHolidayHour = 0;
                        try {
                            otherHolidayHour = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (otherHolidayHour < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOtherHolidayHour(otherHolidayHour);
                        continue;
                    }
                    if (fieldName.equals("total_absence")) {
                        double totalAbsence = 0.0;
                        try {
                            totalAbsence = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (totalAbsence < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTotalAbsence(totalAbsence);
                        continue;
                    }
                    if (fieldName.equals("absence_hour")) {
                        int absenceHolidayHour = 0;
                        try {
                            absenceHolidayHour = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (absenceHolidayHour < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setAbsenceHour(absenceHolidayHour);
                        continue;
                    }
                    if (fieldName.equals("total_allowance")) {
                        int totalAllowance = 0;
                        try {
                            totalAllowance = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (totalAllowance < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setTotalAllowance(totalAllowance);
                        continue;
                    }
                    if (fieldName.equals("sixty_hour_overtime")) {
                        int sixtyHourOvertime = 0;
                        try {
                            sixtyHourOvertime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (sixtyHourOvertime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setSixtyHourOvertime(sixtyHourOvertime);
                        continue;
                    }
                    if (fieldName.equals("week_day_overtime")) {
                        int weekDayOvertime = 0;
                        try {
                            weekDayOvertime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (weekDayOvertime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWeekDayOvertime(weekDayOvertime);
                        continue;
                    }
                    if (fieldName.equals("specific_overtime")) {
                        int specificOvertime = 0;
                        try {
                            specificOvertime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (specificOvertime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setSpecificOvertime(specificOvertime);
                        continue;
                    }
                    if (fieldName.equals("times_alternative")) {
                        double timesAlternative = 0.0;
                        try {
                            timesAlternative = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (timesAlternative < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setTimesAlternative(timesAlternative);
                        continue;
                    }
                    if ("legal_compensation_unused".equals(fieldName)) {
                        double legalCompensationUnused = 0.0;
                        try {
                            legalCompensationUnused = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (legalCompensationUnused < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setLegalCompensationUnused(legalCompensationUnused);
                        continue;
                    }
                    if ("specific_compensation_unused".equals(fieldName)) {
                        double specificCompensationUnused = 0.0;
                        try {
                            specificCompensationUnused = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (specificCompensationUnused < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setSpecificCompensationUnused(specificCompensationUnused);
                        continue;
                    }
                    if ("late_compensation_unused".equals(fieldName)) {
                        double lateCompensationUnused = 0.0;
                        try {
                            lateCompensationUnused = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (lateCompensationUnused < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setLateCompensationUnused(lateCompensationUnused);
                        continue;
                    }
                    if ("statutory_holiday_work_time_in".equals(fieldName)) {
                        int statutoryHolidayWorkTimeIn = 0;
                        try {
                            statutoryHolidayWorkTimeIn = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (statutoryHolidayWorkTimeIn < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setStatutoryHolidayWorkTimeIn(statutoryHolidayWorkTimeIn);
                        continue;
                    }
                    if ("statutory_holiday_work_time_out".equals(fieldName)) {
                        int statutoryHolidayWorkTimeOut = 0;
                        try {
                            statutoryHolidayWorkTimeOut = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (statutoryHolidayWorkTimeOut < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setStatutoryHolidayWorkTimeOut(statutoryHolidayWorkTimeOut);
                        continue;
                    }
                    if ("prescribed_holiday_work_time_in".equals(fieldName)) {
                        int prescribedHolidayWorkTimeIn = 0;
                        try {
                            prescribedHolidayWorkTimeIn = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (prescribedHolidayWorkTimeIn < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrescribedHolidayWorkTimeIn(prescribedHolidayWorkTimeIn);
                        continue;
                    }
                    if ("prescribed_holiday_work_time_out".equals(fieldName)) {
                        int prescribedHolidayWorkTimeOut = 0;
                        try {
                            prescribedHolidayWorkTimeOut = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (prescribedHolidayWorkTimeOut < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setPrescribedHolidayWorkTimeOut(prescribedHolidayWorkTimeOut);
                        continue;
                    }
                    if (fieldName.equals("weekly_over_forty_hour_work_time")) {
                        int weeklyOverFortyHourWorkTime = 0;
                        try {
                            weeklyOverFortyHourWorkTime = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (weeklyOverFortyHourWorkTime < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWeeklyOverFortyHourWorkTime(weeklyOverFortyHourWorkTime);
                        continue;
                    }
                    if (fieldName.equals("overtime_in_no_weekly_forty")) {
                        int overtimeInNoWeeklyForty = 0;
                        try {
                            overtimeInNoWeeklyForty = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeInNoWeeklyForty < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeInNoWeeklyForty(overtimeInNoWeeklyForty);
                        continue;
                    }
                    if (fieldName.equals("overtime_out_no_weekly_forty")) {
                        int overtimeOutNoWeeklyForty = 0;
                        try {
                            overtimeOutNoWeeklyForty = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (overtimeOutNoWeeklyForty < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setOvertimeOutNoWeeklyForty(overtimeOutNoWeeklyForty);
                        continue;
                    }
                    if (fieldName.equals("week_day_overtime_total")) {
                        int weekDayOvertimeTotal = 0;
                        try {
                            weekDayOvertimeTotal = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (weekDayOvertimeTotal < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWeekDayOvertimeTotal(weekDayOvertimeTotal);
                        continue;
                    }
                    if (fieldName.equals("week_day_overtime_in_no_weekly_forty")) {
                        int weekDayOvertimeInNoWeeklyForty = 0;
                        try {
                            weekDayOvertimeInNoWeeklyForty = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (weekDayOvertimeInNoWeeklyForty < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWeekDayOvertimeInNoWeeklyForty(weekDayOvertimeInNoWeeklyForty);
                        continue;
                    }
                    if (fieldName.equals("week_day_overtime_out_no_weekly_forty")) {
                        int weekDayOvertimeOutNoWeeklyForty = 0;
                        try {
                            weekDayOvertimeOutNoWeeklyForty = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (weekDayOvertimeOutNoWeeklyForty < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setWeekDayOvertimeOutNoWeeklyForty(weekDayOvertimeOutNoWeeklyForty);
                        continue;
                    }
                    if (!fieldName.equals("week_day_overtime_in")) continue;
                    int weekDayOvertimeIn = 0;
                    try {
                        weekDayOvertimeIn = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        hasError = true;
                        break;
                    }
                    if (weekDayOvertimeIn < 0) {
                        hasError = true;
                        break;
                    }
                    dto.setWeekDayOvertimeIn(weekDayOvertimeIn);
                }
                if (!hasError && employeeCode.isEmpty()) {
                    hasError = true;
                }
                if (!hasError && dto.getCalculationYear() < 1) {
                    hasError = true;
                }
                if (!(hasError || dto.getCalculationMonth() >= 1 && dto.getCalculationMonth() <= 12)) {
                    hasError = true;
                }
                if (!hasError && dto.getCalculationDate() == null) {
                    hasError = true;
                }
                if (!hasError) {
                    HumanDtoInterface humanDto = this.humanDao.findForEmployeeCode(employeeCode, dto.getCalculationDate());
                    if (humanDto == null || humanDto.getPersonalId() == null || humanDto.getPersonalId().isEmpty()) {
                        hasError = true;
                    } else {
                        dto.setPersonalId(humanDto.getPersonalId());
                    }
                }
                String cutoffCode = "";
                if (!hasError) {
                    ApplicationEntity application = this.timeMaster.getApplicationEntity(dto.getPersonalId(), dto.getCalculationDate());
                    if (!application.isValid()) {
                        hasError = true;
                    } else {
                        CutoffEntityInterface cutoff = application.getCutoffEntity();
                        Date cutoffDate = cutoff.getCutoffCalculationDate(dto.getCalculationYear(), dto.getCalculationMonth(), this.mospParams);
                        if (cutoffDate.equals(dto.getCalculationDate())) {
                            cutoffCode = cutoff.getCode();
                        } else {
                            hasError = true;
                        }
                    }
                }
                if (hasError) {
                    this.addInvalidDataErrorMessage(i);
                } else {
                    for (TotalTimeDataDtoInterface totalTimeDataDto2 : totaltimeList) {
                        if (!totalTimeDataDto2.getPersonalId().equals(dto.getPersonalId()) || totalTimeDataDto2.getCalculationYear() != dto.getCalculationYear() || totalTimeDataDto2.getCalculationMonth() != dto.getCalculationMonth()) continue;
                        this.addDuplicateDataErrorMessage(i);
                        hasError = true;
                        break;
                    }
                }
                if (!hasError && (totalTimeDataDto = this.totalTimeDataDao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth())) != null && cutoffCode != null && !cutoffCode.isEmpty()) {
                    TotalTimeDtoInterface totalTimeDto = this.totalTimeTransaction.findForKey(dto.getCalculationYear(), dto.getCalculationMonth(), cutoffCode);
                    if (totalTimeDto == null) {
                        dto.setTmdTotalTimeId(totalTimeDataDto.getTmdTotalTimeId());
                    } else {
                        int state = totalTimeDto.getCutoffState();
                        if (state == 0 || state == 1) {
                            dto.setTmdTotalTimeId(totalTimeDataDto.getTmdTotalTimeId());
                        } else if (state == 2) {
                            this.addAlreadyRegisteredDataErrorMessage(i);
                            hasError = true;
                            break;
                        }
                    }
                }
                if (!hasError) {
                    totaltimeList.add((TotalTimeDataDtoInterface)dto);
                }
            }
            ++i;
        }
        return totaltimeList;
    }

    public List<PaidHolidayDataDtoInterface> getPaidHolidayList(String importCode, List<String[]> list) throws MospException {
        Date systemDate = this.getSystemDate();
        ImportDtoInterface importDto = this.importDao.findForKey(importCode);
        if (importDto == null) {
            return null;
        }
        List importFieldDtoList = this.importFieldDao.findForList(importCode);
        if (importFieldDtoList == null || importFieldDtoList.isEmpty()) {
            return null;
        }
        ArrayList<PaidHolidayDataDtoInterface> paidHolidayDataList = new ArrayList<PaidHolidayDataDtoInterface>();
        int i = 0;
        for (String[] csvArray : list) {
            if (importDto.getHeader() == 1 && i == 0) {
                if (!this.checkHeader(importDto, importFieldDtoList, csvArray)) {
                    this.addInvalidHeaderErrorMessage();
                    return null;
                }
            } else {
                PaidHolidayDataDtoInterface paidHolidayDataDto;
                PaidHolidayDtoInterface paidHolidayDto;
                Object applicationDto;
                boolean hasError = false;
                String employeeCode = "";
                TmdPaidHolidayDataDto dto = new TmdPaidHolidayDataDto();
                for (ImportFieldDtoInterface importFieldDto : importFieldDtoList) {
                    int fieldOrder = importFieldDto.getFieldOrder();
                    if (csvArray.length <= fieldOrder - 1) continue;
                    String value = csvArray[fieldOrder - 1];
                    String fieldName = importFieldDto.getFieldName();
                    if (fieldName.equals("employee_code")) {
                        employeeCode = value;
                        continue;
                    }
                    if (fieldName.equals("activate_date")) {
                        Date activateDate = this.getDate(value);
                        if (activateDate == null) {
                            hasError = true;
                            break;
                        }
                        dto.setActivateDate(activateDate);
                        continue;
                    }
                    if (fieldName.equals("acquisition_date")) {
                        Date acquisitionDate = this.getDate(value);
                        if (acquisitionDate == null) {
                            hasError = true;
                            break;
                        }
                        dto.setAcquisitionDate(acquisitionDate);
                        continue;
                    }
                    if (fieldName.equals("limit_date")) {
                        Date limitDate = this.getDate(value);
                        if (limitDate == null) {
                            hasError = true;
                            break;
                        }
                        dto.setLimitDate(limitDate);
                        continue;
                    }
                    if (fieldName.equals("hold_day")) {
                        double holdDay = 0.0;
                        try {
                            holdDay = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (holdDay < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setHoldDay(holdDay);
                        continue;
                    }
                    if (!fieldName.equals("hold_hour")) continue;
                    int holdHour = 0;
                    try {
                        holdHour = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        hasError = true;
                        break;
                    }
                    if (holdHour < 0) {
                        hasError = true;
                        break;
                    }
                    dto.setHoldHour(holdHour);
                }
                if (!hasError && employeeCode.isEmpty()) {
                    hasError = true;
                }
                if (!hasError && dto.getActivateDate() == null) {
                    hasError = true;
                }
                if (!hasError) {
                    HumanDtoInterface humanDto = this.humanDao.findForEmployeeCode(employeeCode, dto.getActivateDate());
                    if (humanDto == null || humanDto.getPersonalId() == null || humanDto.getPersonalId().isEmpty()) {
                        hasError = true;
                    } else {
                        dto.setPersonalId(humanDto.getPersonalId());
                    }
                }
                if (!hasError && (applicationDto = this.application.findForPerson(dto.getPersonalId(), systemDate)) != null && (paidHolidayDto = this.paidHolidayReference.getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), systemDate)) != null) {
                    dto.setDenominatorDayHour(paidHolidayDto.getTimeAcquisitionLimitTimes());
                }
                if (dto.getAcquisitionDate() == null || dto.getLimitDate() == null) {
                    hasError = true;
                }
                if (hasError) {
                    this.addInvalidDataErrorMessage(i);
                } else {
                    applicationDto = paidHolidayDataList.iterator();
                    while (applicationDto.hasNext()) {
                        PaidHolidayDataDtoInterface paidHolidayDataDto2 = (PaidHolidayDataDtoInterface)applicationDto.next();
                        if (!paidHolidayDataDto2.getPersonalId().equals(dto.getPersonalId()) || !paidHolidayDataDto2.getActivateDate().equals(dto.getActivateDate()) || !paidHolidayDataDto2.getAcquisitionDate().equals(dto.getAcquisitionDate())) continue;
                        this.addDuplicateDataErrorMessage(i);
                        hasError = true;
                        break;
                    }
                }
                if (!hasError && (paidHolidayDataDto = this.paidHolidayDataDao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate())) != null) {
                    dto.setTmdPaidHolidayId(paidHolidayDataDto.getTmdPaidHolidayId());
                }
                if (!hasError) {
                    paidHolidayDataList.add((PaidHolidayDataDtoInterface)dto);
                }
            }
            ++i;
        }
        return paidHolidayDataList;
    }

    public List<StockHolidayDataDtoInterface> getStockHolidayList(String importCode, List<String[]> list) throws MospException {
        ImportDtoInterface importDto = this.importDao.findForKey(importCode);
        if (importDto == null) {
            return null;
        }
        List importFieldDtoList = this.importFieldDao.findForList(importCode);
        if (importFieldDtoList == null || importFieldDtoList.isEmpty()) {
            return null;
        }
        ArrayList<StockHolidayDataDtoInterface> stockHolidayDataList = new ArrayList<StockHolidayDataDtoInterface>();
        int i = 0;
        for (String[] csvArray : list) {
            if (importDto.getHeader() == 1 && i == 0) {
                if (!this.checkHeader(importDto, importFieldDtoList, csvArray)) {
                    this.addInvalidHeaderErrorMessage();
                    return null;
                }
            } else {
                StockHolidayDataDtoInterface stockHolidayDataDto;
                boolean hasError = false;
                String employeeCode = "";
                TmdStockHolidayDto dto = new TmdStockHolidayDto();
                for (ImportFieldDtoInterface importFieldDto : importFieldDtoList) {
                    int fieldOrder = importFieldDto.getFieldOrder();
                    if (csvArray.length <= fieldOrder - 1) continue;
                    String value = csvArray[fieldOrder - 1];
                    String fieldName = importFieldDto.getFieldName();
                    if (fieldName.equals("employee_code")) {
                        employeeCode = value;
                        continue;
                    }
                    if (fieldName.equals("activate_date")) {
                        Date activateDate = this.getDate(value);
                        if (activateDate == null) {
                            hasError = true;
                            break;
                        }
                        dto.setActivateDate(activateDate);
                        continue;
                    }
                    if (fieldName.equals("acquisition_date")) {
                        Date acquisitionDate = this.getDate(value);
                        if (acquisitionDate == null) {
                            hasError = true;
                            break;
                        }
                        dto.setAcquisitionDate(acquisitionDate);
                        continue;
                    }
                    if (fieldName.equals("limit_date")) {
                        Date limitDate = this.getDate(value);
                        if (limitDate == null) {
                            hasError = true;
                            break;
                        }
                        dto.setLimitDate(this.getDate(value));
                        continue;
                    }
                    if (!fieldName.equals("hold_day")) continue;
                    double holdDay = 0.0;
                    try {
                        holdDay = Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        hasError = true;
                        break;
                    }
                    if (holdDay < 0.0) {
                        hasError = true;
                        break;
                    }
                    dto.setHoldDay(holdDay);
                }
                if (!hasError && employeeCode.isEmpty()) {
                    hasError = true;
                }
                if (!hasError && dto.getActivateDate() == null) {
                    hasError = true;
                }
                if (!hasError) {
                    HumanDtoInterface humanDto = this.humanDao.findForEmployeeCode(employeeCode, dto.getActivateDate());
                    if (humanDto == null || humanDto.getPersonalId() == null || humanDto.getPersonalId().isEmpty()) {
                        hasError = true;
                    } else {
                        dto.setPersonalId(humanDto.getPersonalId());
                    }
                }
                if (dto.getAcquisitionDate() == null || dto.getLimitDate() == null) {
                    hasError = true;
                }
                if (hasError) {
                    this.addInvalidDataErrorMessage(i);
                } else {
                    for (StockHolidayDataDtoInterface stockHolidayDataDto2 : stockHolidayDataList) {
                        if (!stockHolidayDataDto2.getPersonalId().equals(dto.getPersonalId()) || !stockHolidayDataDto2.getActivateDate().equals(dto.getActivateDate()) || !stockHolidayDataDto2.getAcquisitionDate().equals(dto.getAcquisitionDate())) continue;
                        this.addDuplicateDataErrorMessage(i);
                        hasError = true;
                        break;
                    }
                }
                if (!hasError && (stockHolidayDataDto = this.stockHolidayDataDao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate())) != null) {
                    dto.setTmdStockHolidayId(stockHolidayDataDto.getTmdStockHolidayId());
                }
                if (!hasError) {
                    stockHolidayDataList.add((StockHolidayDataDtoInterface)dto);
                }
            }
            ++i;
        }
        return stockHolidayDataList;
    }

    public List<HolidayDataDtoInterface> getHolidayDataList(String importCode, List<String[]> list) throws MospException {
        ImportDtoInterface importDto = this.importDao.findForKey(importCode);
        if (importDto == null) {
            return null;
        }
        List importFieldDtoList = this.importFieldDao.findForList(importCode);
        if (importFieldDtoList == null || importFieldDtoList.isEmpty()) {
            return null;
        }
        ArrayList<HolidayDataDtoInterface> holidayDataList = new ArrayList<HolidayDataDtoInterface>();
        int i = 0;
        for (String[] csvArray : list) {
            if (importDto.getHeader() == 1 && i == 0) {
                if (!this.checkHeader(importDto, importFieldDtoList, csvArray)) {
                    this.addInvalidHeaderErrorMessage();
                    return null;
                }
            } else {
                HolidayDataDtoInterface holidayDataDto;
                boolean hasError = false;
                String employeeCode = "";
                TmdHolidayDataDto dto = new TmdHolidayDataDto();
                for (ImportFieldDtoInterface importFieldDto : importFieldDtoList) {
                    int fieldOrder = importFieldDto.getFieldOrder();
                    if (csvArray.length <= fieldOrder - 1) continue;
                    String value = csvArray[fieldOrder - 1];
                    String fieldName = importFieldDto.getFieldName();
                    if ("employee_code".equals(fieldName)) {
                        employeeCode = value;
                        continue;
                    }
                    if ("activate_date".equals(fieldName)) {
                        Date activateDate = this.getDate(value);
                        if (activateDate == null) {
                            hasError = true;
                            break;
                        }
                        dto.setActivateDate(activateDate);
                        continue;
                    }
                    if ("holiday_code".equals(fieldName)) {
                        dto.setHolidayCode(value);
                        continue;
                    }
                    if ("holiday_type".equals(fieldName)) {
                        int holidayType = 0;
                        try {
                            holidayType = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (holidayType != 2 && holidayType != 3 && holidayType != 4) {
                            hasError = true;
                            break;
                        }
                        dto.setHolidayType(holidayType);
                        continue;
                    }
                    if ("giving_day".equals(fieldName)) {
                        double givingDay = 0.0;
                        try {
                            givingDay = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (givingDay < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setGivingDay(givingDay);
                        continue;
                    }
                    if ("giving_hour".equals(fieldName)) {
                        int givingHour = 0;
                        try {
                            givingHour = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (givingHour < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setGivingHour(givingHour);
                        continue;
                    }
                    if ("cancel_day".equals(fieldName)) {
                        double cancelDay = 0.0;
                        try {
                            cancelDay = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (cancelDay < 0.0) {
                            hasError = true;
                            break;
                        }
                        dto.setCancelDay(cancelDay);
                        continue;
                    }
                    if ("cancel_hour".equals(fieldName)) {
                        int cancelHour = 0;
                        try {
                            cancelHour = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (cancelHour < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setCancelHour(cancelHour);
                        continue;
                    }
                    if ("holiday_limit_date".equals(fieldName)) {
                        Date holidayLimitDate = this.getDate(value);
                        if (holidayLimitDate == null) {
                            hasError = true;
                            break;
                        }
                        dto.setHolidayLimitDate(holidayLimitDate);
                        continue;
                    }
                    if ("holiday_limit_month".equals(fieldName)) {
                        int holidayLimitMonth = 0;
                        try {
                            holidayLimitMonth = Integer.parseInt(value);
                        }
                        catch (NumberFormatException e) {
                            hasError = true;
                            break;
                        }
                        if (holidayLimitMonth < 0) {
                            hasError = true;
                            break;
                        }
                        dto.setHolidayLimitMonth(holidayLimitMonth);
                        continue;
                    }
                    if (!"holiday_limit_day".equals(fieldName)) continue;
                    int holidayLimitDay = 0;
                    try {
                        holidayLimitDay = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        hasError = true;
                        break;
                    }
                    if (holidayLimitDay < 0) {
                        hasError = true;
                        break;
                    }
                    dto.setHolidayLimitDay(holidayLimitDay);
                }
                if (!hasError && employeeCode.isEmpty()) {
                    hasError = true;
                }
                if (!hasError && dto.getActivateDate() == null) {
                    hasError = true;
                }
                if (!hasError) {
                    HumanDtoInterface humanDto = this.humanDao.findForEmployeeCode(employeeCode, dto.getActivateDate());
                    if (humanDto == null || humanDto.getPersonalId() == null || humanDto.getPersonalId().isEmpty()) {
                        hasError = true;
                    } else {
                        dto.setPersonalId(humanDto.getPersonalId());
                    }
                }
                if (!hasError) {
                    if (dto.getHolidayCode() == null || dto.getHolidayCode().isEmpty()) {
                        hasError = true;
                    } else {
                        HolidayDtoInterface holidayDto = this.holidayDao.findForInfo(dto.getHolidayCode(), dto.getActivateDate(), dto.getHolidayType());
                        if (holidayDto == null) {
                            hasError = true;
                        }
                    }
                }
                if (!hasError) {
                    if (dto.getHolidayLimitMonth() == 0 && dto.getHolidayLimitDay() == 0) {
                        dto.setHolidayLimitDate(TimeUtility.getUnlimitedDate());
                    } else {
                        dto.setHolidayLimitDate(DateUtility.addDay((Date)DateUtility.addMonth((Date)dto.getActivateDate(), (int)dto.getHolidayLimitMonth()), (int)(dto.getHolidayLimitDay() - 1)));
                    }
                }
                if (hasError) {
                    this.addInvalidDataErrorMessage(i);
                } else {
                    for (HolidayDataDtoInterface holidayDataDto2 : holidayDataList) {
                        if (!holidayDataDto2.getPersonalId().equals(dto.getPersonalId()) || !holidayDataDto2.getActivateDate().equals(dto.getActivateDate()) || !holidayDataDto2.getHolidayCode().equals(dto.getHolidayCode()) || holidayDataDto2.getHolidayType() != dto.getHolidayType()) continue;
                        this.addDuplicateDataErrorMessage(i);
                        hasError = true;
                        break;
                    }
                }
                if (!hasError && (holidayDataDto = this.holidayDataDao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getHolidayCode(), dto.getHolidayType())) != null) {
                    dto.setTmdHolidayId(holidayDataDto.getTmdHolidayId());
                }
                if (!hasError) {
                    holidayDataList.add((HolidayDataDtoInterface)dto);
                }
            }
            ++i;
        }
        return holidayDataList;
    }

    public Map<WorkTypeDtoInterface, Map<String, WorkTypeItemDtoInterface>> getWorkType(String importCode, List<String[]> list) throws MospException {
        ImportDtoInterface importDto = this.importDao.findForKey(importCode);
        if (importDto == null) {
            return null;
        }
        List importFieldDtoList = this.importFieldDao.findForList(importCode);
        if (importFieldDtoList == null || importFieldDtoList.isEmpty()) {
            return null;
        }
        HashMap<WorkTypeDtoInterface, Map<String, WorkTypeItemDtoInterface>> targetMap = new HashMap<WorkTypeDtoInterface, Map<String, WorkTypeItemDtoInterface>>();
        for (WorkTypeImportAddonBeanInterface addon : this.getWorkTypeAddonBeans()) {
            addon.initAddonBean(importDto, importFieldDtoList, list);
        }
        int i = 0;
        for (String[] csvArray : list) {
            if (importDto.getHeader() == 1 && i == 0) {
                if (!this.checkHeader(importDto, importFieldDtoList, csvArray)) {
                    this.addInvalidHeaderErrorMessage();
                    return null;
                }
            } else {
                String fieldName;
                String value;
                int fieldOrder;
                TmmWorkTypeDto dto = new TmmWorkTypeDto();
                ArrayList<String> workTypeCodeList = new ArrayList<String>();
                HashMap<String, WorkTypeItemDtoInterface> itemMap = new HashMap<String, WorkTypeItemDtoInterface>();
                String year = "";
                String month = "";
                boolean isActivateDate = false;
                dto.setInactivateFlag(0);
                for (ImportFieldDtoInterface importFieldDto : importFieldDtoList) {
                    fieldOrder = importFieldDto.getFieldOrder();
                    if (csvArray.length <= fieldOrder - 1) continue;
                    value = csvArray[fieldOrder - 1];
                    fieldName = importFieldDto.getFieldName();
                    if (!this.isWorkTypeInfo(fieldName)) continue;
                    if (fieldName.equals("activate_date_year")) {
                        year = value;
                    } else if (fieldName.equals("activate_date_month")) {
                        month = value;
                    }
                    if (!(isActivateDate || year.isEmpty() || month.isEmpty())) {
                        String[] rep = new String[]{"\u6709\u52b9\u65e5(\u5e74)", "\u6709\u52b9\u65e5(\u6708)", ""};
                        InputCheckUtility.checkDateGeneral((MospParams)this.mospParams, (String)year, (String)month, (String)"1", (String[])rep);
                        if (this.mospParams.hasErrorMessage()) {
                            return null;
                        }
                        Date activateDate = MonthUtility.getYearMonthDate((int)Integer.parseInt(year), (int)Integer.parseInt(month));
                        dto.setActivateDate(activateDate);
                        isActivateDate = true;
                        continue;
                    }
                    this.setWorkTypeDto((WorkTypeDtoInterface)dto, fieldName, value);
                }
                if (workTypeCodeList.contains(dto.getWorkTypeCode())) {
                    this.addDuplicateDataErrorMessage(i);
                    return null;
                }
                workTypeCodeList.add(dto.getWorkTypeCode());
                if (this.mospParams.hasErrorMessage()) {
                    return null;
                }
                for (ImportFieldDtoInterface importFieldDto : importFieldDtoList) {
                    fieldOrder = importFieldDto.getFieldOrder();
                    if (csvArray.length <= fieldOrder - 1) continue;
                    value = csvArray[fieldOrder - 1];
                    fieldName = importFieldDto.getFieldName();
                    if (!this.isWorkTypeItemInfo(fieldName)) continue;
                    WorkTypeItemDtoInterface itemDto = this.setWorktypeItemDto(fieldName, Integer.valueOf(fieldOrder), value, (WorkTypeDtoInterface)dto, i);
                    if (itemDto == null) {
                        return null;
                    }
                    if (this.isWorkTypeItemShort(itemDto)) {
                        itemDto = this.setWorkTypeItemShort(fieldName, value, itemMap, itemDto);
                    }
                    itemMap.put(itemDto.getWorkTypeItemCode(), itemDto);
                }
                itemMap.put("RestTime", this.getWoryTypeRestTimedto((WorkTypeDtoInterface)dto, itemMap));
                itemMap.put("WorkTime", this.getWoryTypeWorkTimedto((WorkTypeDtoInterface)dto, itemMap));
                targetMap.put((WorkTypeDtoInterface)dto, itemMap);
            }
            ++i;
        }
        return targetMap;
    }

    protected WorkTypeItemDtoInterface getWoryTypeRestTimedto(WorkTypeDtoInterface workTypeDto, Map<String, WorkTypeItemDtoInterface> itemMap) throws MospException {
        WorkTypeItemDtoInterface rest1StartDto = itemMap.get("RestStart1");
        WorkTypeItemDtoInterface rest1EndDto = itemMap.get("RestEnd1");
        WorkTypeItemDtoInterface rest2StartDto = itemMap.get("RestStart2");
        WorkTypeItemDtoInterface rest2EndDto = itemMap.get("RestEnd2");
        WorkTypeItemDtoInterface rest3StartDto = itemMap.get("RestStart3");
        WorkTypeItemDtoInterface rest3EndDto = itemMap.get("RestEnd3");
        WorkTypeItemDtoInterface rest4StartDto = itemMap.get("RestStart4");
        WorkTypeItemDtoInterface rest4EndDto = itemMap.get("RestEnd4");
        int rest1 = 0;
        if (rest1StartDto != null && rest1EndDto != null) {
            rest1 = TimeUtility.getDifferenceMinutes((Date)rest1StartDto.getWorkTypeItemValue(), (Date)rest1EndDto.getWorkTypeItemValue());
        }
        int rest2 = 0;
        if (rest2StartDto != null && rest2EndDto != null) {
            rest2 = TimeUtility.getDifferenceMinutes((Date)rest2StartDto.getWorkTypeItemValue(), (Date)rest2EndDto.getWorkTypeItemValue());
        }
        int rest3 = 0;
        if (rest3StartDto != null && rest3EndDto != null) {
            rest3 = TimeUtility.getDifferenceMinutes((Date)rest3StartDto.getWorkTypeItemValue(), (Date)rest3EndDto.getWorkTypeItemValue());
        }
        int rest4 = 0;
        if (rest4StartDto != null && rest4EndDto != null) {
            rest4 = TimeUtility.getDifferenceMinutes((Date)rest4StartDto.getWorkTypeItemValue(), (Date)rest4EndDto.getWorkTypeItemValue());
        }
        int rest = this.workTypeItemRefer.getRestTime(rest1, rest2, rest3, rest4);
        WorkTypeItemDtoInterface itemDto = this.workTypeItemRegist.getInitDto();
        itemDto.setWorkTypeCode(workTypeDto.getWorkTypeCode());
        itemDto.setActivateDate(workTypeDto.getActivateDate());
        itemDto.setInactivateFlag(workTypeDto.getInactivateFlag());
        itemDto.setWorkTypeItemCode("RestTime");
        itemDto.setWorkTypeItemValue(DateUtility.addMinute((Date)DateUtility.getDefaultTime(), (int)rest));
        itemDto.setPreliminary("");
        return itemDto;
    }

    protected WorkTypeItemDtoInterface getWoryTypeWorkTimedto(WorkTypeDtoInterface workTypeDto, Map<String, WorkTypeItemDtoInterface> itemMap) throws MospException {
        WorkTypeItemDtoInterface startDto = itemMap.get("WorkStart");
        WorkTypeItemDtoInterface endDto = itemMap.get("WorkEnd");
        WorkTypeItemDtoInterface restDto = itemMap.get("RestTime");
        Date startTime = startDto != null ? startDto.getWorkTypeItemValue() : null;
        Date endTime = endDto != null ? endDto.getWorkTypeItemValue() : null;
        int restTime = 0;
        if (restDto != null) {
            restTime = TimeUtility.getDifferenceMinutes((Date)DateUtility.getDefaultTime(), (Date)restDto.getWorkTypeItemValue());
        }
        WorkTypeItemDtoInterface itemDto = this.workTypeItemRegist.getInitDto();
        itemDto.setWorkTypeCode(workTypeDto.getWorkTypeCode());
        itemDto.setActivateDate(workTypeDto.getActivateDate());
        itemDto.setInactivateFlag(workTypeDto.getInactivateFlag());
        itemDto.setWorkTypeItemCode("WorkTime");
        itemDto.setWorkTypeItemValue(DateUtility.addMinute((Date)DateUtility.getDefaultTime(), (int)this.workTypeItemRefer.getWorkTime(startTime, endTime, restTime)));
        itemDto.setPreliminary("");
        return itemDto;
    }

    protected void setWorkTypeDto(WorkTypeDtoInterface dto, String fieldName, String value) throws MospException {
        if (fieldName.equals("work_type_code")) {
            dto.setWorkTypeCode(value);
        } else if (fieldName.equals("work_type_name")) {
            dto.setWorkTypeName(value);
        } else if (fieldName.equals("work_type_abbr")) {
            dto.setWorkTypeAbbr(value);
        } else if (fieldName.equals("inactivate_flag")) {
            String itemName = this.getCodeName(fieldName, "import_tmd_work_type");
            this.checkRequired((Object)value, itemName, null);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkTypeNumber(value, itemName, null);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkFlag(MospUtility.getInt((Object)value), itemName, null);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setInactivateFlag(MospUtility.getInt((Object)value));
        }
    }

    protected WorkTypeItemDtoInterface setWorktypeItemDto(String fieldName, Integer i, String value, WorkTypeDtoInterface worktypeDto, int index) throws MospException {
        WorkTypeItemDtoInterface dto = this.workTypeItemRegist.getInitDto();
        String itemName = this.getCodeName(fieldName, "import_tmd_work_type");
        dto.setActivateDate(worktypeDto.getActivateDate());
        dto.setWorkTypeCode(worktypeDto.getWorkTypeCode());
        dto.setWorkTypeItemValue(DateUtility.getDefaultTime());
        dto.setPreliminary("");
        dto.setInactivateFlag(worktypeDto.getInactivateFlag());
        if (fieldName.equals("work_start_time")) {
            dto.setWorkTypeItemCode("WorkStart");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("work_end_time")) {
            dto.setWorkTypeItemCode("WorkEnd");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("rest1_start_time")) {
            dto.setWorkTypeItemCode("RestStart1");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("rest1_end_time")) {
            dto.setWorkTypeItemCode("RestEnd1");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("rest2_start_time")) {
            dto.setWorkTypeItemCode("RestStart2");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("rest2_end_time")) {
            dto.setWorkTypeItemCode("RestEnd2");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("rest3_start_time")) {
            dto.setWorkTypeItemCode("RestStart3");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("rest3_end_time")) {
            dto.setWorkTypeItemCode("RestEnd3");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("rest4_start_time")) {
            dto.setWorkTypeItemCode("RestStart4");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("rest4_end_time")) {
            dto.setWorkTypeItemCode("RestEnd4");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("front_start_time")) {
            dto.setWorkTypeItemCode("FrontStart");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("front_end_time")) {
            dto.setWorkTypeItemCode("FrontEnd");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("back_start_time")) {
            dto.setWorkTypeItemCode("BackStart");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("back_end_time")) {
            dto.setWorkTypeItemCode("BackEnd");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("over_per")) {
            dto.setWorkTypeItemCode("OverPer");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("over_rest")) {
            dto.setWorkTypeItemCode("OverRest");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("over_before")) {
            dto.setWorkTypeItemCode("OverBefore");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("before_overtime")) {
            if (value == null || value.isEmpty()) {
                value = String.valueOf(1);
            }
            this.checkRequired((Object)value, itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            this.checkTypeNumber(value, itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            this.checkFlag(MospUtility.getInt((Object)value), itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            dto.setWorkTypeItemCode("AutoBefOverWork");
            dto.setPreliminary(value);
            return dto;
        }
        if (fieldName.equals("half_rest_work_time")) {
            dto.setWorkTypeItemCode("HalfRest");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("half_rest_start_time")) {
            dto.setWorkTypeItemCode("HalfRestStart");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("half_rest_end_time")) {
            dto.setWorkTypeItemCode("HalfRestEnd");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("direct_start")) {
            if (value == null || value.isEmpty()) {
                value = String.valueOf("0");
            }
            this.checkTypeNumber(value, itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            this.checkFlag(MospUtility.getInt((Object)value), itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            dto.setWorkTypeItemCode("DirectStart");
            dto.setPreliminary(value);
            return dto;
        }
        if (fieldName.equals("direct_end")) {
            this.checkTypeNumber(value, itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            if (MospUtility.isEmpty((String[])new String[]{value})) {
                value = String.valueOf("0");
            }
            this.checkFlag(MospUtility.getInt((Object)value), itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            dto.setWorkTypeItemCode("DirectEnd");
            dto.setPreliminary(value);
            return dto;
        }
        if (fieldName.equals("exclude_night_rest")) {
            if (value == null || value.isEmpty()) {
                value = String.valueOf(1);
            }
            this.checkTypeNumber(value, itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            this.checkFlag(MospUtility.getInt((Object)value), itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            dto.setWorkTypeItemCode("ExcludeNightRest");
            dto.setPreliminary(value);
            return dto;
        }
        if (fieldName.equals("short1_start")) {
            dto.setWorkTypeItemCode("Short1Start");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("short1_end")) {
            dto.setWorkTypeItemCode("Short1End");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("short1_type")) {
            if (value == null || value.isEmpty()) {
                value = "0";
            }
            this.checkTypeNumber(value, itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            this.checkFlag(MospUtility.getInt((Object)value), itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            dto.setWorkTypeItemCode("Short1Start");
            dto.setPreliminary(value);
            return dto;
        }
        if (fieldName.equals("short2_start")) {
            dto.setWorkTypeItemCode("Short2Start");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("short2_end")) {
            dto.setWorkTypeItemCode("Short2End");
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
            return dto;
        }
        if (fieldName.equals("short2_type")) {
            if (value == null || value.isEmpty()) {
                value = "0";
            }
            this.checkTypeNumber(value, itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            this.checkFlag(MospUtility.getInt((Object)value), itemName, Integer.valueOf(index));
            if (this.mospParams.hasErrorMessage()) {
                return null;
            }
            dto.setWorkTypeItemCode("Short2Start");
            dto.setPreliminary(value);
            return dto;
        }
        for (WorkTypeImportAddonBeanInterface addon : this.getWorkTypeAddonBeans()) {
            dto = addon.setWorktypeItemDto(fieldName, i, value, worktypeDto, index);
            if (dto == null) continue;
            return dto;
        }
        this.addInvalidDataErrorMessage(index);
        return null;
    }

    protected WorkTypeItemDtoInterface setWorkTypeItemShort(String fieldName, String value, Map<String, WorkTypeItemDtoInterface> itemMap, WorkTypeItemDtoInterface dto) throws MospException {
        if (itemMap.get(dto.getWorkTypeItemCode()) == null) {
            return dto;
        }
        dto = itemMap.get(dto.getWorkTypeItemCode());
        if (fieldName.equals("short1_start") || fieldName.equals("short2_start")) {
            dto.setWorkTypeItemValue(this.getDefaltTimestamp(value, fieldName));
        }
        if (fieldName.equals("short1_type") || fieldName.equals("short2_type")) {
            dto.setPreliminary(value);
        }
        return dto;
    }

    protected boolean isWorkTypeItemShort(WorkTypeItemDtoInterface dto) throws MospException {
        return dto.getWorkTypeItemCode().equals("Short1Start") || dto.getWorkTypeItemCode().equals("Short2Start");
    }

    protected boolean isWorkTypeInfo(String fieldName) {
        String[] item = new String[]{"activate_date_year", "activate_date_month", "work_type_code", "work_type_name", "work_type_abbr", "inactivate_flag"};
        List<String> list = Arrays.asList(item);
        return list.contains(fieldName);
    }

    protected boolean isWorkTypeItemInfo(String fieldName) throws MospException {
        boolean containFlag;
        block1: {
            WorkTypeImportAddonBeanInterface addonBean;
            String[] item = new String[]{"work_start_time", "work_end_time", "rest1_start_time", "rest1_end_time", "rest2_start_time", "rest2_end_time", "rest3_start_time", "rest3_end_time", "rest4_start_time", "rest4_end_time", "front_start_time", "front_end_time", "back_start_time", "back_end_time", "over_per", "over_rest", "over_before", "before_overtime", "half_rest_work_time", "half_rest_start_time", "half_rest_end_time", "direct_start", "direct_end", "exclude_night_rest", "short1_start", "short1_type", "short1_end", "short2_start", "short2_type", "short2_end"};
            List<String> list = Arrays.asList(item);
            containFlag = list.contains(fieldName);
            if (containFlag) break block1;
            Iterator iterator = this.getWorkTypeAddonBeans().iterator();
            while (iterator.hasNext() && !(containFlag = (addonBean = (WorkTypeImportAddonBeanInterface)iterator.next()).isWorkTypeItemInfo(fieldName))) {
            }
        }
        return containFlag;
    }

    protected List<WorkTypeImportAddonBeanInterface> getWorkTypeAddonBeans() throws MospException {
        if (this.workTypeAddonBeans == null) {
            this.workTypeAddonBeans = new ArrayList();
            for (String[] addon : this.mospParams.getProperties().getCodeArray(CODE_KEY_WORKTYPE_ADDONS, false)) {
                String addonBean;
                if (addon == null || MospUtility.isEmpty((String[])addon) || (addonBean = addon[0]) == null || addonBean.isEmpty()) continue;
                WorkTypeImportAddonBeanInterface bean = (WorkTypeImportAddonBeanInterface)this.createBean(addonBean);
                this.workTypeAddonBeans.add(bean);
            }
        }
        return this.workTypeAddonBeans;
    }

    protected boolean checkHeader(ImportDtoInterface importDto, List<ImportFieldDtoInterface> list, String[] array) {
        if (importDto == null) {
            return false;
        }
        if (list == null || list.isEmpty()) {
            return false;
        }
        Object[] headerArray = new String[list.size()];
        int i = 0;
        for (ImportFieldDtoInterface importFieldDto : list) {
            headerArray[i] = this.mospParams.getProperties().getCodeItemName(importDto.getImportTable(), importFieldDto.getFieldName());
            ++i;
        }
        if (Arrays.equals(headerArray, array)) {
            return true;
        }
        this.addHeaderErrorMessage((String[])headerArray, array);
        return false;
    }

    protected Date getDate(String date) {
        if (date.indexOf("/") == -1) {
            return DateUtility.getDate((String)date, (String)"yyyyMMdd");
        }
        return DateUtility.getDate((String)date);
    }

    protected Date getTimestamp(String timestamp) {
        if (timestamp.indexOf("/") == -1) {
            return DateUtility.getDate((String)timestamp, (String)"yyyyMMdd H:m");
        }
        return DateUtility.getDate((String)timestamp, (String)"y/M/d H:m");
    }

    protected Date getDefaltTimestamp(String timestamp, String fieldName) throws MospException {
        if (MospUtility.isEmpty((String[])new String[]{timestamp})) {
            timestamp = "0:0";
        }
        String name = this.getCodeName(fieldName, "import_tmd_work_type");
        String type = "HH:MM";
        String[] target = MospUtility.split((String)timestamp, (String)":");
        if (target.length != 2) {
            PfMessageUtility.addErrorCheckGeneral((MospParams)this.mospParams, (String)name, (String)type);
            return null;
        }
        try {
            Integer.parseInt(target[0]);
            Integer.parseInt(target[1]);
        }
        catch (NumberFormatException e) {
            PfMessageUtility.addErrorCheckGeneral((MospParams)this.mospParams, (String)name, (String)type);
            return null;
        }
        if (Integer.parseInt(target[0]) > 47) {
            PfMessageUtility.addErrorOverLimit((MospParams)this.mospParams, (String)name, (int)47);
            return null;
        }
        if (Integer.parseInt(target[1]) > 59) {
            PfMessageUtility.addErrorOverLimit((MospParams)this.mospParams, (String)name, (int)59);
            return null;
        }
        return this.workTypeItemRegist.getDefaultTime(target[0], target[1]);
    }

    protected void addInvalidHeaderErrorMessage() {
        this.mospParams.addErrorMessage("TMW0306", new String[]{PfNameUtility.header((MospParams)this.mospParams)});
    }

    protected void addHeaderErrorMessage(String[] header1, String[] header2) {
        if (header1.length != header2.length) {
            return;
        }
        for (int i = 0; i < header2.length; ++i) {
            if (header2[i].equals(header1[i])) continue;
            StringBuilder fieldName = new StringBuilder(PfNameUtility.header((MospParams)this.mospParams));
            fieldName.append(PfNameUtility.of((MospParams)this.mospParams)).append(header1[i]);
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)fieldName.toString());
            break;
        }
    }

    protected void addInvalidDataErrorMessage(int i) {
        String rep = ++i + this.mospParams.getName("TheLine", new String[]{"Of", "Data"});
        this.mospParams.addErrorMessage("TMW0306", new String[]{rep});
    }

    protected void addDuplicateDataErrorMessage(int i) {
        String rep = ++i + this.mospParams.getName("TheLine", new String[]{"Of", "Data"});
        this.mospParams.addErrorMessage("TMW0307", new String[]{rep});
    }

    protected void addAlreadyRegisteredDataErrorMessage(int i) {
        String rep = ++i + this.mospParams.getName("TheLine", new String[]{"Of", "Data"});
        this.mospParams.addErrorMessage("TMW0222", new String[]{rep});
    }
}

