/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestSearchBeanInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestListDtoInterface;
import jp.mosp.time.dto.settings.RequestListDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayRequestListDto;

public class HolidayRequestSearchBean
extends PlatformBean
implements HolidayRequestSearchBeanInterface {
    protected HolidayRequestDaoInterface holidayRequestDao;
    protected WorkflowReferenceBeanInterface workflowReference;
    protected ApprovalInfoReferenceBeanInterface approvalInfoReference;
    private String personalId;
    private String holidayType1;
    private String holidayType2;
    private String holidayLength;
    private String workflowStatus;
    private Date requestStartDate;
    private Date requestEndDate;

    public void initBean() throws MospException {
        this.holidayRequestDao = (HolidayRequestDaoInterface)this.createDaoInstance(HolidayRequestDaoInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBeanInstance(WorkflowReferenceBeanInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBeanInstance(ApprovalInfoReferenceBeanInterface.class);
    }

    public List<HolidayRequestListDtoInterface> getSearchList() throws MospException {
        Map param = this.holidayRequestDao.getParamsMap();
        param.put("personalId", this.personalId);
        param.put("holidayType1", this.holidayType1);
        param.put("holidayType2", this.holidayType2);
        param.put("holidayLength", this.holidayLength);
        param.put("workflowStatus", this.workflowStatus);
        param.put("requestStartDate", this.requestStartDate);
        param.put("requestEndDate", this.requestEndDate);
        List requestList = this.holidayRequestDao.findForSearch(param);
        ArrayList<HolidayRequestListDtoInterface> list = new ArrayList<HolidayRequestListDtoInterface>();
        boolean flag = false;
        for (int i = 0; i < requestList.size(); ++i) {
            HolidayRequestListDto dto = new HolidayRequestListDto();
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(((HolidayRequestDtoInterface)requestList.get(i)).getWorkflow());
            if (workflowDto == null) continue;
            dto.setTmdHolidayRequestId(((HolidayRequestDtoInterface)requestList.get(i)).getTmdHolidayRequestId());
            dto.setRequestStartDate(((HolidayRequestDtoInterface)requestList.get(i)).getRequestStartDate());
            dto.setRequestEndDate(((HolidayRequestDtoInterface)requestList.get(i)).getRequestEndDate());
            dto.setHolidayType1(((HolidayRequestDtoInterface)requestList.get(i)).getHolidayType1());
            dto.setHolidayType2(((HolidayRequestDtoInterface)requestList.get(i)).getHolidayType2());
            dto.setHolidayRange(((HolidayRequestDtoInterface)requestList.get(i)).getHolidayRange());
            dto.setStartTime(((HolidayRequestDtoInterface)requestList.get(i)).getStartTime());
            dto.setEndTime(((HolidayRequestDtoInterface)requestList.get(i)).getEndTime());
            dto.setRequestReason(((HolidayRequestDtoInterface)requestList.get(i)).getRequestReason());
            dto.setWorkflow(((HolidayRequestDtoInterface)requestList.get(i)).getWorkflow());
            this.approvalInfoReference.setWorkflowInfo((RequestListDtoInterface)dto, workflowDto);
            flag = false;
            if ("1".equals(this.workflowStatus)) {
                if ("0".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("2".equals(this.workflowStatus)) {
                if ("1".equals(dto.getState()) || "2".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("3".equals(this.workflowStatus)) {
                if ("9".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("4".equals(this.workflowStatus)) {
                if ("3".equals(dto.getState()) || "4".equals(dto.getState())) {
                    flag = true;
                }
            } else {
                flag = true;
            }
            if (!flag) continue;
            list.add((HolidayRequestListDtoInterface)dto);
        }
        return list;
    }

    public void setHolidayType1(String holidayType1) {
        this.holidayType1 = holidayType1;
    }

    public void setHolidayType2(String holidayType2) {
        this.holidayType2 = holidayType2;
    }

    public void setHolidayLength(String holidayLength) {
        this.holidayLength = holidayLength;
    }

    public void setWorkflowStatus(String workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public void setRequestStartDate(Date requestStartDate) {
        this.requestStartDate = this.getDateClone(requestStartDate);
    }

    public void setRequestEndDate(Date requestEndDate) {
        this.requestEndDate = this.getDateClone(requestEndDate);
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }
}

