/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.ValidateUtility;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayRemainBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeApprovalBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdHolidayRequestDto;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class HolidayRequestRegistBean
extends TimeApplicationBean
implements HolidayRequestRegistBeanInterface {
    private static final int[] AVAILABLE_HOLIDAY_RANGES = new int[]{1, 2, 3, 4};
    protected HolidayRequestDaoInterface dao;
    protected HolidayRequestReferenceBeanInterface holidayRequestRefer;
    protected WorkflowRegistBeanInterface workflowRegist;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected WorkflowCommentRegistBeanInterface workflowCommentRegist;
    protected AttendanceRegistBeanInterface attendanceRegist;
    protected TimeApprovalBeanInterface timeApproval;
    private ApprovalInfoReferenceBeanInterface approvalInfoReference;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected RequestUtilBeanInterface requestUtil;
    protected PaidHolidayInfoReferenceBeanInterface paidHolidayInfoReference;
    protected PaidHolidayRemainBeanInterface paidHolidayRemain;
    protected AttendanceReferenceBeanInterface attendanceReference;
    protected WorkTypeChangeRequestReferenceBeanInterface workTypeChangeReference;
    protected DifferenceRequestReferenceBeanInterface differenceRequestReference;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HolidayRequestDaoInterface)this.createDaoInstance(HolidayRequestDaoInterface.class);
        this.holidayRequestRefer = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBeanInstance(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBeanInstance(WorkflowCommentRegistBeanInterface.class);
        this.attendanceRegist = (AttendanceRegistBeanInterface)this.createBeanInstance(AttendanceRegistBeanInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBeanInstance(ApprovalInfoReferenceBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBeanInstance(WorkTypeReferenceBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBeanInstance(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBeanInstance(RetirementReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBeanInstance(CutoffUtilBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
        this.paidHolidayInfoReference = (PaidHolidayInfoReferenceBeanInterface)this.createBeanInstance(PaidHolidayInfoReferenceBeanInterface.class);
        this.paidHolidayRemain = (PaidHolidayRemainBeanInterface)this.createBeanInstance(PaidHolidayRemainBeanInterface.class);
        this.attendanceReference = (AttendanceReferenceBeanInterface)this.createBeanInstance(AttendanceReferenceBeanInterface.class);
        this.workTypeChangeReference = (WorkTypeChangeRequestReferenceBeanInterface)this.createBeanInstance(WorkTypeChangeRequestReferenceBeanInterface.class);
        this.differenceRequestReference = (DifferenceRequestReferenceBeanInterface)this.createBeanInstance(DifferenceRequestReferenceBeanInterface.class);
        this.setTimeMaster((TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class));
    }

    public HolidayRequestDtoInterface getInitDto() {
        return new TmdHolidayRequestDto();
    }

    protected void insert(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        this.validate(dto, row);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void update(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        this.validate(dto, row);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdHolidayRequestId());
        dto.setTmdHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void regist(HolidayRequestDtoInterface dto) throws MospException {
        this.regist(dto, null);
    }

    public void regist(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        if (this.dao.findForKey(dto.getTmdHolidayRequestId(), false) == null) {
            this.insert(dto, row);
        } else {
            this.update(dto, row);
        }
    }

    public void delete(HolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdHolidayRequestId());
    }

    public void withdrawn(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)baseDto;
            this.checkWithdrawn(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if ((workflowDto = this.workflowRegist.withdrawn(workflowDto)) == null) continue;
            this.workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getWithdrawSucceed((MospParams)this.mospParams));
        }
    }

    protected void checkInsert(HolidayRequestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestStartDate(), dto.getHolidayType1(), dto.getHolidayType2(), dto.getHolidayRange(), dto.getStartTime()));
    }

    protected void checkUpdate(HolidayRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdHolidayRequestId());
    }

    protected void validate(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        this.holidayRequestRefer.chkBasicInfo(dto.getPersonalId(), dto.getRequestStartDate());
        int holidayRange = dto.getHolidayRange();
        String holidayRangeName = TimeNamingUtility.holidayRange((MospParams)this.mospParams);
        this.checkAvailableInt(holidayRange, AVAILABLE_HOLIDAY_RANGES, holidayRangeName, row);
    }

    public void checkSetRequestDate(HolidayRequestDtoInterface dto) throws MospException {
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        List list = TimeUtility.getDateList((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate());
        this.checkSuspended(dto, list);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTemporaryClosingFinal(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDailyForSetRequestDate(dto, list);
    }

    public void checkDraft(HolidayRequestDtoInterface dto) throws MospException {
        this.checkForRequest(dto, Boolean.valueOf(false), null);
    }

    public void checkAppli(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        this.checkForRequest(dto, Boolean.valueOf(false), row);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeChange(dto);
        this.checkDifference(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTimeHoliday(dto, row);
    }

    public void checkAppli(HolidayRequestDtoInterface dto) throws MospException {
        this.checkAppli(dto, null);
    }

    public void checkApproval(HolidayRequestDtoInterface dto) throws MospException {
        this.checkForRequest(dto, Boolean.valueOf(true), null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeChange(dto);
        this.checkDifference(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTimeHoliday(dto);
    }

    protected void checkForRequest(HolidayRequestDtoInterface dto, Boolean isCompleted, Integer row) throws MospException {
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        List list = TimeUtility.getDateList((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate());
        this.checkSuspended(dto, list);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTemporaryClosingFinal(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkPaidHolidayMaster(dto, row);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTimeHolidayLimit(dto, isCompleted, row);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHolidayMaster(dto, row);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDailyForDraft(dto, list, row);
    }

    public void checkCancelAppli(HolidayRequestDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        if (dto.getRequestStartDate().equals(dto.getRequestEndDate()) && this.approvalInfoReference.isExistAttendanceTargetDate(dto.getPersonalId(), dto.getRequestStartDate())) {
            this.addOthersRequestErrorMessage(dto.getRequestStartDate(), this.mospParams.getName("WorkManage"));
        }
    }

    public void checkWithdrawn(HolidayRequestDtoInterface dto) {
    }

    public void checkCancelApproval(HolidayRequestDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
    }

    public void checkCancel(HolidayRequestDtoInterface dto) {
    }

    protected void checkDailyForSetRequestDate(HolidayRequestDtoInterface dto, List<Date> list) throws MospException {
        for (Date date : list) {
            this.checkDailyForSetRequestDate(dto, date);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkDailyForSetRequestDate(HolidayRequestDtoInterface dto, Date date) throws MospException {
        RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        String personalId = dto.getPersonalId();
        localRequestUtil.setRequests(personalId, date);
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(personalId, date, localRequestUtil);
        this.checkWorkType(dto, date, workTypeCode, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) {
            return;
        }
        this.checkDuplicate(dto, date, localRequestUtil, false);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(dto, date);
    }

    protected void checkDailyForDraft(HolidayRequestDtoInterface dto, List<Date> list, Integer row) throws MospException {
        for (Date date : list) {
            this.checkDailyForDraft(dto, date, row);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkDailyForDraft(HolidayRequestDtoInterface dto, Date date, Integer row) throws MospException {
        RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        String personalId = dto.getPersonalId();
        localRequestUtil.setRequests(personalId, date);
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(personalId, date, localRequestUtil);
        this.checkWorkType(dto, date, workTypeCode, row);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalHoliday((String)workTypeCode) || TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode)) {
            return;
        }
        this.checkDuplicate(dto, date, localRequestUtil, true);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkShortTime(dto, localRequestUtil, workTypeCode, date);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(dto, date);
    }

    protected void checkDuplicate(HolidayRequestDtoInterface dto, Date targetDate, RequestUtilBeanInterface localRequestUtil, boolean isDraft) throws MospException {
        int subHolidayRange;
        boolean holidayRangeAm = false;
        boolean holidayRangePm = false;
        boolean holidayRangeTime = false;
        boolean subHolidayRangeAm = false;
        boolean subHolidayRangePm = false;
        boolean substituteRangeAm = false;
        boolean substituteRangePm = false;
        List list = this.dao.findForTermOnWorkflow(dto.getPersonalId(), targetDate, targetDate);
        for (HolidayRequestDtoInterface holidayRequestDto : list) {
            long workflow = holidayRequestDto.getWorkflow();
            if (this.workflowIntegrate.isWithDrawn(workflow) || dto.getWorkflow() == workflow) continue;
            int holidayRange = holidayRequestDto.getHolidayRange();
            if (holidayRange == 1) {
                this.addHolidayOverlapRange1ErrorMessage();
                return;
            }
            if (holidayRange == 2) {
                holidayRangeAm = true;
                continue;
            }
            if (holidayRange == 3) {
                holidayRangePm = true;
                continue;
            }
            if (holidayRange != 4) continue;
            holidayRangeTime = true;
            if (!isDraft || dto.getHolidayRange() != 4 || !this.checkDuplicationTimeZone(holidayRequestDto.getStartTime(), holidayRequestDto.getEndTime(), dto.getStartTime(), dto.getEndTime())) continue;
            PfMessageUtility.addErrorTermOverlap((MospParams)this.mospParams, (String)TimeNamingUtility.hourlyHoliday((MospParams)this.mospParams));
            return;
        }
        if (holidayRangeAm && holidayRangePm) {
            this.addHolidayOverlapRange1ErrorMessage();
            return;
        }
        if (isDraft) {
            int holidayRange = dto.getHolidayRange();
            if (holidayRange == 1) {
                if (holidayRangeAm || holidayRangePm || holidayRangeTime) {
                    this.addHolidayOverlapRange1ErrorMessage();
                    return;
                }
            } else if (holidayRange == 2) {
                if (holidayRangeAm) {
                    this.addHolidayOverlapRange2ErrorMessage();
                    return;
                }
                if (holidayRangeTime) {
                    TimeMessageUtility.addErrorHalfAndHourlyHoliday((MospParams)this.mospParams);
                    return;
                }
            } else if (holidayRange == 3) {
                if (holidayRangePm) {
                    this.addHolidayOverlapRange2ErrorMessage();
                    return;
                }
                if (holidayRangeTime) {
                    TimeMessageUtility.addErrorHalfAndHourlyHoliday((MospParams)this.mospParams);
                    return;
                }
            } else if (holidayRange == 4 && (holidayRangeAm || holidayRangePm)) {
                TimeMessageUtility.addErrorHalfAndHourlyHoliday((MospParams)this.mospParams);
                return;
            }
        } else if (!dto.getRequestStartDate().equals(dto.getRequestEndDate()) && (holidayRangeAm || holidayRangePm || holidayRangeTime)) {
            this.addHolidayOverlapRange1ErrorMessage();
            return;
        }
        if ((subHolidayRange = localRequestUtil.checkHolidayRangeSubHoliday(localRequestUtil.getSubHolidayList(false))) == 1 || subHolidayRange == 5) {
            this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
            return;
        }
        if (subHolidayRange == 2) {
            subHolidayRangeAm = true;
        } else if (subHolidayRange == 3) {
            subHolidayRangePm = true;
        }
        int substituteRange = localRequestUtil.checkHolidayRangeSubstitute(localRequestUtil.getSubstituteList(false));
        if (substituteRange == 1 || substituteRange == 5) {
            this.addSubstituteErrorMessage(targetDate);
            return;
        }
        if (substituteRange == 2) {
            substituteRangeAm = true;
        } else if (substituteRange == 3) {
            substituteRangePm = true;
        }
        if ((holidayRangeAm || subHolidayRangeAm || substituteRangeAm) && (holidayRangePm || subHolidayRangePm || substituteRangePm)) {
            this.addHolidayOverlapRange1ErrorMessage();
            return;
        }
        if (isDraft) {
            int holidayRange = dto.getHolidayRange();
            if (holidayRange == 1) {
                if (subHolidayRangeAm || subHolidayRangePm) {
                    this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
                    return;
                }
            } else if (holidayRange == 2) {
                if (subHolidayRangeAm) {
                    this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
                    return;
                }
            } else if (holidayRange == 3) {
                if (subHolidayRangePm) {
                    this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
                    return;
                }
            } else if (holidayRange == 4 && (subHolidayRangeAm || subHolidayRangePm)) {
                this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
                return;
            }
        } else if (!dto.getRequestStartDate().equals(dto.getRequestEndDate()) && (subHolidayRangeAm || subHolidayRangePm)) {
            this.addOthersRequestErrorMessage(targetDate, this.mospParams.getName("CompensatoryHoliday"));
            return;
        }
        if (isDraft) {
            int holidayRange = dto.getHolidayRange();
            if (holidayRange == 1) {
                if (substituteRangeAm || substituteRangePm) {
                    this.addSubstituteErrorMessage(targetDate);
                    return;
                }
            } else if (holidayRange == 2) {
                if (substituteRangeAm) {
                    this.addSubstituteErrorMessage(targetDate);
                    return;
                }
            } else if (holidayRange == 3) {
                if (substituteRangePm) {
                    this.addSubstituteErrorMessage(targetDate);
                    return;
                }
            } else if (holidayRange == 4 && (substituteRangeAm || substituteRangePm)) {
                this.addSubstituteErrorMessage(targetDate);
                return;
            }
        } else if (!dto.getRequestStartDate().equals(dto.getRequestEndDate()) && (substituteRangeAm || substituteRangePm)) {
            this.addSubstituteErrorMessage(targetDate);
            return;
        }
        int holidayRange = 1;
        if (isDraft) {
            holidayRange = dto.getHolidayRange();
            if (dto.getHolidayRange() == 2) {
                if (holidayRangePm || subHolidayRangePm || substituteRangePm) {
                    holidayRange = 1;
                }
            } else if (dto.getHolidayRange() == 3 && (holidayRangeAm || subHolidayRangeAm || substituteRangeAm)) {
                holidayRange = 1;
            }
        } else if (dto.getRequestStartDate().equals(dto.getRequestEndDate())) {
            return;
        }
        this.checkOvertimeWorkRequest(localRequestUtil, targetDate, holidayRange);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSubstituteWorkRequest(localRequestUtil, targetDate, holidayRange);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeChangeRequest(localRequestUtil, holidayRange);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDifferenceRequest(localRequestUtil, holidayRange);
    }

    protected void checkShortTime(HolidayRequestDtoInterface dto, RequestUtilBeanInterface localRequestUtil, String workTypeCode, Date date) throws MospException {
        DifferenceRequestDtoInterface differenceRequestDto = localRequestUtil.getDifferenceDto(true);
        if (differenceRequestDto != null) {
            return;
        }
        WorkTypeEntityInterface workTypeEntity = this.workTypeReference.getWorkTypeEntity(workTypeCode, date);
        if (workTypeEntity == null) {
            return;
        }
        boolean isShort1TimeSet = workTypeEntity.isShort1TimeSet();
        Date short1StartTime = null;
        Date short1EndTime = null;
        if (isShort1TimeSet) {
            short1StartTime = this.getTime(workTypeEntity.getShort1StartTime(), date);
            short1EndTime = this.getTime(workTypeEntity.getShort1EndTime(), date);
        }
        boolean isShort2TimeSet = workTypeEntity.isShort2TimeSet();
        Date short2StartTime = null;
        Date short2EndTime = null;
        if (isShort2TimeSet) {
            short2StartTime = this.getTime(workTypeEntity.getShort2StartTime(), date);
            short2EndTime = this.getTime(workTypeEntity.getShort2EndTime(), date);
        }
        if (!isShort1TimeSet && !isShort2TimeSet) {
            return;
        }
        if (dto.getHolidayRange() != 4) {
            return;
        }
        if (isShort1TimeSet && this.checkDuplicationTimeZone(dto.getStartTime(), dto.getEndTime(), short1StartTime, short1EndTime)) {
            this.mospParams.addErrorMessage("TMW0320", new String[]{DateUtility.getStringTime((Date)short1StartTime), DateUtility.getStringTime((Date)short1EndTime)});
            return;
        }
        if (isShort2TimeSet && this.checkDuplicationTimeZone(dto.getStartTime(), dto.getEndTime(), short2StartTime, short2EndTime)) {
            this.mospParams.addErrorMessage("TMW0320", new String[]{DateUtility.getStringTime((Date)short2StartTime), DateUtility.getStringTime((Date)short2EndTime)});
        }
    }

    protected void checkOvertimeWorkRequest(RequestUtilBeanInterface localRequestUtil, Date date, int holidayRange) throws MospException {
        if (holidayRange != 1) {
            return;
        }
        if (localRequestUtil.getOverTimeList(false).isEmpty()) {
            return;
        }
        this.addOthersRequestErrorMessage(date, this.mospParams.getName("OvertimeWork"));
    }

    protected void checkSubstituteWorkRequest(RequestUtilBeanInterface localRequestUtil, Date date, int holidayRange) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = localRequestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null) {
            return;
        }
        int substitute = workOnHolidayRequestDto.getSubstitute();
        if (substitute == 2) {
            return;
        }
        if (substitute == 1) {
            return;
        }
        if (substitute == 5) {
            return;
        }
        this.addOthersRequestErrorMessage(date, this.mospParams.getName("HalfDay", new String[]{"Transfer", "GoingWork"}));
    }

    protected void checkWorkTypeChangeRequest(RequestUtilBeanInterface localRequestUtil, int holidayRange) throws MospException {
        if (holidayRange != 1) {
            return;
        }
        WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto = localRequestUtil.getWorkTypeChangeDto(false);
        if (workTypeChangeRequestDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(workTypeChangeRequestDto.getRequestDate(), this.mospParams.getName("Work", new String[]{"Form", "Change"}));
    }

    protected void checkDifferenceRequest(RequestUtilBeanInterface localRequestUtil, int holidayRange) throws MospException {
        if (holidayRange != 1 && holidayRange != 2) {
            return;
        }
        DifferenceRequestDtoInterface differenceRequestDto = localRequestUtil.getDifferenceDto(false);
        if (differenceRequestDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(differenceRequestDto.getRequestDate(), this.mospParams.getName("TimeDifference", new String[]{"GoingWork"}));
    }

    protected void checkAttendance(HolidayRequestDtoInterface dto, Date date) throws MospException {
        AttendanceDtoInterface attendanceDto = this.attendanceReference.findForKey(dto.getPersonalId(), date);
        if (attendanceDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(attendanceDto.getWorkflow());
        if (workflowDto == null) {
            return;
        }
        if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if (WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        this.addHolidayTargetWorkDateAttendanceRequestErrorMessage(date);
    }

    public void deleteAttendance(HolidayRequestDtoInterface dto) throws MospException {
        int range = dto.getHolidayRange();
        boolean holidayAm = range == 2;
        boolean holidayPm = range == 3;
        List dateList = TimeUtility.getDateList((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate());
        block0: for (Date date : dateList) {
            Object holidayRequestDto2;
            RequestUtilBeanInterface localRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
            localRequestUtil.setRequests(dto.getPersonalId(), date);
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = localRequestUtil.getWorkOnHolidayDto(false);
            if (workOnHolidayRequestDto != null && workOnHolidayRequestDto.getSubstitute() == 2) continue;
            if (range == 1) {
                this.attendanceRegist.delete(dto.getPersonalId(), date);
                continue;
            }
            if (!holidayAm && !holidayPm) continue;
            List list = localRequestUtil.getHolidayList(false);
            for (Object holidayRequestDto2 : list) {
                if ((!holidayAm || holidayRequestDto2.getHolidayRange() != 3) && (!holidayPm || holidayRequestDto2.getHolidayRange() != 2)) continue;
                this.attendanceRegist.delete(dto.getPersonalId(), date);
                break;
            }
            List subHolidayRequestList = localRequestUtil.getSubHolidayList(false);
            holidayRequestDto2 = subHolidayRequestList.iterator();
            while (holidayRequestDto2.hasNext()) {
                SubHolidayRequestDtoInterface subHolidayRequestDto = (SubHolidayRequestDtoInterface)holidayRequestDto2.next();
                if ((!holidayAm || subHolidayRequestDto.getHolidayRange() != 3) && (!holidayPm || subHolidayRequestDto.getHolidayRange() != 2)) continue;
                this.attendanceRegist.delete(dto.getPersonalId(), date);
                break;
            }
            List substituteList = localRequestUtil.getSubstituteList(false);
            for (SubstituteDtoInterface substituteDto : substituteList) {
                if ((!holidayAm || substituteDto.getHolidayRange() != 3) && (!holidayPm || substituteDto.getHolidayRange() != 2)) continue;
                this.attendanceRegist.delete(dto.getPersonalId(), date);
                continue block0;
            }
        }
    }

    public void draftAttendance(HolidayRequestDtoInterface dto) throws MospException {
        if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) {
            return;
        }
        this.timeApproval = (TimeApprovalBeanInterface)this.createBean(TimeApprovalBeanInterface.class);
        boolean deleteRest = false;
        int holidayRange = dto.getHolidayRange();
        if (holidayRange == 2 || holidayRange == 3) {
            deleteRest = true;
        }
        this.timeApproval.reDraft(dto.getPersonalId(), dto.getRequestStartDate(), deleteRest, false, false);
    }

    protected void checkEntered(HolidayRequestDtoInterface dto) throws MospException {
        if (!this.isEntered(dto.getPersonalId(), dto.getRequestStartDate())) {
            PfMessageUtility.addErrorEmployeeNotJoin((MospParams)this.mospParams);
        }
    }

    protected void checkRetired(HolidayRequestDtoInterface dto) throws MospException {
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getRequestEndDate())) {
            PfMessageUtility.addErrorEmployeeRetired((MospParams)this.mospParams);
        }
    }

    protected void checkSuspended(HolidayRequestDtoInterface dto, List<Date> list) throws MospException {
        String personalId = dto.getPersonalId();
        for (Date date : list) {
            if (!this.suspensionReference.isSuspended(personalId, date)) continue;
            PfMessageUtility.addErrorEmployeeSuspended((MospParams)this.mospParams);
            return;
        }
    }

    protected void checkTemporaryClosingFinal(HolidayRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestStartDate(), TimeNamingUtility.holidayDate((MospParams)this.mospParams));
    }

    protected void checkPaidHolidayMaster(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        if (!TimeRequestUtility.isPaidHoliday((HolidayRequestDtoInterface)dto) && !TimeRequestUtility.isStockHoliday((HolidayRequestDtoInterface)dto)) {
            return;
        }
        String personalId = dto.getPersonalId();
        Date targetDate = dto.getRequestStartDate();
        PaidHolidayDtoInterface paidHolidayDto = this.timeMaster.getPaidHolidayForPersonalId(personalId, targetDate).orElse(null);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            TimeMessageUtility.addErrorPaidHolidayDefect((MospParams)this.mospParams, (Date)targetDate, (Integer)row);
            return;
        }
        if (this.holidayRequestRefer.isPaidHolidayReasonRequired() && MospUtility.isEmpty((String[])new String[]{dto.getRequestReason()})) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)TimeNamingUtility.holidayReason((MospParams)this.mospParams), (Integer)row);
        }
        if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) {
            if (TimeRequestUtility.isStockHoliday((HolidayRequestDtoInterface)dto)) {
                TimeMessageUtility.addErrorShortPaidHolidayRemainDays((MospParams)this.mospParams, (Integer)row);
                return;
            }
            if (PlatformUtility.isInactivate((int)paidHolidayDto.getTimelyPaidHolidayFlag())) {
                TimeMessageUtility.addErrorUnsetHorlyPaidHoliday((MospParams)this.mospParams, (Integer)row);
                return;
            }
            int startMinute = DateUtility.getMinute((Date)dto.getStartTime());
            if (!ValidateUtility.chkIndivisible((double)startMinute, (float)paidHolidayDto.getAppliTimeInterval())) {
                PfMessageUtility.addErrorInputValueInvalid((MospParams)this.mospParams, (String)TimeNamingUtility.hourlyHolidayRequestTime((MospParams)this.mospParams), (Integer)row);
                return;
            }
        }
    }

    protected void checkHolidayMaster(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        Date requestStartDate;
        if (!(TimeRequestUtility.isSpecialHoliday((HolidayRequestDtoInterface)dto) || TimeRequestUtility.isOtherHoliday((HolidayRequestDtoInterface)dto) || TimeRequestUtility.isAbsenece((HolidayRequestDtoInterface)dto))) {
            return;
        }
        int holidayType1 = dto.getHolidayType1();
        String holidayType2 = dto.getHolidayType2();
        HolidayDtoInterface holidayDto = this.timeMaster.getHoliday(holidayType2, holidayType1, requestStartDate = dto.getRequestStartDate());
        if (!PlatformUtility.isDtoActivate((PlatformDtoInterface)holidayDto)) {
            PfMessageUtility.addErrorNoItem((MospParams)this.mospParams, (String)TimeNamingUtility.holidayType((MospParams)this.mospParams), (Integer)row);
            return;
        }
        if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto) && PlatformUtility.isInactivate((int)holidayDto.getTimelyHolidayFlag())) {
            TimeMessageUtility.addErrorHourlyHolidayInvalid((MospParams)this.mospParams, (String)holidayDto.getHolidayName());
        }
        if (TimeRequestUtility.isHolidayRangeHalf((HolidayRangeDtoInterface)dto) && PlatformUtility.isInactivate((int)holidayDto.getHalfHolidayRequest())) {
            TimeMessageUtility.addErrorHalfHolidayInvalid((MospParams)this.mospParams, (String)holidayDto.getHolidayName());
        }
        if (holidayDto.getReasonType() == 1 && MospUtility.isEmpty((String[])new String[]{dto.getRequestReason()})) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)TimeNamingUtility.holidayReason((MospParams)this.mospParams));
        }
    }

    protected void checkTimeHolidayLimit(HolidayRequestDtoInterface dto, Boolean isCompleted, Integer row) throws MospException {
        Date requestDate;
        if (this.doAdditionalLogic(new Object[]{"Add_HolidayRequestRegistBean_CheckTimeHolidayLimit", dto, isCompleted})) {
            return;
        }
        if (!TimeRequestUtility.isPaidHoliday((HolidayRequestDtoInterface)dto)) {
            return;
        }
        if (!TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) {
            return;
        }
        String personalId = dto.getPersonalId();
        int[] limit = this.paidHolidayInfoReference.getHolidayTimeUnitLimit(personalId, requestDate = dto.getRequestStartDate(), isCompleted.booleanValue(), dto);
        if (limit[0] <= 0 && limit[1] <= 0) {
            this.addHolidayNumDaysExcessErrorMessage(this.mospParams.getName("HolidayTime", new String[]{"Of", "Years"}), this.mospParams.getName("Time"));
            return;
        }
        Map timeHoliday = this.holidayRequestRefer.getTimeHolidayStatusTimesMap(personalId, requestDate, dto);
        if (timeHoliday.isEmpty()) {
            return;
        }
        int holidayTimes = (Integer)timeHoliday.get(this.mospParams.getName("Finish")) + (Integer)timeHoliday.get(this.mospParams.getName("Register")) + (Integer)timeHoliday.get(this.mospParams.getName("Back"));
        if (!timeHoliday.isEmpty() && holidayTimes >= this.getPrescribedWorkHour(dto)) {
            this.addHolidayNumDaysExcessErrorMessage(this.mospParams.getName("HolidayTime", new String[]{"Of", "No1", "Day"}), this.mospParams.getName("Time"));
        }
    }

    protected void checkWorkType(HolidayRequestDtoInterface dto, Date targetDate, String workTypeCode, Integer row) throws MospException {
        Date requestStartDate = dto.getRequestStartDate();
        Date requestEndDate = dto.getRequestEndDate();
        if (MospUtility.isEmpty((String[])new String[]{workTypeCode})) {
            TimeMessageUtility.addErrorNotWorkDayForHolidayRequest((MospParams)this.mospParams, (Date)targetDate, (Integer)row);
            return;
        }
        if ((TimeUtility.isHoliday((String)workTypeCode) || TimeUtility.isWorkOnLegalOrPrescribedHoliday((String)workTypeCode)) && (DateUtility.isSame((Date)targetDate, (Date)requestStartDate) || DateUtility.isSame((Date)targetDate, (Date)requestEndDate))) {
            TimeMessageUtility.addErrorNotWorkDayForHolidayRequest((MospParams)this.mospParams, (Date)targetDate, (Integer)row);
            return;
        }
    }

    protected int getPrescribedWorkHour(HolidayRequestDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        Date targetDate = dto.getRequestStartDate();
        WorkTypeEntityInterface workType = this.getWorkTypeEntity(personalId, targetDate);
        int workTime = workType.getWorkTime();
        return TimeUtility.getHours((int)workTime);
    }

    public void checkTimeHoliday(HolidayRequestDtoInterface dto) throws MospException {
        this.checkTimeHoliday(dto, null);
    }

    protected void checkTimeHoliday(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        if (this.doAdditionalLogic(new Object[]{"Add_HolidayRequestRegistBean_CheckTimeHoliday", dto})) {
            return;
        }
        if (!TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) {
            return;
        }
        String personalId = dto.getPersonalId();
        Date targetDate = dto.getRequestStartDate();
        WorkTypeEntityInterface workType = this.getWorkTypeEntity(personalId, targetDate);
        Date startWorkTime = workType.getStartWorkTime();
        Date endWorkTime = workType.getEndWorkTime();
        Date requestStartTime = TimeUtility.getDefaultDateTime((Date)dto.getStartTime(), (Date)targetDate);
        Date requestEndTime = TimeUtility.getDefaultDateTime((Date)dto.getEndTime(), (Date)targetDate);
        if (!DateUtility.isTermContain((Date)requestStartTime, (Date)startWorkTime, (Date)endWorkTime) || !DateUtility.isTermContain((Date)requestEndTime, (Date)startWorkTime, (Date)endWorkTime)) {
            TimeMessageUtility.addErrorHorlyHolidayOutOfWorkTypeTime((MospParams)this.mospParams, (Date)startWorkTime, (Date)endWorkTime, (Integer)row);
        }
    }

    protected WorkTypeEntityInterface getWorkTypeEntity(String personalId, Date targetDate) throws MospException {
        RequestEntityInterface request = this.requestUtil.getRequestEntity(personalId, targetDate);
        Set statuses = WorkflowUtility.getCompletedStatuses();
        String workTypeCode = request.getWorkType(true, statuses);
        DifferenceRequestDtoInterface differenceRequest = request.getDifferenceRequestDto(statuses);
        return this.timeMaster.getWorkTypeEntity(workTypeCode, targetDate, differenceRequest);
    }

    protected void checkWorkTypeChange(HolidayRequestDtoInterface dto) throws MospException {
        WorkTypeChangeRequestDtoInterface workTypeChangeDto = this.workTypeChangeReference.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestStartDate());
        if (workTypeChangeDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(workTypeChangeDto.getWorkflow());
        if (this.workflowIntegrate.isCompleted(workflowDto.getWorkflow()) || this.workflowIntegrate.isWithDrawn(workflowDto.getWorkflow()) || this.workflowIntegrate.isDraft(workflowDto.getWorkflow())) {
            return;
        }
        String requestName = this.mospParams.getName("Work", new String[]{"Form", "Change"});
        this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(dto.getRequestStartDate()), requestName});
    }

    protected void checkDifference(HolidayRequestDtoInterface dto) throws MospException {
        if (dto.getHolidayRange() != 4) {
            return;
        }
        DifferenceRequestDtoInterface differenceDto = this.differenceRequestReference.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestStartDate());
        if (differenceDto == null) {
            return;
        }
        WorkflowDtoInterface differenceWorkflow = this.workflowIntegrate.getLatestWorkflowInfo(differenceDto.getWorkflow());
        if (!(WorkflowUtility.isWithDrawn((WorkflowDtoInterface)differenceWorkflow) || WorkflowUtility.isDraft((WorkflowDtoInterface)differenceWorkflow) || WorkflowUtility.isCompleted((WorkflowDtoInterface)differenceWorkflow))) {
            String requestName = this.mospParams.getName("TimeDifference", new String[]{"GoingWork", "Application"});
            this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(dto.getRequestStartDate()), requestName});
        }
    }

    protected void addSubstituteErrorMessage(Date date) {
        this.addOthersRequestErrorMessage(date, this.mospParams.getName("Transfer", new String[]{"DayOff"}));
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
        this.attendanceRegist.setTimeMaster(timeMaster);
        this.scheduleUtil.setTimeMaster(timeMaster);
        this.requestUtil.setTimeMaster(timeMaster);
        this.paidHolidayRemain.setTimeMaster(timeMaster);
        this.cutoffUtil.setTimeMaster(timeMaster);
    }
}

