/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.entity.HolidayRequestEntityInterface;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class HolidayRequestReferenceBean
extends TimeBean
implements HolidayRequestReferenceBeanInterface {
    protected HolidayRequestDaoInterface dao;
    protected WorkflowDaoInterface workflowDao;
    protected WorkflowIntegrateBeanInterface workflowIntegerBean;

    public void initBean() throws MospException {
        this.dao = (HolidayRequestDaoInterface)this.createDaoInstance(HolidayRequestDaoInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDaoInstance(WorkflowDaoInterface.class);
        this.workflowIntegerBean = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestList(String personalId, Date requestDate) throws MospException {
        return this.dao.findForList(personalId, requestDate);
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestListOnWorkflow(String personalId, Date requestDate) throws MospException {
        ArrayList<HolidayRequestDtoInterface> newList = new ArrayList<HolidayRequestDtoInterface>();
        List list = this.dao.findForList(personalId, requestDate);
        for (HolidayRequestDtoInterface dto : list) {
            if (this.workflowIntegerBean.isWithDrawn(dto.getWorkflow())) continue;
            newList.add(dto);
        }
        return newList;
    }

    public HolidayRequestDtoInterface findForKeyOnWorkflow(String personalId, Date requestStartDate, int holidayType1, String holidayType2, int holidayRange, Date startTime) throws MospException {
        return this.dao.findForKeyOnWorkflow(personalId, requestStartDate, holidayType1, holidayType2, holidayRange, startTime);
    }

    public HolidayRequestDtoInterface findForKey(long id) throws MospException {
        BaseDto dto = this.findForKey((BaseDaoInterface)this.dao, id, false);
        if (dto != null) {
            return (HolidayRequestDtoInterface)dto;
        }
        return null;
    }

    public HolidayRequestDtoInterface findForWorkflow(long workflow) throws MospException {
        return this.dao.findForWorkflow(workflow);
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestList(String personalId, Date firstDate, Date lastDate) throws MospException {
        return this.dao.findForTerm(personalId, firstDate, lastDate);
    }

    public Map<String, Set<HolidayRequestDtoInterface>> getHolidayRequests(Collection<String> personalIds, Date requestDate) throws MospException {
        return PlatformUtility.getPersonalIdMap((Collection)this.dao.findForPersonalIds(personalIds, requestDate));
    }

    public Map<Date, List<HolidayRequestDtoInterface>> getHolidayRequests(String personalId, Date firstDate, Date lastDate) throws MospException {
        return TimeUtility.getHolidayRequestsMap((List)this.dao.findForTerm(personalId, firstDate, lastDate));
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestListOnWorkflow(String personalId, Date firstDate, Date lastDate) throws MospException {
        return this.dao.findForTermOnWorkflow(personalId, firstDate, lastDate);
    }

    public Map<String, Object> getRequestDayHour(String personalId, Date acquisitionDate, int holidayType1, String holidayType2, Date requestStartDate, Date requestEndDate) throws MospException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = this.dao.findForRequestList(personalId, acquisitionDate, holidayType1, holidayType2, requestStartDate, requestEndDate);
        map.put("requestDay", TimeUtility.getHolidayUseDays((Collection)list));
        map.put("requestHour", TimeUtility.getHolidayUseHours((Collection)list));
        return map;
    }

    public AbstractMap.SimpleEntry<Double, Integer> getHolidayUses(String personalId, Date firstDate, Date lastDate, int holidayType1, String holidayType2, Collection<Date> acquisitionDates) throws MospException {
        double useDays = 0.0;
        int useHours = 0;
        List list = this.getHolidayRequestListOnWorkflow(personalId, firstDate, lastDate);
        for (HolidayRequestDtoInterface dto : list) {
            if (dto.getHolidayType1() != holidayType1 || !MospUtility.isEqual((Object)holidayType2, (Object)dto.getHolidayType2()) || !acquisitionDates.contains(dto.getHolidayAcquisitionDate())) continue;
            useDays += dto.getUseDay();
            useHours += dto.getUseHour();
        }
        return new AbstractMap.SimpleEntry<Double, Integer>(useDays, useHours);
    }

    public boolean isPaidHolidayReasonRequired() {
        return this.mospParams.getApplicationPropertyBool("PaidHolidayReasonRequired");
    }

    public void chkBasicInfo(String personalId, Date targetDate) throws MospException {
        this.initial(personalId, targetDate, "3");
    }

    public Map<String, Integer> getTimeHolidayStatusTimesMap(String personalId, Date acquisitionDate, HolidayRequestDtoInterface holidayRequestDto) throws MospException {
        HashMap<String, Integer> timeHolidayMap = new HashMap<String, Integer>();
        int draft = 0;
        int approval = 0;
        int complete = 0;
        int revert = 0;
        List holidayList = this.getHolidayRequestListOnWorkflow(personalId, acquisitionDate);
        if (holidayList.isEmpty()) {
            return timeHolidayMap;
        }
        for (HolidayRequestDtoInterface dto : holidayList) {
            if (dto.getHolidayRange() != 4 || this.workflowIntegerBean.isWithDrawn(dto.getWorkflow()) || holidayRequestDto != null && holidayRequestDto.getTmdHolidayRequestId() == dto.getTmdHolidayRequestId()) continue;
            if (this.workflowIntegerBean.isDraft(dto.getWorkflow())) {
                ++draft;
                continue;
            }
            if (this.workflowIntegerBean.isCompleted(dto.getWorkflow())) {
                ++complete;
                continue;
            }
            if (this.workflowIntegerBean.isFirstReverted(dto.getWorkflow())) {
                ++revert;
                continue;
            }
            ++approval;
        }
        timeHolidayMap.put(PfNameUtility.draftAbbr((MospParams)this.mospParams), draft);
        timeHolidayMap.put(PfNameUtility.appliedAbbr((MospParams)this.mospParams), approval);
        timeHolidayMap.put(PfNameUtility.completedAbbr((MospParams)this.mospParams), complete);
        timeHolidayMap.put(PfNameUtility.revertedAbbr((MospParams)this.mospParams), revert);
        return timeHolidayMap;
    }

    public List<HolidayRequestDtoInterface> getAppliedPaidHolidayRequests(String personalId, Date acquisitionDate, Date startDate, Date endDate) throws MospException {
        return this.dao.findForAppliedList(personalId, acquisitionDate, startDate, endDate, 1, "1");
    }

    public List<HolidayRequestDtoInterface> getAppliedPaidHolidayRequests(Date startDate, Date endDate) throws MospException {
        return this.getAppliedPaidHolidayRequests("", null, startDate, endDate);
    }

    public List<HolidayRequestDtoInterface> getCompletedRequests(String personalId, Date startDate, Date endDate, int holidayType1, String holidayType2) throws MospException {
        return this.dao.findForApprovedList(personalId, null, holidayType1, holidayType2, startDate, endDate);
    }

    public Set<HolidayRequestDtoInterface> getRequestsForAcquisitionDate(String personalId, int holidayType1, String holidayType2, Date acquisitionDate, Set<String> statuses) throws MospException {
        List dtos = this.dao.findForAcquisitionList(personalId, holidayType1, holidayType2, acquisitionDate);
        Map workflows = this.workflowDao.findForInKey(WorkflowUtility.getWorkflowSet((Collection[])new Collection[]{dtos}));
        return WorkflowUtility.getRequests((Collection)dtos, (Map)workflows, statuses);
    }

    public Set<HolidayRequestDtoInterface> getRequestsForAcquisitionDate(String personalId, int holidayType1, String holidayType2, Date acquisitionDate, Set<String> statuses, Date targetDate) throws MospException {
        Set requests = this.getRequestsForAcquisitionDate(personalId, holidayType1, holidayType2, acquisitionDate, statuses);
        return TimeRequestUtility.getStartedHolidayRequests((Collection)requests, (Date)targetDate);
    }

    public HolidayRequestEntityInterface getHolidayRequestEntity(String personalId, Date firstDate, Date lastDate) throws MospException {
        HolidayRequestEntityInterface entity = (HolidayRequestEntityInterface)this.createObject(HolidayRequestEntityInterface.class);
        List holidayList = this.dao.findForTerm(personalId, firstDate, lastDate);
        entity.setHolidays(holidayList);
        entity.setWorkflows(this.workflowDao.findForInKey(WorkflowUtility.getWorkflowSet((Collection[])new Collection[]{holidayList})));
        return entity;
    }
}

