/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.file.ImportBeanInterface;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.time.bean.HolidayRequestExecuteBeanInterface;
import jp.mosp.time.utils.TimeMessageUtility;

public class HolidayRequestImportBean
extends PlatformFileBean
implements ImportBeanInterface {
    protected HolidayRequestExecuteBeanInterface holidayRequestExecute;

    public void initBean() throws MospException {
        this.holidayRequestExecute = (HolidayRequestExecuteBeanInterface)this.createBeanInstance(HolidayRequestExecuteBeanInterface.class);
    }

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        this.convertEmployeeCodeIntoPersonalId(fieldList, dataList, "request_start_date", PfNameUtility.activateDate((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        return this.importFile(fieldList, dataList);
    }

    protected int importFile(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) throws MospException {
        int count = 0;
        for (int i = 0; i < dataList.size(); ++i) {
            count += this.importData(fieldList, dataList.get(i), i);
        }
        return count;
    }

    protected int importData(List<ImportFieldDtoInterface> fieldList, String[] data, int row) throws MospException {
        this.checkDate(fieldList, data, row);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        String personalId = this.getFieldValue("personal_id", fieldList, data);
        Date requestStartDate = this.getDateFieldValue("request_start_date", fieldList, data);
        Date requestEndDate = this.getDateFieldValue("request_end_date", fieldList, data);
        int holidayType1 = this.getIntegerFieldValue("holiday_type1", fieldList, data);
        String holidayType2 = this.getFieldValue("holiday_type2", fieldList, data);
        int holidayRange = this.getIntegerFieldValue("holiday_range", fieldList, data);
        Date startTime = this.getTimestampFieldValue("start_time", fieldList, data);
        String requestReason = this.getFieldValue("request_reason", fieldList, data);
        int hours = 0;
        if (MospUtility.isEmpty((Object[])new Object[]{requestEndDate})) {
            requestEndDate = requestStartDate;
        }
        if (holidayRange == 2 || holidayRange == 3) {
            requestEndDate = requestStartDate;
        }
        if (holidayRange == 4) {
            if (MospUtility.isEmpty((Object[])new Object[]{startTime})) {
                String fieldName = this.mospParams.getProperties().getCodeItemName("import_tmd_holiday_request", "start_time");
                PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)fieldName, (Integer)row);
                return 0;
            }
            requestEndDate = requestStartDate = DateUtility.getDate((Date)startTime);
            hours = 1;
        }
        this.holidayRequestExecute.apply(personalId, requestStartDate, requestEndDate, holidayType1, holidayType2, holidayRange, startTime, hours, requestReason, row);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        return 1;
    }

    protected Date getTimestampFieldValue(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data) {
        return DateUtility.getVariousDate((String)this.getFieldValue(fieldName, fieldList, data));
    }

    protected void checkDate(List<ImportFieldDtoInterface> fieldList, String[] data, int row) {
        Date requestStartDate = this.getDateFieldValue("request_start_date", fieldList, data);
        Date requestEndDate = this.getDateFieldValue("request_end_date", fieldList, data);
        if (MospUtility.isEmpty((Object[])new Object[]{requestStartDate})) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)PfNameUtility.term((MospParams)this.mospParams), (Integer)row);
            return;
        }
        if (!this.checkDateOrder(requestStartDate, requestEndDate, true)) {
            TimeMessageUtility.addErrorHolidayOrderInvalid((MospParams)this.mospParams, (Integer)row);
        }
    }
}

