/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestExecuteBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.PaidHolidayRemainBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayRemainDto;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class HolidayRequestExecuteBean
extends PlatformBean
implements HolidayRequestExecuteBeanInterface {
    private static final String[] APPROVER_IDS_FOR_SELF = new String[]{"SELF_APPRO"};
    protected HolidayRequestReferenceBeanInterface refer;
    protected HolidayRequestRegistBeanInterface regist;
    protected WorkflowRegistBeanInterface workflowRegist;
    protected WorkflowCommentRegistBeanInterface workflowCommentRegist;
    protected AttendanceTransactionRegistBeanInterface attendanceTransactionRegist;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected PaidHolidayRemainBeanInterface paidHolidayRemain;
    protected HolidayInfoReferenceBeanInterface holidayInfo;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.refer = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
        this.regist = (HolidayRequestRegistBeanInterface)this.createBeanInstance(HolidayRequestRegistBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBeanInstance(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBeanInstance(WorkflowCommentRegistBeanInterface.class);
        this.attendanceTransactionRegist = (AttendanceTransactionRegistBeanInterface)this.createBeanInstance(AttendanceTransactionRegistBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.paidHolidayRemain = (PaidHolidayRemainBeanInterface)this.createBeanInstance(PaidHolidayRemainBeanInterface.class);
        this.holidayInfo = (HolidayInfoReferenceBeanInterface)this.createBeanInstance(HolidayInfoReferenceBeanInterface.class);
        this.setTimeMaster((TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class));
    }

    public void draft(String personalId, Date requestStartDate, Date requestEndDate, int holidayType1, String holidayType2, int holidayRange, Date startTime, int hours, String requestReason, long recordId, String[] approverIds) throws MospException {
        List dtos = this.getHolidayRequests(personalId, requestStartDate, requestEndDate, holidayType1, holidayType2, holidayRange, startTime, hours);
        this.setRecordIdAndWorkflow(dtos, recordId);
        for (HolidayRequestDtoInterface dto : dtos) {
            this.setAcquisitionDateAndUseDays(dto, null);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setRequestReason(requestReason);
            this.draft(dto, approverIds);
        }
    }

    public void apply(String personalId, Date requestStartDate, Date requestEndDate, int holidayType1, String holidayType2, int holidayRange, Date startTime, int hours, String requestReason, long recordId, String[] approverIds) throws MospException {
        this.apply(personalId, requestStartDate, requestEndDate, holidayType1, holidayType2, holidayRange, startTime, hours, requestReason, recordId, approverIds, null);
    }

    public void apply(String personalId, Date requestStartDate, Date requestEndDate, int holidayType1, String holidayType2, int holidayRange, Date startTime, int hours, String requestReason, int row) throws MospException {
        this.apply(personalId, requestStartDate, requestEndDate, holidayType1, holidayType2, holidayRange, startTime, hours, requestReason, 0L, APPROVER_IDS_FOR_SELF, Integer.valueOf(row));
    }

    public boolean batchUpdate(String personalId, long[] recordIds) throws MospException {
        if (MospUtility.isEmpty((long[])recordIds)) {
            PfMessageUtility.addErrorRequireCheck((MospParams)this.mospParams);
            return false;
        }
        boolean isHalfHolidayContained = false;
        for (long recordId : recordIds) {
            HolidayRequestDtoInterface dto = this.refer.findForKey(recordId);
            if (PlatformUtility.isDtoDeleted((BaseDtoInterface)dto)) {
                PfMessageUtility.addErrorExclusive((MospParams)this.mospParams);
                return isHalfHolidayContained;
            }
            this.setAcquisitionDateAndUseDays(dto, null);
            if (this.mospParams.hasErrorMessage()) {
                return isHalfHolidayContained;
            }
            this.applyForBatchUpdate(dto);
            isHalfHolidayContained = isHalfHolidayContained ? true : TimeRequestUtility.isHolidayRangeHalf((HolidayRangeDtoInterface)dto);
        }
        return isHalfHolidayContained;
    }

    public List<Date> getConsecutiveHolidayDates(String personalId, Date requestStartDate, Date requestEndDate) throws MospException {
        ArrayList<Date> holidayDates = new ArrayList<Date>();
        List dateList = TimeUtility.getDateList((Date)requestStartDate, (Date)requestEndDate);
        for (Date requestDate : dateList) {
            String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(personalId, requestDate, true);
            if (TimeRequestUtility.isNotHolidayForConsecutiveHolidays((String)workTypeCode)) continue;
            holidayDates.add(requestDate);
        }
        return holidayDates;
    }

    protected void apply(String personalId, Date requestStartDate, Date requestEndDate, int holidayType1, String holidayType2, int holidayRange, Date startTime, int hours, String requestReason, long recordId, String[] approverIds, Integer row) throws MospException {
        List dtos = this.getHolidayRequests(personalId, requestStartDate, requestEndDate, holidayType1, holidayType2, holidayRange, startTime, hours);
        this.setRecordIdAndWorkflow(dtos, recordId);
        for (HolidayRequestDtoInterface dto : dtos) {
            this.setAcquisitionDateAndUseDays(dto, row);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setRequestReason(requestReason);
            this.apply(dto, approverIds, row);
        }
    }

    protected List<HolidayRequestDtoInterface> getHolidayRequests(String personalId, Date requestStartDate, Date requestEndDate, int holidayType1, String holidayType2, int holidayRange, Date startTime, int hours) throws MospException {
        if (holidayRange == 4) {
            return this.getHourlyHolidayRequests(personalId, requestStartDate, holidayType1, holidayType2, startTime, hours);
        }
        if (holidayType1 == 1) {
            return this.getPaidHolidayRequests(personalId, requestStartDate, requestEndDate, holidayType2, holidayRange);
        }
        ArrayList<HolidayRequestDtoInterface> dtos = new ArrayList<HolidayRequestDtoInterface>();
        dtos.add(this.getHolidayRequest(personalId, requestStartDate, requestEndDate, holidayType1, holidayType2, holidayRange));
        return dtos;
    }

    protected List<HolidayRequestDtoInterface> getPaidHolidayRequests(String personalId, Date requestStartDate, Date requestEndDate, String holidayType2, int holidayRange) throws MospException {
        ArrayList<HolidayRequestDtoInterface> dtos = new ArrayList<HolidayRequestDtoInterface>();
        List holidayDates = this.getConsecutiveHolidayDates(personalId, requestStartDate, requestEndDate);
        for (Date requestDate : holidayDates) {
            dtos.add(this.getPaidHolidayRequest(personalId, requestDate, holidayType2, holidayRange));
        }
        return dtos;
    }

    protected List<HolidayRequestDtoInterface> getHourlyHolidayRequests(String personalId, Date requestDate, int holidayType1, String holidayType2, Date startTime, int hours) throws MospException {
        ArrayList<HolidayRequestDtoInterface> dtos = new ArrayList<HolidayRequestDtoInterface>();
        this.checkHours(hours);
        if (this.mospParams.hasErrorMessage()) {
            return dtos;
        }
        for (int i = 0; i < hours; ++i) {
            Date start = DateUtility.addHour((Date)startTime, (int)i);
            dtos.add(this.getHourlyHolidayRequest(personalId, requestDate, holidayType1, holidayType2, start));
        }
        return dtos;
    }

    protected HolidayRequestDtoInterface getHourlyHolidayRequest(String personalId, Date requestDate, int holidayType1, String holidayType2, Date startTime) {
        HolidayRequestDtoInterface dto = this.regist.getInitDto();
        dto.setPersonalId(personalId);
        dto.setRequestStartDate(requestDate);
        dto.setRequestEndDate(requestDate);
        dto.setHolidayType1(holidayType1);
        dto.setHolidayType2(holidayType2);
        dto.setHolidayRange(4);
        dto.setStartTime(startTime);
        dto.setEndTime(DateUtility.addHour((Date)startTime, (int)1));
        dto.setUseHour(1);
        return dto;
    }

    protected HolidayRequestDtoInterface getHolidayRequest(String personalId, Date requestStartDate, Date requestEndDate, int holidayType1, String holidayType2, int holidayRange) {
        HolidayRequestDtoInterface dto = this.regist.getInitDto();
        dto.setPersonalId(personalId);
        dto.setRequestStartDate(requestStartDate);
        dto.setRequestEndDate(requestEndDate);
        dto.setHolidayType1(holidayType1);
        dto.setHolidayType2(holidayType2);
        dto.setHolidayRange(holidayRange);
        dto.setStartTime(requestStartDate);
        dto.setEndTime(requestStartDate);
        dto.setUseHour(0);
        return dto;
    }

    protected HolidayRequestDtoInterface getPaidHolidayRequest(String personalId, Date requestDate, String holidayType2, int holidayRange) {
        return this.getHolidayRequest(personalId, requestDate, requestDate, 1, holidayType2, holidayRange);
    }

    protected void checkHours(int hours) {
        if (hours <= 0) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)TimeNamingUtility.hourlyHoliday((MospParams)this.mospParams));
        }
    }

    protected void setRecordIdAndWorkflow(List<HolidayRequestDtoInterface> dtos, long recordId) throws MospException {
        if ((double)recordId == 0.0) {
            return;
        }
        HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)MospUtility.getFirstValue(dtos);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return;
        }
        HolidayRequestDtoInterface registeredDto = this.refer.findForKey(recordId);
        if (MospUtility.isEmpty((Object[])new Object[]{registeredDto})) {
            return;
        }
        dto.setTmdHolidayRequestId(recordId);
        dto.setWorkflow(registeredDto.getWorkflow());
    }

    protected void setAcquisitionDateAndUseDays(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        if (TimeRequestUtility.isPaidHoliday((HolidayRequestDtoInterface)dto)) {
            this.setAcquisitionDateAndUseDaysForPaidHoliday(dto, row);
        }
        if (TimeRequestUtility.isStockHoliday((HolidayRequestDtoInterface)dto)) {
            this.setAcquisitionDateAndUseDaysForStockHoliday(dto, row);
        }
        if (TimeRequestUtility.isSpecialHoliday((HolidayRequestDtoInterface)dto) || TimeRequestUtility.isOtherHoliday((HolidayRequestDtoInterface)dto) || TimeRequestUtility.isAbsenece((HolidayRequestDtoInterface)dto)) {
            this.setAcquisitionDateAndUseDaysForHoliday(dto, row);
        }
    }

    protected void setAcquisitionDateAndUseDaysForPaidHoliday(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        String personalId = dto.getPersonalId();
        Date targetDate = dto.getRequestStartDate();
        dto.setUseDay((double)TimeUtility.getHolidayTimes((int)dto.getHolidayRange()));
        List remains = this.paidHolidayRemain.getPaidHolidayRemainsForRequest(personalId, targetDate);
        Date acquisitionDate = this.getAcquisitionDateForHolidayRequest(remains, dto).orElse(null);
        if (MospUtility.isEmpty((Object[])new Object[]{acquisitionDate})) {
            if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) {
                TimeMessageUtility.addErrorShortPaidHolidayRemainHours((MospParams)this.mospParams, (Integer)row);
                return;
            }
            TimeMessageUtility.addErrorShortPaidHolidayRemainDays((MospParams)this.mospParams, (Integer)row);
            return;
        }
        dto.setHolidayAcquisitionDate(acquisitionDate);
        this.checkPreviousPaidHolidayRemain(dto, remains, row);
    }

    protected void setAcquisitionDateAndUseDaysForStockHoliday(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        String personalId = dto.getPersonalId();
        Date targetDate = dto.getRequestStartDate();
        dto.setUseDay((double)TimeUtility.getHolidayTimes((int)dto.getHolidayRange()));
        List remains = this.paidHolidayRemain.getStockHolidayRemainsForRequest(personalId, targetDate);
        Date acquisitionDate = this.getAcquisitionDateForHolidayRequest(remains, dto).orElse(null);
        if (MospUtility.isEmpty((Object[])new Object[]{acquisitionDate})) {
            TimeMessageUtility.addErrorShortStockHolidayRemainDays((MospParams)this.mospParams, (Integer)row);
            return;
        }
        dto.setHolidayAcquisitionDate(acquisitionDate);
    }

    protected void checkPreviousPaidHolidayRemain(HolidayRequestDtoInterface dto, List<HolidayRemainDto> remains, Integer row) {
        if (!TimeRequestUtility.isHolidayRangeAll((HolidayRangeDtoInterface)dto)) {
            return;
        }
        Date acquisitionDate = dto.getHolidayAcquisitionDate();
        for (HolidayRemainDto remain : remains) {
            if (!remain.getAcquisitionDate().before(acquisitionDate) || !TimeUtility.isHolidayTimesHalf((double)remain.getRemainDays())) continue;
            TimeMessageUtility.addErrorPreviousPaidHolidayRemain((MospParams)this.mospParams, (Integer)row);
            return;
        }
    }

    protected Optional<Date> getAcquisitionDateForHolidayRequest(List<HolidayRemainDto> remains, HolidayRequestDtoInterface dto) throws MospException {
        Date acquisitionDate = null;
        if (!this.isHolidayRemain(TimeUtility.getTotalHolidayRemain(remains), dto)) {
            return Optional.ofNullable(acquisitionDate);
        }
        for (HolidayRemainDto remain : remains) {
            if (!this.isHolidayRemain(remain, dto)) continue;
            acquisitionDate = remain.getAcquisitionDate();
            break;
        }
        return Optional.ofNullable(acquisitionDate);
    }

    protected boolean isHolidayRemain(HolidayRemainDto remain, HolidayRequestDtoInterface dto) {
        double useDays = dto.getUseDay();
        int useHours = dto.getUseHour();
        if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) {
            return useHours <= remain.getRemainHours() || 1.0 <= remain.getRemainDays();
        }
        return useDays <= remain.getRemainDays();
    }

    protected void setAcquisitionDateAndUseDaysForHoliday(HolidayRequestDtoInterface dto, Integer row) throws MospException {
        int holidayType;
        String personalId = dto.getPersonalId();
        Date targetDate = dto.getRequestStartDate();
        Date requestEndDate = dto.getRequestEndDate();
        String holidayCode = dto.getHolidayType2();
        HolidayDtoInterface holidayDto = this.timeMaster.getHoliday(holidayCode, holidayType = dto.getHolidayType1(), targetDate);
        if (!PlatformUtility.isDtoActivate((PlatformDtoInterface)holidayDto)) {
            PfMessageUtility.addErrorNoItem((MospParams)this.mospParams, (String)TimeNamingUtility.holidayType((MospParams)this.mospParams), (Integer)row);
            return;
        }
        dto.setUseDay(this.getUseDaysForHoliday(dto));
        if (TimeRequestUtility.isAbsenece((HolidayRequestDtoInterface)dto)) {
            dto.setHolidayAcquisitionDate(dto.getRequestStartDate());
            return;
        }
        HolidayRemainDto remain = this.holidayInfo.getAppliableHoliday(personalId, targetDate, holidayCode, holidayType);
        if (MospUtility.isEmpty((Object[])new Object[]{remain})) {
            TimeMessageUtility.addErrorHolidayNotGranted((MospParams)this.mospParams, (String)holidayDto.getHolidayName(), (Integer)row);
            return;
        }
        if (!TimeUtility.isUnlimited((HolidayDtoInterface)holidayDto) && !this.isHolidayRemain(remain, dto)) {
            if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) {
                TimeMessageUtility.addErrorShortHolidayRemainHours((MospParams)this.mospParams, (String)holidayDto.getHolidayName(), (Integer)row);
                return;
            }
            TimeMessageUtility.addErrorShortHolidayRemainDays((MospParams)this.mospParams, (String)holidayDto.getHolidayName(), (Integer)row);
            return;
        }
        if (requestEndDate.after(remain.getHolidayLimitDate())) {
            TimeMessageUtility.addErrorHolidayExpiredLimit((MospParams)this.mospParams, (Integer)row);
            return;
        }
        if (TimeUtility.isForcedConsecutive((HolidayDtoInterface)holidayDto)) {
            dto.setUseDay(remain.getRemainDays());
        }
        dto.setHolidayAcquisitionDate(remain.getAcquisitionDate());
    }

    protected double getUseDaysForHoliday(HolidayRequestDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) {
            return 0.0;
        }
        if (TimeRequestUtility.isHolidayRangeHalf((HolidayRangeDtoInterface)dto)) {
            return TimeUtility.getHolidayTimes((int)dto.getHolidayRange());
        }
        List dates = this.getConsecutiveHolidayDates(personalId, dto.getRequestStartDate(), dto.getRequestEndDate());
        return MospUtility.getDouble((Object)dates.size());
    }

    protected void draft(HolidayRequestDtoInterface dto, String[] approverIds) throws MospException {
        this.regist.checkDraft(dto);
        WorkflowDtoInterface workflow = this.workflowRegist.getInitDto(dto.getWorkflow(), "3");
        this.workflowRegist.setDtoApproverIds(workflow, approverIds);
        String personalID = dto.getPersonalId();
        Date targetDate = dto.getRequestStartDate();
        workflow = this.workflowRegist.draft(workflow, personalID, targetDate, 1);
        if (MospUtility.isEmpty((Object[])new Object[]{workflow})) {
            return;
        }
        dto.setWorkflow(workflow.getWorkflow());
        String loginPersonalId = MospUtility.getLoginPersonalId((MospParams)this.mospParams);
        String workflowComment = PfMessageUtility.getDraftSucceed((MospParams)this.mospParams);
        this.workflowCommentRegist.addComment(workflow, loginPersonalId, workflowComment);
        this.regist.regist(dto);
    }

    protected void apply(HolidayRequestDtoInterface dto, String[] approverIds, Integer row) throws MospException {
        this.regist.checkAppli(dto, row);
        WorkflowDtoInterface workflow = this.workflowRegist.getInitDto(dto.getWorkflow(), "3");
        if (!MospUtility.isEmpty((String[])approverIds)) {
            this.workflowRegist.setDtoApproverIds(workflow, approverIds);
        }
        String personalID = dto.getPersonalId();
        Date targetDate = dto.getRequestStartDate();
        int workflowType = 1;
        workflow = this.workflowRegist.appli(workflow, personalID, targetDate, workflowType, "");
        if (MospUtility.isEmpty((Object[])new Object[]{workflow})) {
            return;
        }
        dto.setWorkflow(workflow.getWorkflow());
        this.regist.regist(dto, row);
        this.regist.deleteAttendance(dto);
        this.regist.draftAttendance(dto);
        this.attendanceTransactionRegist.regist(dto);
    }

    protected void applyForBatchUpdate(HolidayRequestDtoInterface dto) throws MospException {
        this.apply(dto, new String[]{""}, null);
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
        this.regist.setTimeMaster(timeMaster);
        this.scheduleUtil.setTimeMaster(timeMaster);
        this.paidHolidayRemain.setTimeMaster(timeMaster);
        this.holidayInfo.setTimeMaster(timeMaster);
        this.attendanceTransactionRegist.setTimeMaster(timeMaster);
    }
}

