/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.utils.TimeNamingUtility;

public class HolidayReferenceBean
extends PlatformBean
implements HolidayReferenceBeanInterface {
    protected HolidayDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (HolidayDaoInterface)this.createDaoInstance(HolidayDaoInterface.class);
    }

    public HolidayDtoInterface getHolidayInfo(String holidayCode, Date targetDate, int holidayType) throws MospException {
        return this.dao.findForInfo(holidayCode, targetDate, holidayType);
    }

    public List<HolidayDtoInterface> getHolidayHistory(String holidayCode, int holidayType) throws MospException {
        return this.dao.findForHistory(holidayCode, holidayType);
    }

    public List<HolidayDtoInterface> getHolidayList(Date targetDate, int holidayType) throws MospException {
        return this.dao.findForActivateDate(targetDate, holidayType);
    }

    public String[][] getSelectArray(Date targetDate, int holidayType, boolean needBlank) throws MospException {
        return this.getSelectArray(targetDate, holidayType, true, needBlank);
    }

    public String[][] getSelectArray(Date targetDate, int holidayType, boolean isAbbr, boolean needBlank) throws MospException {
        List list = this.dao.findForActivateDate(targetDate, holidayType);
        if (list.isEmpty()) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (HolidayDtoInterface dto : list) {
            array[idx][0] = dto.getHolidayCode();
            array[idx][1] = isAbbr ? dto.getHolidayAbbr() : dto.getHolidayName();
            ++idx;
        }
        return array;
    }

    public String[][] getExportArray(Date targetDate) throws MospException {
        List specialList = this.dao.findForExport(targetDate, 2);
        List otherList = this.dao.findForExport(targetDate, 3);
        List absenceList = this.dao.findForExport(targetDate, 4);
        ArrayList holidayList = new ArrayList(specialList);
        holidayList.addAll(otherList);
        holidayList.addAll(absenceList);
        if (MospUtility.isEmpty(holidayList)) {
            return this.prepareSelectArray(0, false);
        }
        String comma = ",";
        String allHoliday = TimeNamingUtility.holidayRangeAllWithParentheses((MospParams)this.mospParams);
        String halfHoliday = TimeNamingUtility.holidayHalfWithParentheses((MospParams)this.mospParams);
        String hourHoliday = TimeNamingUtility.hourlyHolidayAbbrWithParentheses((MospParams)this.mospParams);
        String amHoliday = TimeNamingUtility.anteMeridiemWithParentheses((MospParams)this.mospParams);
        String pmHoliday = TimeNamingUtility.postMeridiemWithParentheses((MospParams)this.mospParams);
        ArrayList<String[]> arrays = new ArrayList<String[]>();
        for (HolidayDtoInterface dto : holidayList) {
            String[] arrayAll = new String[2];
            String[] arrayHalf = new String[2];
            String[] arrayHour = new String[2];
            String[] arrayAm = new String[2];
            String[] arrayPm = new String[2];
            StringBuffer sb = new StringBuffer();
            sb.append(dto.getHolidayType());
            sb.append(comma);
            sb.append(dto.getHolidayCode());
            sb.append(comma);
            arrayAll[0] = sb.toString() + "all";
            arrayAll[1] = dto.getHolidayAbbr() + allHoliday;
            arrayHalf[0] = sb.toString() + "half";
            arrayHalf[1] = dto.getHolidayAbbr() + halfHoliday;
            arrayHour[0] = sb.toString() + "hour";
            arrayHour[1] = dto.getHolidayAbbr() + hourHoliday;
            arrayAm[0] = sb.toString() + "am";
            arrayAm[1] = dto.getHolidayAbbr() + amHoliday;
            arrayPm[0] = sb.toString() + "pm";
            arrayPm[1] = dto.getHolidayAbbr() + pmHoliday;
            arrays.add(arrayAll);
            arrays.add(arrayHalf);
            arrays.add(arrayHour);
            arrays.add(arrayAm);
            arrays.add(arrayPm);
        }
        this.doStoredLogic(new Object[]{"Add_HolidayReferenceBean_getExportArray", arrays});
        return MospUtility.toArrayArray(arrays);
    }

    public HolidayDtoInterface findForKey(String holidayCode, Date activateDate, int holidayType) throws MospException {
        return this.dao.findForKey(holidayCode, activateDate, holidayType);
    }

    public String getHolidayAbbr(String holidayCode, Date targetDate, int holidayType) throws MospException {
        HolidayDtoInterface dto = this.dao.findForInfo(holidayCode, targetDate, holidayType);
        if (dto == null) {
            return holidayCode;
        }
        return dto.getHolidayAbbr();
    }

    public String getHolidayType1NameForHolidayRequest(int type1, String type2) {
        if (type1 == 1) {
            if (Integer.toString(1).equals(type2)) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Salaried"));
                sb.append(this.mospParams.getName("Holiday"));
                return sb.toString();
            }
            if (Integer.toString(2).equals(type2)) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Stock"));
                sb.append(this.mospParams.getName("Holiday"));
                return sb.toString();
            }
        } else {
            if (type1 == 2) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Specially"));
                return sb.toString();
            }
            if (type1 == 3) {
                return this.mospParams.getName("Others");
            }
            if (type1 == 4) {
                return this.mospParams.getName("Absence");
            }
        }
        return "";
    }

    public boolean isTimelyHoliday(Date activateDate) throws MospException {
        Set set = this.dao.findForActivateDate(activateDate);
        for (HolidayDtoInterface dto : set) {
            if (dto.getTimelyHolidayFlag() != 0) continue;
            return true;
        }
        return false;
    }
}

