/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayManagementSearchBeanInterface;
import jp.mosp.time.dto.settings.HolidayManagementListDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayManagementListDto;
import jp.mosp.time.dto.settings.impl.HolidayRemainDto;

public class HolidayManagementSearchBean
extends PlatformBean
implements HolidayManagementSearchBeanInterface {
    protected HumanSearchBeanInterface humanSearch;
    protected HolidayInfoReferenceBeanInterface refer;
    private Date activateDate;
    private String employeeCode;
    private String employeeName;
    private String workPlaceCode;
    private String employmentCode;
    private String sectionCode;
    private String positionCode;

    public void initBean() throws MospException {
        this.humanSearch = (HumanSearchBeanInterface)this.createBeanInstance(HumanSearchBeanInterface.class);
        this.refer = (HolidayInfoReferenceBeanInterface)this.createBeanInstance(HolidayInfoReferenceBeanInterface.class);
    }

    public List<HolidayManagementListDtoInterface> getSearchList(int holidayType) throws MospException {
        ArrayList<HolidayManagementListDtoInterface> list = new ArrayList<HolidayManagementListDtoInterface>();
        this.humanSearch.setTargetDate(this.activateDate);
        this.humanSearch.setEmployeeCode(this.employeeCode);
        this.humanSearch.setEmployeeCodeType("forward");
        this.humanSearch.setEmployeeName(this.employeeName);
        this.humanSearch.setWorkPlaceCode(this.workPlaceCode);
        this.humanSearch.setEmploymentContractCode(this.employmentCode);
        this.humanSearch.setPositionCode(this.positionCode);
        this.humanSearch.setSectionCode(this.sectionCode);
        this.humanSearch.setStateType("presence");
        for (HumanDtoInterface humanDto : this.humanSearch.search()) {
            list.addAll(this.makeDtos(humanDto, this.activateDate, holidayType));
        }
        return list;
    }

    protected List<HolidayManagementListDtoInterface> makeDtos(HumanDtoInterface humanDto, Date targetDate, int holidayType) throws MospException {
        ArrayList<HolidayManagementListDtoInterface> list = new ArrayList<HolidayManagementListDtoInterface>();
        String personalId = humanDto.getPersonalId();
        Set holidayRemains = this.refer.getHolidayRemains(personalId, targetDate, holidayType);
        for (HolidayRemainDto remain : holidayRemains) {
            HolidayManagementListDto dto = new HolidayManagementListDto();
            dto.setEmployeeCode(humanDto.getEmployeeCode());
            dto.setActivateDate(remain.getAcquisitionDate());
            dto.setLastName(humanDto.getLastName());
            dto.setFirstName(humanDto.getFirstName());
            dto.setSectionCode(humanDto.getSectionCode());
            dto.setHolidayCode(remain.getHolidayCode());
            dto.setHolidayRemainder(remain.getRemainDays());
            dto.setHolidayRemaindHours(remain.getRemainHours());
            dto.setHolidayRemaindMinutes(remain.getRemainMinutes());
            dto.setHolidayLimit(remain.getHolidayLimitDate());
            list.add((HolidayManagementListDtoInterface)dto);
        }
        return list;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = this.getDateClone(activateDate);
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setEmploymentCode(String employmentCode) {
        this.employmentCode = employmentCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }
}

