/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.HolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.MinutesOffBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dao.settings.HolidayDataDaoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayRemainDto;
import jp.mosp.time.utils.TimeUtility;

public class HolidayInfoReferenceBean
extends PlatformBean
implements HolidayInfoReferenceBeanInterface {
    protected HolidayDataDaoInterface dao;
    protected HolidayDataReferenceBeanInterface refer;
    protected HolidayRequestReferenceBeanInterface holidayRequest;
    protected PlatformMasterBeanInterface master;
    protected TimeMasterBeanInterface timeMaster;
    protected List<MinutesOffBeanInterface> minutesBeans;

    public void initBean() throws MospException {
        this.dao = (HolidayDataDaoInterface)this.createDaoInstance(HolidayDataDaoInterface.class);
        this.refer = (HolidayDataReferenceBeanInterface)this.createBeanInstance(HolidayDataReferenceBeanInterface.class);
        this.holidayRequest = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
        this.master = (PlatformMasterBeanInterface)this.createBeanInstance(PlatformMasterBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.timeMaster.setPlatformMaster(this.master);
    }

    public Set<HolidayRemainDto> getRemainHolidays(String personalId, Date targetDate, int holidayType) throws MospException {
        Set dtos = this.getHolidayRemains(personalId, targetDate, holidayType);
        return TimeUtility.getRemainHolidays((Set)dtos, (boolean)false);
    }

    public Set<HolidayRemainDto> getRemainHolidays(String personalId, Date targetDate) throws MospException {
        LinkedHashSet<HolidayRemainDto> remains = new LinkedHashSet<HolidayRemainDto>();
        remains.addAll(this.getRemainHolidays(personalId, targetDate, 2));
        remains.addAll(this.getRemainHolidays(personalId, targetDate, 3));
        return remains;
    }

    public String[][] getRemainArray(String personalId, Date targetDate, int holidayType) throws MospException {
        Set remains = this.getRemainHolidays(personalId, targetDate, holidayType);
        return this.getRemainArray(remains, true, false);
    }

    public String[][] getRemainArray(Set<HolidayRemainDto> remains, boolean isAbbr, boolean needBlank) {
        if (MospUtility.isEmpty(remains)) {
            return this.getNoObjectDataPulldown();
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (needBlank) {
            map.put("", "");
        }
        for (HolidayRemainDto dto : remains) {
            map.put(dto.getHolidayCode(), isAbbr ? dto.getHolidayAbbr() : dto.getHolidayName());
        }
        return MospUtility.toArray(map);
    }

    public HolidayRemainDto getAppliableHoliday(String personalId, Date targetDate, String holidayCode, int holidayType) throws MospException {
        List dtos = this.getHolidays(personalId, targetDate, holidayCode, holidayType);
        Set remains = this.getHolidayRemains(personalId, targetDate, (Collection)dtos);
        for (HolidayRemainDto remain : remains) {
            if (!(remain.getRemainDays() > 0.0)) continue;
            return remain;
        }
        for (HolidayRemainDto remain : remains) {
            if (remain.getRemainHours() <= 0) continue;
            return remain;
        }
        for (HolidayRemainDto remain : remains) {
            if (remain.getRemainMinutes() <= 0) continue;
            return remain;
        }
        return (HolidayRemainDto)MospUtility.getLastValue((Collection)remains);
    }

    public Set<HolidayRemainDto> getHolidayRemains(String personalId, Date targetDate, int holidayType) throws MospException {
        List dtos = this.refer.getActiveList(personalId, targetDate, holidayType);
        return this.getHolidayRemains(personalId, targetDate, (Collection)dtos);
    }

    public Set<HolidayRemainDto> getHolidayRemains(String personalId, Date targetDate, Collection<HolidayDataDtoInterface> dtos) throws MospException {
        HumanDtoInterface humanDto = this.master.getHuman(personalId, targetDate);
        LinkedHashSet<HolidayRemainDto> remains = new LinkedHashSet<HolidayRemainDto>();
        int hoursPerDay = this.timeMaster.getPaidHolidayHoursPerDay(humanDto, targetDate);
        int minutesPerDay = this.getMinutesPerDay(humanDto, targetDate);
        for (HolidayDataDtoInterface dto : dtos) {
            HolidayDtoInterface holiday = this.timeMaster.getHoliday(dto.getHolidayCode(), dto.getHolidayType(), targetDate);
            if (!PlatformUtility.isDtoActivate((PlatformDtoInterface)holiday)) continue;
            remains.add(this.getHolidayRemain(dto, holiday, hoursPerDay, minutesPerDay));
        }
        return remains;
    }

    public boolean hasPersonalApplication(String personalId, Date startDate, Date endDate, int holidayType) throws MospException {
        List list = this.dao.findPersonTerm(personalId, startDate, endDate, holidayType);
        return !list.isEmpty();
    }

    protected HolidayRemainDto getHolidayRemain(HolidayDataDtoInterface dto, HolidayDtoInterface holiday, int hoursPerDay, int minutesPerDay) throws MospException {
        if (TimeUtility.isUnlimited((HolidayDataDtoInterface)dto)) {
            return TimeUtility.getHolidayRemains((HolidayDataDtoInterface)dto, (HolidayDtoInterface)holiday, (double)0.0, (int)0, (int)0, (int)hoursPerDay, (int)minutesPerDay);
        }
        String personalId = dto.getPersonalId();
        Date acquisitionDate = dto.getActivateDate();
        Date limitDate = dto.getHolidayLimitDate();
        int holidayType = dto.getHolidayType();
        String holidayCode = dto.getHolidayCode();
        Map map = this.holidayRequest.getRequestDayHour(personalId, acquisitionDate, holidayType, holidayCode, acquisitionDate, limitDate);
        double days = (Double)map.get("requestDay");
        int hours = MospUtility.getInt(map.get("requestHour"));
        int minutes = this.getUseMinutes(dto);
        return TimeUtility.getHolidayRemains((HolidayDataDtoInterface)dto, (HolidayDtoInterface)holiday, (double)days, (int)hours, (int)minutes, (int)hoursPerDay, (int)minutesPerDay);
    }

    public int getUseMinutes(HolidayDataDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        int holidayType = dto.getHolidayType();
        String holidayCode = dto.getHolidayCode();
        Date acquisitionDate = dto.getActivateDate();
        int useMinutes = 0;
        for (MinutesOffBeanInterface bean : this.getMinutesBeans()) {
            useMinutes += bean.getUseMinutes(personalId, holidayType, holidayCode, acquisitionDate);
        }
        return useMinutes;
    }

    public int getMinutesPerDay(String personalId, Date targetDate) throws MospException {
        return this.getMinutesPerDay(this.master.getHuman(personalId, targetDate), targetDate);
    }

    protected int getMinutesPerDay(HumanDtoInterface humanDto, Date targetDate) throws MospException {
        int minutesPerDay = 0;
        for (MinutesOffBeanInterface bean : this.getMinutesBeans()) {
            int value = bean.getMinutesPerDay(humanDto.getPersonalId(), targetDate);
            if (value == 0) continue;
            minutesPerDay = value;
        }
        return minutesPerDay;
    }

    protected List<MinutesOffBeanInterface> getMinutesBeans() throws MospException {
        if (!MospUtility.isEmpty((Collection)this.minutesBeans)) {
            return this.minutesBeans;
        }
        this.minutesBeans = new ArrayList();
        for (String[] addon : MospUtility.getCodeArray((MospParams)this.mospParams, (String)"MinutesOffBeans", (boolean)false)) {
            MinutesOffBeanInterface bean = (MinutesOffBeanInterface)this.createBean(addon[0]);
            bean.setMaster(this.master);
            bean.setTimeMaster(this.timeMaster);
            this.minutesBeans.add(bean);
        }
        return this.minutesBeans;
    }

    public List<HolidayDataDtoInterface> getHolidays(String personalId, Date targetDate, String holidayCode, int holidayType) throws MospException {
        return this.dao.findForEarliestList(personalId, targetDate, holidayCode, holidayType);
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
    }
}

