/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.impl.TimeBaseExportBean;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class HolidayExportBean
extends TimeBaseExportBean {
    protected SubHolidayRequestDaoInterface subHolidayRequestDao;
    protected WorkOnHolidayRequestDaoInterface workOnHolidayRequestDao;
    protected SubstituteDaoInterface substituteDao;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected HolidayRequestReferenceBeanInterface holidayRequestRefer;

    public void initBean() throws MospException {
        super.initBean();
        this.subHolidayRequestDao = (SubHolidayRequestDaoInterface)this.createDaoInstance(SubHolidayRequestDaoInterface.class);
        this.workOnHolidayRequestDao = (WorkOnHolidayRequestDaoInterface)this.createDaoInstance(WorkOnHolidayRequestDaoInterface.class);
        this.substituteDao = (SubstituteDaoInterface)this.createDaoInstance(SubstituteDaoInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.holidayRequestRefer = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.scheduleUtil.setTimeMaster(this.timeMaster);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date firstDate, Date lastDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, boolean needLowerSection, String positionCode) throws MospException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        List humanList = this.getHumanList(firstDate, lastDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, needLowerSection, positionCode);
        this.addHumanData(list, fieldList, humanList, lastDate);
        this.addPaidHolidayData(list, fieldList, humanList, firstDate, lastDate);
        this.addStockHolidayData(list, fieldList, humanList, firstDate, lastDate);
        this.addSubHolidayData(list, fieldList, humanList, firstDate, lastDate);
        this.addSubstituteHolidayData(list, fieldList, humanList, firstDate, lastDate);
        this.addHolidayData(list, fieldList, humanList, firstDate, lastDate);
        this.doStoredLogic(new Object[]{"Add_HolidayExportBean_getCsvDataList", humanList, list, fieldList, firstDate, lastDate});
        return list;
    }

    protected String[] getHeader(ExportDtoInterface exportDto, List<String> fieldList, Date targetDate) throws MospException {
        String[] header = new String[fieldList.size()];
        Set holidays = this.timeMaster.getHolidaySet(targetDate);
        int i = 0;
        for (String field : fieldList) {
            header[i++] = this.getFieldTitle(field, holidays);
        }
        this.doStoredLogic(new Object[]{"Add_HolidayExportBean_addHeader", header, fieldList});
        return header;
    }

    protected void addPaidHolidayData(List<String[]> csvDataList, List<String> fieldList, List<HumanDtoInterface> humanList, Date firstDate, Date lastDate) throws MospException {
        if (!PlatformUtility.isTheFieldExit(fieldList, (String[])new String[]{"paid_holiday_all", "paid_holiday_half", "paid_holiday_am", "paid_holiday_pm", "paid_holiday_time"})) {
            return;
        }
        int i = 0;
        for (HumanDtoInterface human : humanList) {
            int paidHolidayAll = 0;
            int paidHolidayHalf = 0;
            int paidHolidayTime = 0;
            int paidHolidayAm = 0;
            int paidHolidayPm = 0;
            List list = this.holidayRequestRefer.getCompletedRequests(human.getPersonalId(), firstDate, lastDate, 1, "1");
            for (HolidayRequestDtoInterface dto : list) {
                if (TimeRequestUtility.isHolidayRangeAll((HolidayRangeDtoInterface)dto)) {
                    ++paidHolidayAll;
                }
                if (TimeRequestUtility.isHolidayRangeAm((HolidayRangeDtoInterface)dto)) {
                    ++paidHolidayHalf;
                    ++paidHolidayAm;
                }
                if (TimeRequestUtility.isHolidayRangePm((HolidayRangeDtoInterface)dto)) {
                    ++paidHolidayHalf;
                    ++paidHolidayPm;
                }
                if (!TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) continue;
                ++paidHolidayTime;
            }
            String[] csvData = csvDataList.get(i++);
            this.setCsvValue(csvData, fieldList, "paid_holiday_all", (Object)paidHolidayAll);
            this.setCsvValue(csvData, fieldList, "paid_holiday_half", (Object)paidHolidayHalf);
            this.setCsvValue(csvData, fieldList, "paid_holiday_am", (Object)paidHolidayAm);
            this.setCsvValue(csvData, fieldList, "paid_holiday_pm", (Object)paidHolidayPm);
            this.setCsvValue(csvData, fieldList, "paid_holiday_time", (Object)paidHolidayTime);
        }
    }

    protected void addStockHolidayData(List<String[]> csvDataList, List<String> fieldList, List<HumanDtoInterface> humanList, Date firstDate, Date lastDate) throws MospException {
        if (!PlatformUtility.isTheFieldExit(fieldList, (String[])new String[]{"stock_holiday_all", "stock_holiday_am", "stock_holiday_pm", "stock_holiday_half"})) {
            return;
        }
        int i = 0;
        for (HumanDtoInterface human : humanList) {
            int stockHolidayAll = 0;
            int stockHolidayHalf = 0;
            int stockHolidayAm = 0;
            int stockHolidayPm = 0;
            List list = this.holidayRequestRefer.getCompletedRequests(human.getPersonalId(), firstDate, lastDate, 1, "2");
            for (HolidayRequestDtoInterface dto : list) {
                if (TimeRequestUtility.isHolidayRangeAll((HolidayRangeDtoInterface)dto)) {
                    ++stockHolidayAll;
                }
                if (TimeRequestUtility.isHolidayRangeAm((HolidayRangeDtoInterface)dto)) {
                    ++stockHolidayHalf;
                    ++stockHolidayAm;
                }
                if (!TimeRequestUtility.isHolidayRangePm((HolidayRangeDtoInterface)dto)) continue;
                ++stockHolidayHalf;
                ++stockHolidayPm;
            }
            String[] csvData = csvDataList.get(i++);
            this.setCsvValue(csvData, fieldList, "stock_holiday_all", (Object)stockHolidayAll);
            this.setCsvValue(csvData, fieldList, "stock_holiday_half", (Object)stockHolidayHalf);
            this.setCsvValue(csvData, fieldList, "stock_holiday_am", (Object)stockHolidayAm);
            this.setCsvValue(csvData, fieldList, "stock_holiday_pm", (Object)stockHolidayPm);
        }
    }

    protected void addSubHolidayData(List<String[]> csvDataList, List<String> fieldList, List<HumanDtoInterface> humanList, Date firstDate, Date lastDate) throws MospException {
        if (!PlatformUtility.isTheFieldExit(fieldList, (String[])new String[]{"sub_holiday_all", "sub_holiday_am", "sub_holiday_pm", "sub_holiday_half"})) {
            return;
        }
        int i = 0;
        for (HumanDtoInterface human : humanList) {
            int subHolidayAll = 0;
            int subHolidayHalf = 0;
            int subHolidayAm = 0;
            int subHolidayPm = 0;
            List list = this.subHolidayRequestDao.findForTerm(human.getPersonalId(), firstDate, lastDate);
            for (SubHolidayRequestDtoInterface dto : list) {
                if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) continue;
                if (TimeRequestUtility.isHolidayRangeAll((HolidayRangeDtoInterface)dto)) {
                    ++subHolidayAll;
                }
                if (TimeRequestUtility.isHolidayRangeAm((HolidayRangeDtoInterface)dto)) {
                    ++subHolidayHalf;
                    ++subHolidayAm;
                }
                if (!TimeRequestUtility.isHolidayRangePm((HolidayRangeDtoInterface)dto)) continue;
                ++subHolidayHalf;
                ++subHolidayPm;
            }
            String[] csvData = csvDataList.get(i++);
            this.setCsvValue(csvData, fieldList, "sub_holiday_all", (Object)subHolidayAll);
            this.setCsvValue(csvData, fieldList, "sub_holiday_half", (Object)subHolidayHalf);
            this.setCsvValue(csvData, fieldList, "sub_holiday_am", (Object)subHolidayAm);
            this.setCsvValue(csvData, fieldList, "sub_holiday_pm", (Object)subHolidayPm);
        }
    }

    protected void addSubstituteHolidayData(List<String[]> csvDataList, List<String> fieldList, List<HumanDtoInterface> humanList, Date firstDate, Date lastDate) throws MospException {
        if (!PlatformUtility.isTheFieldExit(fieldList, (String[])new String[]{"substitute_holiday_all"})) {
            return;
        }
        int i = 0;
        for (HumanDtoInterface human : humanList) {
            int substituteAll = 0;
            List list = this.substituteDao.findForTerm(human.getPersonalId(), firstDate, lastDate);
            for (SubstituteDtoInterface dto : list) {
                if (!this.workflowIntegrate.isCompleted(dto.getWorkflow())) continue;
                WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.workOnHolidayRequestDao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getSubstituteDate());
                if (workOnHolidayRequestDto == null) {
                    ++substituteAll;
                    continue;
                }
                if (this.workflowIntegrate.isCompleted(workOnHolidayRequestDto.getWorkflow())) continue;
                ++substituteAll;
            }
            String[] csvData = csvDataList.get(i++);
            this.setCsvValue(csvData, fieldList, "substitute_holiday_all", (Object)substituteAll);
        }
    }

    protected void addHolidayData(List<String[]> csvDataList, List<String> fieldList, List<HumanDtoInterface> humanList, Date firstDate, Date lastDate) throws MospException {
        Map holidayIndexes = this.getHolidayIndexes(fieldList);
        if (MospUtility.isEmpty((Map)holidayIndexes)) {
            return;
        }
        for (int i = 0; i < humanList.size(); ++i) {
            HumanDtoInterface human = humanList.get(i);
            for (Map.Entry entry : holidayIndexes.entrySet()) {
                int count = this.getHolidayCount((String)entry.getKey(), human, firstDate, lastDate);
                String[] csvData = csvDataList.get(i);
                csvData[((Integer)entry.getValue()).intValue()] = MospUtility.getString((Object)count);
            }
        }
    }

    protected int getHolidayCount(String fieldName, HumanDtoInterface human, Date firstDate, Date lastDate) throws MospException {
        int count = 0;
        String[] array = MospUtility.split((String)fieldName, (String)",");
        int holidayType = MospUtility.getInt((Object)array[0]);
        String holidayCode = array[1];
        String range = array[2];
        List list = this.holidayRequestRefer.getCompletedRequests(human.getPersonalId(), firstDate, lastDate, holidayType, holidayCode);
        for (HolidayRequestDtoInterface dto : list) {
            if (MospUtility.isEqual((Object)range, (Object)"all") && TimeRequestUtility.isHolidayRangeAll((HolidayRangeDtoInterface)dto)) {
                Date targetDate = dto.getRequestStartDate();
                if (dto.getRequestStartDate().before(firstDate)) {
                    targetDate = firstDate;
                }
                Date targetEndDate = dto.getRequestEndDate();
                if (dto.getRequestEndDate().after(lastDate)) {
                    targetEndDate = lastDate;
                }
                while (!targetDate.after(targetEndDate)) {
                    if (this.canHolidayRequest(dto.getPersonalId(), targetDate)) {
                        ++count;
                    }
                    targetDate = this.addDay(targetDate, 1);
                }
            }
            if (MospUtility.isEqual((Object)range, (Object)"half") && TimeRequestUtility.isHolidayRangeHalf((HolidayRangeDtoInterface)dto)) {
                ++count;
            }
            if (MospUtility.isEqual((Object)range, (Object)"am") && TimeRequestUtility.isHolidayRangeAm((HolidayRangeDtoInterface)dto)) {
                ++count;
            }
            if (MospUtility.isEqual((Object)range, (Object)"pm") && TimeRequestUtility.isHolidayRangePm((HolidayRangeDtoInterface)dto)) {
                ++count;
            }
            if (!MospUtility.isEqual((Object)range, (Object)"hour") || !TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) continue;
            ++count;
        }
        return count;
    }

    protected Map<String, Integer> getHolidayIndexes(List<String> fieldList) {
        HashMap<String, Integer> holidayIndexes = new HashMap<String, Integer>();
        String separotor = ",";
        String special = 2 + separotor;
        String other = 3 + separotor;
        String absence = 4 + separotor;
        for (int fieldIndex = 0; fieldIndex < fieldList.size(); ++fieldIndex) {
            String fieldName = fieldList.get(fieldIndex);
            if (!fieldName.startsWith(special) && !fieldName.startsWith(other) && !fieldName.startsWith(absence)) continue;
            holidayIndexes.put(fieldName, fieldIndex);
        }
        return holidayIndexes;
    }

    protected String getFieldTitle(String fieldName, Set<HolidayDtoInterface> holidays) {
        String title = this.getCodeName(fieldName, "export_holiday_request_data");
        if (!MospUtility.isEqual((Object)fieldName, (Object)title)) {
            return title;
        }
        String[] array = MospUtility.split((String)fieldName, (String)",");
        int holidayType = MospUtility.getInt((Object)array[0]);
        String holidayCode = array[1];
        String range = array[2];
        HolidayDtoInterface holidayDto = TimeUtility.getHolidayDto(holidays, (String)holidayCode, (int)holidayType);
        if (MospUtility.isEmpty((Object[])new Object[]{holidayDto})) {
            return NameUtility.cornerParentheses((MospParams)this.mospParams, (String)holidayCode);
        }
        StringBuilder sb = new StringBuilder(holidayDto.getHolidayName());
        String rangeTitle = "";
        if (MospUtility.isEqual((Object)range, (Object)"all")) {
            rangeTitle = TimeNamingUtility.holidayRangeAll((MospParams)this.mospParams);
        }
        if (MospUtility.isEqual((Object)range, (Object)"half")) {
            rangeTitle = TimeNamingUtility.holidayHalf((MospParams)this.mospParams);
        }
        if (MospUtility.isEqual((Object)range, (Object)"am")) {
            rangeTitle = TimeNamingUtility.anteMeridiem((MospParams)this.mospParams);
        }
        if (MospUtility.isEqual((Object)range, (Object)"pm")) {
            rangeTitle = TimeNamingUtility.postMeridiem((MospParams)this.mospParams);
        }
        if (MospUtility.isEqual((Object)range, (Object)"hour")) {
            rangeTitle = TimeNamingUtility.holidayRangeHourAbbr((MospParams)this.mospParams);
        }
        if (!MospUtility.isEmpty((String[])new String[]{rangeTitle})) {
            sb.append(PfNameUtility.parentheses((MospParams)this.mospParams, (String)rangeTitle));
        }
        sb.append(NameUtility.cornerParentheses((MospParams)this.mospParams, (String)holidayCode));
        return sb.toString();
    }

    protected boolean canHolidayRequest(String personalId, Date targetDate) throws MospException {
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate, true);
        return !TimeRequestUtility.isNotHolidayForConsecutiveHolidays((String)workTypeCode);
    }
}

