/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.system.EmploymentContractReferenceBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.system.WorkPlaceReferenceBeanInterface;
import jp.mosp.platform.dao.file.ExportDaoInterface;
import jp.mosp.platform.dao.file.ExportFieldDaoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.file.ExportFieldDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.TransStringUtility;
import jp.mosp.time.bean.CalendarWorkingDaysBeanInterface;
import jp.mosp.time.bean.ExportTableReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayRemainBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TimeRecordReferenceBeanInterface;
import jp.mosp.time.dao.settings.ExportDataDaoInterface;
import jp.mosp.time.dto.settings.TimeRecordDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class ExportTableReferenceBean
extends PlatformBean
implements ExportTableReferenceBeanInterface {
    protected String exportCode;
    protected int startYear;
    protected int startMonth;
    protected int endYear;
    protected int endMonth;
    protected String cutoffCode;
    protected String workPlaceCode;
    protected String employmentCode;
    protected String sectionCode;
    protected String positionCode;
    protected int ckbNeedLowerSection;
    protected ExportDaoInterface exportDao;
    protected ExportFieldDaoInterface exportFieldDao;
    protected ExportDataDaoInterface exportDataDao;
    protected TimeRecordReferenceBeanInterface timeRecord;
    protected WorkPlaceReferenceBeanInterface workPlace;
    protected EmploymentContractReferenceBeanInterface employmentContract;
    protected SectionReferenceBeanInterface section;
    protected PositionReferenceBeanInterface position;
    protected RetirementReferenceBeanInterface retirementReference;
    protected PaidHolidayRemainBeanInterface paidHolidayRemain;
    protected PlatformMasterBeanInterface platformMaster;
    protected TimeMasterBeanInterface timeMaster;
    protected CalendarWorkingDaysBeanInterface calendarWorkingDays;
    protected static final int addPrevious = -1;

    public void initBean() throws MospException {
        this.exportDao = (ExportDaoInterface)this.createDaoInstance(ExportDaoInterface.class);
        this.exportFieldDao = (ExportFieldDaoInterface)this.createDaoInstance(ExportFieldDaoInterface.class);
        this.exportDataDao = (ExportDataDaoInterface)this.createDaoInstance(ExportDataDaoInterface.class);
        this.timeRecord = (TimeRecordReferenceBeanInterface)this.createBeanInstance(TimeRecordReferenceBeanInterface.class);
        this.workPlace = (WorkPlaceReferenceBeanInterface)this.createBeanInstance(WorkPlaceReferenceBeanInterface.class);
        this.employmentContract = (EmploymentContractReferenceBeanInterface)this.createBeanInstance(EmploymentContractReferenceBeanInterface.class);
        this.section = (SectionReferenceBeanInterface)this.createBeanInstance(SectionReferenceBeanInterface.class);
        this.position = (PositionReferenceBeanInterface)this.createBeanInstance(PositionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBeanInstance(RetirementReferenceBeanInterface.class);
        this.paidHolidayRemain = (PaidHolidayRemainBeanInterface)this.createBeanInstance(PaidHolidayRemainBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBeanInstance(PlatformMasterBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.calendarWorkingDays = (CalendarWorkingDaysBeanInterface)this.createBeanInstance(CalendarWorkingDaysBeanInterface.class);
        this.timeMaster.setPlatformMaster(this.platformMaster);
        this.calendarWorkingDays.setPlatformMaster(this.platformMaster);
        this.paidHolidayRemain.setTimeMaster(this.timeMaster);
        this.calendarWorkingDays.setTimeMaster(this.timeMaster);
    }

    public List<String[]> export() throws MospException {
        ExportDtoInterface exportDto = this.exportDao.findForKey(this.exportCode);
        if (exportDto == null) {
            return null;
        }
        List exportFieldDtoList = this.exportFieldDao.findForList(this.exportCode);
        if (exportFieldDtoList.isEmpty()) {
            return null;
        }
        int format = this.getExportTimeFormat();
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (exportDto.getHeader() == 1) {
            ArrayList<String> headerList = new ArrayList<String>();
            for (ExportFieldDtoInterface exportFieldDto : exportFieldDtoList) {
                headerList.add(this.mospParams.getProperties().getCodeItemName(exportDto.getExportTable(), exportFieldDto.getFieldName()));
            }
            list.add(headerList.toArray(new String[0]));
        }
        CutoffEntityInterface cutoffStart = this.timeMaster.getCutoff(this.cutoffCode, this.startYear, this.startMonth);
        CutoffEntityInterface cutoffEnd = this.timeMaster.getCutoff(this.cutoffCode, this.endYear, this.endMonth);
        java.util.Date startDate = cutoffStart.getCutoffFirstDate(this.startYear, this.startMonth, this.mospParams);
        java.util.Date endDate = cutoffEnd.getCutoffLastDate(this.endYear, this.endMonth, this.mospParams);
        java.util.Date firstTargetDate = MonthUtility.getYearMonthTargetDate((int)this.startYear, (int)this.startMonth, (MospParams)this.mospParams);
        ResultSet rs = null;
        boolean isAttendance = "export_tmd_attendance".equals(exportDto.getExportTable());
        boolean isTotalTime = "export_tmd_total_time".equals(exportDto.getExportTable());
        boolean isPaidHoliday = "export_tmd_paid_holiday".equals(exportDto.getExportTable());
        boolean isStockHoliday = "export_tmd_stock_holiday".equals(exportDto.getExportTable());
        boolean isHolidayData = "export_tmd_holiday".equals(exportDto.getExportTable());
        if (isAttendance) {
            rs = this.exportDataDao.findForAttendance(startDate, endDate, this.cutoffCode, this.workPlaceCode, this.employmentCode, this.sectionCode, this.ckbNeedLowerSection, this.positionCode);
        }
        if (isTotalTime) {
            rs = this.exportDataDao.findForTotalTime(startDate, endDate, this.cutoffCode, this.workPlaceCode, this.employmentCode, this.sectionCode, this.ckbNeedLowerSection, this.positionCode);
        }
        if (isPaidHoliday) {
            rs = this.exportDataDao.findForPaidHoliday(startDate, endDate, this.cutoffCode, this.workPlaceCode, this.employmentCode, this.sectionCode, this.ckbNeedLowerSection, this.positionCode);
        }
        if (isStockHoliday) {
            rs = this.exportDataDao.findForStockHoliday(startDate, endDate, this.cutoffCode, this.workPlaceCode, this.employmentCode, this.sectionCode, this.ckbNeedLowerSection, this.positionCode);
        }
        if (isHolidayData) {
            rs = this.exportDataDao.findForHolidayData(startDate, endDate, this.cutoffCode, this.workPlaceCode, this.employmentCode, this.sectionCode, this.ckbNeedLowerSection, this.positionCode);
        }
        try {
            while (rs != null && rs.next()) {
                ArrayList<String> dataList = new ArrayList<String>();
                if (!this.cutoffCode.isEmpty()) {
                    ApplicationEntity application;
                    String personalId = "";
                    if (isAttendance) {
                        personalId = rs.getString("personal_id");
                        firstTargetDate = rs.getDate("work_date");
                    }
                    if (isTotalTime) {
                        personalId = rs.getString("personal_id");
                        firstTargetDate = rs.getDate("calculation_date");
                    }
                    if (isPaidHoliday) {
                        personalId = rs.getString("personal_id");
                        firstTargetDate = rs.getDate("activate_date");
                        java.util.Date retirementDate = this.retirementReference.getRetireDate(personalId);
                        if (retirementDate != null && DateUtility.isTermContain((java.util.Date)firstTargetDate, (java.util.Date)retirementDate, null)) continue;
                    }
                    if (isStockHoliday) {
                        personalId = rs.getString("personal_id");
                        firstTargetDate = rs.getDate("activate_date");
                    }
                    if (isHolidayData) {
                        personalId = rs.getString("personal_id");
                        firstTargetDate = rs.getDate("activate_date");
                    }
                    if (!(application = this.timeMaster.getApplicationEntity(personalId, firstTargetDate)).isValid() || !MospUtility.isEqual((Object)this.cutoffCode, (Object)application.getCutoffCode())) continue;
                }
                for (ExportFieldDtoInterface exportFieldDto : exportFieldDtoList) {
                    String fieldName = exportFieldDto.getFieldName();
                    String personalId = "";
                    Date targetDate = null;
                    if (isAttendance) {
                        personalId = rs.getString("personal_id");
                        targetDate = rs.getDate("work_date");
                    }
                    if (isTotalTime) {
                        personalId = rs.getString("personal_id");
                        targetDate = rs.getDate("calculation_date");
                    }
                    if (isPaidHoliday) {
                        personalId = rs.getString("personal_id");
                        targetDate = rs.getDate("activate_date");
                    }
                    if (isStockHoliday) {
                        personalId = rs.getString("personal_id");
                        targetDate = rs.getDate("activate_date");
                    }
                    if (isHolidayData) {
                        personalId = rs.getString("personal_id");
                        targetDate = rs.getDate("activate_date");
                    }
                    if (isAttendance) {
                        if ("work_date".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDate((java.util.Date)rs.getDate(fieldName)));
                            continue;
                        }
                        if ("start_time".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDateAndTime((java.util.Date)rs.getTimestamp("start_time")));
                            continue;
                        }
                        if ("actual_start_time".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDateAndTime((java.util.Date)rs.getTimestamp("actual_start_time")));
                            continue;
                        }
                        if ("time_recode_start_time".equals(fieldName)) {
                            String timeRecodeStartTime = "";
                            TimeRecordDtoInterface recodeDto = this.timeRecord.findForKey(personalId, (java.util.Date)targetDate, "StartWork");
                            if (recodeDto != null) {
                                timeRecodeStartTime = DateUtility.getStringDateAndTime((java.util.Date)recodeDto.getRecordTime());
                            }
                            dataList.add(timeRecodeStartTime);
                            continue;
                        }
                        if ("end_time".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDateAndTime((java.util.Date)rs.getTimestamp("end_time")));
                            continue;
                        }
                        if ("actual_end_time".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDateAndTime((java.util.Date)rs.getTimestamp("actual_end_time")));
                            continue;
                        }
                        if ("time_recode_end_time".equals(fieldName)) {
                            String timeRecodeStartTime = "";
                            TimeRecordDtoInterface recodeDto = this.timeRecord.findForKey(personalId, (java.util.Date)targetDate, "EndWork");
                            if (recodeDto != null) {
                                timeRecodeStartTime = DateUtility.getStringDateAndTime((java.util.Date)recodeDto.getRecordTime());
                            }
                            dataList.add(timeRecodeStartTime);
                            continue;
                        }
                        if ("late_time".equals(fieldName) || "actual_late_time".equals(fieldName) || "late_thirty_minutes_or_more_time".equals(fieldName) || "late_less_than_thirty_minutes_time".equals(fieldName) || "leave_early_time".equals(fieldName) || "actual_leave_early_time".equals(fieldName) || "leave_early_thirty_minutes_or_more_time".equals(fieldName) || "leave_early_less_than_thirty_minutes_time".equals(fieldName) || "work_time".equals(fieldName) || "general_work_time".equals(fieldName) || "work_time_within_prescribed_work_time".equals(fieldName) || "contract_work_time".equals(fieldName) || "short_unpaid".equals(fieldName) || "rest_time".equals(fieldName) || "over_rest_time".equals(fieldName) || "night_rest_time".equals(fieldName) || "legal_holiday_rest_time".equals(fieldName) || "prescribed_holiday_rest_time".equals(fieldName) || "public_time".equals(fieldName) || "private_time".equals(fieldName) || "minutely_holiday_a_time".equals(fieldName) || "minutely_holiday_b_time".equals(fieldName) || "overtime".equals(fieldName) || "overtime_before".equals(fieldName) || "overtime_after".equals(fieldName) || "overtime_in".equals(fieldName) || "overtime_out".equals(fieldName) || "workday_overtime_in".equals(fieldName) || "workday_overtime_out".equals(fieldName) || "prescribed_holiday_overtime_in".equals(fieldName) || "prescribed_holiday_overtime_out".equals(fieldName) || "late_night_time".equals(fieldName) || "night_work_within_prescribed_work".equals(fieldName) || "night_overtime_work".equals(fieldName) || "night_work_on_holiday".equals(fieldName) || "specific_work_time".equals(fieldName) || "legal_work_time".equals(fieldName) || "decrease_time".equals(fieldName) || "legal_holiday_work_time_with_compensation_day".equals(fieldName) || "legal_holiday_work_time_without_compensation_day".equals(fieldName) || "prescribed_holiday_work_time_with_compensation_day".equals(fieldName) || "prescribed_holiday_work_time_without_compensation_day".equals(fieldName) || "overtime_in_with_compensation_day".equals(fieldName) || "overtime_in_without_compensation_day".equals(fieldName) || "overtime_out_with_compensation_day".equals(fieldName) || "overtime_out_without_compensation_day".equals(fieldName) || "statutory_holiday_work_time_in".equals(fieldName) || "statutory_holiday_work_time_out".equals(fieldName) || "prescribed_holiday_work_time_in".equals(fieldName) || "prescribed_holiday_work_time_out".equals(fieldName)) {
                            dataList.add(this.getExportTime(rs.getInt(fieldName), format));
                            continue;
                        }
                    }
                    if (isTotalTime) {
                        if ("calculation_date".equals(fieldName)) {
                            dataList.add(DateUtility.getStringDate((java.util.Date)rs.getDate(fieldName)));
                            continue;
                        }
                        if (MospUtility.isEqual((Object)fieldName, (Object)"weekly_over_forty_in")) {
                            int overtimeIn = rs.getInt("overtime_in");
                            int overtimeInNoWeeklyForty = rs.getInt("overtime_in_no_weekly_forty");
                            int weeklyOverFortyIn = TimeUtility.calcWeeklyOverFortyIn((int)overtimeIn, (int)overtimeInNoWeeklyForty);
                            dataList.add(this.getExportTime(weeklyOverFortyIn, format));
                            continue;
                        }
                        if (MospUtility.isEqual((Object)fieldName, (Object)"weekly_over_forty_normnal")) {
                            int weeklyOverForty = rs.getInt("weekly_over_forty_hour_work_time");
                            int overtimeIn = rs.getInt("overtime_in");
                            int overtimeInNoWeeklyForty = rs.getInt("overtime_in_no_weekly_forty");
                            int weeklyOverFortyNormal = TimeUtility.calcWeeklyOverFortyNormal((int)weeklyOverForty, (int)overtimeIn, (int)overtimeInNoWeeklyForty);
                            dataList.add(this.getExportTime(weeklyOverFortyNormal, format));
                            continue;
                        }
                        if ("work_time".equals(fieldName) || "specific_work_time".equals(fieldName) || "contract_work_time".equals(fieldName) || "short_unpaid".equals(fieldName) || "rest_time".equals(fieldName) || "rest_late_night".equals(fieldName) || "rest_work_on_specific_holiday".equals(fieldName) || "rest_work_on_holiday".equals(fieldName) || "public_time".equals(fieldName) || "private_time".equals(fieldName) || "minutely_holiday_a_time".equals(fieldName) || "minutely_holiday_b_time".equals(fieldName) || "overtime".equals(fieldName) || "overtime_in".equals(fieldName) || "overtime_out".equals(fieldName) || "late_night".equals(fieldName) || "night_work_within_prescribed_work".equals(fieldName) || "night_overtime_work".equals(fieldName) || "night_work_on_holiday".equals(fieldName) || "work_on_specific_holiday".equals(fieldName) || "work_on_holiday".equals(fieldName) || "decrease_time".equals(fieldName) || "forty_five_hour_overtime".equals(fieldName) || "late_time".equals(fieldName) || "late_thirty_minutes_or_more_time".equals(fieldName) || "late_less_than_thirty_minutes_time".equals(fieldName) || "leave_early_time".equals(fieldName) || "leave_early_thirty_minutes_or_more_time".equals(fieldName) || "leave_early_less_than_thirty_minutes_time".equals(fieldName) || "sixty_hour_overtime".equals(fieldName) || "week_day_overtime".equals(fieldName) || "specific_overtime".equals(fieldName) || "statutory_holiday_work_time_in".equals(fieldName) || "statutory_holiday_work_time_out".equals(fieldName) || "prescribed_holiday_work_time_in".equals(fieldName) || "prescribed_holiday_work_time_out".equals(fieldName) || "weekly_over_forty_hour_work_time".equals(fieldName) || "overtime_in_no_weekly_forty".equals(fieldName) || "overtime_out_no_weekly_forty".equals(fieldName) || "week_day_overtime_total".equals(fieldName) || "week_day_overtime_in_no_weekly_forty".equals(fieldName) || "week_day_overtime_out_no_weekly_forty".equals(fieldName) || "week_day_overtime_in".equals(fieldName) || "general_int_item1".equals(fieldName)) {
                            dataList.add(this.getExportTime(rs.getInt(fieldName), format));
                            continue;
                        }
                    }
                    if (isPaidHoliday && ("activate_date".equals(fieldName) || "acquisition_date".equals(fieldName) || "limit_date".equals(fieldName))) {
                        dataList.add(DateUtility.getStringDate((java.util.Date)rs.getDate(fieldName)));
                        continue;
                    }
                    if (isPaidHoliday && MospUtility.isEqual((Object)fieldName, (Object)"carryover_day")) {
                        Date acquisitionDate = rs.getDate("acquisition_date");
                        java.util.Date systemDate = this.getSystemDate();
                        double days = this.paidHolidayRemain.getCarryoverDays(personalId, systemDate, (java.util.Date)acquisitionDate);
                        dataList.add(TransStringUtility.getDoubleTimes((MospParams)this.mospParams, (Double)days, (boolean)false, (boolean)true));
                        continue;
                    }
                    if (isPaidHoliday && MospUtility.isEqual((Object)fieldName, (Object)"carryover_hour")) {
                        Date acquisitionDate = rs.getDate("acquisition_date");
                        java.util.Date systemDate = this.getSystemDate();
                        int hours = this.paidHolidayRemain.getCarryoverHours(personalId, systemDate, (java.util.Date)acquisitionDate);
                        dataList.add(TransStringUtility.getIntegerTimes((MospParams)this.mospParams, (Integer)hours, (boolean)false));
                        continue;
                    }
                    if (isStockHoliday && ("activate_date".equals(fieldName) || "acquisition_date".equals(fieldName) || "limit_date".equals(fieldName))) {
                        dataList.add(DateUtility.getStringDate((java.util.Date)rs.getDate(fieldName)));
                        continue;
                    }
                    if (isHolidayData && ("activate_date".equals(fieldName) || "holiday_limit_date".equals(fieldName))) {
                        dataList.add(DateUtility.getStringDate((java.util.Date)rs.getDate(fieldName)));
                        continue;
                    }
                    if ("full_name".equals(fieldName)) {
                        dataList.add(MospUtility.getHumansName((String)rs.getString("first_name"), (String)rs.getString("last_name")));
                        continue;
                    }
                    if ("work_place_name".equals(fieldName)) {
                        dataList.add(this.workPlace.getWorkPlaceName(rs.getString("work_place_code"), (java.util.Date)targetDate));
                        continue;
                    }
                    if ("employment_contract_name".equals(fieldName)) {
                        dataList.add(this.employmentContract.getContractName(rs.getString("employment_contract_code"), (java.util.Date)targetDate));
                        continue;
                    }
                    if ("section_name".equals(fieldName)) {
                        dataList.add(this.section.getSectionName(rs.getString("section_code"), (java.util.Date)targetDate));
                        continue;
                    }
                    if ("position_name".equals(fieldName)) {
                        dataList.add(this.position.getPositionName(rs.getString("position_code"), (java.util.Date)targetDate));
                        continue;
                    }
                    if ("section_display".equals(fieldName)) {
                        dataList.add(this.section.getSectionDisplay(rs.getString("section_code"), (java.util.Date)targetDate));
                        continue;
                    }
                    if ("calendar_working_days".equals(fieldName)) {
                        int targetYear = rs.getInt("calculation_year");
                        int targetMonth = rs.getInt("calculation_month");
                        int days = this.calendarWorkingDays.getCalendarWorkingDays(personalId, this.cutoffCode, targetYear, targetMonth);
                        dataList.add(String.valueOf(days));
                        continue;
                    }
                    if (this.doStoredLogic(new Object[]{"Add_ExportTableReferenceBean_Export", personalId, targetDate, dataList, fieldName}) || this.addExtraField(personalId, (java.util.Date)targetDate, dataList, fieldName, rs)) continue;
                    dataList.add(rs.getString(fieldName));
                }
                list.add(dataList.toArray(new String[0]));
            }
        }
        catch (SQLException e) {
            throw new MospException((Throwable)e);
        }
        this.exportDataDao.closers();
        return list;
    }

    protected int getExportTimeFormat() {
        return TimeUtility.getExportTimeFormat((MospParams)this.mospParams);
    }

    protected String getExportTime(int minute, int format) {
        return TimeUtility.getExportTime((MospParams)this.mospParams, (int)minute, (int)format);
    }

    public void setExportCode(String exportCode) {
        this.exportCode = exportCode;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public void setStartMonth(int startMonth) {
        this.startMonth = startMonth;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public void setEndMonth(int endMonth) {
        this.endMonth = endMonth;
    }

    public void setCutoffCode(String cutoffCode) {
        this.cutoffCode = cutoffCode;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setEmploymentCode(String employmentCode) {
        this.employmentCode = employmentCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }

    public void setCkbNeedLowerSection(int ckbNeedLowerSection) {
        this.ckbNeedLowerSection = ckbNeedLowerSection;
    }

    protected boolean addExtraField(String personalId, java.util.Date targetDate, List<String> dataList, String fieldName, ResultSet rs) throws MospException {
        return false;
    }
}

