/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.DifferenceRequestSearchBeanInterface;
import jp.mosp.time.dao.settings.DifferenceRequestDaoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestListDtoInterface;
import jp.mosp.time.dto.settings.RequestListDtoInterface;
import jp.mosp.time.dto.settings.impl.DifferenceRequestListDto;

public class DifferenceRequestSearchBean
extends PlatformBean
implements DifferenceRequestSearchBeanInterface {
    protected DifferenceRequestDaoInterface differenceDao;
    protected WorkflowReferenceBeanInterface workflowReference;
    private String personalId;
    private String workflowStatus;
    private String workTypeCode;
    private Date requestStartDate;
    private Date requestEndDate;
    protected ApprovalInfoReferenceBeanInterface approvalInfoReference;

    public void initBean() throws MospException {
        this.differenceDao = (DifferenceRequestDaoInterface)this.createDaoInstance(DifferenceRequestDaoInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBeanInstance(WorkflowReferenceBeanInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBeanInstance(ApprovalInfoReferenceBeanInterface.class);
    }

    public List<DifferenceRequestListDtoInterface> getSearchList() throws MospException {
        Map param = this.differenceDao.getParamsMap();
        param.put("personalId", this.personalId);
        param.put("workflowStatus", this.workflowStatus);
        param.put("workTypeCode", this.workTypeCode);
        param.put("requestStartDate", this.requestStartDate);
        param.put("requestEndDate", this.requestEndDate);
        List requestList = this.differenceDao.findForSearch(param);
        ArrayList<DifferenceRequestListDtoInterface> list = new ArrayList<DifferenceRequestListDtoInterface>();
        boolean flag = false;
        for (int i = 0; i < requestList.size(); ++i) {
            DifferenceRequestListDto dto = new DifferenceRequestListDto();
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(((DifferenceRequestDtoInterface)requestList.get(i)).getWorkflow());
            if (workflowDto == null) continue;
            dto.setTmdDifferenceRequestId(((DifferenceRequestDtoInterface)requestList.get(i)).getTmdDifferenceRequestId());
            dto.setRequestDate(((DifferenceRequestDtoInterface)requestList.get(i)).getRequestDate());
            dto.setAroundType(String.valueOf(((DifferenceRequestDtoInterface)requestList.get(i)).getDifferenceType()));
            dto.setStartTime(((DifferenceRequestDtoInterface)requestList.get(i)).getRequestStart());
            dto.setEndTime(((DifferenceRequestDtoInterface)requestList.get(i)).getRequestEnd());
            dto.setRequestReason(((DifferenceRequestDtoInterface)requestList.get(i)).getRequestReason());
            dto.setWorkflow(((DifferenceRequestDtoInterface)requestList.get(i)).getWorkflow());
            this.approvalInfoReference.setWorkflowInfo((RequestListDtoInterface)dto, workflowDto);
            flag = false;
            if ("1".equals(this.workflowStatus)) {
                if ("0".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("2".equals(this.workflowStatus)) {
                if ("1".equals(dto.getState()) || "2".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("3".equals(this.workflowStatus)) {
                if ("9".equals(dto.getState())) {
                    flag = true;
                }
            } else if ("4".equals(this.workflowStatus)) {
                if ("3".equals(dto.getState()) || "4".equals(dto.getState())) {
                    flag = true;
                }
            } else {
                flag = true;
            }
            if (!flag) continue;
            list.add((DifferenceRequestListDtoInterface)dto);
        }
        return list;
    }

    public void setWorkflowStatus(String workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public void setWorkTypeCode(String workTypeCode) {
        this.workTypeCode = workTypeCode;
    }

    public void setRequestStartDate(Date requestStartDate) {
        this.requestStartDate = CapsuleUtility.getDateClone((Date)requestStartDate);
    }

    public void setRequestEndDate(Date requestEndDate) {
        this.requestEndDate = CapsuleUtility.getDateClone((Date)requestEndDate);
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }
}

