/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.CutoffEntityInterface;

public class CutoffUtilBean
extends TimeBean
implements CutoffUtilBeanInterface {
    protected CutoffReferenceBeanInterface cutoffRefer;
    protected HumanSearchBeanInterface humanSearch;
    protected TotalTimeEmployeeTransactionReferenceBeanInterface totalTimeEmployeeRefer;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.cutoffRefer = (CutoffReferenceBeanInterface)this.createBeanInstance(CutoffReferenceBeanInterface.class);
        this.humanSearch = (HumanSearchBeanInterface)this.createBeanInstance(HumanSearchBeanInterface.class);
        this.totalTimeEmployeeRefer = (TotalTimeEmployeeTransactionReferenceBeanInterface)this.createBeanInstance(TotalTimeEmployeeTransactionReferenceBeanInterface.class);
        this.setTimeMaster((TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class));
    }

    public Set<String> getCutoffPersonalIdSet(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        LinkedHashSet<String> idSet = new LinkedHashSet<String>();
        CutoffEntityInterface cutoff = this.getCutoff(cutoffCode, targetYear, targetMonth);
        if (this.mospParams.hasErrorMessage()) {
            return idSet;
        }
        Date cutoffTermTargetDate = cutoff.getCutoffTermTargetDate(targetYear, targetMonth, this.mospParams);
        Date firstDate = cutoff.getCutoffFirstDate(targetYear, targetMonth, this.mospParams);
        Date lastDate = cutoff.getCutoffLastDate(targetYear, targetMonth, this.mospParams);
        Map activateMap = this.getActivateHumans(cutoffTermTargetDate, firstDate, lastDate);
        for (HumanDtoInterface humanDto : activateMap.values()) {
            ApplicationEntity entity = this.timeMaster.getApplicationEntity(humanDto, cutoffTermTargetDate);
            if (!entity.getCutoffCode().equals(cutoffCode)) continue;
            idSet.add(humanDto.getPersonalId());
        }
        if (idSet.isEmpty()) {
            PfMessageUtility.addErrorEmployeeNotExist((MospParams)this.mospParams);
        }
        return idSet;
    }

    protected CutoffEntityInterface getCutoff(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        return this.getCutoff(cutoffCode, targetDate);
    }

    protected CutoffEntityInterface getCutoff(String cutoffCode, Date targetDate) throws MospException {
        CutoffEntityInterface cutoff = this.timeMaster.getCutoff(cutoffCode, targetDate);
        this.cutoffRefer.chkExistCutoff(cutoff.getCutoffDto(), targetDate);
        return cutoff;
    }

    public boolean checkTighten(String personalId, Date targetDate, String targetName) throws MospException {
        int month;
        Date cutoffDate = this.getCutoffMonth(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return false;
        }
        int year = DateUtility.getYear((Date)cutoffDate);
        boolean isNotTighten = this.isNotTighten(personalId, year, month = DateUtility.getMonth((Date)cutoffDate));
        if (!isNotTighten) {
            this.addMonthlyTreatmentErrorMessage(year, month, targetName);
        }
        return isNotTighten;
    }

    public boolean isNotTighten(String personalId, Date targetDate) throws MospException {
        ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, targetDate);
        if (!application.isValid()) {
            return false;
        }
        Date cutoffMonth = application.getCutoffEntity().getCutoffMonth(targetDate, this.mospParams);
        return this.isNotTighten(personalId, DateUtility.getYear((Date)cutoffMonth), DateUtility.getMonth((Date)cutoffMonth));
    }

    public boolean isNotTighten(String personalId, int targetYear, int targetMonth) throws MospException {
        Integer state = this.totalTimeEmployeeRefer.getCutoffState(personalId, targetYear, targetMonth);
        return state == null || state == 0;
    }

    public Date getCutoffMonth(String personalId, Date targetDate) throws MospException {
        CutoffEntityInterface cutoff = this.timeMaster.getCutoffForPersonalId(personalId, targetDate);
        if (!cutoff.isExist()) {
            return MonthUtility.getTargetYearMonth((Date)targetDate, (MospParams)this.mospParams);
        }
        return cutoff.getCutoffMonth(targetDate, this.mospParams);
    }

    protected Map<String, HumanDtoInterface> getActivateHumans(Date targetDate, Date staDate, Date endDate) throws MospException {
        this.humanSearch.setTargetDate(targetDate);
        this.humanSearch.setStartDate(staDate);
        this.humanSearch.setEndDate(endDate);
        this.humanSearch.setStateType("presence");
        return this.humanSearch.getHumanDtoMap();
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
    }
}

