/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.time.bean.CalendarWorkingDaysBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class CalendarWorkingDaysBean
extends PlatformBean
implements CalendarWorkingDaysBeanInterface {
    protected TimeMasterBeanInterface timeMaster;
    protected PlatformMasterBeanInterface platformMaster;
    protected ScheduleUtilBeanInterface scheduleUtil;

    public void initBean() throws MospException {
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBeanInstance(PlatformMasterBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
    }

    public int getCalendarWorkingDays(String personalId, String cutoffCode, int targetYear, int targetMonth) throws MospException {
        int calendarWorkingDays = 0;
        CutoffEntityInterface cutoff = this.timeMaster.getCutoff(cutoffCode, targetYear, targetMonth);
        Date firstDate = cutoff.getCutoffFirstDate(targetYear, targetMonth, this.mospParams);
        Date lastDate = cutoff.getCutoffLastDate(targetYear, targetMonth, this.mospParams);
        for (Date calendarTargetDate : TimeUtility.getDateList((Date)firstDate, (Date)lastDate)) {
            String workTypeCode;
            if (this.platformMaster.isRetired(personalId, calendarTargetDate) || this.platformMaster.isSuspended(personalId, calendarTargetDate) || TimeUtility.isHoliday((String)(workTypeCode = this.scheduleUtil.getScheduledWorkTypeCodeNoMessage(personalId, calendarTargetDate))) || MospUtility.isEmpty((String[])new String[]{workTypeCode})) continue;
            ++calendarWorkingDays;
        }
        return calendarWorkingDays;
    }

    public void setPlatformMaster(PlatformMasterBeanInterface platformMaster) {
        this.platformMaster = platformMaster;
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
        this.scheduleUtil.setTimeMaster(timeMaster);
    }
}

