/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dao.settings.AttendanceTransactionDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.AttendanceTransactionDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmtAttendanceDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class AttendanceTransactionRegistBean
extends TimeBean
implements AttendanceTransactionRegistBeanInterface {
    protected AttendanceTransactionDaoInterface dao;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected ApplicationReferenceBeanInterface applicationReference;
    protected PaidHolidayReferenceBeanInterface paidHolidayReference;
    protected HolidayReferenceBeanInterface holidayReference;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.dao = (AttendanceTransactionDaoInterface)this.createDaoInstance(AttendanceTransactionDaoInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBeanInstance(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBeanInstance(RetirementReferenceBeanInterface.class);
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBeanInstance(ApplicationReferenceBeanInterface.class);
        this.paidHolidayReference = (PaidHolidayReferenceBeanInterface)this.createBeanInstance(PaidHolidayReferenceBeanInterface.class);
        this.holidayReference = (HolidayReferenceBeanInterface)this.createBeanInstance(HolidayReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.setTimeMaster(this.timeMaster);
    }

    public void regist(String personalId, Date workDate) throws MospException {
        this.regist(personalId, workDate, true);
    }

    public void regist(AttendanceDtoInterface dto) throws MospException {
        this.regist(dto.getPersonalId(), dto.getWorkDate(), dto.getWorkflow());
    }

    public void regist(HolidayRequestDtoInterface dto) throws MospException {
        Date date = dto.getRequestStartDate();
        while (!date.after(dto.getRequestEndDate())) {
            this.regist(dto.getPersonalId(), date, dto.getWorkflow());
            date = this.addDay(date, 1);
        }
    }

    public void regist(SubHolidayRequestDtoInterface dto) throws MospException {
        this.regist(dto.getPersonalId(), dto.getRequestDate(), dto.getWorkflow());
    }

    public void regist(SubstituteDtoInterface dto) throws MospException {
        this.regist(dto.getPersonalId(), dto.getSubstituteDate(), dto.getWorkflow());
    }

    protected void regist(String personalId, Date workDate, long workflow) throws MospException {
        if (this.workflowIntegrate.isCompleted(workflow)) {
            this.regist(personalId, workDate);
        }
    }

    protected void regist(String personalId, Date workDate, boolean isUpdate) throws MospException {
        AttendanceTransactionDtoInterface dto = this.dao.findForKey(personalId, workDate);
        if (dto == null) {
            dto = new TmtAttendanceDto();
            this.setDtoFields(dto, personalId, workDate);
            this.insert(dto);
            return;
        }
        if (isUpdate) {
            this.setDtoFields(dto);
            this.update(dto);
        }
    }

    protected void setDtoFields(AttendanceTransactionDtoInterface dto, String personalId, Date workDate) throws MospException {
        dto.setPersonalId(personalId);
        dto.setWorkDate(workDate);
        this.setDtoFields(dto);
    }

    protected void setDtoFields(AttendanceTransactionDtoInterface dto) throws MospException {
        dto.setAttendanceType("");
        dto.setNumerator(0);
        dto.setDenominator(0);
        if (this.setDtoFieldsIsSuspended(dto)) {
            return;
        }
        if (this.setDtoFieldsIsRetired(dto)) {
            return;
        }
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(dto.getPersonalId(), dto.getWorkDate());
        if (this.setDtoFieldsIsAttendance(dto, requestUtil)) {
            return;
        }
        if (this.setDtoFieldsIsSubstitute(dto, requestUtil)) {
            return;
        }
        if (this.setDtoFieldsIsSubHoliday(dto, requestUtil)) {
            return;
        }
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(dto.getPersonalId(), dto.getWorkDate(), true);
        if (this.setDtoFieldsIsHoliday(dto, requestUtil, workTypeCode)) {
            return;
        }
        if (workTypeCode.isEmpty() || "legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
            dto.setAttendanceType(workTypeCode);
            dto.setNumerator(0);
            dto.setDenominator(0);
            return;
        }
        dto.setAttendanceType("attendance");
        dto.setNumerator(0);
        dto.setDenominator(1);
    }

    protected boolean setDtoFieldsIsSuspended(AttendanceTransactionDtoInterface dto) throws MospException {
        if (this.suspensionReference.isSuspended(dto.getPersonalId(), dto.getWorkDate())) {
            dto.setAttendanceType("suspension");
            dto.setNumerator(0);
            dto.setDenominator(0);
            return true;
        }
        return false;
    }

    protected boolean setDtoFieldsIsRetired(AttendanceTransactionDtoInterface dto) throws MospException {
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getWorkDate())) {
            dto.setAttendanceType("retirement");
            dto.setNumerator(0);
            dto.setDenominator(0);
            return true;
        }
        return false;
    }

    protected boolean setDtoFieldsIsAttendance(AttendanceTransactionDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceDtoInterface attendanceDto = requestUtil.getApplicatedAttendance();
        if (attendanceDto != null && this.workflowIntegrate.isCompleted(attendanceDto.getWorkflow())) {
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
            if (workOnHolidayRequestDto == null) {
                dto.setAttendanceType("attendance");
                dto.setNumerator(1);
                dto.setDenominator(1);
                return true;
            }
            int substitute = workOnHolidayRequestDto.getSubstitute();
            if (substitute == 1) {
                dto.setAttendanceType("attendance");
                dto.setNumerator(1);
                dto.setDenominator(1);
                return true;
            }
            if (substitute == 2) {
                PaidHolidayDtoInterface paidHolidayDto;
                ApplicationDtoInterface applicationDto;
                String attendanceType = "";
                if ("legal_holiday".equals(workOnHolidayRequestDto.getWorkOnHolidayType())) {
                    attendanceType = "work_on_legal";
                } else if ("prescribed_holiday".equals(workOnHolidayRequestDto.getWorkOnHolidayType())) {
                    attendanceType = "work_on_prescribed";
                }
                if (!attendanceType.isEmpty() && (applicationDto = this.applicationReference.findForPerson(dto.getPersonalId(), dto.getWorkDate())) != null && (paidHolidayDto = this.paidHolidayReference.getPaidHolidayInfo(applicationDto.getPaidHolidayCode(), dto.getWorkDate())) != null) {
                    int workOnHolidayCalc = paidHolidayDto.getWorkOnHolidayCalc();
                    if (workOnHolidayCalc == 1) {
                        dto.setAttendanceType(attendanceType);
                        dto.setNumerator(1);
                        dto.setDenominator(1);
                        return true;
                    }
                    if (workOnHolidayCalc == 2) {
                        dto.setAttendanceType(attendanceType);
                        dto.setNumerator(0);
                        dto.setDenominator(1);
                        return true;
                    }
                    if (workOnHolidayCalc == 3) {
                        dto.setAttendanceType(attendanceType);
                        dto.setNumerator(0);
                        dto.setDenominator(0);
                        return true;
                    }
                }
            } else if (substitute == 3 || substitute == 4) {
                dto.setAttendanceType("attendance");
                dto.setNumerator(1);
                dto.setDenominator(1);
                return true;
            }
            dto.setAttendanceType("attendance");
            dto.setNumerator(1);
            dto.setDenominator(1);
            return true;
        }
        return false;
    }

    protected boolean setDtoFieldsIsSubstitute(AttendanceTransactionDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        int substituteRange = requestUtil.checkHolidayRangeSubstitute(requestUtil.getSubstituteList(true));
        if (substituteRange == 1 || substituteRange == 5) {
            dto.setAttendanceType("substitute");
            dto.setNumerator(0);
            dto.setDenominator(0);
            return true;
        }
        return false;
    }

    protected boolean setDtoFieldsIsSubHoliday(AttendanceTransactionDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        int subHolidayRange = requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(true));
        if (subHolidayRange == 1 || subHolidayRange == 2 || subHolidayRange == 3 || subHolidayRange == 5) {
            dto.setAttendanceType("sub_holiday");
            dto.setNumerator(1);
            dto.setDenominator(1);
            return true;
        }
        return false;
    }

    protected boolean setDtoFieldsIsHoliday(AttendanceTransactionDtoInterface dto, RequestUtilBeanInterface requestUtil, String workTypeCode) throws MospException {
        Integer amHoliday = null;
        Integer pmHoliday = null;
        List holidayList = requestUtil.getHolidayList(true);
        for (HolidayRequestDtoInterface holidayRequestDto : holidayList) {
            boolean isPm;
            boolean isAll = holidayRequestDto.getHolidayRange() == 1;
            boolean isAm = holidayRequestDto.getHolidayRange() == 2;
            boolean bl = isPm = holidayRequestDto.getHolidayRange() == 3;
            if (holidayRequestDto.getHolidayType1() == 1) {
                if (Integer.toString(1).equals(holidayRequestDto.getHolidayType2())) {
                    dto.setAttendanceType("holiday");
                    dto.setNumerator(1);
                    dto.setDenominator(1);
                    return true;
                }
                if (!Integer.toString(2).equals(holidayRequestDto.getHolidayType2())) continue;
                int stockHolidayAttendance = this.mospParams.getApplicationProperty("StockHolidayAttendance", 1);
                if (stockHolidayAttendance == 1) {
                    dto.setAttendanceType("holiday");
                    dto.setNumerator(1);
                    dto.setDenominator(1);
                    return true;
                }
                if (isAll) {
                    dto.setAttendanceType("holiday");
                    if (stockHolidayAttendance == 2) {
                        dto.setNumerator(0);
                        dto.setDenominator(1);
                        return true;
                    }
                    if (stockHolidayAttendance != 3) continue;
                    dto.setNumerator(0);
                    dto.setDenominator(0);
                    return true;
                }
                if (holidayRequestDto.getHolidayRange() == 2) {
                    amHoliday = stockHolidayAttendance;
                    continue;
                }
                if (holidayRequestDto.getHolidayRange() != 3) continue;
                pmHoliday = stockHolidayAttendance;
                continue;
            }
            if (holidayRequestDto.getHolidayType1() != 2 && holidayRequestDto.getHolidayType1() != 3 && holidayRequestDto.getHolidayType1() != 4) continue;
            if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode)) {
                dto.setAttendanceType(workTypeCode);
                dto.setNumerator(0);
                dto.setDenominator(0);
                return true;
            }
            HolidayDtoInterface holidayDto = this.holidayReference.getHolidayInfo(holidayRequestDto.getHolidayType2(), holidayRequestDto.getRequestStartDate(), holidayRequestDto.getHolidayType1());
            if (holidayDto == null) continue;
            if (holidayDto.getPaidHolidayCalc() == 1) {
                dto.setAttendanceType("holiday");
                dto.setNumerator(1);
                dto.setDenominator(1);
                return true;
            }
            if (holidayDto.getPaidHolidayCalc() == 2) {
                if (isAll) {
                    dto.setAttendanceType("holiday");
                    dto.setNumerator(0);
                    dto.setDenominator(1);
                    return true;
                }
                if (isAm) {
                    amHoliday = 2;
                }
                if (!isPm) continue;
                pmHoliday = 2;
                continue;
            }
            if (holidayDto.getPaidHolidayCalc() != 3) continue;
            if (isAll) {
                dto.setAttendanceType("holiday");
                dto.setNumerator(0);
                dto.setDenominator(0);
                return true;
            }
            if (isAm && amHoliday == null) {
                amHoliday = 3;
            }
            if (!isPm || pmHoliday != null) continue;
            pmHoliday = 3;
        }
        if (requestUtil.isHolidayAllDay(true)) {
            if (amHoliday != null && amHoliday == 2 || pmHoliday != null && pmHoliday == 2) {
                dto.setAttendanceType("holiday");
                dto.setNumerator(0);
                dto.setDenominator(1);
                return true;
            }
            if (amHoliday != null && amHoliday == 3 || pmHoliday != null && pmHoliday == 3) {
                dto.setAttendanceType("holiday");
                dto.setNumerator(0);
                dto.setDenominator(0);
                return true;
            }
        }
        return false;
    }

    public void regist(String personalId, Map<Date, String> attendanceMap) throws MospException {
        for (Map.Entry<Date, String> entry : attendanceMap.entrySet()) {
            Date workDate = entry.getKey();
            String attendanceType = entry.getValue();
            AttendanceTransactionDtoInterface dto = this.makeAttendanceTransactionDto(personalId, workDate, attendanceType);
            AttendanceTransactionDtoInterface formerDto = this.dao.findForKey(personalId, workDate);
            if (formerDto != null) {
                if (AttendanceTransactionRegistBean.isSameDto((AttendanceTransactionDtoInterface)dto, (AttendanceTransactionDtoInterface)formerDto)) continue;
                this.logicalDelete((BaseDaoInterface)this.dao, formerDto.getTmtAttendanceId());
            }
            this.insert(dto);
        }
    }

    protected AttendanceTransactionDtoInterface makeAttendanceTransactionDto(String personalId, Date workDate, String attendanceType) throws MospException {
        TmtAttendanceDto dto = new TmtAttendanceDto();
        dto.setPersonalId(personalId);
        dto.setWorkDate(workDate);
        dto.setAttendanceType(attendanceType);
        dto.setNumerator(0);
        dto.setDenominator(0);
        this.doStoredLogic(new Object[]{"Add_Make_Attedance_Transaction_Dto", dto});
        return dto;
    }

    protected void insert(AttendanceTransactionDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmtAttendanceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void update(AttendanceTransactionDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmtAttendanceId());
        dto.setTmtAttendanceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void validate(AttendanceTransactionDtoInterface dto) {
    }

    protected void checkInsert(AttendanceTransactionDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getWorkDate()));
    }

    protected void checkUpdate(AttendanceTransactionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmtAttendanceId());
    }

    protected static boolean isSameDto(AttendanceTransactionDtoInterface dto1, AttendanceTransactionDtoInterface dto2) {
        return MospUtility.isEqual((Object)dto1.getPersonalId(), (Object)dto2.getPersonalId()) && MospUtility.isEqual((Object)dto1.getWorkDate(), (Object)dto2.getWorkDate()) && MospUtility.isEqual((Object)dto1.getAttendanceType(), (Object)dto2.getAttendanceType()) && dto1.getNumerator() == dto2.getNumerator() && dto1.getDenominator() == dto2.getDenominator();
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
        this.scheduleUtil.setTimeMaster(timeMaster);
    }
}

