/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.AttendanceTotalVo;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceTotalInfoBeanInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;

public class AttendanceTotalInfoBean
extends TimeBean
implements AttendanceTotalInfoBeanInterface {
    AttendanceListReferenceBeanInterface attendanceListRefer;
    public static final String SEPARATOR_HOURS = ".";
    public static final int HOURS_DIGITS = 2;

    public void initBean() throws MospException {
        this.attendanceListRefer = (AttendanceListReferenceBeanInterface)this.createBean(AttendanceListReferenceBeanInterface.class);
    }

    protected AttendanceListDto getTotalAttendanceListDto(String personalId, Date targetDate) throws MospException {
        int month;
        int year = DateUtility.getYear((Date)targetDate);
        List attendanceList = this.attendanceListRefer.getAttendanceList(personalId, year, month = DateUtility.getMonth((Date)targetDate));
        if (attendanceList.isEmpty()) {
            return null;
        }
        return (AttendanceListDto)attendanceList.get(attendanceList.size() - 1);
    }

    protected AttendanceTotalVo setDefaltValue(Date targetDate) {
        AttendanceTotalVo vo = new AttendanceTotalVo();
        StringBuilder title = new StringBuilder();
        title.append(this.mospParams.getName("FrontWithCornerParentheses"));
        title.append(DateUtility.getStringYear((Date)targetDate) + this.mospParams.getName("Year"));
        title.append(DateUtility.getStringMonth((Date)targetDate) + this.mospParams.getName("Month"));
        title.append(this.mospParams.getName("BackWithCornerParentheses"));
        vo.setTargetDate(title.toString());
        vo.setRowItemNumber(15);
        vo.setTitleList(this.getTitleList());
        vo.setValueList(this.getInitValueList());
        return vo;
    }

    protected List<String> getTitleList() {
        ArrayList<String> titleList = new ArrayList<String>();
        titleList.add("\u5408\u8a08\u6642\u9593");
        titleList.add("\u52e4\u52d9");
        titleList.add("\u4f11\u61a9");
        titleList.add("\u5916\u51fa");
        titleList.add("\u9045\u65e9");
        titleList.add("\u5185\u6b8b");
        titleList.add("\u5916\u6b8b");
        titleList.add("\u4f11\u51fa");
        titleList.add("\u6df1\u591c");
        titleList.add("\u56de\u6570");
        titleList.add("\u51fa\u52e4");
        titleList.add("\u9045\u523b");
        titleList.add("\u65e9\u9000");
        titleList.add("\u6b8b\u696d");
        titleList.add("\u4f11\u51fa");
        titleList.add("\u4f11\u65e5");
        titleList.add("\u6cd5\u5b9a");
        titleList.add("\u6240\u5b9a");
        titleList.add("\u632f\u4f11");
        titleList.add("\u4f11\u6687");
        titleList.add("\u6709\u4f11");
        titleList.add("\u6709\u6642");
        titleList.add("\u7279\u4f11");
        titleList.add("\u305d\u306e\u4ed6");
        titleList.add("\u4ee3\u4f11");
        titleList.add("\u6b20\u52e4");
        titleList.add("\u4ee3\u4f11\u767a\u751f");
        titleList.add("\u6cd5\u5b9a");
        titleList.add("\u6240\u5b9a");
        titleList.add("\u6df1\u591c");
        return titleList;
    }

    protected List<String> getInitValueList() {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(null);
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add(null);
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add(null);
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add(null);
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add("");
        valueList.add(null);
        valueList.add("");
        valueList.add("");
        valueList.add("");
        return valueList;
    }

    protected void setValues(List<String> valueList, AttendanceListDto dto) throws MospException {
        valueList.set(0, null);
        valueList.set(1, dto.getWorkTimeTotalString());
        valueList.set(2, dto.getRestTimeTotalString());
        valueList.set(3, dto.getPrivateTimeTotalString());
        valueList.set(4, dto.getLateLeaveEarlyTimeTotalString());
        valueList.set(5, dto.getOvertimeInTotalString());
        valueList.set(6, dto.getOvertimeOutTotalString());
        valueList.set(7, dto.getHolidayWorkTimeTotalString());
        valueList.set(8, dto.getLateNightTimeTotalString());
        valueList.set(9, null);
        valueList.set(10, dto.getWorkDaysString());
        valueList.set(11, dto.getLateDaysString());
        valueList.set(12, dto.getLeaveEarlyDaysString());
        valueList.set(13, dto.getOvertimeDaysString());
        valueList.set(14, dto.getHolidayWorkDaysString());
        valueList.set(15, null);
        valueList.set(16, dto.getLegalHolidaysString());
        valueList.set(17, dto.getPrescribedHolidaysString());
        valueList.set(18, dto.getSubstituteHolidaysString());
        valueList.set(19, null);
        valueList.set(20, dto.getPaidHolidaysString());
        valueList.set(21, dto.getPaidHolidayTimeString());
        valueList.set(22, dto.getSpecialHolidaysString());
        valueList.set(23, dto.getOtherHolidaysString());
        valueList.set(24, dto.getSubHolidaysString());
        valueList.set(25, dto.getAbsenceDaysString());
        valueList.set(26, null);
        valueList.set(27, dto.getBirthLegalSubHolidayString());
        valueList.set(28, dto.getBirthPrescribedSubHolidayString());
        valueList.set(29, dto.getBirthMidnightSubHolidayString());
    }

    public List<AttendanceTotalVo> setFiscalYearAttendanceTotalList(String personalId, int fiscalYear) throws MospException {
        ArrayList<AttendanceTotalVo> list = new ArrayList<AttendanceTotalVo>();
        ArrayList<AttendanceTotalVo> monthList = new ArrayList<AttendanceTotalVo>();
        Date startDate = MonthUtility.getFiscalStartMonth((int)fiscalYear, (MospParams)this.mospParams);
        Integer workTimeTotal = 0;
        Integer restTimeTotal = 0;
        Integer privateTimeTotal = 0;
        Integer lateLeaveEarlyTimeTotal = 0;
        Integer overtimeInTotal = 0;
        Integer overtimeOutTotal = 0;
        Integer holidayWorkTimeTotal = 0;
        Integer lateNightTimeTotal = 0;
        Integer workDays = 0;
        Integer lateDays = 0;
        Integer leaveEarlyDays = 0;
        Integer overtimeDays = 0;
        Integer holidayWorkDays = 0;
        Integer legalHolidays = 0;
        Integer prescribedHolidays = 0;
        Float substituteHolidays = Float.valueOf(0.0f);
        Float paidHolidays = Float.valueOf(0.0f);
        Float paidHolidayTime = Float.valueOf(0.0f);
        Float specialHolidays = Float.valueOf(0.0f);
        Float specialHolidayHours = Float.valueOf(0.0f);
        Float otherHolidays = Float.valueOf(0.0f);
        Float otherHolidayHours = Float.valueOf(0.0f);
        Float subHolidays = Float.valueOf(0.0f);
        Float absenceDays = Float.valueOf(0.0f);
        Float absenceHours = Float.valueOf(0.0f);
        Float birthLegalSubHoliday = Float.valueOf(0.0f);
        Float birthPrescribedSubHoliday = Float.valueOf(0.0f);
        Float birthMidNightSubHoliday = Float.valueOf(0.0f);
        boolean isPaidHolidayTime = false;
        ArrayList errorMes = new ArrayList();
        for (int i = 0; i < 12; ++i) {
            Date targetDate = DateUtility.addMonth((Date)startDate, (int)i);
            AttendanceListDto attendanceListDto = this.getTotalAttendanceListDto(personalId, targetDate);
            if (this.mospParams.hasErrorMessage()) {
                errorMes.addAll(this.mospParams.getErrorMessageList());
                this.mospParams.getErrorMessageList().clear();
                continue;
            }
            AttendanceTotalVo vo = this.setDefaltValue(targetDate);
            this.setValues(vo.getValueList(), attendanceListDto);
            monthList.add(vo);
            workTimeTotal = workTimeTotal + attendanceListDto.getWorkTimeTotal();
            restTimeTotal = restTimeTotal + attendanceListDto.getRestTimeTotal();
            privateTimeTotal = privateTimeTotal + attendanceListDto.getPrivateTimeTotal();
            lateLeaveEarlyTimeTotal = lateLeaveEarlyTimeTotal + attendanceListDto.getLateLeaveEarlyTimeTotal();
            overtimeInTotal = overtimeInTotal + attendanceListDto.getOvertimeInTotal();
            overtimeOutTotal = overtimeOutTotal + attendanceListDto.getOvertimeOutTotal();
            holidayWorkTimeTotal = holidayWorkTimeTotal + attendanceListDto.getHolidayWorkTimeTotal();
            lateNightTimeTotal = lateNightTimeTotal + attendanceListDto.getLateNightTimeTotal();
            workDays = workDays + attendanceListDto.getWorkDays();
            lateDays = lateDays + attendanceListDto.getLateDays();
            leaveEarlyDays = leaveEarlyDays + attendanceListDto.getLeaveEarlyDays();
            overtimeDays = overtimeDays + attendanceListDto.getOvertimeDays();
            holidayWorkDays = holidayWorkDays + attendanceListDto.getHolidayWorkDays();
            legalHolidays = legalHolidays + attendanceListDto.getLegalHolidays();
            prescribedHolidays = prescribedHolidays + attendanceListDto.getPrescribedHolidays();
            substituteHolidays = Float.valueOf(substituteHolidays.floatValue() + attendanceListDto.getSubstituteHolidays().floatValue());
            paidHolidays = Float.valueOf(paidHolidays.floatValue() + attendanceListDto.getPaidHolidays().floatValue());
            if (attendanceListDto.getPaidHolidayTime() != null) {
                isPaidHolidayTime = true;
            }
            paidHolidayTime = Float.valueOf(paidHolidayTime.floatValue() + MospUtility.getFloat((Object)attendanceListDto.getPaidHolidayTime()));
            specialHolidays = Float.valueOf(specialHolidays.floatValue() + attendanceListDto.getSpecialHolidays().floatValue());
            specialHolidayHours = Float.valueOf(specialHolidayHours.floatValue() + attendanceListDto.getSpecialHolidayHours().floatValue());
            otherHolidays = Float.valueOf(otherHolidays.floatValue() + attendanceListDto.getOtherHolidays().floatValue());
            otherHolidayHours = Float.valueOf(otherHolidayHours.floatValue() + attendanceListDto.getOtherHolidayHours().floatValue());
            subHolidays = Float.valueOf(subHolidays.floatValue() + attendanceListDto.getSubHolidays().floatValue());
            absenceDays = Float.valueOf(absenceDays.floatValue() + attendanceListDto.getAbsenceDays().floatValue());
            absenceHours = Float.valueOf(absenceHours.floatValue() + attendanceListDto.getAbsenceHours().floatValue());
            birthLegalSubHoliday = Float.valueOf(birthLegalSubHoliday.floatValue() + attendanceListDto.getBirthLegalSubHoliday().floatValue());
            birthPrescribedSubHoliday = Float.valueOf(birthPrescribedSubHoliday.floatValue() + attendanceListDto.getBirthPrescribedSubHoliday().floatValue());
            birthMidNightSubHoliday = Float.valueOf(birthMidNightSubHoliday.floatValue() + attendanceListDto.getBirthMidnightSubHoliday().floatValue());
        }
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(0, null);
        valueList.add(1, this.getStringHours(workTimeTotal, false));
        valueList.add(2, this.getStringHours(restTimeTotal, false));
        valueList.add(3, this.getStringHours(privateTimeTotal, false));
        valueList.add(4, this.getStringHours(lateLeaveEarlyTimeTotal, false));
        valueList.add(5, this.getStringHours(overtimeInTotal, false));
        valueList.add(6, this.getStringHours(overtimeOutTotal, false));
        valueList.add(7, this.getStringHours(holidayWorkTimeTotal, false));
        valueList.add(8, this.getStringHours(lateNightTimeTotal, false));
        valueList.add(9, null);
        valueList.add(10, this.getStringTimes(workDays, false));
        valueList.add(11, this.getStringTimes(lateDays, false));
        valueList.add(12, this.getStringTimes(leaveEarlyDays, false));
        valueList.add(13, this.getStringTimes(overtimeDays, false));
        valueList.add(14, this.getStringTimes(holidayWorkDays, false));
        valueList.add(15, null);
        valueList.add(16, this.getStringTimes(legalHolidays, false));
        valueList.add(17, this.getStringTimes(prescribedHolidays, false));
        valueList.add(18, this.getStringTimes(substituteHolidays, false));
        valueList.add(19, null);
        valueList.add(20, this.getStringTimes(paidHolidays, false));
        valueList.add(21, this.getStringTimes(paidHolidayTime, !isPaidHolidayTime));
        valueList.add(22, this.getStringTimes(specialHolidays, false) + this.mospParams.getName("Slash") + this.getStringTimes(specialHolidayHours, false));
        valueList.add(23, this.getStringTimes(otherHolidays, false) + this.mospParams.getName("Slash") + this.getStringTimes(otherHolidayHours, false));
        valueList.add(24, this.getStringTimes(subHolidays, false));
        valueList.add(25, this.getStringTimes(absenceDays, false) + this.mospParams.getName("Slash") + this.getStringTimes(absenceHours, false));
        valueList.add(26, null);
        valueList.add(27, this.getStringFloat(birthLegalSubHoliday));
        valueList.add(28, this.getStringFloat(birthPrescribedSubHoliday));
        valueList.add(29, this.getStringFloat(birthMidNightSubHoliday));
        AttendanceTotalVo totalVo = new AttendanceTotalVo();
        StringBuilder title = new StringBuilder();
        title.append(this.mospParams.getName("FrontWithCornerParentheses"));
        title.append("\u5e74\u5ea6\u7d2f\u8a08");
        title.append(this.mospParams.getName("BackWithCornerParentheses"));
        totalVo.setTargetDate(title.toString());
        totalVo.setClassName("style=\"background-color: #ccffcc;\"");
        totalVo.setRowItemNumber(15);
        totalVo.setTitleList(this.getTitleList());
        totalVo.setValueList(valueList);
        list.add(totalVo);
        list.addAll(monthList);
        this.mospParams.getErrorMessageList().addAll(errorMes);
        return list;
    }

    protected String getStringTimes(Integer times, boolean isHyphen) {
        if (times == null || isHyphen) {
            return this.getHyphenNaming();
        }
        return times.toString();
    }

    protected String getStringTimes(Float times, boolean isHyphen) {
        if (times == null || isHyphen) {
            return this.getHyphenNaming();
        }
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(times);
    }

    protected String getStringHours(Integer minutes, boolean needHyphen) {
        if (minutes == null) {
            return this.getHyphenNaming();
        }
        if (needHyphen && minutes == 0) {
            return this.getHyphenNaming();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(minutes / 60);
        sb.append(SEPARATOR_HOURS);
        int remainder = minutes % 60;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setRoundingMode(RoundingMode.DOWN);
        nf.setMinimumIntegerDigits(2);
        sb.append(nf.format(remainder));
        return sb.toString();
    }

    protected String getStringFloat(Float value) {
        if (value == null) {
            return this.getHyphenNaming();
        }
        return String.valueOf(value);
    }
}

