/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeApplicationBean;
import jp.mosp.time.bean.AttendanceCorrectionRegistBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceRegistAddonBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.GoOutRegistBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.RestRegistBeanInterface;
import jp.mosp.time.bean.SubHolidayRegistBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdAttendanceDto;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class AttendanceRegistBean
extends TimeApplicationBean
implements AttendanceRegistBeanInterface {
    protected AttendanceDaoInterface dao;
    private AttendanceReferenceBeanInterface attendanceReference;
    protected WorkTypeItemDaoInterface workTypeItemDao;
    protected WorkflowReferenceBeanInterface workflowReference;
    protected WorkOnHolidayRequestDaoInterface workOnHolidayRequestDao;
    private SubHolidayRequestDaoInterface subHolidayDao;
    private RetirementReferenceBeanInterface retirementReference;
    private WorkflowCommentReferenceBeanInterface workflowCommentReference;
    private AttendanceCorrectionRegistBeanInterface attendanceCorrectionRegist;
    private RestRegistBeanInterface restRegist;
    private GoOutRegistBeanInterface goOutRegist;
    private SubHolidayRegistBeanInterface subHolidayRegist;
    private WorkflowRegistBeanInterface workflowRegist;
    private WorkflowCommentRegistBeanInterface workflowCommentRegist;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected RequestUtilBeanInterface requestUtil;
    protected TimeMasterBeanInterface timeMaster;
    protected static final String APP_KEY_APPLICABLE_LIMIT_ATTENDANCE = "ApplicableLimitAttendance";
    protected List<AttendanceRegistAddonBeanInterface> addonBeans;
    protected static final String CODE_KEY_ADDONS = "AttendanceRegistAddons";

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (AttendanceDaoInterface)this.createDaoInstance(AttendanceDaoInterface.class);
        this.workTypeItemDao = (WorkTypeItemDaoInterface)this.createDaoInstance(WorkTypeItemDaoInterface.class);
        this.workOnHolidayRequestDao = (WorkOnHolidayRequestDaoInterface)this.createDaoInstance(WorkOnHolidayRequestDaoInterface.class);
        this.subHolidayDao = (SubHolidayRequestDaoInterface)this.createDaoInstance(SubHolidayRequestDaoInterface.class);
        this.attendanceReference = (AttendanceReferenceBeanInterface)this.createBeanInstance(AttendanceReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBeanInstance(WorkflowReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBeanInstance(RetirementReferenceBeanInterface.class);
        this.workflowCommentReference = (WorkflowCommentReferenceBeanInterface)this.createBeanInstance(WorkflowCommentReferenceBeanInterface.class);
        this.attendanceCorrectionRegist = (AttendanceCorrectionRegistBeanInterface)this.createBeanInstance(AttendanceCorrectionRegistBeanInterface.class);
        this.restRegist = (RestRegistBeanInterface)this.createBeanInstance(RestRegistBeanInterface.class);
        this.goOutRegist = (GoOutRegistBeanInterface)this.createBeanInstance(GoOutRegistBeanInterface.class);
        this.subHolidayRegist = (SubHolidayRegistBeanInterface)this.createBeanInstance(SubHolidayRegistBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBeanInstance(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBeanInstance(WorkflowCommentRegistBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBeanInstance(CutoffUtilBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
        this.addonBeans = this.getAddonBeans();
        this.setTimeMaster((TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class));
    }

    public AttendanceDtoInterface getInitDto() {
        return new TmdAttendanceDto();
    }

    public void regist(AttendanceDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork()) == null) {
            this.insert(dto);
        } else {
            this.add(dto);
        }
    }

    protected void insert(AttendanceDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdAttendanceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (AttendanceRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.insert(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void add(AttendanceDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdAttendanceId());
        dto.setTmdAttendanceId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (AttendanceRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.add(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkInsert(AttendanceDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork()));
    }

    protected void checkAdd(AttendanceDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdAttendanceId());
    }

    public void checkValidate(AttendanceDtoInterface dto) throws MospException {
        this.checkTimeValidity(dto);
        this.attendanceReference.chkBasicInfo(dto.getPersonalId(), dto.getWorkDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
    }

    protected void validate(AttendanceDtoInterface dto) {
    }

    public void checkDraft(AttendanceDtoInterface dto) throws MospException {
        this.requestUtil.setRequests(dto.getPersonalId(), dto.getWorkDate());
        this.checkTemporaryClosingFinal(dto);
        if (dto.getStartTime() != null || dto.getEndTime() != null) {
            this.setTimeSettings(dto.getPersonalId(), dto.getWorkDate());
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDraftStartTimeForWork(dto);
            this.checkDraftEndTimeForWork(dto);
        }
        this.checkWorkOnHolidayRequest(dto);
        this.checkHolidayRequest(dto);
    }

    public void checkAppli(AttendanceDtoInterface dto) throws MospException {
        this.checkDraft(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkPeriod(dto);
        this.checkLateEarlyTime(dto);
        this.checkOvertime(dto);
        this.checkRequest(dto);
        this.checkPaidLeaveTime(dto);
        this.checkPaidLeaveTimeForShortTime(dto);
        this.checkAttendance(dto);
        for (AttendanceRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkAppli(dto);
        }
        this.doAdditionalLogic(new Object[]{"Add_AttendanceRegistBean_CheckAppli", dto});
    }

    public void checkCancelAppli(AttendanceDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        this.checkSubHoliday(dto, this.mospParams.getName("Release"));
    }

    public void checkDelete(AttendanceDtoInterface dto) throws MospException {
        this.checkSubHoliday(dto, this.mospParams.getName("Delete"));
    }

    public void checkApproval(AttendanceDtoInterface dto) throws MospException {
        this.checkAppli(dto);
        this.checkTomorrowAttendance(dto);
    }

    public void checkCancelApproval(AttendanceDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
    }

    public void checkCancel(AttendanceDtoInterface dto) throws MospException {
        this.checkSubHoliday(dto, this.mospParams.getName("Release"));
    }

    protected void checkPeriod(AttendanceDtoInterface dto) {
        int checkPeriodDays = this.mospParams.getApplicationProperty(APP_KEY_APPLICABLE_LIMIT_ATTENDANCE, 0);
        if (checkPeriodDays == 0) {
            return;
        }
        if (checkPeriodDays > 100) {
            int targetMonth = checkPeriodDays - 100;
            if (dto.getWorkDate().after(DateUtility.addMonth((Date)this.getSystemDate(), (int)targetMonth)) || dto.getWorkDate().equals(DateUtility.addMonth((Date)this.getSystemDate(), (int)targetMonth))) {
                this.addAttendancePeriodErrorMessage(targetMonth + this.mospParams.getName("Months"));
            }
            return;
        }
        if (dto.getWorkDate().after(DateUtility.addDay((Date)this.getSystemDate(), (int)checkPeriodDays)) || dto.getWorkDate().equals(DateUtility.addDay((Date)this.getSystemDate(), (int)checkPeriodDays))) {
            this.addAttendancePeriodErrorMessage(checkPeriodDays + this.mospParams.getName("Day"));
        }
    }

    protected void checkLateEarlyTime(AttendanceDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        Date workDate = dto.getWorkDate();
        this.setTimeSettings(personalId, workDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.requestUtil.setRequests(personalId, workDate);
        List holidayList = this.requestUtil.getHolidayList(false);
        List subHolidayList = this.requestUtil.getSubHolidayList(false);
        if (this.checkLateLimit(dto, this.timeSettingDto)) {
            this.checkLateTime(workDate, holidayList, subHolidayList);
        }
        if (this.checkLeaveEarlyLimit(dto, this.timeSettingDto)) {
            this.checkLeaveEarlyTime(workDate, holidayList, subHolidayList);
        }
    }

    public void checkLateTime(Date workDate, List<HolidayRequestDtoInterface> holidayList, List<SubHolidayRequestDtoInterface> subHolidayList) {
        for (HolidayRequestDtoInterface holidayRequestDto : holidayList) {
            if (holidayRequestDto.getHolidayRange() != 2) continue;
            return;
        }
        for (SubHolidayRequestDtoInterface subHolidayDto : subHolidayList) {
            if (subHolidayDto.getHolidayRange() != 2) continue;
            return;
        }
        this.getArdinessTardinessLimitOver(workDate);
    }

    protected void checkLeaveEarlyTime(Date workDate, List<HolidayRequestDtoInterface> holidayList, List<SubHolidayRequestDtoInterface> subHolidayList) {
        for (HolidayRequestDtoInterface holidayRequestDto : holidayList) {
            if (holidayRequestDto.getHolidayRange() != 3) continue;
            return;
        }
        for (SubHolidayRequestDtoInterface subHolidayDto : subHolidayList) {
            if (subHolidayDto.getHolidayRange() != 3) continue;
            return;
        }
        this.getLeaveEarlyLimitOver(workDate);
    }

    public void checkHolidayTime(String personalId, Date workDate, List<RestDtoInterface> restList, List<GoOutDtoInterface> goOutPublicList, List<GoOutDtoInterface> goOutPrivateList) throws MospException {
        String workDateString = DateUtility.getStringDateAndDay((Date)workDate);
        this.requestUtil.setRequests(personalId, workDate);
        List holidayList = this.requestUtil.getHolidayList(true);
        for (HolidayRequestDtoInterface holidayDto : holidayList) {
            if (holidayDto.getHolidayRange() != 4) continue;
            Date startTime = holidayDto.getStartTime();
            Date endTime = holidayDto.getEndTime();
            for (RestDtoInterface restDto : restList) {
                if (!this.checkDuplicationTimeZone(startTime, endTime, restDto.getRestStart(), restDto.getRestEnd())) continue;
                String[] rep = new String[]{workDateString, this.mospParams.getName("HolidayTime"), this.mospParams.getName("Rest" + restDto.getRest())};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            for (GoOutDtoInterface goOutDto : goOutPublicList) {
                if (!this.checkDuplicationTimeZone(startTime, endTime, goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Official"));
                sb.append(this.mospParams.getName("GoingOut"));
                sb.append(goOutDto.getTimesGoOut());
                String[] rep = new String[]{workDateString, this.mospParams.getName("HolidayTime"), sb.toString()};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            for (GoOutDtoInterface goOutDto : goOutPrivateList) {
                if (!this.checkDuplicationTimeZone(startTime, endTime, goOutDto.getGoOutStart(), goOutDto.getGoOutEnd())) continue;
                String[] rep = new String[]{workDateString, this.mospParams.getName("HolidayTime"), this.mospParams.getName("PrivateGoingOut" + goOutDto.getTimesGoOut())};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
        }
    }

    public void checkDraftStartTimeForWork(AttendanceDtoInterface dto) throws MospException {
        if (dto.getStartTime() == null) {
            return;
        }
        if (this.doAdditionalLogic(new Object[]{"AttendanceCheckAddons", "Add_CheckStartTime", dto})) {
            return;
        }
        String workDate = this.getStringDate(dto.getWorkDate());
        if (!dto.getStartTime().before(this.addDay(dto.getWorkDate(), 1))) {
            this.mospParams.addErrorMessage("TMW0235", new String[]{workDate, DateUtility.getStringTime((Date)DateUtility.addHour((Date)DateUtility.getDefaultTime(), (int)24), (Date)DateUtility.getDefaultTime()), this.getNameStartTimeForWork()});
        }
        if (!dto.getStartTime().before(this.getTime(this.timeSettingDto.getStartDayTime(), dto.getWorkDate()))) {
            return;
        }
        AttendanceDtoInterface yesterdayDto = this.attendanceReference.findForKey(dto.getPersonalId(), this.addDay(dto.getWorkDate(), -1));
        if (yesterdayDto == null || yesterdayDto.getEndTime() == null) {
            return;
        }
        if (!dto.getStartTime().before(yesterdayDto.getEndTime())) {
            return;
        }
        String rep = this.mospParams.getName("Ahead", new String[]{"Day", "Kara"});
        this.mospParams.addErrorMessage("TMW0239", new String[]{workDate, rep, DateUtility.getStringTime((Date)this.timeSettingDto.getStartDayTime()), DateUtility.getStringTime((Date)DateUtility.addHour((Date)this.timeSettingDto.getStartDayTime(), (int)24), (Date)DateUtility.getDefaultTime())});
    }

    public void checkDraftEndTimeForWork(AttendanceDtoInterface dto) throws MospException {
        if (dto.getEndTime() == null) {
            return;
        }
        if (this.doAdditionalLogic(new Object[]{"AttendanceCheckAddons", "Add_CheckEndTime", dto})) {
            return;
        }
        String workDate = this.getStringDate(dto.getWorkDate());
        Date tomorrowDate = this.addDay(dto.getWorkDate(), 1);
        Date afterTwentyFourHoursTime = this.getTime(this.timeSettingDto.getStartDayTime(), tomorrowDate);
        String afterTwentyFourHours = DateUtility.getStringTime((Date)afterTwentyFourHoursTime, (Date)dto.getWorkDate());
        if (dto.getEndTime().compareTo(afterTwentyFourHoursTime) > 0) {
            this.mospParams.addErrorMessage("TMW0235", new String[]{workDate, afterTwentyFourHours, this.getNameEndTimeForWork()});
        }
        RequestUtilBeanInterface tomorrowRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        tomorrowRequestUtil.setRequests(dto.getPersonalId(), tomorrowDate);
        AttendanceDtoInterface tomorrowDto = tomorrowRequestUtil.getApplicatedAttendance();
        if (tomorrowDto == null || tomorrowDto.getStartTime() == null) {
            return;
        }
        if (dto.getEndTime().compareTo(tomorrowDto.getStartTime()) < 0) {
            return;
        }
        if (dto.getEndTime().equals(tomorrowDto.getStartTime()) && afterTwentyFourHoursTime.equals(dto.getEndTime())) {
            return;
        }
        this.mospParams.addErrorMessage("TMW0341", new String[0]);
    }

    public boolean checkLateLimit(AttendanceDtoInterface dto, TimeSettingDtoInterface timeSettingDto) {
        int lateEarlyHalf = DateUtility.getHour((Date)timeSettingDto.getLateEarlyHalf()) * 60 + DateUtility.getMinute((Date)timeSettingDto.getLateEarlyHalf());
        return lateEarlyHalf < dto.getLateTime();
    }

    public boolean checkLeaveEarlyLimit(AttendanceDtoInterface dto, TimeSettingDtoInterface timeSettingDto) {
        int lateEarlyHalf = DateUtility.getHour((Date)timeSettingDto.getLateEarlyHalf()) * 60 + DateUtility.getMinute((Date)timeSettingDto.getLateEarlyHalf());
        return lateEarlyHalf < dto.getLeaveEarlyTime();
    }

    public void checkOvertime(AttendanceDtoInterface dto) throws MospException {
        boolean overTimeAfter;
        this.setCutoffSettings(dto.getPersonalId(), dto.getWorkDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        int noApproval = this.cutoffDto.getNoApproval();
        if (noApproval != 2) {
            return;
        }
        boolean overTimeBefore = dto.getOvertimeBefore() > 0;
        boolean bl = overTimeAfter = dto.getOvertimeAfter() > 0;
        if (!overTimeBefore && !overTimeAfter) {
            return;
        }
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto != null && workOnHolidayRequestDto.getSubstitute() == 2) {
            return;
        }
        List overtimeRequestList = this.requestUtil.getOverTimeList(true);
        for (OvertimeRequestDtoInterface overtimeRequestDto : overtimeRequestList) {
            int type = overtimeRequestDto.getOvertimeType();
            if (overTimeBefore && type == 1) {
                overTimeBefore = false;
                continue;
            }
            if (!overTimeAfter || type != 2) continue;
            overTimeAfter = false;
        }
        if (!overTimeBefore && !overTimeAfter) {
            return;
        }
        this.mospParams.addErrorMessage("TMW0304", new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("OvertimeWork"), this.mospParams.getName("OvertimeWork")});
    }

    protected void checkRequest(AttendanceDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        Date requestDate = dto.getWorkDate();
        RequestEntityInterface request = this.requestUtil.getRequestEntity(personalId, requestDate);
        Set statuses = WorkflowUtility.getEffectiveWithoutCompletedStatuses();
        this.checkOvertimeRequest((Collection)request.getOvertimeRequestList(statuses));
        if (!MospUtility.isEmpty((Object[])new Object[]{request.getDifferenceRequestDto(statuses)})) {
            TimeMessageUtility.addErrorDifferenceNotCompleted((MospParams)this.mospParams, (Date)requestDate);
        }
        if (!MospUtility.isEmpty((Collection)request.getHolidayRequestList(statuses)) && !request.isWorkOnHolidaySubstituteOff(true)) {
            TimeMessageUtility.addErrorHolidayNotCompleted((MospParams)this.mospParams, (Date)requestDate);
        }
        if (!MospUtility.isEmpty((Collection)request.getSubstituteList(statuses))) {
            TimeMessageUtility.addErrorSubstituteNotCompleted((MospParams)this.mospParams, (Date)requestDate);
        }
        if (!MospUtility.isEmpty((Collection)request.getSubHolidayRequestList(statuses))) {
            TimeMessageUtility.addErrorSubHolidayNotCompleted((MospParams)this.mospParams, (Date)requestDate);
        }
        if (!MospUtility.isEmpty((Object[])new Object[]{request.getWorkTypeChangeRequestDto(statuses)})) {
            TimeMessageUtility.addErrorWorkTypeChangeNotCompleted((MospParams)this.mospParams, (Date)requestDate);
        }
        for (HolidayRequestDtoInterface holiday : request.getHolidayRequestList(true)) {
            this.checkHolidayRequestTime(holiday, dto, request.getDifferenceRequestDto(true));
        }
    }

    protected void checkOvertimeRequest(Collection<OvertimeRequestDtoInterface> overtimeRequests) {
        if (MospUtility.isEmpty(overtimeRequests)) {
            return;
        }
        Date requestDate = ((OvertimeRequestDtoInterface)MospUtility.getFirstValue(overtimeRequests)).getRequestDate();
        TimeMessageUtility.addErrorOvertimeNotCompleted((MospParams)this.mospParams, (Date)requestDate);
    }

    protected void checkHolidayRequestTime(HolidayRequestDtoInterface holidayRequest, AttendanceDtoInterface dto, DifferenceRequestDtoInterface differenceRequest) throws MospException {
        if (!TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)holidayRequest)) {
            return;
        }
        if (this.doAdditionalLogic(new Object[]{"Add_AttendanceRegistBean_CheckHolidayRequestTime", holidayRequest, dto, differenceRequest})) {
            return;
        }
        String workTypeCode = dto.getWorkTypeCode();
        Date targetDate = dto.getWorkDate();
        WorkTypeEntityInterface workType = this.timeMaster.getWorkTypeEntity(workTypeCode, targetDate, differenceRequest);
        Date startWorkTime = workType.getStartWorkTime();
        Date endWorkTime = workType.getEndWorkTime();
        Date requestStartTime = TimeUtility.getDefaultDateTime((Date)holidayRequest.getStartTime(), (Date)targetDate);
        Date requestEndTime = TimeUtility.getDefaultDateTime((Date)holidayRequest.getEndTime(), (Date)targetDate);
        if (!DateUtility.isTermContain((Date)requestStartTime, (Date)startWorkTime, (Date)endWorkTime) || !DateUtility.isTermContain((Date)requestEndTime, (Date)startWorkTime, (Date)endWorkTime)) {
            TimeMessageUtility.addErrorHorlyHolidayOutOfWorkTypeTime((MospParams)this.mospParams, (Date)startWorkTime, (Date)endWorkTime, null);
        }
    }

    protected void checkWorkOnHolidayRequest(AttendanceDtoInterface dto) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.workOnHolidayRequestDao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getWorkDate());
        if (workOnHolidayRequestDto == null || this.workflowIntegrate.isCompleted(workOnHolidayRequestDto.getWorkflow())) {
            return;
        }
        this.mospParams.addErrorMessage("TMW0278", new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("jp.mosp.time.input.vo.WorkOnHolidayRequestVo")});
    }

    protected boolean isWorkDayForWorkOnHoliday() throws MospException {
        if (this.requestUtil.getWorkOnHolidayDto(true) != null) {
            return true;
        }
        return this.requestUtil.checkHolidayRangeSubstitute(this.requestUtil.getSubstituteList(false)) != 1;
    }

    protected void checkHolidayRequest(AttendanceDtoInterface dto) throws MospException {
        if (!this.isWorkDayForWorkOnHoliday()) {
            this.mospParams.addErrorMessage("TMW0279", new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("ObservedHoliday"), this.mospParams.getName("WorkManage", new String[]{"Application"})});
            return;
        }
        boolean holidayAm = false;
        boolean holidayPm = false;
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null || workOnHolidayRequestDto.getSubstitute() == 1) {
            int holidayRange = this.requestUtil.checkHolidayRangeHoliday(this.requestUtil.getHolidayList(false));
            if (holidayRange == 1) {
                TimeMessageUtility.addErrorNotApplicableForHoliday((MospParams)this.mospParams, (Date)dto.getWorkDate(), null);
                return;
            }
            if (holidayRange == 2) {
                holidayAm = true;
            } else if (holidayRange == 3) {
                holidayPm = true;
            } else if (holidayRange == 5) {
                holidayAm = true;
                holidayPm = true;
            }
        }
        boolean subHolidayAm = false;
        boolean subHolidayPm = false;
        int subHolidayRange = this.requestUtil.checkHolidayRangeSubHoliday(this.requestUtil.getSubHolidayList(false));
        if (subHolidayRange == 1) {
            String[] rep = new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("CompensatoryHoliday"), this.mospParams.getName("WorkManage", new String[]{"Application"})};
            this.mospParams.addErrorMessage("TMW0279", rep);
            return;
        }
        if (subHolidayRange == 2) {
            subHolidayAm = true;
        } else if (subHolidayRange == 3) {
            subHolidayPm = true;
        } else if (subHolidayRange == 5) {
            subHolidayAm = true;
            subHolidayPm = true;
        }
        boolean substituteAm = false;
        boolean substitutePm = false;
        int substituteRange = this.getSubstituteRange(dto);
        if (substituteRange == 1) {
            String[] rep = new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("ObservedHoliday"), this.mospParams.getName("WorkManage", new String[]{"Application"})};
            this.mospParams.addErrorMessage("TMW0279", rep);
            return;
        }
        if (substituteRange == 2) {
            substituteAm = true;
        } else if (substituteRange == 3) {
            substitutePm = true;
        } else if (substituteRange == 5) {
            substituteAm = true;
            substitutePm = true;
        }
        if ((holidayAm || subHolidayAm || substituteAm) && (holidayPm || subHolidayPm || substitutePm)) {
            String[] rep = new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("WorkManage", new String[]{"Application"})};
            this.mospParams.addErrorMessage("TMW0338", rep);
        }
    }

    public void checkTimeExist(AttendanceDtoInterface dto) {
        if (dto.getStartTime() == null && dto.getEndTime() == null) {
            this.mospParams.addErrorMessage("TMW0268", new String[0]);
            return;
        }
    }

    public void checkTimeValidity(AttendanceDtoInterface dto) {
        Date startTime = dto.getStartTime();
        Date endTime = dto.getEndTime();
        if (startTime == null || endTime == null) {
            return;
        }
        this.checkWorkTime(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (startTime.compareTo(endTime) >= 0) {
            PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)TimeNamingUtility.endWork((MospParams)this.mospParams), (String)TimeNamingUtility.startWork((MospParams)this.mospParams));
        }
    }

    protected void checkWorkTime(AttendanceDtoInterface dto) {
        if (dto.getWorkTime() < 0) {
            this.mospParams.addErrorMessage("TMW0325", new String[0]);
        }
    }

    protected void checkAttendance(AttendanceDtoInterface dto) throws MospException {
        AttendanceDtoInterface attendanceDto = this.dao.findForKey(dto.getPersonalId(), dto.getWorkDate(), 1);
        if (attendanceDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(attendanceDto.getWorkflow());
        if (workflowDto == null) {
            return;
        }
        if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        if ("3".equals(workflowDto.getWorkflowStatus()) && workflowDto.getWorkflowStage() == 0) {
            return;
        }
        if (dto.getWorkflow() == workflowDto.getWorkflow()) {
            return;
        }
        TimeMessageUtility.addErrorAlreadyApplyWork((MospParams)this.mospParams, (Date)dto.getWorkDate(), null);
    }

    protected void checkRequired(AttendanceDtoInterface dto) {
        this.checkRegistStartTimeForWork(dto);
        this.checkRegistEndTimeForWork(dto);
        this.checkLateReason(dto);
        this.checkLeaveEarlyReason(dto);
    }

    protected void checkRegistStartTimeForWork(AttendanceDtoInterface dto) {
        if (dto == null || dto.getStartTime() == null) {
            this.mospParams.addErrorMessage("TMW0233", new String[]{this.getNameStartTimeForWork()});
        }
    }

    protected void checkRegistEndTimeForWork(AttendanceDtoInterface dto) {
        if (dto == null || dto.getEndTime() == null) {
            this.mospParams.addErrorMessage("TMW0233", new String[]{this.getNameEndTimeForWork()});
        }
    }

    protected void checkLateReason(AttendanceDtoInterface dto) {
        if (dto.getActualLateTime() == 0) {
            return;
        }
        if (dto.getLateReason().isEmpty()) {
            this.mospParams.addErrorMessage("TMW0319", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("Tardiness", new String[]{"Reason"})});
        }
    }

    protected void checkLeaveEarlyReason(AttendanceDtoInterface dto) {
        if (dto.getActualLeaveEarlyTime() == 0) {
            return;
        }
        if (dto.getLeaveEarlyReason().isEmpty()) {
            this.mospParams.addErrorMessage("TMW0319", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("LeaveEarly", new String[]{"Reason"})});
        }
    }

    protected void checkPaidLeaveTime(AttendanceDtoInterface dto) throws MospException {
        AttendanceDtoInterface tomorrowDto;
        RequestUtilBeanInterface yesterdayRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        yesterdayRequestUtil.setRequests(dto.getPersonalId(), DateUtility.addDay((Date)dto.getWorkDate(), (int)-1));
        RequestUtilBeanInterface tomorrowRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        tomorrowRequestUtil.setRequests(dto.getPersonalId(), DateUtility.addDay((Date)dto.getWorkDate(), (int)1));
        AttendanceDtoInterface yesterdayDto = yesterdayRequestUtil.getApplicatedAttendance();
        if (yesterdayDto == null) {
            yesterdayDto = yesterdayRequestUtil.getFirstRevertedAttendance();
        }
        if (yesterdayDto == null) {
            yesterdayDto = yesterdayRequestUtil.getDraftAttendance();
        }
        Date yesterdayEndTime = null;
        if (yesterdayDto != null) {
            yesterdayEndTime = yesterdayDto.getEndTime();
        }
        if ((tomorrowDto = tomorrowRequestUtil.getApplicatedAttendance()) == null) {
            tomorrowDto = tomorrowRequestUtil.getFirstRevertedAttendance();
        }
        if (tomorrowDto == null) {
            tomorrowDto = tomorrowRequestUtil.getDraftAttendance();
        }
        Date tomorrowStartTime = null;
        if (tomorrowDto != null) {
            tomorrowStartTime = tomorrowDto.getStartTime();
        }
        if (yesterdayEndTime != null || tomorrowStartTime != null) {
            for (HolidayRequestDtoInterface holidayDto : this.requestUtil.getHolidayList(true)) {
                if (holidayDto.getHolidayRange() != 4) continue;
                if (yesterdayEndTime != null && holidayDto.getStartTime().before(yesterdayEndTime)) {
                    String rep = this.mospParams.getName("Ahead", new String[]{"Day", "Of", "Work", "Time"});
                    this.mospParams.addErrorMessage("TMW0315", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("HolidayTime"), rep});
                    return;
                }
                if (tomorrowStartTime == null || !holidayDto.getEndTime().after(tomorrowStartTime)) continue;
                String rep = this.mospParams.getName("NextDay", new String[]{"Of", "Work", "Time"});
                this.mospParams.addErrorMessage("TMW0315", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("HolidayTime"), rep});
                return;
            }
        }
        if (dto.getStartTime() != null) {
            for (HolidayRequestDtoInterface holidayDto : yesterdayRequestUtil.getHolidayList(false)) {
                if (holidayDto.getHolidayRange() != 4 || !holidayDto.getEndTime().after(dto.getStartTime())) continue;
                String rep = this.mospParams.getName("Ahead", new String[]{"Day", "Of", "HolidayTime"});
                this.mospParams.addErrorMessage("TMW0315", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("Work", new String[]{"Time"}), rep});
                return;
            }
        }
        if (dto.getEndTime() != null) {
            for (HolidayRequestDtoInterface holidayDto : tomorrowRequestUtil.getHolidayList(false)) {
                if (holidayDto.getHolidayRange() != 4 || !holidayDto.getStartTime().before(dto.getEndTime())) continue;
                String rep = this.mospParams.getName("NextDay", new String[]{"Of", "HolidayTime"});
                this.mospParams.addErrorMessage("TMW0315", new String[]{DateUtility.getStringDate((Date)dto.getWorkDate()), this.mospParams.getName("Work", new String[]{"Time"}), rep});
                return;
            }
        }
    }

    protected void checkPaidLeaveTimeForShortTime(AttendanceDtoInterface dto) throws MospException {
        DifferenceRequestDtoInterface differenceRequestDto = this.requestUtil.getDifferenceDto(true);
        if (differenceRequestDto != null) {
            return;
        }
        Date workDate = dto.getWorkDate();
        WorkTypeEntityInterface workTypeEntity = this.timeMaster.getWorkTypeEntity(dto.getWorkTypeCode(), workDate);
        if (workTypeEntity == null) {
            return;
        }
        boolean isShort1TimeSet = workTypeEntity.isShort1TimeSet();
        Date short1StartTime = null;
        Date short1EndTime = null;
        if (isShort1TimeSet) {
            short1StartTime = this.getTime(workTypeEntity.getShort1StartTime(), workDate);
            short1EndTime = this.getTime(workTypeEntity.getShort1EndTime(), workDate);
        }
        boolean isShort2TimeSet = workTypeEntity.isShort2TimeSet();
        Date short2StartTime = null;
        Date short2EndTime = null;
        if (isShort2TimeSet) {
            short2StartTime = this.getTime(workTypeEntity.getShort2StartTime(), workDate);
            short2EndTime = this.getTime(workTypeEntity.getShort2EndTime(), workDate);
        }
        if (!isShort1TimeSet && !isShort2TimeSet) {
            return;
        }
        for (HolidayRequestDtoInterface holidayDto : this.requestUtil.getHolidayList(true)) {
            if (holidayDto.getHolidayRange() != 4) continue;
            if (isShort1TimeSet && this.checkDuplicationTimeZone(holidayDto.getStartTime(), holidayDto.getEndTime(), short1StartTime, short1EndTime)) {
                this.mospParams.addErrorMessage("TMW0312", new String[]{DateUtility.getStringDate((Date)workDate), this.mospParams.getName("ShortTime", new String[]{"Time", "No1"}), this.mospParams.getName("HolidayTime")});
                return;
            }
            if (!isShort2TimeSet || !this.checkDuplicationTimeZone(holidayDto.getStartTime(), holidayDto.getEndTime(), short2StartTime, short2EndTime)) continue;
            this.mospParams.addErrorMessage("TMW0312", new String[]{DateUtility.getStringDate((Date)workDate), this.mospParams.getName("ShortTime", new String[]{"Time", "No2"}), this.mospParams.getName("HolidayTime")});
            return;
        }
    }

    public void checkPrivateGoOut(AttendanceDtoInterface dto, List<RestDtoInterface> restList, List<GoOutDtoInterface> privateList) throws MospException {
        int end;
        int start;
        int count;
        int time;
        int workEnd;
        int workStart;
        WorkflowDtoInterface workflowDto;
        if (dto.getStartTime() == null || dto.getEndTime() == null) {
            return;
        }
        this.requestUtil.setRequests(dto.getPersonalId(), dto.getWorkDate());
        this.setTimeSettings(dto.getPersonalId(), dto.getWorkDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        int regWorkStart = 0;
        int regWorkEnd = 0;
        boolean isWorkOnDayOff = false;
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.requestUtil.getWorkOnHolidayDto(false);
        if (workOnHolidayRequestDto != null && (workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(workOnHolidayRequestDto.getWorkflow())) != null && (this.workflowIntegrate.isApprovable(workflowDto) || WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto)) && workOnHolidayRequestDto.getSubstitute() == 2) {
            isWorkOnDayOff = true;
            regWorkStart = this.getDefferenceMinutes(dto.getWorkDate(), dto.getStartTime());
            regWorkEnd = this.getDefferenceMinutes(dto.getWorkDate(), dto.getEndTime());
        }
        boolean isDifferenceWork = false;
        DifferenceRequestDtoInterface differenceDto = this.requestUtil.getDifferenceDto(true);
        if (differenceDto != null) {
            isDifferenceWork = true;
            regWorkStart = this.getDefferenceMinutes(dto.getWorkDate(), differenceDto.getRequestStart());
            regWorkEnd = this.getDefferenceMinutes(dto.getWorkDate(), differenceDto.getRequestEnd());
        }
        if (!isWorkOnDayOff && !isDifferenceWork) {
            WorkTypeItemDtoInterface workStartDto = this.workTypeItemDao.findForInfo(dto.getWorkTypeCode(), dto.getWorkDate(), "WorkStart");
            WorkTypeItemDtoInterface workEndDto = this.workTypeItemDao.findForInfo(dto.getWorkTypeCode(), dto.getWorkDate(), "WorkEnd");
            if (workStartDto == null || workEndDto == null) {
                this.addWorkTypeNotExistErrorMessage(dto.getWorkDate());
                return;
            }
            regWorkStart = this.getDefferenceMinutes(this.getDefaultStandardDate(), workStartDto.getWorkTypeItemValue());
            regWorkEnd = this.getDefferenceMinutes(this.getDefaultStandardDate(), workEndDto.getWorkTypeItemValue());
        }
        if ((workStart = this.getDefferenceMinutes(dto.getWorkDate(), dto.getStartTime())) < regWorkStart) {
            workStart = regWorkStart;
        }
        if ((workEnd = this.getDefferenceMinutes(dto.getWorkDate(), dto.getEndTime())) > regWorkEnd) {
            workEnd = regWorkEnd;
        }
        TreeMap<Integer, Integer> restMap = new TreeMap<Integer, Integer>();
        for (RestDtoInterface restDtoInterface : restList) {
            int start2 = this.getDefferenceMinutes(dto.getWorkDate(), restDtoInterface.getRestStart());
            int end3 = this.getDefferenceMinutes(dto.getWorkDate(), restDtoInterface.getRestEnd());
            if (start2 >= regWorkEnd || end3 <= regWorkStart) continue;
            if (start2 < workStart) {
                start2 = workStart;
            }
            if (end3 > workEnd) {
                end3 = workEnd;
            }
            if (restMap.containsKey(start2) && (Integer)restMap.get(start2) >= end3) continue;
            restMap.put(start2, end3);
        }
        TreeMap<Integer, GoOutDtoInterface> privateMap = new TreeMap<Integer, GoOutDtoInterface>();
        for (GoOutDtoInterface privateDto : privateList) {
            GoOutDtoInterface goOutDto;
            int start3 = this.getDefferenceMinutes(dto.getWorkDate(), privateDto.getGoOutStart());
            int end4 = this.getDefferenceMinutes(dto.getWorkDate(), privateDto.getGoOutEnd());
            if (start3 >= regWorkEnd || end4 <= regWorkStart) continue;
            if (start3 < workStart) {
                start3 = workStart;
            }
            if (end4 > workEnd) {
                end4 = workEnd;
            }
            if ((goOutDto = (GoOutDtoInterface)privateMap.get(start3)) == null) {
                privateMap.put(start3, privateDto);
                continue;
            }
            int goOutEnd = this.getDefferenceMinutes(dto.getWorkDate(), goOutDto.getGoOutEnd());
            if (goOutEnd > workEnd) {
                goOutEnd = workEnd;
            }
            if (goOutEnd >= end4) continue;
            privateMap.put(start3, privateDto);
        }
        int n = this.getDefferenceMinutes(this.getDefaultStandardDate(), this.timeSettingDto.getLateEarlyHalf());
        int holidayRange = this.requestUtil.checkHolidayRangeHoliday(this.requestUtil.getHolidayList(false));
        int subHolidayRange = this.requestUtil.checkHolidayRangeSubHoliday(this.requestUtil.getSubHolidayList(false));
        if (holidayRange != 2 && subHolidayRange != 2 && dto.getLateTime() <= n) {
            time = workStart;
            int privateTime = dto.getLateTime();
            while (privateTime <= n) {
                count = 0;
                for (Map.Entry entry : privateMap.entrySet()) {
                    GoOutDtoInterface privateDto = (GoOutDtoInterface)entry.getValue();
                    start = (Integer)entry.getKey();
                    int end2 = this.getDefferenceMinutes(dto.getWorkDate(), privateDto.getGoOutEnd());
                    if (end2 > workEnd) {
                        end2 = workEnd;
                    }
                    if (start != time || end2 <= time) continue;
                    privateTime += privateDto.getGoOutTime();
                    time = end2;
                    ++count;
                }
                for (Map.Entry entry : restMap.entrySet()) {
                    int start4 = (Integer)entry.getKey();
                    end = (Integer)entry.getValue();
                    if (start4 != time || end <= time) continue;
                    time = end;
                    ++count;
                }
                if (count != 0) continue;
                break;
            }
            if (privateTime > n) {
                this.mospParams.addErrorMessage("TMW0282", new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("PrivateGoingOut"), this.mospParams.getName("Tardiness"), this.mospParams.getName("AmRest")});
                return;
            }
        }
        if (holidayRange != 3 && subHolidayRange != 3 && dto.getLeaveEarlyTime() <= n) {
            time = workEnd;
            int privateTime = dto.getLeaveEarlyTime();
            while (privateTime <= n) {
                count = 0;
                for (Map.Entry entry : privateMap.entrySet()) {
                    GoOutDtoInterface privateDto = (GoOutDtoInterface)entry.getValue();
                    start = (Integer)entry.getKey();
                    int end2 = this.getDefferenceMinutes(dto.getWorkDate(), privateDto.getGoOutEnd());
                    if (end2 > workEnd) {
                        end2 = workEnd;
                    }
                    if (end2 != time || start >= time) continue;
                    privateTime += privateDto.getGoOutTime();
                    time = start;
                    ++count;
                }
                for (Map.Entry entry : restMap.entrySet()) {
                    int start5 = (Integer)entry.getKey();
                    end = (Integer)entry.getValue();
                    if (end != time || start5 >= time) continue;
                    time = start5;
                    ++count;
                }
                if (count != 0) continue;
                break;
            }
            if (privateTime > n) {
                this.mospParams.addErrorMessage("TMW0282", new String[]{this.getStringDate(dto.getWorkDate()), this.mospParams.getName("PrivateGoingOut"), this.mospParams.getName("LeaveEarly"), this.mospParams.getName("PmRest")});
            }
        }
    }

    protected void checkTemporaryClosingFinal(AttendanceDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getWorkDate(), this.getNameWorkDate());
    }

    public void checkApprover(AttendanceDtoInterface dto, WorkflowDtoInterface workDto) throws MospException {
        String approverId = workDto.getApproverId();
        if ("SELF_APPRO".equals(approverId)) {
            return;
        }
        String[] arrayApproverId = approverId.split(",");
        String approver = PfNameUtility.approver((MospParams)this.mospParams);
        for (String element : arrayApproverId) {
            if (element.isEmpty()) {
                if (0 < arrayApproverId.length) continue;
                PfMessageUtility.addErrorCnaNotGet((MospParams)this.mospParams, (String)approver, (String)this.getNameWorkDate());
                continue;
            }
            if (!this.isEntered(element, dto.getWorkDate())) {
                PfMessageUtility.addErrorCnaNotGet((MospParams)this.mospParams, (String)approver, (String)this.getNameWorkDate());
            }
            if (!this.retirementReference.isRetired(element, dto.getWorkDate())) continue;
            PfMessageUtility.addErrorCnaNotGet((MospParams)this.mospParams, (String)approver, (String)this.getNameWorkDate());
        }
    }

    protected void checkTomorrowAttendance(AttendanceDtoInterface dto) throws MospException {
        RequestUtilBeanInterface tomorrowRequestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        tomorrowRequestUtil.setRequests(dto.getPersonalId(), this.addDay(dto.getWorkDate(), 1));
        AttendanceDtoInterface tomorrowDto = tomorrowRequestUtil.getApplicatedAttendance();
        if (tomorrowDto == null || tomorrowDto.getStartTime() == null) {
            return;
        }
        if (tomorrowDto.getStartTime().before(dto.getEndTime())) {
            this.mospParams.addErrorMessage("TMW0286", new String[]{this.getStringDate(dto.getWorkDate())});
        }
    }

    protected void checkSubHoliday(AttendanceDtoInterface dto, String operationName) throws MospException {
        List legalList = this.subHolidayDao.findForList(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), 2);
        if (this.isAppliSubHoliday(legalList)) {
            this.addSubHolidayRequestedErrorMessage(operationName);
            return;
        }
        List prescribedList = this.subHolidayDao.findForList(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), 1);
        if (this.isAppliSubHoliday(prescribedList)) {
            this.addSubHolidayRequestedErrorMessage(operationName);
            return;
        }
        List nightList = this.subHolidayDao.findForList(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), 3);
        if (this.isAppliSubHoliday(nightList)) {
            this.addSubHolidayRequestedErrorMessage(operationName);
            return;
        }
    }

    int getSubstituteRange(AttendanceDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        List substituteDtoList = this.requestUtil.getSubstituteList(false);
        int substituteRange = this.requestUtil.checkHolidayRangeSubstitute(substituteDtoList);
        int workOnHolidayRange = 0;
        WorkOnHolidayRequestDtoInterface workOnHolidayDto = this.workOnHolidayRequestDao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getWorkDate());
        if (workOnHolidayDto != null && WorkflowUtility.isApplied((WorkflowDtoInterface)(workflowDto = this.workflowReference.getLatestWorkflowInfo(workOnHolidayDto.getWorkflow()))) && !WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto)) {
            if (workOnHolidayDto.getSubstitute() == 3) {
                workOnHolidayRange = 2;
            } else if (workOnHolidayDto.getSubstitute() == 4) {
                workOnHolidayRange = 3;
            }
        }
        return substituteRange - workOnHolidayRange;
    }

    protected boolean isAppliSubHoliday(List<SubHolidayRequestDtoInterface> list) throws MospException {
        for (SubHolidayRequestDtoInterface subHolidayRequestDto : list) {
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(subHolidayRequestDto.getWorkflow());
            if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) continue;
            return true;
        }
        return false;
    }

    protected void addSubHolidayRequestedErrorMessage(String operationName) {
        TimeMessageUtility.addErrorDoAfterRocess((MospParams)this.mospParams, (String)TimeNamingUtility.subHolidayRequest((MospParams)this.mospParams), (String)operationName);
    }

    public void delete(String personalId, Date workDate) throws MospException {
        AttendanceDtoInterface dto = this.dao.findForKey(personalId, workDate, 1);
        if (dto == null) {
            return;
        }
        this.workflowRegist.delete(this.workflowReference.getLatestWorkflowInfo(dto.getWorkflow()));
        this.workflowCommentRegist.deleteList(this.workflowCommentReference.getWorkflowCommentList(dto.getWorkflow()));
        this.restRegist.delete(personalId, workDate, 1);
        this.goOutRegist.delete(personalId, workDate, 1);
        this.attendanceCorrectionRegist.delete(personalId, workDate, 1);
        this.delete(dto);
        this.subHolidayRegist.delete(personalId, workDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (AttendanceRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.delete(personalId, workDate);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void delete(AttendanceDtoInterface dto) throws MospException {
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdAttendanceId());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (AttendanceRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.delete(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected String getNameWorkDate() {
        return this.mospParams.getName("Work", new String[]{"Day"});
    }

    protected String getNameStartTimeForWork() {
        return this.mospParams.getName("StartWork", new String[]{"Moment"});
    }

    protected String getNameEndTimeForWork() {
        return this.mospParams.getName("EndWork", new String[]{"Moment"});
    }

    protected void getArdinessTardinessLimitOver(Date workDate) {
        this.mospParams.addErrorMessage("TMW0282", new String[]{this.getStringDate(workDate), this.mospParams.getName("Tardiness"), this.mospParams.getName("Tardiness"), this.mospParams.getName("AmRest")});
    }

    protected void getLeaveEarlyLimitOver(Date workDate) {
        this.mospParams.addErrorMessage("TMW0282", new String[]{this.getStringDate(workDate), this.mospParams.getName("LeaveEarly"), this.mospParams.getName("LeaveEarly"), this.mospParams.getName("PmRest")});
    }

    protected List<AttendanceRegistAddonBeanInterface> getAddonBeans() throws MospException {
        ArrayList<AttendanceRegistAddonBeanInterface> addonBeans = new ArrayList<AttendanceRegistAddonBeanInterface>();
        for (String[] addon : this.mospParams.getProperties().getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            AttendanceRegistAddonBeanInterface bean = (AttendanceRegistAddonBeanInterface)this.createBean(addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
        this.requestUtil.setTimeMaster(timeMaster);
        this.cutoffUtil.setTimeMaster(timeMaster);
    }
}

