/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.impl.TimeBaseExportBean;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;

public class AttendanceReapplicationExportBean
extends TimeBaseExportBean {
    protected AttendanceDaoInterface attendanceDao;
    protected ScheduleUtilBeanInterface scheduleUtil;

    public void initBean() throws MospException {
        super.initBean();
        this.attendanceDao = (AttendanceDaoInterface)this.createDaoInstance(AttendanceDaoInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.scheduleUtil.setTimeMaster(this.timeMaster);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date firstDate, Date lastDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, boolean needLowerSection, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        List humanList = this.getHumanList(lastDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, needLowerSection, positionCode);
        Map humans = PlatformUtility.getPersonalIdDtoMap((Collection)humanList);
        List dtos = this.findAttendanceList(humanList, firstDate, lastDate);
        for (AttendanceDtoInterface dto : dtos) {
            csvDataList.add(this.makeCsvData(dto, (HumanDtoInterface)humans.get(dto.getPersonalId()), fieldList, lastDate));
        }
        return csvDataList;
    }

    protected String[] makeCsvData(AttendanceDtoInterface dto, HumanDtoInterface humanDto, List<String> fieldList, Date targetDate) throws MospException {
        String[] csvData = this.getHumanCsvData(fieldList, humanDto, targetDate);
        this.setCsvValue(csvData, fieldList, "work_date", (Object)DateUtility.getStringDate((Date)dto.getWorkDate()));
        return csvData;
    }

    protected List<AttendanceDtoInterface> findAttendanceList(List<HumanDtoInterface> list, Date firstDate, Date lastDate) throws MospException {
        ArrayList<AttendanceDtoInterface> attendanceList = new ArrayList<AttendanceDtoInterface>();
        for (HumanDtoInterface dto : list) {
            List attendanceDtoList = this.findAttendanceList(dto.getPersonalId(), firstDate, lastDate);
            if (attendanceDtoList.isEmpty()) continue;
            attendanceList.addAll(attendanceDtoList);
        }
        return attendanceList;
    }

    protected List<AttendanceDtoInterface> findAttendanceList(String personalId, Date firstDate, Date lastDate) throws MospException {
        ArrayList<AttendanceDtoInterface> list = new ArrayList<AttendanceDtoInterface>();
        for (AttendanceDtoInterface dto : this.attendanceDao.findForReapplicationExport(personalId, firstDate, lastDate)) {
            if (!this.isReapplicationTarget(dto)) continue;
            list.add(dto);
        }
        return list;
    }

    protected String getTomorrowWorkTypeCode(AttendanceDtoInterface dto) throws MospException {
        return this.getWorkTypeCode(dto.getPersonalId(), this.addDay(dto.getWorkDate(), 1));
    }

    protected String getWorkTypeCode(String personalId, Date targetDate) throws MospException {
        return this.scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate, true);
    }

    protected boolean isReapplicationTarget(AttendanceDtoInterface dto) throws MospException {
        return this.isReapplicationTarget(dto, this.getTomorrowWorkTypeCode(dto));
    }

    protected boolean isReapplicationTarget(AttendanceDtoInterface dto, String tomorrowWorkTypeCode) {
        return dto.getLegalWorkTime() > 0 && !"work_on_legal".equals(dto.getWorkTypeCode()) && !"legal_holiday".equals(tomorrowWorkTypeCode) && !"work_on_legal".equals(tomorrowWorkTypeCode) || this.addDay(dto.getWorkDate(), 1).before(dto.getEndTime()) && dto.getLegalWorkTime() == 0 && ("legal_holiday".equals(tomorrowWorkTypeCode) || "work_on_legal".equals(tomorrowWorkTypeCode));
    }
}

