/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.AttendanceCorrectionReferenceBeanInterface;
import jp.mosp.time.bean.HolidayReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.AttendanceCorrectionDaoInterface;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeCorrectionDtoInterface;
import jp.mosp.time.utils.TimeNamingUtility;

public class AttendanceCorrectionReferenceBean
extends PlatformBean
implements AttendanceCorrectionReferenceBeanInterface {
    protected AttendanceCorrectionDaoInterface dao;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected HolidayReferenceBeanInterface holidayReference;

    public void initBean() throws MospException {
        this.dao = (AttendanceCorrectionDaoInterface)this.createDaoInstance(AttendanceCorrectionDaoInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBeanInstance(WorkTypeReferenceBeanInterface.class);
        this.holidayReference = (HolidayReferenceBeanInterface)this.createBeanInstance(HolidayReferenceBeanInterface.class);
    }

    public AttendanceCorrectionDtoInterface getLatestAttendanceCorrectionInfo(String personalId, Date workDate, int works) throws MospException {
        return this.dao.findForLatestInfo(personalId, workDate, works);
    }

    public List<AttendanceCorrectionDtoInterface> getAttendanceCorrectionHistory(String personalId, Date workDate, int works) throws MospException {
        return this.dao.findForHistory(personalId, workDate, works);
    }

    public Map<Date, List<AttendanceCorrectionDtoInterface>> getCorrections(String personalId, Date firstDate, Date lastDate) throws MospException {
        return this.dao.findForTerm(personalId, firstDate, lastDate);
    }

    public Map<String, Set<AttendanceCorrectionDtoInterface>> getCorrections(Set<String> personalIds, Date workDate) throws MospException {
        return PlatformUtility.getPersonalIdMap((Collection)this.dao.findForPersonalIds(personalIds, workDate));
    }

    public String getCorrectionValue(String code, String value, Date targetDate) throws MospException {
        if (value.equals(this.mospParams.getName("Hyphen"))) {
            return value;
        }
        if (code.equals("1")) {
            if (this.workTypeReference != null) {
                return this.workTypeReference.getWorkTypeAbbr(value, targetDate);
            }
            return "";
        }
        if (code.equals("4")) {
            if (value.equals("1")) {
                return this.mospParams.getName("DirectStart");
            }
            return "";
        }
        if (code.equals("5")) {
            if (value.equals("1")) {
                return this.mospParams.getName("DirectEnd");
            }
            return "";
        }
        if (code.equals("7") || code.equals("10") || code.equals("13") || code.equals("14") || code.equals("15") || code.equals("16") || code.equals("17") || code.equals("18") || code.equals("19") || code.equals("20") || code.equals("21") || code.equals("22")) {
            if (value.equals("0")) {
                return this.mospParams.getName("Without");
            }
            if (value.equals("1")) {
                return this.mospParams.getName("Yes");
            }
            return "";
        }
        if (code.equals("2") || code.equals("3") || code.equals("33") || code.equals("34") || code.equals("12") || code.equals("8") || code.equals("11") || code.equals("23") || code.equals("24") || code.equals("25") || code.equals("26") || code.equals("27") || code.equals("28") || code.equals("29") || code.equals("30") || code.equals("31") || code.equals("32")) {
            return value;
        }
        if (code.equals("6") || code.equals("9")) {
            if ("individu".equals(value)) {
                return this.mospParams.getName("Personal", new String[]{"Convenience"});
            }
            if ("bad_health".equals(value)) {
                return this.mospParams.getName("PhysicalCondition", new String[]{"Bad"});
            }
            if ("others".equals(value)) {
                return this.mospParams.getName("Others");
            }
            if ("train".equals(value)) {
                return this.mospParams.getName("Train", new String[]{"Delay"});
            }
            if ("company".equals(value)) {
                return this.mospParams.getName("Company", new String[]{"Directions"});
            }
            return "";
        }
        return code;
    }

    public String getHistoryAttendanceMoreName(String code) {
        if (code.equals("1")) {
            return this.mospParams.getName("Work", new String[]{"Form"});
        }
        if (code.equals("2")) {
            return this.mospParams.getName("GoingWork", new String[]{"Moment"});
        }
        if (code.equals("3")) {
            return this.mospParams.getName("RetireOffice", new String[]{"Moment"});
        }
        if (code.equals("33")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Fact"));
            sb.append(this.mospParams.getName("GoingWork"));
            sb.append(this.mospParams.getName("Moment"));
            return sb.toString();
        }
        if (code.equals("34")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Fact"));
            sb.append(this.mospParams.getName("RetireOffice"));
            sb.append(this.mospParams.getName("Moment"));
            return sb.toString();
        }
        if (code.equals("4")) {
            return this.mospParams.getName("DirectStart");
        }
        if (code.equals("5")) {
            return this.mospParams.getName("DirectEnd");
        }
        if (code.equals("6")) {
            return this.mospParams.getName("Tardiness", new String[]{"Reason"});
        }
        if (code.equals("7")) {
            return this.mospParams.getName("Tardiness", new String[]{"Certificates"});
        }
        if (code.equals("8")) {
            return this.mospParams.getName("Tardiness", new String[]{"Comment"});
        }
        if (code.equals("9")) {
            return this.mospParams.getName("LeaveEarly", new String[]{"Reason"});
        }
        if (code.equals("10")) {
            return this.mospParams.getName("LeaveEarly", new String[]{"Certificates"});
        }
        if (code.equals("11")) {
            return this.mospParams.getName("LeaveEarly", new String[]{"Comment"});
        }
        if (code.equals("12")) {
            return this.mospParams.getName("WorkManage", new String[]{"Comment"});
        }
        if (code.equals("13")) {
            return this.mospParams.getName("Allowance", new String[]{"No1"});
        }
        if (code.equals("14")) {
            return this.mospParams.getName("Allowance", new String[]{"No2"});
        }
        if (code.equals("15")) {
            return this.mospParams.getName("Allowance", new String[]{"No3"});
        }
        if (code.equals("16")) {
            return this.mospParams.getName("Allowance", new String[]{"No4"});
        }
        if (code.equals("17")) {
            return this.mospParams.getName("Allowance", new String[]{"No5"});
        }
        if (code.equals("18")) {
            return this.mospParams.getName("Allowance", new String[]{"No6"});
        }
        if (code.equals("19")) {
            return this.mospParams.getName("Allowance", new String[]{"No7"});
        }
        if (code.equals("20")) {
            return this.mospParams.getName("Allowance", new String[]{"No8"});
        }
        if (code.equals("21")) {
            return this.mospParams.getName("Allowance", new String[]{"No9"});
        }
        if (code.equals("22")) {
            return this.mospParams.getName("Allowance", new String[]{"No10"});
        }
        if (code.equals("23")) {
            return this.mospParams.getName("Rest1");
        }
        if (code.equals("24")) {
            return this.mospParams.getName("Rest2");
        }
        if (code.equals("25")) {
            return this.mospParams.getName("Rest3");
        }
        if (code.equals("26")) {
            return this.mospParams.getName("Rest4");
        }
        if (code.equals("27")) {
            return this.mospParams.getName("Rest5");
        }
        if (code.equals("28")) {
            return this.mospParams.getName("Rest6");
        }
        if (code.equals("29")) {
            return this.mospParams.getName("Official", new String[]{"GoingOut", "No1"});
        }
        if (code.equals("30")) {
            return this.mospParams.getName("Official", new String[]{"GoingOut", "No2"});
        }
        if (code.equals("31")) {
            return this.mospParams.getName("PrivateGoingOut1");
        }
        if (code.equals("32")) {
            return this.mospParams.getName("PrivateGoingOut2");
        }
        return code;
    }

    public String getHistoryAttendanceAggregateName(TotalTimeCorrectionDtoInterface dto) throws MospException {
        Date date = MonthUtility.getYearMonthTargetDate((int)dto.getCalculationYear(), (int)dto.getCalculationMonth(), (MospParams)this.mospParams);
        String type = dto.getCorrectionType();
        if (type.equals("1")) {
            return this.mospParams.getName("Work", new String[]{"Time"});
        }
        if (type.equals("2")) {
            return this.mospParams.getName("Prescribed", new String[]{"Work", "Time"});
        }
        if (type.equals("3")) {
            return this.mospParams.getName("GoingWork", new String[]{"Days"});
        }
        if (type.equals("4")) {
            return this.mospParams.getName("GoingWork", new String[]{"Frequency"});
        }
        if (type.equals("5")) {
            return this.mospParams.getName("Legal", new String[]{"DayOff", "GoingWork", "Days"});
        }
        if (type.equals("6")) {
            return this.mospParams.getName("Prescribed", new String[]{"DayOff", "GoingWork", "Days"});
        }
        if (type.equals("7")) {
            return this.mospParams.getName("DirectStart", new String[]{"Frequency"});
        }
        if (type.equals("8")) {
            return this.mospParams.getName("DirectEnd", new String[]{"Frequency"});
        }
        if (type.equals("9")) {
            return this.mospParams.getName("RestTime", new String[]{"Time"});
        }
        if (type.equals("10")) {
            return this.mospParams.getName("Midnight", new String[]{"RestTime", "Time"});
        }
        if (type.equals("11")) {
            return this.mospParams.getName("Prescribed", new String[]{"WorkingHoliday", "RestTime", "Time"});
        }
        if (type.equals("12")) {
            return this.mospParams.getName("Legal", new String[]{"WorkingHoliday", "RestTime", "Time"});
        }
        if (type.equals("13")) {
            return this.mospParams.getName("PublicGoingOut", new String[]{"Time"});
        }
        if (type.equals("14")) {
            return this.mospParams.getName("PrivateGoingOut", new String[]{"Time"});
        }
        if (type.equals("15")) {
            return this.mospParams.getName("OvertimeWork", new String[]{"Frequency"});
        }
        if (type.equals("108")) {
            return this.mospParams.getName("OvertimeWork", new String[]{"Time"});
        }
        if (type.equals("16")) {
            return this.mospParams.getName("Legal", new String[]{"Inside", "OvertimeWork", "Time"});
        }
        if (type.equals("17")) {
            return this.mospParams.getName("Legal", new String[]{"Outside", "OvertimeWork", "Time"});
        }
        if (type.equals("18")) {
            return this.mospParams.getName("Midnight", new String[]{"Time"});
        }
        if (type.equals("19")) {
            return this.mospParams.getName("Prescribed", new String[]{"WorkingHoliday", "Time"});
        }
        if (type.equals("20")) {
            return this.mospParams.getName("Legal", new String[]{"WorkingHoliday", "Time"});
        }
        if (type.equals("21")) {
            return this.mospParams.getName("Reduced", new String[]{"Target", "Time"});
        }
        if (type.equals("22")) {
            return this.mospParams.getName("No45", new String[]{"Time", "Exceed", "OvertimeWork", "Time"});
        }
        if (type.equals("23")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Tardiness"));
            sb.append(this.mospParams.getName("SumTotal"));
            sb.append(this.mospParams.getName("Frequency"));
            return sb.toString();
        }
        if (type.equals("27")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Tardiness"));
            sb.append(this.mospParams.getName("SumTotal"));
            sb.append(this.mospParams.getName("Time"));
            return sb.toString();
        }
        if (type.equals("31")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("LeaveEarly"));
            sb.append(this.mospParams.getName("SumTotal"));
            sb.append(this.mospParams.getName("Frequency"));
            return sb.toString();
        }
        if (type.equals("35")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("LeaveEarly"));
            sb.append(this.mospParams.getName("SumTotal"));
            sb.append(this.mospParams.getName("Time"));
            return sb.toString();
        }
        if (type.equals("39")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("SumTotal"));
            sb.append(this.mospParams.getName("Holiday"));
            sb.append(this.mospParams.getName("Days"));
            return sb.toString();
        }
        if (type.equals("40")) {
            return this.mospParams.getName("Legal", new String[]{"DayOff", "Days"});
        }
        if (type.equals("41")) {
            return this.mospParams.getName("Prescribed", new String[]{"DayOff", "Days"});
        }
        if (type.equals("42")) {
            return this.mospParams.getName("Salaried", new String[]{"Holiday", "Days"});
        }
        if (type.equals("43")) {
            return this.mospParams.getName("Salaried", new String[]{"Holiday", "Time"});
        }
        if (type.equals("44")) {
            return this.mospParams.getName("Stock", new String[]{"Holiday", "Days"});
        }
        if (type.equals("45")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("SumTotal"));
            sb.append(this.mospParams.getName("CompensatoryHoliday"));
            sb.append(this.mospParams.getName("Days"));
            return sb.toString();
        }
        if (type.equals("46")) {
            return this.mospParams.getName("Legal", new String[]{"CompensatoryHoliday", "Days"});
        }
        if (type.equals("47")) {
            return this.mospParams.getName("Prescribed", new String[]{"CompensatoryHoliday", "Days"});
        }
        if (type.equals("48")) {
            return this.mospParams.getName("Midnight", new String[]{"CompensatoryHoliday", "Days"});
        }
        if (type.equals("49")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("SumTotal"));
            sb.append(this.mospParams.getName("Transfer"));
            sb.append(this.mospParams.getName("DayOff"));
            sb.append(this.mospParams.getName("Days"));
            return sb.toString();
        }
        if (type.equals("50")) {
            return this.mospParams.getName("Legal", new String[]{"Transfer", "DayOff", "Days"});
        }
        if (type.equals("51")) {
            return this.mospParams.getName("Prescribed", new String[]{"Transfer", "DayOff", "Days"});
        }
        if (type.equals("52")) {
            return this.mospParams.getName("Specially", new String[]{"Holiday", "SumTotal", "Days"});
        }
        if (type.equals("53")) {
            return this.mospParams.getName("Others", new String[]{"Holiday", "SumTotal", "Days"});
        }
        if (type.equals("54")) {
            return this.mospParams.getName("Absence", new String[]{"SumTotal", "Days"});
        }
        if (type.equals("55")) {
            return this.mospParams.getName("Allowance", new String[]{"SumTotal"});
        }
        if (type.equals("56")) {
            return this.mospParams.getName("No60", new String[]{"Time", "Exceed", "OvertimeWork", "Time"});
        }
        if (type.equals("57")) {
            return this.mospParams.getName("Weekday", new String[]{"Time", "Outside", "Time"});
        }
        if (type.equals("58")) {
            return this.mospParams.getName("Prescribed", new String[]{"DayOff", "Time", "Outside", "Time"});
        }
        if (type.equals("59")) {
            return this.mospParams.getName("Substitute", new String[]{"Holiday", "Days"});
        }
        if (type.equals("91")) {
            return this.mospParams.getName("Allowance", new String[]{"No1"});
        }
        if (type.equals("92")) {
            return this.mospParams.getName("Allowance", new String[]{"No2"});
        }
        if (type.equals("93")) {
            return this.mospParams.getName("Allowance", new String[]{"No3"});
        }
        if (type.equals("94")) {
            return this.mospParams.getName("Allowance", new String[]{"No4"});
        }
        if (type.equals("95")) {
            return this.mospParams.getName("Allowance", new String[]{"No5"});
        }
        if (type.equals("96")) {
            return this.mospParams.getName("Allowance", new String[]{"No6"});
        }
        if (type.equals("97")) {
            return this.mospParams.getName("Allowance", new String[]{"No7"});
        }
        if (type.equals("98")) {
            return this.mospParams.getName("Allowance", new String[]{"No8"});
        }
        if (type.equals("99")) {
            return this.mospParams.getName("Allowance", new String[]{"No9"});
        }
        if (type.equals("100")) {
            return this.mospParams.getName("Allowance", new String[]{"No10"});
        }
        if (type.equals("101")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Tardiness"));
            sb.append(this.mospParams.getName("SumTotal"));
            sb.append(this.mospParams.getName("Days"));
            return sb.toString();
        }
        if (type.equals("102")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("LeaveEarly"));
            sb.append(this.mospParams.getName("SumTotal"));
            sb.append(this.mospParams.getName("Days"));
            return sb.toString();
        }
        if (type.equals("103")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Legal"));
            sb.append(this.mospParams.getName("CompensatoryHoliday"));
            sb.append(this.mospParams.getName("Ram"));
            sb.append(this.mospParams.getName("Acquisition"));
            return sb.toString();
        }
        if (type.equals("104")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Prescribed"));
            sb.append(this.mospParams.getName("CompensatoryHoliday"));
            sb.append(this.mospParams.getName("Ram"));
            sb.append(this.mospParams.getName("Acquisition"));
            return sb.toString();
        }
        if (type.equals("105")) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Midnight"));
            sb.append(this.mospParams.getName("CompensatoryHoliday"));
            sb.append(this.mospParams.getName("Ram"));
            sb.append(this.mospParams.getName("Acquisition"));
            return sb.toString();
        }
        if (type.equals("106")) {
            return this.mospParams.getName("GoingWork", new String[]{"Performance", "Days"});
        }
        if (type.equals("107")) {
            return this.mospParams.getName("GoingWork", new String[]{"Target", "Days"});
        }
        if (type.equals("108")) {
            return this.mospParams.getName("OvertimeWork", new String[]{"Time"});
        }
        if (type.equals("109")) {
            return this.mospParams.getName("WorkingHoliday", new String[]{"Frequency"});
        }
        if ("110".equals(type)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Tardiness"));
            sb.append(this.mospParams.getName("Thirty"));
            sb.append(this.mospParams.getName("Minutes"));
            sb.append(this.mospParams.getName("Over"));
            sb.append(this.mospParams.getName("Days"));
            return sb.toString();
        }
        if ("111".equals(type)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Tardiness"));
            sb.append(this.mospParams.getName("Thirty"));
            sb.append(this.mospParams.getName("Minutes"));
            sb.append(this.mospParams.getName("LessThan"));
            sb.append(this.mospParams.getName("Days"));
            return sb.toString();
        }
        if ("112".equals(type)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Tardiness"));
            sb.append(this.mospParams.getName("Thirty"));
            sb.append(this.mospParams.getName("Minutes"));
            sb.append(this.mospParams.getName("Over"));
            sb.append(this.mospParams.getName("Time"));
            return sb.toString();
        }
        if ("113".equals(type)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("Tardiness"));
            sb.append(this.mospParams.getName("Thirty"));
            sb.append(this.mospParams.getName("Minutes"));
            sb.append(this.mospParams.getName("LessThan"));
            sb.append(this.mospParams.getName("Time"));
            return sb.toString();
        }
        if ("114".equals(type)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("LeaveEarly"));
            sb.append(this.mospParams.getName("Thirty"));
            sb.append(this.mospParams.getName("Minutes"));
            sb.append(this.mospParams.getName("Over"));
            sb.append(this.mospParams.getName("Days"));
            return sb.toString();
        }
        if ("115".equals(type)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("LeaveEarly"));
            sb.append(this.mospParams.getName("Thirty"));
            sb.append(this.mospParams.getName("Minutes"));
            sb.append(this.mospParams.getName("LessThan"));
            sb.append(this.mospParams.getName("Days"));
            return sb.toString();
        }
        if ("116".equals(type)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("LeaveEarly"));
            sb.append(this.mospParams.getName("Thirty"));
            sb.append(this.mospParams.getName("Minutes"));
            sb.append(this.mospParams.getName("Over"));
            sb.append(this.mospParams.getName("Time"));
            return sb.toString();
        }
        if ("117".equals(type)) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("LeaveEarly"));
            sb.append(this.mospParams.getName("Thirty"));
            sb.append(this.mospParams.getName("Minutes"));
            sb.append(this.mospParams.getName("LessThan"));
            sb.append(this.mospParams.getName("Time"));
            return sb.toString();
        }
        if ("120".equals(type)) {
            return this.mospParams.getName("UnpaidShortTime");
        }
        String[] codeArray = type.split(",");
        if (codeArray.length >= 2) {
            String arrayType = codeArray[0];
            String arrayCode = codeArray[1];
            if (MospUtility.isEqual((Object)arrayType, (Object)"61")) {
                return this.getHolidayName(arrayCode, date, 2, true);
            }
            if (MospUtility.isEqual((Object)arrayType, (Object)"121")) {
                return this.getHolidayName(arrayCode, date, 2, false);
            }
            if (MospUtility.isEqual((Object)arrayType, (Object)"71")) {
                return this.getHolidayName(arrayCode, date, 3, true);
            }
            if (MospUtility.isEqual((Object)arrayType, (Object)"122")) {
                return this.getHolidayName(arrayCode, date, 3, false);
            }
            if (MospUtility.isEqual((Object)arrayType, (Object)"81")) {
                return this.getHolidayName(arrayCode, date, 4, true);
            }
            if (MospUtility.isEqual((Object)arrayType, (Object)"123")) {
                return this.getHolidayName(arrayCode, date, 4, false);
            }
        }
        return type;
    }

    protected String getHolidayName(String holidayCode, Date targetDate, int holidayType, boolean isDays) throws MospException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.holidayReference.getHolidayAbbr(holidayCode, targetDate, holidayType));
        if (isDays) {
            sb.append(TimeNamingUtility.days((MospParams)this.mospParams));
        } else {
            sb.append(PfNameUtility.time((MospParams)this.mospParams));
        }
        return sb.toString();
    }

    public boolean chkRest(RestDtoInterface newRest, RestDtoInterface oldRest) {
        return !newRest.getRestStart().equals(oldRest.getRestStart()) || !newRest.getRestEnd().equals(oldRest.getRestEnd());
    }

    public boolean chkGoOut(GoOutDtoInterface newGoOut, GoOutDtoInterface oldGoOut) {
        return !newGoOut.getGoOutStart().equals(oldGoOut.getGoOutStart()) || !newGoOut.getGoOutEnd().equals(oldGoOut.getGoOutEnd());
    }
}

