/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.bean.impl.TimeBaseExportBean;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;

public class AttendanceBookExportBean
extends TimeBaseExportBean {
    protected AttendanceListReferenceBeanInterface attendanceListRefer;

    public void initBean() throws MospException {
        super.initBean();
        this.attendanceListRefer = (AttendanceListReferenceBeanInterface)this.createBeanInstance(AttendanceListReferenceBeanInterface.class);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date firstDate, Date lastDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, boolean needLowerSection, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        List humanList = this.getHumanList(firstDate, lastDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, needLowerSection, positionCode);
        int months = this.getTargetMonths(firstDate, lastDate, cutoffCode);
        Date firstMonth = this.timeMaster.getCutoff(cutoffCode, firstDate).getCutoffMonth(firstDate, this.mospParams);
        int cutoffDate = this.timeMaster.getCutoff(cutoffCode, firstDate).getCutoffDate();
        for (HumanDtoInterface humanDto : humanList) {
            for (int i = 0; i < months; ++i) {
                Date targetMonth = DateUtility.addMonth((Date)firstMonth, (int)i);
                csvDataList.addAll(this.makeCsvData(humanDto, fieldList, targetMonth, cutoffDate));
            }
        }
        return csvDataList;
    }

    protected List<String[]> makeCsvData(HumanDtoInterface humanDto, List<String> fieldList, Date targetMonth, int cutoffDate) throws MospException {
        ArrayList<String[]> csvData = new ArrayList<String[]>();
        String personalId = humanDto.getPersonalId();
        int year = DateUtility.getYear((Date)targetMonth);
        int month = DateUtility.getMonth((Date)targetMonth);
        List dtos = this.attendanceListRefer.getActualList(personalId, year, month, cutoffDate);
        this.mospParams.getErrorMessageList().clear();
        for (AttendanceListDto dto : dtos) {
            csvData.add(this.makeCsvData(dto, humanDto, fieldList, targetMonth));
        }
        return csvData;
    }

    protected String[] makeCsvData(AttendanceListDto dto, HumanDtoInterface humanDto, List<String> fieldList, Date targetDate) throws MospException {
        Date workDate = dto.getWorkDate();
        String[] csvData = this.getHumanCsvData(fieldList, humanDto, workDate);
        this.setCsvValue(csvData, fieldList, "schedule_Day", (Object)DateUtility.getStringDateAndDay((Date)workDate));
        this.setCsvValue(csvData, fieldList, "work_type_code", (Object)dto.getWorkTypeCode());
        this.setCsvValue(csvData, fieldList, "work_type_abbr", (Object)dto.getWorkTypeAbbr());
        this.setCsvValue(csvData, fieldList, "start_time", (Object)dto.getStartTimeString());
        this.setCsvValue(csvData, fieldList, "end_time", (Object)dto.getEndTimeString());
        this.setCsvValue(csvData, fieldList, "work_time", (Object)dto.getWorkTimeString());
        this.setCsvValue(csvData, fieldList, "rest_time", (Object)dto.getRestTimeString());
        this.setCsvValue(csvData, fieldList, "private_time", (Object)dto.getPrivateTimeString());
        this.setCsvValue(csvData, fieldList, "late_leave_early_time", (Object)dto.getLateLeaveEarlyTimeString());
        this.setCsvValue(csvData, fieldList, "overtime_in", (Object)dto.getOvertimeInString());
        this.setCsvValue(csvData, fieldList, "overtime_out", (Object)dto.getOvertimeOutString());
        this.setCsvValue(csvData, fieldList, "work_on_holiday", (Object)dto.getHolidayWorkTimeString());
        this.setCsvValue(csvData, fieldList, "late_night", (Object)dto.getLateNightTimeString());
        this.setCsvValue(csvData, fieldList, "time_remarks", (Object)MospUtility.concat((String[])new String[]{dto.getRemark(), dto.getTimeComment()}));
        return csvData;
    }

    protected int getTargetMonths(Date firstDate, Date lastDate, String cutoffCode) throws MospException {
        Date firstMonth = this.timeMaster.getCutoff(cutoffCode, firstDate).getCutoffMonth(firstDate, this.mospParams);
        Date lastMonth = this.timeMaster.getCutoff(cutoffCode, lastDate).getCutoffMonth(lastDate, this.mospParams);
        int monthDifference = DateUtility.getMonthDifference((Date)firstMonth, (Date)lastMonth);
        return ++monthDifference;
    }
}

