/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.bean.AttendListCheckBoxBeanInterface;
import jp.mosp.time.bean.AttendanceCorrectionReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceListReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.OvertimeRequestReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.SubHolidayReferenceBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.AttendListEntityInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.utils.AttendanceUtility;
import jp.mosp.time.utils.TimeUtility;

public class AttendListReferenceBean
extends PlatformBean
implements AttendanceListReferenceBeanInterface {
    protected PlatformMasterBeanInterface platformMaster;
    protected TimeMasterBeanInterface timeMaster;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected AttendanceReferenceBeanInterface attendanceRefer;
    protected OvertimeRequestReferenceBeanInterface overtimeReqRefer;
    protected HolidayRequestReferenceBeanInterface holidayReqRefer;
    protected WorkOnHolidayRequestReferenceBeanInterface workOnHolidayReqRefer;
    protected SubstituteReferenceBeanInterface substituteRefer;
    protected SubHolidayRequestReferenceBeanInterface subHolidayReqRefer;
    protected SubHolidayReferenceBeanInterface subHolidayRefer;
    protected WorkTypeChangeRequestReferenceBeanInterface workTypeChangeReqRefer;
    protected DifferenceRequestReferenceBeanInterface differenceReqRefer;
    protected WorkflowReferenceBeanInterface workflowRefer;
    protected AttendanceCorrectionReferenceBeanInterface correctionRefer;
    protected AttendListCheckBoxBeanInterface checkBox;

    public void initBean() throws MospException {
        this.platformMaster = (PlatformMasterBeanInterface)this.createBeanInstance(PlatformMasterBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.timeMaster.setPlatformMaster(this.platformMaster);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.scheduleUtil.setTimeMaster(this.timeMaster);
        this.attendanceRefer = (AttendanceReferenceBeanInterface)this.createBeanInstance(AttendanceReferenceBeanInterface.class);
        this.overtimeReqRefer = (OvertimeRequestReferenceBeanInterface)this.createBeanInstance(OvertimeRequestReferenceBeanInterface.class);
        this.holidayReqRefer = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
        this.workOnHolidayReqRefer = (WorkOnHolidayRequestReferenceBeanInterface)this.createBeanInstance(WorkOnHolidayRequestReferenceBeanInterface.class);
        this.substituteRefer = (SubstituteReferenceBeanInterface)this.createBeanInstance(SubstituteReferenceBeanInterface.class);
        this.subHolidayReqRefer = (SubHolidayRequestReferenceBeanInterface)this.createBeanInstance(SubHolidayRequestReferenceBeanInterface.class);
        this.workTypeChangeReqRefer = (WorkTypeChangeRequestReferenceBeanInterface)this.createBeanInstance(WorkTypeChangeRequestReferenceBeanInterface.class);
        this.differenceReqRefer = (DifferenceRequestReferenceBeanInterface)this.createBeanInstance(DifferenceRequestReferenceBeanInterface.class);
        this.subHolidayRefer = (SubHolidayReferenceBeanInterface)this.createBeanInstance(SubHolidayReferenceBeanInterface.class);
        this.workflowRefer = (WorkflowReferenceBeanInterface)this.createBeanInstance(WorkflowReferenceBeanInterface.class);
        this.correctionRefer = (AttendanceCorrectionReferenceBeanInterface)this.createBeanInstance(AttendanceCorrectionReferenceBeanInterface.class);
        this.checkBox = (AttendListCheckBoxBeanInterface)this.createBeanInstance(AttendListCheckBoxBeanInterface.class);
        this.checkBox.setTimeMaster(this.timeMaster);
    }

    public List<AttendanceListDto> getScheduleList(String personalId, Date targetDate) throws MospException {
        List attendList = this.getInitAttendList(personalId, targetDate);
        this.fillInAttendList(attendList, 3, false);
        return attendList;
    }

    public List<AttendanceListDto> getScheduleList(String personalId, int year, int month) throws MospException {
        List attendList = this.getInitAttendList(personalId, year, month);
        this.fillInAttendList(attendList, 3, false);
        return attendList;
    }

    public List<AttendanceListDto> getScheduleList(String personalId, int year, int month, int cutoffDate) throws MospException {
        List attendList = this.getInitAttendList(personalId, year, month, cutoffDate);
        this.fillInAttendList(attendList, 3, false);
        return attendList;
    }

    public List<AttendanceListDto> getActualList(String personalId, int year, int month) throws MospException {
        List attendList = this.getInitAttendList(personalId, year, month);
        this.fillInAttendList(attendList, 2, false);
        return attendList;
    }

    public List<AttendanceListDto> getActualList(String personalId, int year, int month, int cutoffDate) throws MospException {
        List attendList = this.getInitAttendList(personalId, year, month, cutoffDate);
        this.fillInAttendList(attendList, 2, false);
        return attendList;
    }

    public List<AttendanceListDto> getAttendanceList(String personalId, Date targetDate) throws MospException {
        List attendList = this.getInitAttendList(personalId, targetDate);
        this.fillInAttendList(attendList, 1, true);
        return attendList;
    }

    public List<AttendanceListDto> getAttendanceList(String personalId, int year, int month) throws MospException {
        List attendList = this.getInitAttendList(personalId, year, month);
        this.fillInAttendList(attendList, 1, true);
        return attendList;
    }

    public List<AttendanceListDto> getAttendanceList(String personalId, int year, int month, int cutoffDate) throws MospException {
        List attendList = this.getInitAttendList(personalId, year, month, cutoffDate);
        this.fillInAttendList(attendList, 1, true);
        return attendList;
    }

    public List<AttendanceListDto> getWeeklyAttendanceList(String personalId, Date targetDate) throws MospException {
        List attendList = this.getInitWeeklyAttendList(personalId, targetDate);
        this.fillInAttendList(attendList, 1, false);
        return attendList;
    }

    public List<AttendanceListDto> getApprovalAttendanceList(String personalId, int year, int month) throws MospException {
        List attendList = this.getInitAttendList(personalId, year, month);
        this.fillInAttendList(attendList, 4, true);
        return attendList;
    }

    public AttendanceListDto getAttendanceListDto(String personalId, Date targetDate) throws MospException {
        List attendList = this.getInitAttendList(personalId, targetDate, targetDate);
        this.fillInAttendList(attendList, 1, false);
        return (AttendanceListDto)MospUtility.getFirstValue((Collection)attendList);
    }

    public List<AttendanceListDto> getTermAttendanceList(String personalId, Date firstDate, Date lastDate) throws MospException {
        List attendList = this.getInitAttendList(personalId, firstDate, lastDate);
        this.fillInAttendList(attendList, 1, true);
        return attendList;
    }

    protected List<AttendanceListDto> getInitAttendList(String personalId, Date targetDate) throws MospException {
        ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, targetDate);
        if (!application.isValid(this.mospParams)) {
            return Collections.emptyList();
        }
        Date cuttoffMonth = application.getCutoffEntity().getCutoffMonth(targetDate, this.mospParams);
        int targetYear = DateUtility.getYear((Date)cuttoffMonth);
        int targetMonth = DateUtility.getMonth((Date)cuttoffMonth);
        return this.getInitAttendList(personalId, targetYear, targetMonth, application);
    }

    protected List<AttendanceListDto> getInitAttendList(String personalId, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, targetDate);
        return this.getInitAttendList(personalId, targetYear, targetMonth, application);
    }

    protected List<AttendanceListDto> getInitAttendList(String personalId, int targetYear, int targetMonth, int cutoffDate) throws MospException {
        Date targetDate = TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, targetDate);
        return this.getInitAttendList(personalId, targetYear, targetMonth, application);
    }

    protected List<AttendanceListDto> getInitWeeklyAttendList(String personalId, Date targetDate) throws MospException {
        ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, targetDate);
        if (!application.isValid()) {
            return Collections.emptyList();
        }
        int startDayOfWeek = application.getStartDayOfWeek();
        Date firstDate = DateUtility.getFirstDateOfWeek((int)startDayOfWeek, (Date)targetDate);
        Date lastDate = DateUtility.getLastDateOfWeek((int)startDayOfWeek, (Date)targetDate);
        return this.getInitAttendList(personalId, firstDate, lastDate);
    }

    protected List<AttendanceListDto> getInitAttendList(String personalId, int targetYear, int targetMonth, ApplicationEntity application) throws MospException {
        ArrayList<AttendanceListDto> attendList = new ArrayList<AttendanceListDto>();
        if (!application.isValid(this.mospParams)) {
            return attendList;
        }
        for (Date workDate : application.getCutoffEntity().getCutoffTerm(targetYear, targetMonth, this.mospParams)) {
            AttendanceListDto dto = new AttendanceListDto();
            dto.setPersonalId(personalId);
            dto.setWorkDate(workDate);
            dto.setTargetYear(targetYear);
            dto.setTargetMonth(targetMonth);
            dto.setCutoffDate(application.getCutoffDate());
            dto.setScheduleCode(application.getScheduleCode());
            attendList.add(dto);
        }
        return attendList;
    }

    protected List<AttendanceListDto> getInitAttendList(String personalId, Date firstDate, Date lastDate) {
        ArrayList<AttendanceListDto> attendList = new ArrayList<AttendanceListDto>();
        for (Date workDate : TimeUtility.getDateList((Date)firstDate, (Date)lastDate)) {
            AttendanceListDto dto = new AttendanceListDto();
            dto.setPersonalId(personalId);
            dto.setWorkDate(workDate);
            attendList.add(dto);
        }
        return attendList;
    }

    protected void fillInAttendList(List<AttendanceListDto> attendList, int listType, boolean isCheckBox) throws MospException {
        if (MospUtility.isEmpty(attendList)) {
            return;
        }
        AttendListEntityInterface entity = this.getAttendListEntity(attendList);
        entity.fillInAttendList(listType);
        if (isCheckBox) {
            this.checkBox.setCheckBox(attendList, entity);
        }
        this.doStoredLogic(new Object[]{"Add_AttendListRemarks", entity});
        this.fillTimeSettingFields(attendList);
        this.fillHeadersAndFooters(attendList);
        this.doStoredLogic(new Object[]{"Add_AttendListAfter", entity});
    }

    protected AttendListEntityInterface getAttendListEntity(List<AttendanceListDto> attendList) throws MospException {
        AttendListEntityInterface entity = (AttendListEntityInterface)this.createObject(AttendListEntityInterface.class);
        entity.setMospParams(this.mospParams);
        AttendanceListDto dto = (AttendanceListDto)MospUtility.getFirstValue(attendList);
        String personalId = dto.getPersonalId();
        Date firstDate = dto.getWorkDate();
        Date lastDate = ((AttendanceListDto)MospUtility.getLastValue(attendList)).getWorkDate();
        entity.setAttendList(attendList);
        entity.setRetireDate(HumanUtility.getRetireDate((RetirementDtoInterface)this.platformMaster.getRetirement(personalId)));
        entity.setSuspensions((Collection)this.platformMaster.getSuspensions(personalId));
        Map schedules = this.scheduleUtil.getScheduleDates(personalId, firstDate, lastDate);
        Map attendances = this.attendanceRefer.getAttendances(personalId, firstDate, lastDate);
        Map overtimeRequests = this.overtimeReqRefer.getOvertimeRequests(personalId, firstDate, lastDate);
        Map holidayRequests = this.holidayReqRefer.getHolidayRequests(personalId, firstDate, lastDate);
        List workOnHolidayRequestList = this.workOnHolidayReqRefer.getWorkOnHolidayRequestList(personalId, firstDate, lastDate);
        Map substitutes = this.substituteRefer.getSubstitutes(personalId, firstDate, lastDate);
        Map subHolidayRequests = this.subHolidayReqRefer.getSubHolidayRequests(personalId, firstDate, lastDate);
        Map subHolidays = this.subHolidayRefer.getSubHolidays(personalId, firstDate, lastDate);
        List workTypeChangeRequestList = this.workTypeChangeReqRefer.getWorkTypeChangeRequestList(personalId, firstDate, lastDate);
        List differenceRequestList = this.differenceReqRefer.getDifferenceRequestList(personalId, firstDate, lastDate);
        Set workflowSet = WorkflowUtility.getWorkflowSet((Collection[])new Collection[]{attendances.values(), overtimeRequests.values(), holidayRequests.values(), workOnHolidayRequestList, substitutes.values(), subHolidayRequests.values(), workTypeChangeRequestList, differenceRequestList});
        Map workflows = this.workflowRefer.getWorkflows(workflowSet);
        Set statuses = WorkflowUtility.getStatusesExceptWithDrawn();
        Map workOnHolidayRequests = TimeUtility.getRequestDateMap((Collection)workOnHolidayRequestList, (Map)workflows, (Set)statuses);
        Map workTypeChangeRequests = TimeUtility.getRequestDateMap((Collection)workTypeChangeRequestList, (Map)workflows, (Set)statuses);
        Map differenceRequests = TimeUtility.getRequestDateMap((Collection)differenceRequestList, (Map)workflows, (Set)statuses);
        entity.setScheduleDates(schedules);
        entity.setAttendances(attendances);
        entity.setOvertimeRequests(overtimeRequests);
        entity.setHolidayRequests(holidayRequests);
        entity.setWorkOnHolidayRequests(workOnHolidayRequests);
        entity.setSubstitutes(substitutes);
        entity.setSubHolidayRequests(subHolidayRequests);
        entity.setSubHolidays(subHolidays);
        entity.setWorkTypeChangeRequests(workTypeChangeRequests);
        entity.setDifferenceRequests(differenceRequests);
        entity.setWorkflows(workflows);
        Set substituteWorkDates = TimeUtility.getSubstituteWorkDates((Map)workOnHolidayRequests, (Map)workflows);
        Map substituteDates = this.substituteRefer.getSubstituteDates(personalId, substituteWorkDates);
        Map substitutedSchedules = this.scheduleUtil.getSubstitutedSchedules(personalId, substituteDates);
        entity.setSubstitutedSchedules(substitutedSchedules);
        Set workTypeCodes = TimeUtility.getWorkTypeCodes((Collection[])new Collection[]{schedules.values(), attendances.values(), workOnHolidayRequests.values(), workTypeChangeRequests.values(), differenceRequests.values(), substitutedSchedules.values()});
        entity.setWorkTypeEntities(this.timeMaster.getWorkTypeEntities((Collection)workTypeCodes));
        entity.setCorrections(this.correctionRefer.getCorrections(personalId, firstDate, lastDate));
        entity.setHolidays(this.timeMaster.getHolidaySet(lastDate));
        return entity;
    }

    protected void fillHeadersAndFooters(List<AttendanceListDto> attendList) throws MospException {
        AttendanceListDto headerDto = (AttendanceListDto)MospUtility.getFirstValue(attendList);
        AttendanceListDto footerDto = (AttendanceListDto)MospUtility.getLastValue(attendList);
        String personalId = headerDto.getPersonalId();
        Date targetDate = footerDto.getWorkDate();
        ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, targetDate);
        HumanDtoInterface human = this.platformMaster.getHuman(personalId, targetDate);
        if (MospUtility.isEmpty((Object[])new Object[]{human})) {
            return;
        }
        headerDto.setEmployeeCode(human.getEmployeeCode());
        headerDto.setEmployeeName(MospUtility.getHumansName((String)human.getFirstName(), (String)human.getLastName()));
        String sectionCode = human.getSectionCode();
        headerDto.setSectionName(this.platformMaster.getSectionNameOrDisplay(sectionCode, targetDate, this.mospParams));
        headerDto.setSealBoxAvailable(true);
        footerDto.setSubHolidayRequestValid(TimeUtility.isSubHolidayRequestValid((MospParams)this.mospParams));
        if (!application.isHourlyPaidHolidayAvailable()) {
            footerDto.setPaidHolidayTimeString(PfNameUtility.hyphen((MospParams)this.mospParams));
        }
    }

    protected void fillTimeSettingFields(List<AttendanceListDto> attendList) throws MospException {
        AttendanceListDto lastDto = (AttendanceListDto)MospUtility.getLastValue(attendList);
        String personalId = lastDto.getPersonalId();
        Date targetDate = lastDto.getWorkDate();
        TimeSettingEntityInterface timeSetting = this.timeMaster.getTimeSettingForPersonalId(personalId, targetDate);
        this.fillLimitStandard(attendList, timeSetting);
        AttendanceUtility.resetStartEndTimeString((MospParams)this.mospParams, attendList, (TimeSettingEntityInterface)timeSetting);
    }

    protected void fillLimitStandard(List<AttendanceListDto> attendList, TimeSettingEntityInterface timeSetting) {
        int overtimeTotal = 0;
        for (AttendanceListDto dto : attendList) {
            int overtimeOut = MospUtility.getInt((Object)dto.getOvertimeOut());
            if (overtimeOut == 0) continue;
            dto.setOvertimeStyle(timeSetting.getOneMonthStyle(overtimeTotal += overtimeOut));
        }
    }
}

