/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.bean.impl.AttendListReferRemarkBaseBean;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.entity.AttendListEntityInterface;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;

public class AttendListReferRemarkHolidayBean
extends AttendListReferRemarkBaseBean {
    protected String getRemark(AttendListEntityInterface entity, AttendanceListDto dto) throws MospException {
        LinkedHashSet<String> remarks = new LinkedHashSet<String>();
        String prefix = TimeNamingUtility.getVacation((MospParams)this.mospParams);
        Set statuses = this.getWorkflowStatuses(dto);
        RequestEntityInterface requestEntity = entity.getRequestEntity(dto);
        String workTypeCode = dto.getWorkTypeCode();
        List requests = requestEntity.getHolidayRequestList(statuses);
        Map workflows = requestEntity.getWorkflowMap();
        WorkflowUtility.sortByStatus((List)requests, (Map)workflows);
        for (HolidayRequestDtoInterface request : requests) {
            if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)request) || TimeRequestUtility.isConsecutiveHolidays((HolidayRequestDtoInterface)request) && TimeRequestUtility.isNotHolidayForConsecutiveHolidays((String)workTypeCode)) continue;
            remarks.add(this.getRequestWorkflowStatusRemark(prefix, (WorkflowDtoInterface)workflows.get(request.getWorkflow())));
        }
        remarks.addAll(this.getHourlyHolidayRemarks(requests, workflows));
        this.removeDuplicateRemark(remarks);
        return this.getRemark(remarks);
    }

    protected Set<String> getHourlyHolidayRemarks(List<HolidayRequestDtoInterface> dtos, Map<Long, WorkflowDtoInterface> workflows) {
        LinkedHashSet<String> remarks = new LinkedHashSet<String>();
        Map map = this.getHourlyHolidays(dtos, workflows);
        for (Map.Entry entry : map.entrySet()) {
            String status = (String)entry.getKey();
            int hours = MospUtility.getInt(entry.getValue());
            remarks.add(this.getHourlyHolidayRemark(status, hours));
        }
        return remarks;
    }

    protected String getHourlyHolidayRemark(String status, int hours) {
        StringBuilder remark = new StringBuilder(TimeNamingUtility.getVacation((MospParams)this.mospParams));
        remark.append(status);
        this.addRemark(remark, new String[]{PfNameUtility.hour((MospParams)this.mospParams)});
        remark.append(hours);
        return remark.toString();
    }

    protected Map<String, Integer> getHourlyHolidays(List<HolidayRequestDtoInterface> dtos, Map<Long, WorkflowDtoInterface> workflows) {
        LinkedHashMap<String, Integer> hourlyHolidays = new LinkedHashMap<String, Integer>();
        for (HolidayRequestDtoInterface dto : dtos) {
            if (!TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) continue;
            String status = this.getWorkflowStatusRemark(workflows.get(dto.getWorkflow()));
            int hourlyHoliday = MospUtility.getInt(hourlyHolidays.get(status));
            hourlyHolidays.put(status, hourlyHoliday + dto.getUseHour());
        }
        return hourlyHolidays;
    }

    protected void removeDuplicateRemark(Set<String> remarks) {
        if (remarks.size() < 2) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(remarks);
        if (MospUtility.isContain((String)((String)list.get(1)), (String)((String)list.get(0)))) {
            remarks.remove(list.get(0));
        }
    }
}

