/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.time.bean.impl.AttendListReferRemarkBaseBean;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.entity.AttendListEntityInterface;
import jp.mosp.time.utils.TimeNamingUtility;

public class AttendListReferRemarkAttendanceBean
extends AttendListReferRemarkBaseBean {
    protected String getRemark(AttendListEntityInterface entity, AttendanceListDto dto) throws MospException {
        int listType = dto.getListType();
        if (listType == 3) {
            return this.getEmpty();
        }
        Set statuses = this.getWorkflowStatuses(dto);
        AttendanceDtoInterface attendance = entity.getRequestEntity(dto).getAttendanceDto(statuses);
        if (MospUtility.isEmpty((Object[])new Object[]{attendance})) {
            return this.getEmpty();
        }
        StringBuilder remark = new StringBuilder();
        this.addRemark(remark, new String[]{this.getLateRemark(attendance)});
        this.addRemark(remark, new String[]{this.getLeaveEarlyRemark(attendance)});
        this.addRemark(remark, new String[]{this.getDirectStartRemark(attendance)});
        this.addRemark(remark, new String[]{this.getDirectEndRemark(attendance)});
        this.addRemark(remark, new String[]{attendance.getTimeComment()});
        this.addRemark(remark, new String[]{attendance.getRemarks()});
        return remark.toString();
    }

    protected String getLateRemark(AttendanceDtoInterface dto) {
        String lateReason = dto.getLateReason();
        if (MospUtility.isEmpty((String[])new String[]{lateReason})) {
            return this.getEmpty();
        }
        StringBuilder remark = new StringBuilder();
        this.addRemark(remark, new String[]{TimeNamingUtility.getLateAbbrNaming((MospParams)this.mospParams)});
        this.addRemark(remark, new String[]{MospUtility.getCodeName((MospParams)this.mospParams, (String)lateReason, (String)"ReasonOfLate")});
        return remark.toString();
    }

    protected String getLeaveEarlyRemark(AttendanceDtoInterface dto) {
        String leaveEarlyReason = dto.getLeaveEarlyReason();
        if (MospUtility.isEmpty((String[])new String[]{leaveEarlyReason})) {
            return this.getEmpty();
        }
        StringBuilder remark = new StringBuilder();
        this.addRemark(remark, new String[]{TimeNamingUtility.getEarlyAbbrNaming((MospParams)this.mospParams)});
        this.addRemark(remark, new String[]{MospUtility.getCodeName((MospParams)this.mospParams, (String)leaveEarlyReason, (String)"ReasonOfLeaveEarly")});
        return remark.toString();
    }

    protected String getDirectStartRemark(AttendanceDtoInterface dto) {
        if (!MospUtility.isChecked((int)dto.getDirectStart())) {
            return this.getEmpty();
        }
        return TimeNamingUtility.directStart((MospParams)this.mospParams);
    }

    protected String getDirectEndRemark(AttendanceDtoInterface dto) {
        if (!MospUtility.isChecked((int)dto.getDirectEnd())) {
            return this.getEmpty();
        }
        return TimeNamingUtility.directEnd((MospParams)this.mospParams);
    }
}

