/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.bean.AttendListCheckBoxBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.dto.settings.TotalTimeEmployeeDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.entity.AttendListEntityInterface;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.utils.AttendanceUtility;
import jp.mosp.time.utils.TimeUtility;

public class AttendListCheckBoxBean
extends PlatformBean
implements AttendListCheckBoxBeanInterface {
    protected TotalTimeEmployeeTransactionReferenceBeanInterface totalTimeEmployeeTransRefer;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.totalTimeEmployeeTransRefer = (TotalTimeEmployeeTransactionReferenceBeanInterface)this.createBeanInstance(TotalTimeEmployeeTransactionReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
    }

    public void setCheckBox(List<AttendanceListDto> attendList, AttendListEntityInterface entity) throws MospException {
        if (MospUtility.isEmpty(attendList)) {
            return;
        }
        AttendanceListDto lastDto = (AttendanceListDto)MospUtility.getLastValue(attendList);
        if (TimeUtility.isTightend((TotalTimeEmployeeDtoInterface)this.getTotalTimeEmployee(lastDto))) {
            this.setAllCheckBox(attendList, false);
            return;
        }
        if (AttendanceUtility.isListTypeApproval((int)lastDto.getListType())) {
            this.setCheckBoxForApproval(attendList);
            return;
        }
        for (AttendanceListDto dto : attendList) {
            this.setCheckBoxForAttendance(dto, entity);
        }
    }

    public void setCheckBox(Map<String, AttendanceListDto> dtos, Map<String, AttendListEntityInterface> entities) throws MospException {
        for (Map.Entry<String, AttendanceListDto> entry : dtos.entrySet()) {
            String personalId = entry.getKey();
            AttendanceListDto dto = entry.getValue();
            AttendListEntityInterface entity = entities.get(personalId);
            this.setCheckBox(dto, entity);
        }
    }

    protected void setCheckBox(AttendanceListDto dto, AttendListEntityInterface entity) throws MospException {
        if (MospUtility.isEmpty((Object[])new Object[]{dto, entity})) {
            return;
        }
        if (TimeUtility.isTightend((TotalTimeEmployeeDtoInterface)this.getTotalTimeEmployee(dto))) {
            dto.setNeedCheckbox(false);
        }
        this.setCheckBoxForAttendance(dto, entity);
    }

    protected void setCheckBoxForAttendance(AttendanceListDto dto, AttendListEntityInterface entity) throws MospException {
        RequestEntityInterface requestEntity = entity.getRequestEntity(dto);
        Set statuses = WorkflowUtility.getEffectiveStatuses();
        Date workDate = dto.getWorkDate();
        String workTypeCode = requestEntity.getWorkType(false, statuses);
        if (TimeUtility.isHoliday((String)workTypeCode) || requestEntity.isAllHoliday(statuses)) {
            dto.setNeedCheckbox(false);
            return;
        }
        if (requestEntity.hasWorkOnHoliday(statuses) && !requestEntity.hasWorkOnHoliday(true)) {
            dto.setNeedCheckbox(false);
            return;
        }
        if (requestEntity.isAttendanceApplied()) {
            dto.setNeedCheckbox(false);
            return;
        }
        if (entity.isRetireOrSusoension(workDate)) {
            dto.setNeedCheckbox(false);
            return;
        }
        if (MospUtility.isEmpty((String[])new String[]{workTypeCode})) {
            dto.setNeedCheckbox(false);
            return;
        }
        dto.setNeedCheckbox(true);
    }

    protected void setCheckBoxForApproval(Collection<AttendanceListDto> dtos) throws MospException {
        Map approvables = this.getApprovables();
        for (AttendanceListDto dto : dtos) {
            dto.setNeedCheckbox(approvables.containsKey(dto.getWorkflow()));
        }
    }

    protected void setAllCheckBox(Collection<AttendanceListDto> dtos, boolean value) {
        for (AttendanceListDto dto : dtos) {
            dto.setNeedCheckbox(value);
        }
    }

    protected TotalTimeEmployeeDtoInterface getTotalTimeEmployee(AttendanceListDto dto) throws MospException {
        String personalId = dto.getPersonalId();
        int targetYear = dto.getTargetYear();
        int targetMonth = dto.getTargetMonth();
        if (targetYear != 0) {
            return this.totalTimeEmployeeTransRefer.findForKey(personalId, targetYear, targetMonth);
        }
        Date workDate = dto.getWorkDate();
        Date cutoffMonth = this.timeMaster.getCutoffForPersonalId(personalId, workDate).getCutoffMonth(workDate, this.mospParams);
        return this.totalTimeEmployeeTransRefer.getTotalTimeEmployee(personalId, cutoffMonth);
    }

    protected Map<Long, WorkflowDtoInterface> getApprovables() throws MospException {
        String personalId = MospUtility.getLoginPersonalId((MospParams)this.mospParams);
        return this.workflowIntegrate.getApprovableMap(personalId, "1");
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
    }
}

