/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.AttendCalcExecuteBeanInterface;
import jp.mosp.time.bean.AttendCalcExecuteExtraBeanInterface;
import jp.mosp.time.bean.AttendCalcReferenceBeanInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.entity.AttendCalcEntityInterface;
import jp.mosp.time.entity.AttendanceEntityInterface;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.utils.AttendanceUtility;
import jp.mosp.time.utils.TimeUtility;

public class AttendCalcExecuteBean
extends TimeBean
implements AttendCalcExecuteBeanInterface {
    protected static final String CODE_KEY_BEFORE = "AttendCalcExecuteBefore";
    protected static final String CODE_KEY_AFTER = "AttendCalcExecuteAfter";
    protected AttendCalcReferenceBeanInterface refer;

    public void initBean() throws MospException {
    }

    public void setAttendCalcRefer(AttendCalcReferenceBeanInterface refer) {
        this.refer = refer;
    }

    public AttendCalcEntityInterface getCalcEntity(AttendanceEntityInterface attendance) throws MospException {
        return this.createCalcEntity(attendance);
    }

    public void calc(AttendanceEntityInterface attendance) throws MospException {
        AttendanceDtoInterface dto = AttendanceUtility.getAttendanceDtoClone(null, (AttendanceDtoInterface)attendance.getAttendanceDto());
        AttendCalcEntityInterface calc = this.createCalcEntity(attendance);
        for (AttendCalcExecuteExtraBeanInterface extra : this.getExtraBeans(CODE_KEY_BEFORE)) {
            extra.execute(calc, dto);
        }
        this.setStartEndTimes(dto, calc);
        this.setCalcItems(dto, calc);
        this.setLateItems(dto);
        this.setLeaveEarlyItems(dto);
        this.setOvertimeItems(dto);
        this.setWorkTimes(dto, attendance);
        this.setDaysAndTimes(dto);
        this.setCompensationDays(dto);
        this.setExtraItems(dto, calc);
        this.setUnusedItems(dto);
        for (AttendCalcExecuteExtraBeanInterface extra : this.getExtraBeans(CODE_KEY_AFTER)) {
            extra.execute(calc, dto);
        }
        attendance.setAttendanceDto(dto);
    }

    protected void setStartEndTimes(AttendanceDtoInterface dto, AttendCalcEntityInterface calc) throws MospException {
        int inputStartTime = this.getMinutes(dto.getActualStartTime(), dto.getWorkDate());
        int inputEndTime = this.getMinutes(dto.getActualEndTime(), dto.getWorkDate());
        dto.setStartTime(this.toDate(dto, calc.calcStartTime(inputStartTime)));
        dto.setActualStartTime(this.toDate(dto, calc.calcActualStartTime(inputStartTime)));
        dto.setEndTime(this.toDate(dto, calc.calcEndTime(inputEndTime)));
        dto.setActualEndTime(this.toDate(dto, calc.calcActualEndTime(inputEndTime)));
    }

    protected void setCalcItems(AttendanceDtoInterface dto, AttendCalcEntityInterface calc) throws MospException {
        int startTime = this.getMinutes(dto.getStartTime(), dto.getWorkDate());
        int endTime = this.getMinutes(dto.getEndTime(), dto.getWorkDate());
        dto.setLateTime(calc.calcLateTime(startTime, endTime));
        dto.setActualLateTime(calc.calcActualLateTime(startTime, endTime));
        dto.setLeaveEarlyTime(calc.calcLeaveEarlyTime(startTime, endTime));
        dto.setActualLeaveEarlyTime(calc.calcActualLeaveEarlyTime(startTime, endTime));
        dto.setWorkTime(calc.calcWorkTime(startTime, endTime));
        dto.setGeneralWorkTime(calc.calcPrescribedWorkTime());
        dto.setWorkTimeWithinPrescribedWorkTime(calc.calcWorkTimeWithinPrescribed(startTime, endTime));
        dto.setShortUnpaid(calc.calcShortUnpaid(startTime, endTime));
        dto.setRestTime(calc.calcRestTime(startTime, endTime));
        dto.setNightRestTime(calc.calcNightRestTime(startTime, endTime));
        dto.setLegalHolidayRestTime(calc.calcLegalHolidayRestTime(startTime, endTime));
        dto.setPrescribedHolidayRestTime(calc.calcPrescribedHolidayRestTime(startTime, endTime));
        dto.setPublicTime(calc.calcPublicTime());
        dto.setPrivateTime(calc.calcPrivateTime());
        dto.setOvertimeBefore(calc.calcOvertimeBefore(startTime, endTime));
        dto.setOvertimeAfter(calc.calcOvertimeAfter(startTime, endTime));
        dto.setOvertimeIn(calc.calcOvertimeIn(startTime, endTime));
        dto.setOvertimeOut(calc.calcOvertimeOut(startTime, endTime));
        dto.setWorkdayOvertimeIn(calc.calcWorkdayOvertimeIn(startTime, endTime));
        dto.setWorkdayOvertimeOut(calc.calcWorkdayOvertimeOut(startTime, endTime));
        dto.setPrescribedHolidayOvertimeIn(calc.calcPrescribedHolidayOvertimeIn(startTime, endTime));
        dto.setPrescribedHolidayOvertimeOut(calc.calcPrescribedHolidayOvertimeOut(startTime, endTime));
        dto.setLateNightTime(calc.calcNightWorkTime(startTime, endTime));
        dto.setNightWorkWithinPrescribedWork(calc.calcNightWorkWithinPrescribed(startTime, endTime));
        dto.setNightOvertimeWork(calc.calcNightWorkOvertime(startTime, endTime));
        dto.setNightWorkOnHoliday(calc.calcNightWorkOnLegalHoliday(startTime, endTime));
        dto.setSpecificWorkTime(calc.calcPrescribedHolidayWorkTime(startTime, endTime));
        dto.setLegalWorkTime(calc.calcLegalHolidayWorkTime(startTime, endTime));
        dto.setDecreaseTime(calc.calcDecreaseTime(startTime, endTime));
        dto.setStatutoryHolidayWorkTimeIn(calc.calcLegalHolidayWorkTimeIn(startTime, endTime));
        dto.setStatutoryHolidayWorkTimeOut(calc.calcLegalHolidayWorkTimeOut(startTime, endTime));
        dto.setPrescribedHolidayWorkTimeIn(calc.calcPrescribedHolidayWorkTimeIn(startTime, endTime));
        dto.setPrescribedHolidayWorkTimeOut(calc.calcPrescribedHolidayWorkTimeOut(startTime, endTime));
    }

    protected void setLateItems(AttendanceDtoInterface dto) {
        int lateTime = dto.getLateTime();
        int actualLateTime = dto.getActualLateTime();
        dto.setLateDays(0);
        dto.setLateThirtyMinutesOrMore(0);
        dto.setLateLessThanThirtyMinutes(0);
        dto.setLateThirtyMinutesOrMoreTime(0);
        dto.setLateLessThanThirtyMinutesTime(0);
        if (lateTime > 0) {
            dto.setLateDays(1);
            if (lateTime >= 30) {
                dto.setLateThirtyMinutesOrMore(1);
                dto.setLateThirtyMinutesOrMoreTime(actualLateTime);
            } else {
                dto.setLateLessThanThirtyMinutes(1);
                dto.setLateLessThanThirtyMinutesTime(actualLateTime);
            }
            if (MospUtility.isEmpty((String[])new String[]{dto.getLateReason()})) {
                dto.setLateReason("individu");
            }
        }
        if (lateTime == 0 && MospUtility.isEqual((Object)"individu", (Object)dto.getLateReason())) {
            dto.setLateReason("");
        }
    }

    protected void setLeaveEarlyItems(AttendanceDtoInterface dto) {
        int leaveEarlyTime = dto.getLeaveEarlyTime();
        int actualLeaveEarlyTime = dto.getActualLeaveEarlyTime();
        dto.setLeaveEarlyDays(0);
        dto.setLeaveEarlyThirtyMinutesOrMore(0);
        dto.setLeaveEarlyLessThanThirtyMinutes(0);
        dto.setLeaveEarlyThirtyMinutesOrMoreTime(0);
        dto.setLeaveEarlyLessThanThirtyMinutesTime(0);
        if (leaveEarlyTime > 0) {
            dto.setLeaveEarlyDays(1);
            if (leaveEarlyTime >= 30) {
                dto.setLeaveEarlyThirtyMinutesOrMore(1);
                dto.setLeaveEarlyThirtyMinutesOrMoreTime(actualLeaveEarlyTime);
            } else {
                dto.setLeaveEarlyLessThanThirtyMinutes(1);
                dto.setLeaveEarlyLessThanThirtyMinutesTime(actualLeaveEarlyTime);
            }
            if (MospUtility.isEmpty((String[])new String[]{dto.getLeaveEarlyReason()})) {
                dto.setLeaveEarlyReason("individu");
            }
        }
        if (leaveEarlyTime == 0 && MospUtility.isEqual((Object)"individu", (Object)dto.getLeaveEarlyReason())) {
            dto.setLeaveEarlyReason("");
        }
    }

    protected void setOvertimeItems(AttendanceDtoInterface dto) {
        int overtimeBefore = dto.getOvertimeBefore();
        int overtimeAfter = dto.getOvertimeAfter();
        int overtime = overtimeBefore + overtimeAfter;
        dto.setOvertime(overtime);
        dto.setTimesOvertime(0);
        if (overtime > 0) {
            dto.setTimesOvertime(1);
        }
    }

    protected void setWorkTimes(AttendanceDtoInterface dto, AttendanceEntityInterface attendance) {
        int workTimeWithinPrescribed;
        int contractWorkTime = workTimeWithinPrescribed = dto.getWorkTimeWithinPrescribedWorkTime();
        if (attendance.isLateReasonTrain() || attendance.isLateReasonCompany()) {
            contractWorkTime += dto.getActualLateTime();
        }
        if (attendance.isLeaveEarlyReasonCompany()) {
            contractWorkTime += dto.getActualLeaveEarlyTime();
        }
        dto.setContractWorkTime(contractWorkTime);
    }

    protected void setDaysAndTimes(AttendanceDtoInterface dto) throws MospException {
        boolean isCompleted = true;
        String personalId = dto.getPersonalId();
        Date workDate = dto.getWorkDate();
        RequestEntityInterface request = this.refer.getRequest(personalId, workDate);
        dto.setWorkDays((double)request.calcWorkDays(isCompleted));
        dto.setWorkDaysForPaidLeave(request.calcWorkDaysForPaidHoliday(isCompleted));
        dto.setTotalWorkDaysForPaidLeave(request.calcWorkDaysForPaidHoliday(isCompleted));
        dto.setTimesHolidayWork(request.calcWorkOnHolidayTimes(isCompleted));
        dto.setTimesLegalHolidayWork(request.calcWorkOnLegalHolidayTimes(isCompleted));
        dto.setTimesPrescribedHolidayWork(request.calcWorkOnPrescribedHolidayTimes(isCompleted));
        dto.setPaidLeaveDays((double)request.calcPaidHolidayDays(isCompleted));
        dto.setPaidLeaveHours(request.calcPaidHolidayHours(isCompleted));
        dto.setStockLeaveDays((double)request.calcStockHolidayDays(isCompleted));
        dto.setCompensationDays((double)request.calcSubHolidayDays(isCompleted));
        dto.setLegalCompensationDays((double)request.calcLegalSubHolidayDays(isCompleted));
        dto.setPrescribedCompensationDays((double)request.calcPrescribedSubHolidayDays(isCompleted));
        dto.setNightCompensationDays((double)request.calcNightSubHolidayDays(isCompleted));
        dto.setSpecialLeaveDays((double)request.calcSpecialHolidayDays(isCompleted));
        dto.setSpecialLeaveHours(request.calcSpecialHolidayHours(isCompleted));
        dto.setOtherLeaveDays((double)request.calcOtherHolidayDays(isCompleted));
        dto.setOtherLeaveHours(request.calcOtherHolidayHours(isCompleted));
        dto.setAbsenceDays((double)request.calcAbsenceDays(isCompleted));
        dto.setAbsenceHours(request.calcAbsenceHours(isCompleted));
    }

    protected void setCompensationDays(AttendanceDtoInterface dto) throws MospException {
        boolean isCompleted = true;
        String personalId = dto.getPersonalId();
        Date workDate = dto.getWorkDate();
        RequestEntityInterface request = this.refer.getRequest(personalId, workDate);
        TimeSettingEntityInterface timeSetting = this.refer.getTimeSetting(personalId, workDate);
        int workTime = dto.getWorkTime();
        int subHolidayAllNorm = timeSetting.getSubHolidayAllNorm();
        int subHolidayHalfNorm = timeSetting.getSubHolidayHalfNorm();
        dto.setGrantedLegalCompensationDays(0.0);
        dto.setGrantedPrescribedCompensationDays(0.0);
        float compensation = 0.0f;
        if (subHolidayAllNorm <= workTime) {
            compensation = 1.0f;
        } else if (subHolidayHalfNorm <= workTime) {
            compensation = 0.5f;
        }
        if (request.isWorkOnLegal(isCompleted)) {
            dto.setGrantedLegalCompensationDays((double)compensation);
        }
        if (request.isWorkOnPrescribed(isCompleted)) {
            dto.setGrantedPrescribedCompensationDays((double)compensation);
        }
    }

    protected void setExtraItems(AttendanceDtoInterface dto, AttendCalcEntityInterface calc) {
        dto.setMinutelyHolidayATime(this.getMinutelyHolidayATime(calc));
    }

    protected void setUnusedItems(AttendanceDtoInterface dto) {
        dto.setOverRestTime(0);
        dto.setMinutelyHolidayBTime(0);
        dto.setMinutelyHolidayA(0);
        dto.setMinutelyHolidayB(0);
        dto.setGrantedNightCompensationDays(0.0);
        dto.setLegalHolidayWorkTimeWithCompensationDay(0);
        dto.setLegalHolidayWorkTimeWithoutCompensationDay(0);
        dto.setPrescribedHolidayWorkTimeWithCompensationDay(0);
        dto.setPrescribedHolidayWorkTimeWithoutCompensationDay(0);
        dto.setOvertimeInWithCompensationDay(0);
        dto.setOvertimeInWithoutCompensationDay(0);
        dto.setOvertimeOutWithCompensationDay(0);
        dto.setOvertimeOutWithoutCompensationDay(0);
    }

    protected int getMinutelyHolidayATime(AttendCalcEntityInterface calc) {
        return TimeUtility.getMinutes((Map)calc.getDurationsParam("AdditionalMinutelyHolidayATime"));
    }

    protected AttendCalcEntityInterface createCalcEntity(AttendanceEntityInterface attendance) throws MospException {
        String personalId = attendance.getPersonalId();
        Date workDate = attendance.getWorkDate();
        String workTypeCode = attendance.getWorkTypeCode();
        AttendCalcEntityInterface calc = this.createCalcEntity(personalId, workDate);
        calc.setAttendance(attendance);
        calc.setTimeSetting(this.refer.getTimeSetting(personalId, workDate));
        calc.setWorkType(this.refer.getWorkType(personalId, workDate, workTypeCode));
        calc.setRequest(this.refer.getRequest(personalId, workDate));
        calc.setNextWorkType(this.refer.getNextWorkType(personalId, workDate));
        calc.setMospParams(this.mospParams);
        return calc;
    }

    protected List<AttendCalcExecuteExtraBeanInterface> getExtraBeans(String key) throws MospException {
        ArrayList<AttendCalcExecuteExtraBeanInterface> extras = new ArrayList<AttendCalcExecuteExtraBeanInterface>();
        for (String[] array : MospUtility.getCodeArray((MospParams)this.mospParams, (String)key, (boolean)false)) {
            String className = array[0];
            AttendCalcExecuteExtraBeanInterface extra = (AttendCalcExecuteExtraBeanInterface)this.createBean(AttendCalcExecuteExtraBeanInterface.class, className);
            extra.setAttendCalcRefer(this.refer);
            extras.add(extra);
        }
        return extras;
    }

    protected AttendCalcEntityInterface createCalcEntity(String personalId, Date workDate) throws MospException {
        return (AttendCalcEntityInterface)this.createObject(AttendCalcEntityInterface.class);
    }

    protected Date toDate(AttendanceDtoInterface dto, int minutes) {
        if (minutes == Integer.MIN_VALUE) {
            return null;
        }
        return DateUtility.addMinute((Date)dto.getWorkDate(), (int)minutes);
    }

    protected int getMinutes(Date time, Date workDate) {
        return TimeUtility.getAttendMinutes((Date)time, (Date)workDate);
    }
}

