/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.AttendCalcExecuteExtraBeanInterface;
import jp.mosp.time.bean.AttendCalcReferenceBeanInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.entity.AttendCalcEntityInterface;
import jp.mosp.time.entity.AttendanceEntityInterface;
import jp.mosp.time.entity.TimeDuration;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeUtility;

public class AttendCalcCheckRestBean
extends PlatformBean
implements AttendCalcExecuteExtraBeanInterface {
    protected AttendCalcReferenceBeanInterface refer;

    public void initBean() throws MospException {
    }

    public void setAttendCalcRefer(AttendCalcReferenceBeanInterface refer) {
        this.refer = refer;
    }

    public void execute(AttendCalcEntityInterface calc, AttendanceDtoInterface dto) throws MospException {
        AttendanceEntityInterface attendance = calc.getAttendance();
        String personalId = attendance.getPersonalId();
        Date workDate = attendance.getWorkDate();
        int startTime = TimeUtility.getAttendMinutes((Date)attendance.getStartTime(), (Date)workDate);
        int endTime = TimeUtility.getAttendMinutes((Date)attendance.getEndTime(), (Date)workDate);
        TimeSettingEntityInterface timeSetting = this.refer.getTimeSetting(personalId, workDate);
        Map rests = attendance.getRestTimes(timeSetting);
        Map publics = attendance.getPublicGoOutTimes(timeSetting);
        Map privates = attendance.getPrivateGoOutTimes(timeSetting);
        this.checkOvertimeBeforeRest(startTime, endTime, calc, rests, publics, privates);
        this.checkOvertimeRest(startTime, endTime, calc, rests, publics, privates);
    }

    protected void checkOvertimeBeforeRest(int startTime, int endTime, AttendCalcEntityInterface calc, Map<Integer, TimeDuration> rests, Map<Integer, TimeDuration> publics, Map<Integer, TimeDuration> privates) throws MospException {
        Map overtimeBeforeRest = calc.getOvertimeBeforeRest(startTime, endTime);
        for (TimeDuration overlap : TimeUtility.getOverlap((Map)overtimeBeforeRest, rests).values()) {
            TimeMessageUtility.addErrorOverBefRestOverlapWithRest((MospParams)this.mospParams, (TimeDuration)overlap);
        }
        for (TimeDuration overlap : TimeUtility.getOverlap((Map)overtimeBeforeRest, publics).values()) {
            TimeMessageUtility.addErrorOverBefRestOverlapWithPublic((MospParams)this.mospParams, (TimeDuration)overlap);
        }
        for (TimeDuration overlap : TimeUtility.getOverlap((Map)overtimeBeforeRest, privates).values()) {
            TimeMessageUtility.addErrorOverBefRestOverlapWithPrivate((MospParams)this.mospParams, (TimeDuration)overlap);
        }
    }

    protected void checkOvertimeRest(int startTime, int endTime, AttendCalcEntityInterface calc, Map<Integer, TimeDuration> rests, Map<Integer, TimeDuration> publics, Map<Integer, TimeDuration> privates) throws MospException {
        Map overtimeRests = calc.getOvertimeRest(startTime, endTime);
        for (TimeDuration overlap : TimeUtility.getOverlap((Map)overtimeRests, rests).values()) {
            TimeMessageUtility.addErrorOvertimeRestOverlapWithRest((MospParams)this.mospParams, (TimeDuration)overlap);
        }
        for (TimeDuration overlap : TimeUtility.getOverlap((Map)overtimeRests, publics).values()) {
            TimeMessageUtility.addErrorOvertimeRestOverlapWithPublic((MospParams)this.mospParams, (TimeDuration)overlap);
        }
        for (TimeDuration overlap : TimeUtility.getOverlap((Map)overtimeRests, privates).values()) {
            TimeMessageUtility.addErrorOvertimeRestOverlapWithPrivate((MospParams)this.mospParams, (TimeDuration)overlap);
        }
    }
}

