/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.AttendCalcConditionBeanInterface;
import jp.mosp.time.bean.AttendCalcExecuteBeanInterface;
import jp.mosp.time.bean.AttendCalcExtraBeanInterface;
import jp.mosp.time.bean.AttendCalcReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceCalcBeanInterface;
import jp.mosp.time.bean.GoOutReferenceBeanInterface;
import jp.mosp.time.bean.RestReferenceBeanInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.entity.AttendanceEntityInterface;
import jp.mosp.time.utils.AttendanceUtility;

public class AttendCalcBean
extends TimeBean
implements AttendanceCalcBeanInterface {
    protected static final String CODE_KEY_SWITCH = "AttendCalcSwitch";
    protected static final String CODE_KEY_BEFORE = "AttendCalcBefore";
    protected static final String CODE_KEY_AFTER = "AttendCalcAfter";
    protected AttendCalcReferenceBeanInterface refer;

    public void initBean() throws MospException {
        this.refer = (AttendCalcReferenceBeanInterface)this.createBeanInstance(AttendCalcReferenceBeanInterface.class);
    }

    public void attendanceCalc(AttendanceDtoInterface attendanceDto) throws MospException {
        RestReferenceBeanInterface restRefer = (RestReferenceBeanInterface)this.createBeanInstance(RestReferenceBeanInterface.class);
        GoOutReferenceBeanInterface goOutRefer = (GoOutReferenceBeanInterface)this.createBeanInstance(GoOutReferenceBeanInterface.class);
        String personalId = attendanceDto.getPersonalId();
        Date workDate = attendanceDto.getWorkDate();
        List restDtos = restRefer.getRestList(personalId, workDate);
        List goOutDtos = goOutRefer.getGoOutList(personalId, workDate);
        AttendanceEntityInterface attendance = this.getAttendanceEntity(attendanceDto, (Collection)restDtos, (Collection)goOutDtos);
        this.calc(attendance);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        AttendanceUtility.getAttendanceDtoClone((AttendanceDtoInterface)attendanceDto, (AttendanceDtoInterface)attendance.getAttendanceDto());
    }

    public void attendanceCalc(AttendanceDtoInterface attendanceDto, List<RestDtoInterface> restList, List<GoOutDtoInterface> publicGoOutList, List<GoOutDtoInterface> privateGoOutList) throws MospException {
        HashSet<GoOutDtoInterface> goOutDtos = new HashSet<GoOutDtoInterface>();
        goOutDtos.addAll(publicGoOutList);
        goOutDtos.addAll(privateGoOutList);
        AttendanceEntityInterface attendance = this.getAttendanceEntity(attendanceDto, restList, goOutDtos);
        this.calc(attendance);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        AttendanceUtility.getAttendanceDtoClone((AttendanceDtoInterface)attendanceDto, (AttendanceDtoInterface)attendance.getAttendanceDto());
    }

    public void calcStartEndTime(AttendanceDtoInterface attendanceDto, boolean useBetweenTime) throws MospException {
        Set restDtos = Collections.emptySet();
        Set goOutDtos = Collections.emptySet();
        AttendanceEntityInterface attendance = this.getAttendanceEntity(attendanceDto, restDtos, goOutDtos);
        this.calc(attendance);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        attendanceDto.setStartTime(attendance.getAttendanceDto().getStartTime());
        attendanceDto.setActualStartTime(attendance.getAttendanceDto().getActualStartTime());
        attendanceDto.setEndTime(attendance.getAttendanceDto().getEndTime());
        attendanceDto.setActualEndTime(attendance.getAttendanceDto().getActualEndTime());
    }

    protected void calc(AttendanceEntityInterface attendance) throws MospException {
        for (AttendCalcExtraBeanInterface extra : this.getExtraBeans(CODE_KEY_BEFORE, attendance)) {
            extra.execute(attendance);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        AttendCalcExecuteBeanInterface calc = this.getCalcBean(attendance);
        calc.calc(attendance);
        for (AttendCalcExtraBeanInterface extra : this.getExtraBeans(CODE_KEY_AFTER, attendance)) {
            extra.execute(attendance);
        }
    }

    protected AttendCalcExecuteBeanInterface getCalcBean(AttendanceEntityInterface attendance) throws MospException {
        AttendCalcExecuteBeanInterface calc = null;
        for (String[] array : MospUtility.getCodeArray((MospParams)this.mospParams, (String)CODE_KEY_SWITCH, (boolean)false)) {
            String conditionName = array[0];
            String executeName = array[1];
            if (!this.isSatisfied(conditionName, executeName, attendance)) continue;
            calc = (AttendCalcExecuteBeanInterface)this.createBean(AttendCalcExecuteBeanInterface.class, executeName);
            break;
        }
        if (calc == null) {
            calc = (AttendCalcExecuteBeanInterface)this.createBeanInstance(AttendCalcExecuteBeanInterface.class);
        }
        calc.setAttendCalcRefer(this.refer);
        return calc;
    }

    protected List<AttendCalcExtraBeanInterface> getExtraBeans(String codeKey, AttendanceEntityInterface attendance) throws MospException {
        ArrayList<AttendCalcExtraBeanInterface> extras = new ArrayList<AttendCalcExtraBeanInterface>();
        for (String[] array : MospUtility.getCodeArray((MospParams)this.mospParams, (String)codeKey, (boolean)false)) {
            String conditionName = array[0];
            String executeName = array[1];
            if (!this.isSatisfied(conditionName, executeName, attendance)) continue;
            AttendCalcExtraBeanInterface extra = (AttendCalcExtraBeanInterface)this.createBean(AttendCalcExtraBeanInterface.class, executeName);
            extra.setAttendCalcRefer(this.refer);
            extras.add(extra);
        }
        return extras;
    }

    protected boolean isSatisfied(String conditionName, String executeName, AttendanceEntityInterface attendance) throws MospException {
        if (MospUtility.isEmpty((String[])new String[]{conditionName, executeName})) {
            return false;
        }
        if (MospUtility.isEqual((Object)conditionName, (Object)executeName)) {
            return true;
        }
        AttendCalcConditionBeanInterface condition = (AttendCalcConditionBeanInterface)this.createBean(AttendCalcConditionBeanInterface.class, conditionName);
        condition.setAttendCalcRefer(this.refer);
        return condition.isSatisfied(attendance);
    }

    protected AttendanceEntityInterface getAttendanceEntity(AttendanceDtoInterface attendanceDto, Collection<RestDtoInterface> restDtos, Collection<GoOutDtoInterface> goOutDtos) throws MospException {
        AttendanceEntityInterface attendance = (AttendanceEntityInterface)this.createObject(AttendanceEntityInterface.class);
        attendance.setAttendanceDto(attendanceDto);
        attendance.setRestDtos(restDtos);
        attendance.setGoOutDtos(goOutDtos);
        return attendance;
    }
}

