/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.ApplicationReferenceSearchBeanInterface;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.ApplicationReferenceDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.impl.ApplicationReferenceDto;

public class ApplicationReferenceSearchBean
extends TimeBean
implements ApplicationReferenceSearchBeanInterface {
    private Date activateDate;
    private String employeeCode;
    private String employeeName;
    private String workPlaceCode;
    private String employmentCode;
    private String sectionCode;
    private String positionCode;
    private String applicationCode;
    private String applicationName;
    private String timeSettingCode;
    private String cutoffCode;
    private String scheduleCode;
    private String paidHolidayCode;
    private HumanSearchBeanInterface humanSearch;
    private ApplicationReferenceBeanInterface applicationRefer;
    private TimeSettingReferenceBeanInterface timeReference;
    private ScheduleUtilBeanInterface scheduleUtil;
    private CutoffReferenceBeanInterface cutoffRefer;
    private PaidHolidayReferenceBeanInterface paidHolidayRefer;

    public void initBean() throws MospException {
        this.humanSearch = (HumanSearchBeanInterface)this.createBeanInstance(HumanSearchBeanInterface.class);
        this.applicationRefer = (ApplicationReferenceBeanInterface)this.createBeanInstance(ApplicationReferenceBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.cutoffRefer = (CutoffReferenceBeanInterface)this.createBeanInstance(CutoffReferenceBeanInterface.class);
        this.paidHolidayRefer = (PaidHolidayReferenceBeanInterface)this.createBeanInstance(PaidHolidayReferenceBeanInterface.class);
        this.timeReference = (TimeSettingReferenceBeanInterface)this.createBeanInstance(TimeSettingReferenceBeanInterface.class);
    }

    public List<ApplicationReferenceDtoInterface> getSearchList() throws MospException {
        ArrayList<ApplicationReferenceDtoInterface> list = new ArrayList<ApplicationReferenceDtoInterface>();
        this.humanSearch.setTargetDate(this.activateDate);
        this.humanSearch.setEmployeeCode(this.employeeCode);
        this.humanSearch.setEmployeeName(this.employeeName);
        this.humanSearch.setWorkPlaceCode(this.workPlaceCode);
        this.humanSearch.setSectionCode(this.sectionCode);
        this.humanSearch.setPositionCode(this.positionCode);
        this.humanSearch.setEmploymentContractCode(this.employmentCode);
        this.humanSearch.setEmployeeCodeType("forward");
        this.humanSearch.setNeedLowerSection(true);
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setStateType("presence");
        List humanList = this.humanSearch.search();
        String[][] aryTimeSet = this.timeReference.getSelectArray(this.activateDate, false);
        String[][] arySchedule = this.scheduleUtil.getSelectArray(this.activateDate, false);
        String[][] aryCutoff = this.cutoffRefer.getSelectArray(this.activateDate, false);
        String[][] aryPaidHoliday = this.paidHolidayRefer.getSelectArray(this.activateDate, false);
        for (HumanDtoInterface humanDto : humanList) {
            ApplicationDtoInterface applicationDto = this.applicationRefer.findForPerson(humanDto.getPersonalId(), this.activateDate);
            if (!this.isApplicaationMatch(applicationDto)) continue;
            TimeSettingDtoInterface timeSettingDto = null;
            if (applicationDto != null) {
                timeSettingDto = this.timeReference.getTimeSettingInfo(applicationDto.getWorkSettingCode(), this.activateDate);
            }
            if (!this.isCutoffMatch(timeSettingDto)) continue;
            ApplicationReferenceDto dto = this.getApplicationReferenceDto();
            dto.setPersonalId(humanDto.getPersonalId());
            dto.setEmployeeCode(humanDto.getEmployeeCode());
            dto.setFirstName(humanDto.getFirstName());
            dto.setLastName(humanDto.getLastName());
            dto.setEmployeeName(MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName()));
            if (applicationDto != null) {
                dto.setActivateDate(applicationDto.getActivateDate());
                dto.setApplicationCode(applicationDto.getApplicationCode());
                dto.setApplicationName(applicationDto.getApplicationName());
                dto.setScheduleCode(applicationDto.getScheduleCode());
                dto.setScheduleAbbr(this.getCodeName(applicationDto.getScheduleCode(), arySchedule));
                dto.setPaidHolidayCode(applicationDto.getPaidHolidayCode());
                dto.setPaidHolidayAbbr(this.getCodeName(applicationDto.getPaidHolidayCode(), aryPaidHoliday));
                dto.setTimeSettingCode(applicationDto.getWorkSettingCode());
                dto.setTimeSettingAbbr(this.getCodeName(applicationDto.getWorkSettingCode(), aryTimeSet));
                if (timeSettingDto != null) {
                    dto.setCutoffAbbr(this.getCodeName(timeSettingDto.getCutoffCode(), aryCutoff));
                    dto.setCutoffCode(timeSettingDto.getCutoffCode());
                }
            }
            list.add((ApplicationReferenceDtoInterface)dto);
        }
        return list;
    }

    public ApplicationReferenceDto getApplicationReferenceDto() {
        ApplicationReferenceDto dto = new ApplicationReferenceDto();
        dto.setActivateDate(null);
        dto.setEmployeeCode("");
        dto.setEmployeeName("");
        dto.setApplicationName("");
        dto.setApplicationCode("");
        dto.setApplicationAbbr("");
        dto.setCutoff("");
        dto.setCutoffAbbr("");
        dto.setCutoffCode("");
        dto.setCutoffName("");
        dto.setTimeSetting("");
        dto.setTimeSettingCode("");
        dto.setTimeSettingName("");
        dto.setTimeSettingAbbr("");
        dto.setSectionCode("");
        dto.setScheduleName("");
        dto.setScheduleCode("");
        dto.setScheduleAbbr("");
        dto.setSchedule("");
        dto.setPositionCode("");
        dto.setPersonalId("");
        dto.setPaidHolidayName("");
        dto.setPaidHolidayCode("");
        dto.setEmploymentContractCode("");
        dto.setFirstName("");
        dto.setLastName("");
        dto.setWorkPlaceCode("");
        return dto;
    }

    protected boolean isApplicaationMatch(ApplicationDtoInterface applicationDto) throws MospException {
        if (!this.applicationCode.isEmpty()) {
            if (applicationDto == null) {
                return false;
            }
            if (!this.isForwardMatch(this.applicationCode, applicationDto.getApplicationCode())) {
                return false;
            }
        }
        if (!this.applicationName.isEmpty()) {
            if (applicationDto == null) {
                return false;
            }
            if (!this.isBroadMatch(this.applicationName, applicationDto.getApplicationName()) && !this.isBroadMatch(this.applicationName, applicationDto.getApplicationAbbr())) {
                return false;
            }
        }
        if (!this.timeSettingCode.isEmpty()) {
            if (applicationDto == null) {
                return false;
            }
            if (!this.isExactMatch(this.timeSettingCode, applicationDto.getWorkSettingCode())) {
                return false;
            }
        }
        if (!this.paidHolidayCode.isEmpty()) {
            if (applicationDto == null) {
                return false;
            }
            if (!this.isExactMatch(this.paidHolidayCode, applicationDto.getPaidHolidayCode())) {
                return false;
            }
        }
        if (!this.scheduleCode.isEmpty()) {
            if (applicationDto == null) {
                return false;
            }
            if (!this.isExactMatch(this.scheduleCode, applicationDto.getScheduleCode())) {
                return false;
            }
        }
        return true;
    }

    protected boolean isCutoffMatch(TimeSettingDtoInterface timeSettingDto) throws MospException {
        if (!this.cutoffCode.isEmpty()) {
            if (timeSettingDto == null) {
                return false;
            }
            if (!this.isExactMatch(this.cutoffCode, timeSettingDto.getCutoffCode())) {
                return false;
            }
        }
        return true;
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = this.getDateClone(activateDate);
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setEmploymentCode(String employmentCode) {
        this.employmentCode = employmentCode;
    }

    public void setScheduleCode(String scheduleCode) {
        this.scheduleCode = scheduleCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setTimeSettingCode(String timeSettingCode) {
        this.timeSettingCode = timeSettingCode;
    }

    public void setCutoffCode(String cutoffCode) {
        this.cutoffCode = cutoffCode;
    }

    public void setPaidHolidayCode(String paidHolidayCode) {
        this.paidHolidayCode = paidHolidayCode;
    }
}

