/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dao.settings.ApplicationDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeUtility;

public class ApplicationReferenceBean
extends TimeBean
implements ApplicationReferenceBeanInterface {
    protected ApplicationDaoInterface dao;
    protected HumanDaoInterface humanDao;

    public void initBean() throws MospException {
        this.dao = (ApplicationDaoInterface)this.createDaoInstance(ApplicationDaoInterface.class);
        this.humanDao = (HumanDaoInterface)this.createDaoInstance(HumanDaoInterface.class);
    }

    public List<ApplicationDtoInterface> getApplicationHistory(String applicationCode) throws MospException {
        return this.dao.findForHistory(applicationCode);
    }

    public ApplicationDtoInterface findForKey(String applicationCode, Date targetDate) throws MospException {
        ApplicationDtoInterface dto = this.dao.findForKey(applicationCode, targetDate);
        if (dto != null) {
            return dto;
        }
        return null;
    }

    public ApplicationDtoInterface findFormerInfo(String applicationCode, Date activateDate) throws MospException {
        return this.dao.findFormerInfo(applicationCode, activateDate);
    }

    public ApplicationDtoInterface findForPerson(String personalId, Date targetDate) throws MospException {
        ApplicationDtoInterface dto = null;
        dto = this.dao.findForPersonalId(targetDate, personalId);
        if (dto != null) {
            return dto;
        }
        HumanDtoInterface humanDto = this.humanDao.findForInfo(personalId, targetDate);
        if (humanDto == null) {
            return dto;
        }
        String positionCode = humanDto.getPositionCode();
        String sectionCode = humanDto.getSectionCode();
        String employmentContractCode = humanDto.getEmploymentContractCode();
        String workPlaceCode = humanDto.getWorkPlaceCode();
        String blank = "";
        dto = this.dao.findForMaster(targetDate, workPlaceCode, employmentContractCode, sectionCode, positionCode);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, employmentContractCode, sectionCode, positionCode);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, blank, sectionCode, positionCode);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, blank, blank, positionCode);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, workPlaceCode, employmentContractCode, sectionCode, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, employmentContractCode, sectionCode, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, blank, sectionCode, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, workPlaceCode, employmentContractCode, blank, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, employmentContractCode, blank, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, workPlaceCode, blank, blank, blank);
        if (dto != null) {
            return dto;
        }
        dto = this.dao.findForMaster(targetDate, blank, blank, blank, blank);
        if (dto != null) {
            return dto;
        }
        return dto;
    }

    public void chkExistApplication(ApplicationDtoInterface dto, Date targetDate) {
        if (dto == null) {
            TimeMessageUtility.addErrorApplicationDefect((MospParams)this.mospParams, (Date)targetDate);
        }
    }

    public boolean hasPersonalApplication(String personalId, Date startDate, Date endDate) throws MospException {
        List list = this.dao.findPersonTerm(personalId, startDate, endDate);
        return !list.isEmpty();
    }

    public ApplicationEntity getApplicationEntity(String personalId, Date targetDate) throws MospException {
        ApplicationDtoInterface applicationDto = this.findForPerson(personalId, targetDate);
        ApplicationEntity applicationEntity = new ApplicationEntity(applicationDto);
        if (MospUtility.isEmpty((Object[])new Object[]{applicationDto})) {
            applicationEntity.setCutoffEntity(TimeUtility.getBareCutoffEntity((MospParams)this.mospParams));
            return applicationEntity;
        }
        TimeSettingReferenceBeanInterface timeSettingRefer = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
        CutoffReferenceBeanInterface cutoffRefer = (CutoffReferenceBeanInterface)this.createBean(CutoffReferenceBeanInterface.class);
        PaidHolidayReferenceBeanInterface paidHolidayRefer = (PaidHolidayReferenceBeanInterface)this.createBean(PaidHolidayReferenceBeanInterface.class);
        String workSettingCode = applicationEntity.getWorkSettingCode();
        TimeSettingDtoInterface timeSettingDto = timeSettingRefer.getTimeSettingInfo(workSettingCode, targetDate);
        applicationEntity.setTimeSettingDto(timeSettingDto);
        String cutoffCode = applicationEntity.getCutoffCode();
        CutoffEntityInterface cutoffEntity = cutoffRefer.getCutoffEntity(cutoffCode, targetDate);
        applicationEntity.setCutoffEntity(cutoffEntity);
        String paidHolidayCode = applicationEntity.getPaidHolidayCode();
        applicationEntity.setPaidHolidayDto(paidHolidayRefer.getPaidHolidayInfo(paidHolidayCode, targetDate));
        return applicationEntity;
    }

    public ApplicationEntity getApplicationEntity(String personalId, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        return this.getApplicationEntity(personalId, targetDate);
    }
}

