/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.TransStringUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.bean.impl.TimeBaseExportBean;
import jp.mosp.time.comparator.report.AppliReasonDataComparator;
import jp.mosp.time.dao.settings.DifferenceRequestDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeChangeRequestDaoInterface;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class AppliReasonDataExportBean
extends TimeBaseExportBean {
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected OvertimeRequestDaoInterface overtimeReqDao;
    protected HolidayRequestDaoInterface holidayReqDao;
    protected WorkOnHolidayRequestDaoInterface workOnHolidayReqDao;
    protected SubstituteDaoInterface substituteDao;
    protected WorkTypeChangeRequestDaoInterface workTypeChangeReqDao;
    WorkTypeReferenceBeanInterface workTypeRefer;
    protected DifferenceRequestDaoInterface differenceReqDao;
    protected WorkflowReferenceBeanInterface workflowRefer;
    protected List<OvertimeRequestDtoInterface> overtimeRequestList;
    protected List<HolidayRequestDtoInterface> holidayRequestList;
    protected List<WorkOnHolidayRequestDtoInterface> workOnHolidayList;
    protected List<DifferenceRequestDtoInterface> differenceRequestList;
    protected List<WorkTypeChangeRequestDtoInterface> workTypeChangeRequestList;

    public void initBean() throws MospException {
        super.initBean();
        this.substituteDao = (SubstituteDaoInterface)this.createDaoInstance(SubstituteDaoInterface.class);
        this.overtimeReqDao = (OvertimeRequestDaoInterface)this.createDaoInstance(OvertimeRequestDaoInterface.class);
        this.holidayReqDao = (HolidayRequestDaoInterface)this.createDaoInstance(HolidayRequestDaoInterface.class);
        this.workOnHolidayReqDao = (WorkOnHolidayRequestDaoInterface)this.createDaoInstance(WorkOnHolidayRequestDaoInterface.class);
        this.workTypeChangeReqDao = (WorkTypeChangeRequestDaoInterface)this.createDaoInstance(WorkTypeChangeRequestDaoInterface.class);
        this.differenceReqDao = (DifferenceRequestDaoInterface)this.createDaoInstance(DifferenceRequestDaoInterface.class);
        this.workTypeRefer = (WorkTypeReferenceBeanInterface)this.createBeanInstance(WorkTypeReferenceBeanInterface.class);
        this.workflowRefer = (WorkflowReferenceBeanInterface)this.createBeanInstance(WorkflowReferenceBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.scheduleUtil.setTimeMaster(this.timeMaster);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date firstDate, Date lastDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, boolean needLowerSection, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        List humanList = this.getHumanList(firstDate, lastDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, needLowerSection, positionCode);
        for (HumanDtoInterface humanDto : humanList) {
            this.getAppliedRequestList(humanDto.getPersonalId(), firstDate, lastDate);
            this.addOverTimeRequestData(humanDto, csvDataList, fieldList, (Collection)this.overtimeRequestList, lastDate);
            this.addHolidayRequestData(humanDto, csvDataList, fieldList, (Collection)this.holidayRequestList, firstDate, lastDate);
            this.addWorkOnHolidayRequestData(humanDto, csvDataList, fieldList, (Collection)this.workOnHolidayList, lastDate);
            this.addDifferenceRequestData(humanDto, csvDataList, fieldList, (Collection)this.differenceRequestList, lastDate);
            this.addWorkTypeChangeRequestData(humanDto, csvDataList, fieldList, (Collection)this.workTypeChangeRequestList, lastDate);
        }
        Collections.sort(csvDataList, new AppliReasonDataComparator());
        return csvDataList;
    }

    protected void getAppliedRequestList(String personalId, Date firstDate, Date lastDate) throws MospException {
        List overtimes = this.overtimeReqDao.findForList(personalId, firstDate, lastDate);
        List holidays = this.holidayReqDao.findForTerm(personalId, firstDate, lastDate);
        List works = this.workOnHolidayReqDao.findForList(personalId, firstDate, lastDate);
        List differences = this.differenceReqDao.findForList(personalId, firstDate, lastDate);
        List workTypes = this.workTypeChangeReqDao.findForTerm(personalId, firstDate, lastDate);
        Set workflowSet = WorkflowUtility.getWorkflowSet((Collection[])new Collection[]{overtimes, holidays, works, differences, workTypes});
        Map workflows = this.workflowRefer.getWorkflows(workflowSet);
        Set statuses = WorkflowUtility.getCompletedStatuses();
        this.overtimeRequestList = WorkflowUtility.getStatusMatchedList((Collection)overtimes, (Map)workflows, (Set)statuses);
        this.holidayRequestList = WorkflowUtility.getStatusMatchedList((Collection)holidays, (Map)workflows, (Set)statuses);
        this.workOnHolidayList = WorkflowUtility.getStatusMatchedList((Collection)works, (Map)workflows, (Set)statuses);
        this.differenceRequestList = WorkflowUtility.getStatusMatchedList((Collection)differences, (Map)workflows, (Set)statuses);
        this.workTypeChangeRequestList = WorkflowUtility.getStatusMatchedList((Collection)workTypes, (Map)workflows, (Set)statuses);
    }

    protected void addOverTimeRequestData(HumanDtoInterface humanDto, List<String[]> csvDataList, List<String> fieldList, Collection<OvertimeRequestDtoInterface> dtos, Date targetDate) throws MospException {
        for (OvertimeRequestDtoInterface dto : dtos) {
            csvDataList.add(this.getOverTimeRequestData(humanDto, fieldList, dto, targetDate));
        }
    }

    protected String[] getOverTimeRequestData(HumanDtoInterface humanDto, List<String> fieldList, OvertimeRequestDtoInterface dto, Date targetDate) throws MospException {
        String[] csvData = this.getHumanCsvData(fieldList, humanDto, targetDate);
        String workDate = DateUtility.getStringDateAndDay((Date)dto.getRequestDate());
        String appliType = TimeNamingUtility.getOvertimeWork((MospParams)this.mospParams);
        String detail1 = this.getCodeName(dto.getOvertimeType(), "OverTimeType");
        String detail2 = TimeUtility.getStringJpTime((MospParams)this.mospParams, (int)dto.getRequestTime());
        String appliReason = dto.getRequestReason();
        this.setCsvValue(csvData, fieldList, "work_date", (Object)workDate);
        this.setCsvValue(csvData, fieldList, "appli_type", (Object)appliType);
        this.setCsvValue(csvData, fieldList, "appli_detailed_1", (Object)detail1);
        this.setCsvValue(csvData, fieldList, "appli_detailed_2", (Object)detail2);
        this.setCsvValue(csvData, fieldList, "appli_reason", (Object)appliReason);
        return csvData;
    }

    protected void addHolidayRequestData(HumanDtoInterface humanDto, List<String[]> csvDataList, List<String> fieldList, Collection<HolidayRequestDtoInterface> dtos, Date firstDate, Date lastDate) throws MospException {
        for (HolidayRequestDtoInterface dto : dtos) {
            List dateList = TimeUtility.getDateList((Date)dto.getRequestStartDate(), (Date)dto.getRequestEndDate());
            for (Date requestDate : dateList) {
                String personalId = humanDto.getPersonalId();
                String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(personalId, requestDate, true);
                if (TimeRequestUtility.isNotHolidayForConsecutiveHolidays((String)workTypeCode) || requestDate.compareTo(firstDate) < 0 || requestDate.compareTo(lastDate) > 0) continue;
                csvDataList.add(this.getHolidayRequestData(humanDto, fieldList, dto, requestDate, lastDate));
            }
        }
    }

    protected String[] getHolidayRequestData(HumanDtoInterface humanDto, List<String> fieldList, HolidayRequestDtoInterface dto, Date requestDate, Date targetDate) throws MospException {
        String[] csvData = this.getHumanCsvData(fieldList, humanDto, targetDate);
        String workDate = DateUtility.getStringDateAndDay((Date)requestDate);
        String appliType = TimeNamingUtility.getVacation((MospParams)this.mospParams);
        String detail1 = this.getCodeName(dto.getHolidayType1(), "HolidayType");
        String detail2 = this.getCodeName(dto.getHolidayType2(), "HolidayType2WithPay");
        if (TimeRequestUtility.isSpecialHoliday((HolidayRequestDtoInterface)dto) || TimeRequestUtility.isOtherHoliday((HolidayRequestDtoInterface)dto) || TimeRequestUtility.isAbsenece((HolidayRequestDtoInterface)dto)) {
            detail2 = this.timeMaster.getHolidayAbbr(dto.getHolidayType2(), dto.getHolidayType1(), targetDate);
        }
        String detail3 = this.getCodeName(dto.getHolidayRange(), "HolidayType3Range1");
        String detail4 = "";
        if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) {
            detail4 = this.getTimeWaveFormat(dto.getStartTime(), dto.getEndTime(), dto.getRequestStartDate());
        }
        String appliReason = dto.getRequestReason();
        this.setCsvValue(csvData, fieldList, "work_date", (Object)workDate);
        this.setCsvValue(csvData, fieldList, "appli_type", (Object)appliType);
        this.setCsvValue(csvData, fieldList, "appli_detailed_1", (Object)detail1);
        this.setCsvValue(csvData, fieldList, "appli_detailed_2", (Object)detail2);
        this.setCsvValue(csvData, fieldList, "appli_detailed_3", (Object)detail3);
        this.setCsvValue(csvData, fieldList, "appli_detailed_4", (Object)detail4);
        this.setCsvValue(csvData, fieldList, "appli_reason", (Object)appliReason);
        return csvData;
    }

    protected void addWorkOnHolidayRequestData(HumanDtoInterface humanDto, List<String[]> csvDataList, List<String> fieldList, Collection<WorkOnHolidayRequestDtoInterface> dtos, Date targetDate) throws MospException {
        for (WorkOnHolidayRequestDtoInterface dto : dtos) {
            csvDataList.add(this.getWorkOnHolidayRequestData(humanDto, fieldList, dto, targetDate));
        }
    }

    protected String[] getWorkOnHolidayRequestData(HumanDtoInterface humanDto, List<String> fieldList, WorkOnHolidayRequestDtoInterface dto, Date targetDate) throws MospException {
        String[] csvData = this.getHumanCsvData(fieldList, humanDto, targetDate);
        String workDate = DateUtility.getStringDateAndDay((Date)dto.getRequestDate());
        String appliType = TimeNamingUtility.workOnHoliday((MospParams)this.mospParams);
        String detail1 = this.getCodeName(dto.getSubstitute(), "WorkOnHolidaySubstitute");
        if (TimeRequestUtility.isWorkOnHolidayAnteSubstitute((WorkOnHolidayRequestDtoInterface)dto)) {
            detail1 = TimeNamingUtility.anteMeridiem((MospParams)this.mospParams);
        }
        if (TimeRequestUtility.isWorkOnHolidayPostSubstitute((WorkOnHolidayRequestDtoInterface)dto)) {
            detail1 = TimeNamingUtility.postMeridiem((MospParams)this.mospParams);
        }
        List substitutes = this.substituteDao.findForWorkflow(dto.getWorkflow());
        String detail2 = this.getWorkOnHolidayRequestDetail2(dto, substitutes);
        String detail3 = this.getWorkOnHolidayRequestDetail3(substitutes);
        String detail4 = dto.getWorkTypeCode();
        String appliReason = dto.getRequestReason();
        this.setCsvValue(csvData, fieldList, "work_date", (Object)workDate);
        this.setCsvValue(csvData, fieldList, "appli_type", (Object)appliType);
        this.setCsvValue(csvData, fieldList, "appli_detailed_1", (Object)detail1);
        this.setCsvValue(csvData, fieldList, "appli_detailed_2", (Object)detail2);
        this.setCsvValue(csvData, fieldList, "appli_detailed_3", (Object)detail3);
        this.setCsvValue(csvData, fieldList, "appli_detailed_4", (Object)detail4);
        this.setCsvValue(csvData, fieldList, "appli_reason", (Object)appliReason);
        return csvData;
    }

    protected String getWorkOnHolidayRequestDetail2(WorkOnHolidayRequestDtoInterface dto, List<SubstituteDtoInterface> substitutes) {
        if (TimeRequestUtility.isWorkOnHolidaySubstituteOff((WorkOnHolidayRequestDtoInterface)dto)) {
            return this.getTimeWaveFormat(dto.getStartTime(), dto.getEndTime(), dto.getRequestDate());
        }
        ArrayList<String> substituteDate = new ArrayList<String>();
        for (SubstituteDtoInterface substitute : substitutes) {
            substituteDate.add(DateUtility.getStringDateAndDay((Date)substitute.getSubstituteDate()));
        }
        return MospUtility.concat((String[])MospUtility.toArray(substituteDate));
    }

    protected String getWorkOnHolidayRequestDetail3(List<SubstituteDtoInterface> substitutes) {
        ArrayList<String> substituteRange = new ArrayList<String>();
        for (SubstituteDtoInterface substitute : substitutes) {
            substituteRange.add(TimeRequestUtility.getSubstituteRangeName((SubstituteDtoInterface)substitute, (MospParams)this.mospParams));
        }
        return MospUtility.concat((String[])MospUtility.toArray(substituteRange));
    }

    protected void addDifferenceRequestData(HumanDtoInterface humanDto, List<String[]> csvDataList, List<String> fieldList, Collection<DifferenceRequestDtoInterface> dtos, Date targetDate) throws MospException {
        for (DifferenceRequestDtoInterface dto : dtos) {
            csvDataList.add(this.getDifferenceRequestData(humanDto, fieldList, dto, targetDate));
        }
    }

    protected String[] getDifferenceRequestData(HumanDtoInterface humanDto, List<String> fieldList, DifferenceRequestDtoInterface dto, Date targetDate) throws MospException {
        String[] csvData = this.getHumanCsvData(fieldList, humanDto, targetDate);
        String workDate = DateUtility.getStringDateAndDay((Date)dto.getRequestDate());
        String appliType = TimeNamingUtility.getTimeDifference((MospParams)this.mospParams);
        String detail1 = TimeRequestUtility.getDifferenceTypeAbbr((DifferenceRequestDtoInterface)dto, (MospParams)this.mospParams);
        String detail2 = this.getTimeWaveFormat(dto.getRequestStart(), dto.getRequestEnd(), dto.getRequestDate());
        String appliReason = dto.getRequestReason();
        this.setCsvValue(csvData, fieldList, "work_date", (Object)workDate);
        this.setCsvValue(csvData, fieldList, "appli_type", (Object)appliType);
        this.setCsvValue(csvData, fieldList, "appli_detailed_1", (Object)detail1);
        this.setCsvValue(csvData, fieldList, "appli_detailed_2", (Object)detail2);
        this.setCsvValue(csvData, fieldList, "appli_reason", (Object)appliReason);
        return csvData;
    }

    protected void addWorkTypeChangeRequestData(HumanDtoInterface humanDto, List<String[]> csvDataList, List<String> fieldList, Collection<WorkTypeChangeRequestDtoInterface> dtos, Date targetDate) throws MospException {
        for (WorkTypeChangeRequestDtoInterface dto : dtos) {
            csvDataList.add(this.getWorkTypeChangeRequestData(humanDto, fieldList, dto, targetDate));
        }
    }

    protected String[] getWorkTypeChangeRequestData(HumanDtoInterface humanDto, List<String> fieldList, WorkTypeChangeRequestDtoInterface dto, Date targetDate) throws MospException {
        String[] csvData = this.getHumanCsvData(fieldList, humanDto, targetDate);
        String workDate = DateUtility.getStringDateAndDay((Date)dto.getRequestDate());
        String appliType = TimeNamingUtility.workTypeChangeShort((MospParams)this.mospParams);
        String detail1 = this.workTypeRefer.getWorkTypeAbbrAndTime(dto.getWorkTypeCode(), dto.getRequestDate());
        String detail2 = dto.getWorkTypeCode();
        String appliReason = dto.getRequestReason();
        this.setCsvValue(csvData, fieldList, "work_date", (Object)workDate);
        this.setCsvValue(csvData, fieldList, "appli_type", (Object)appliType);
        this.setCsvValue(csvData, fieldList, "appli_detailed_1", (Object)detail1);
        this.setCsvValue(csvData, fieldList, "appli_detailed_2", (Object)detail2);
        this.setCsvValue(csvData, fieldList, "appli_reason", (Object)appliReason);
        return csvData;
    }

    protected String getTimeWaveFormat(Date date1, Date date2, Date standardDate) {
        return TransStringUtility.getHourColonMinuteTerm((MospParams)this.mospParams, (Date)date1, (Date)date2, (Date)standardDate);
    }
}

