/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.base;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayReferenceBeanInterface;
import jp.mosp.time.bean.TimeSettingReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;

public abstract class TimeApplicationBean
extends TimeBean {
    protected ApplicationReferenceBeanInterface applicationRefer;
    protected TimeSettingReferenceBeanInterface timeSettingRefer;
    protected CutoffReferenceBeanInterface cutoffRefer;
    protected PaidHolidayReferenceBeanInterface paidHolidayRefer;
    protected ApplicationDtoInterface applicationDto;
    protected TimeSettingDtoInterface timeSettingDto;
    protected CutoffDtoInterface cutoffDto;
    protected PaidHolidayDtoInterface paidHolidayDto;

    public void initBean() throws MospException {
        this.cutoffRefer = (CutoffReferenceBeanInterface)this.createBean(CutoffReferenceBeanInterface.class);
        this.timeSettingRefer = (TimeSettingReferenceBeanInterface)this.createBean(TimeSettingReferenceBeanInterface.class);
        this.applicationRefer = (ApplicationReferenceBeanInterface)this.createBean(ApplicationReferenceBeanInterface.class);
        this.paidHolidayRefer = (PaidHolidayReferenceBeanInterface)this.createBean(PaidHolidayReferenceBeanInterface.class);
    }

    protected void setApplicationSettings(String personalId, Date targetDate) throws MospException {
        this.applicationDto = this.applicationRefer.findForPerson(personalId, targetDate);
        this.applicationRefer.chkExistApplication(this.applicationDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
    }

    protected void setTimeSettings(String personalId, Date targetDate) throws MospException {
        this.setApplicationSettings(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.timeSettingDto = this.timeSettingRefer.getTimeSettingInfo(this.applicationDto.getWorkSettingCode(), targetDate);
        this.timeSettingRefer.chkExistTimeSetting(this.timeSettingDto, targetDate);
    }

    protected void setCutoffSettings(String personalId, Date targetDate) throws MospException {
        this.setTimeSettings(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.cutoffDto = this.cutoffRefer.getCutoffInfo(this.timeSettingDto.getCutoffCode(), targetDate);
        if (this.cutoffDto == null) {
            this.addCutoffNotExistErrorMessage(targetDate);
            return;
        }
    }

    protected boolean hasApplicationSettings(String personalId, Date targetDate) throws MospException {
        this.applicationDto = this.applicationRefer.findForPerson(personalId, targetDate);
        return this.applicationDto != null;
    }

    protected boolean hasTimeSettings(String personalId, Date targetDate) throws MospException {
        if (!this.hasApplicationSettings(personalId, targetDate)) {
            return false;
        }
        this.timeSettingDto = this.timeSettingRefer.getTimeSettingInfo(this.applicationDto.getWorkSettingCode(), targetDate);
        return this.timeSettingDto != null;
    }

    protected void setPaidHolidaySettings(String personalId, Date targetDate) throws MospException {
        this.setApplicationSettings(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.paidHolidayDto = this.paidHolidayRefer.getPaidHolidayInfo(this.applicationDto.getPaidHolidayCode(), targetDate);
        this.paidHolidayRefer.chkExistPaidHoliday(this.paidHolidayDto, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
    }

    protected boolean hasPaidHolidaySettings(String personalId, Date targetDate) throws MospException {
        if (!this.hasApplicationSettings(personalId, targetDate)) {
            return false;
        }
        this.paidHolidayDto = this.paidHolidayRefer.getPaidHolidayInfo(this.applicationDto.getPaidHolidayCode(), targetDate);
        return this.paidHolidayDto != null;
    }

    protected void addCutoffNotExistErrorMessage(Date targetDate) {
        String[] rep = new String[]{this.getStringDate(targetDate), this.mospParams.getName("CutoffDate", new String[]{"Information"})};
        this.mospParams.addErrorMessage("TMW0246", rep);
    }
}

