/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.base;

import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.HtmlUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.RoleUtility;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowCommentDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.TransStringUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeBeanHandlerInterface;
import jp.mosp.time.base.TimeReferenceBeanHandlerInterface;
import jp.mosp.time.base.TimeVo;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.CheckAvailableBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypePatternItemReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.ManagementRequestListDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypePatternDtoInterface;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public abstract class TimeAction
extends PlatformAction {
    public static final String PATH_TIME_JS = "/pub/time/base/js/time.js";
    public static final String PATH_TIME_CSS = "/pub/time/base/css/time.css";
    protected TimeBeanHandlerInterface time;
    protected TimeReferenceBeanHandlerInterface timeReference;

    protected void addBaseJsCssFiles() {
        super.addBaseJsCssFiles();
        this.mospParams.addJsFile(PATH_TIME_JS);
        this.mospParams.addCssFile(PATH_TIME_CSS);
    }

    protected TimeBeanHandlerInterface time() throws MospException {
        if (this.time != null) {
            return this.time;
        }
        this.time = (TimeBeanHandlerInterface)this.createHandler(TimeBeanHandlerInterface.class);
        return this.time;
    }

    protected TimeReferenceBeanHandlerInterface timeReference() throws MospException {
        if (this.timeReference != null) {
            return this.timeReference;
        }
        this.timeReference = (TimeReferenceBeanHandlerInterface)this.createHandler(TimeReferenceBeanHandlerInterface.class);
        return this.timeReference;
    }

    protected Date getEditActivateDate() {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        return this.getDate(vo.getTxtEditActivateYear(), vo.getTxtEditActivateMonth(), vo.getTxtEditActivateDay());
    }

    protected Date getSearchActivateDate() {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        return this.getDate(vo.getTxtSearchActivateYear(), vo.getTxtSearchActivateMonth(), vo.getTxtSearchActivateDay());
    }

    protected Date getUpdateActivateDate() {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        return this.getDate(vo.getTxtUpdateActivateYear(), vo.getTxtUpdateActivateMonth(), vo.getTxtUpdateActivateDay());
    }

    protected void setSearchActivateDate(Date date) {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        if (date == null) {
            vo.setTxtSearchActivateYear("");
            vo.setTxtSearchActivateMonth("");
            vo.setTxtSearchActivateDay("");
        }
        vo.setTxtSearchActivateYear(this.getStringYear(date));
        vo.setTxtSearchActivateMonth(this.getStringMonth(date));
        vo.setTxtSearchActivateDay(this.getStringDay(date));
    }

    protected String[][] getYearArray(int year) {
        return this.getYearArray(year, 3, 1);
    }

    protected String[][] getYearArray() throws MospException {
        int year = DateUtility.getYear((Date)this.getSystemDate());
        int minYear = this.timeReference().totalTime().getMinYear();
        int former = year - minYear;
        if (minYear == 0 || former < 1) {
            former = 1;
        }
        return this.getYearArray(year, former, 1);
    }

    protected String[][] getYearArray(int year, int former, int further) {
        int y = year - former;
        String[][] aryYear = new String[former + further + 1][2];
        for (int i = 0; i < aryYear.length; ++i) {
            String stringYear;
            aryYear[i][0] = stringYear = Integer.toString(y + i);
            aryYear[i][1] = stringYear;
        }
        return aryYear;
    }

    public String[][] getMonthArray() {
        return this.getMonthArray(false);
    }

    public String[][] getMonthArray(boolean needBlank) {
        int month = 12;
        if (!needBlank) {
            String[][] aryMonth = new String[month][2];
            for (int i = 0; i < month; ++i) {
                aryMonth[i][0] = String.valueOf(i + 1);
                aryMonth[i][1] = String.valueOf(i + 1);
            }
            return aryMonth;
        }
        int months = 13;
        String[][] aryMonth = new String[months][2];
        aryMonth[0][0] = "";
        aryMonth[0][1] = "";
        for (int i = 0; i < month; ++i) {
            aryMonth[i + 1][0] = String.valueOf(i + 1);
            aryMonth[i + 1][1] = String.valueOf(i + 1);
        }
        return aryMonth;
    }

    public String[][] getDayArray() {
        return this.getDayArray(false);
    }

    public String[][] getDayArray(boolean needBlank) {
        return this.getDayArray(31, needBlank);
    }

    public String[][] getDayArray(int day, boolean needBlank) {
        if (day < 1) {
            return this.getDayArray(1, needBlank);
        }
        if (day > 31) {
            return this.getDayArray(31, needBlank);
        }
        if (needBlank) {
            String[][] aryDay = new String[day + 1][2];
            aryDay[0][0] = "";
            aryDay[0][1] = "";
            for (int i = 1; i <= day; ++i) {
                String stringDay;
                aryDay[i][0] = stringDay = Integer.toString(i);
                aryDay[i][1] = stringDay;
            }
            return aryDay;
        }
        String[][] aryDay = new String[day][2];
        for (int i = 0; i < day; ++i) {
            String stringDay;
            aryDay[i][0] = stringDay = Integer.toString(i + 1);
            aryDay[i][1] = stringDay;
        }
        return aryDay;
    }

    public String[][] getHourArray(int maxHour, boolean needStart) {
        if (maxHour < 0) {
            return this.getHourArray(0, true);
        }
        if (needStart) {
            String[][] aryHour = new String[++maxHour][2];
            for (int i = 0; i < aryHour.length; ++i) {
                String stringHour;
                aryHour[i][0] = stringHour = Integer.toString(i);
                aryHour[i][1] = stringHour;
            }
            return aryHour;
        }
        String[][] aryHour = new String[maxHour][2];
        for (int i = 0; i < aryHour.length; ++i) {
            String stringHour;
            aryHour[i][0] = stringHour = Integer.toString(i + 1);
            aryHour[i][1] = stringHour;
        }
        return aryHour;
    }

    public String[][] getHourArray() {
        return this.getHourArray(23, true);
    }

    public String[][] getMinuteArray(int interval) {
        if (interval <= 0) {
            return this.getMinuteArray(1);
        }
        if (interval > 60) {
            return this.getMinuteArray(60);
        }
        String[][] aryMinute = new String[60 / interval][2];
        for (int i = 0; i < aryMinute.length; ++i) {
            String stringMinute;
            aryMinute[i][0] = stringMinute = Integer.toString(i * interval);
            aryMinute[i][1] = stringMinute;
        }
        return aryMinute;
    }

    protected int convIntegerTimeToIntegerHour(int time) {
        return TimeUtility.getHours((int)time);
    }

    protected String convIntegerTimeToStringHour(int time) {
        return String.valueOf(this.convIntegerTimeToIntegerHour(time));
    }

    protected int convIntegerTimeToIntegerMinute(int time) {
        return TimeUtility.getMinutes((int)time);
    }

    protected String convIntegerTimeToStringMinutes(int time) {
        int minute = this.convIntegerTimeToIntegerMinute(time);
        StringBuffer sb = new StringBuffer();
        if (minute < 10) {
            sb.append(0);
        }
        sb.append(minute);
        return sb.toString();
    }

    protected void setEmployeeInfo(String personalId, Date targetDate) throws MospException {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        vo.setPersonalId(personalId);
        vo.setTargetDate(targetDate);
        HumanDtoInterface humanDto = this.getHumanInfo(personalId, targetDate);
        if (humanDto == null) {
            PfMessageUtility.addErrorEmployeeHistoryNotExist((MospParams)this.mospParams, (Date)targetDate);
            return;
        }
        vo.setLblEmployeeCode(humanDto.getEmployeeCode());
        vo.setLblEmployeeName(this.getLastFirstName(humanDto.getLastName(), humanDto.getFirstName()));
        vo.setLblSectionName(this.reference().section().getSectionName(humanDto.getSectionCode(), targetDate));
        if (this.reference().section().useDisplayName()) {
            vo.setLblSectionName(this.reference().section().getSectionDisplay(humanDto.getSectionCode(), targetDate));
        }
    }

    protected int getTargetYear() {
        return (Integer)this.mospParams.getGeneralParam("prmTargetYear");
    }

    protected int getTargetMonth() {
        return (Integer)this.mospParams.getGeneralParam("prmTargetMonth");
    }

    protected Date getTargetTime() {
        return (Date)this.mospParams.getGeneralParam("prmTargetTime");
    }

    protected long getTargetWorkflow() {
        return (Long)this.mospParams.getGeneralParam("prmTargetWorkflow");
    }

    protected void setTargetYear(int targetYear) {
        this.mospParams.addGeneralParam("prmTargetYear", (Object)targetYear);
    }

    protected void setTargetMonth(int targetMonth) {
        this.mospParams.addGeneralParam("prmTargetMonth", (Object)targetMonth);
    }

    protected void setTargetWorkflow(long targetWorkflow) {
        this.mospParams.addGeneralParam("prmTargetWorkflow", (Object)targetWorkflow);
    }

    protected String getTransferredType() {
        return this.mospParams.getRequestParam("transferredType");
    }

    protected String getTransferredMonth() {
        return this.mospParams.getRequestParam("transferredMonth");
    }

    protected String getTransferredGenericCode() {
        return this.mospParams.getRequestParam("transferredGenericCode");
    }

    protected String getNumberString(Double number, int fraction) {
        return TimeUtility.getStringNumberOrHyphen((MospParams)this.mospParams, (Double)number, (int)fraction, (boolean)false);
    }

    protected String getNumberString(double number, int fraction) {
        return TimeUtility.getStringNumber((MospParams)this.mospParams, (double)number, (int)fraction, (int)4);
    }

    protected String toTimeDotFormatString(Integer time) {
        return TimeUtility.getStringPeriodTimeOrHyphen((MospParams)this.mospParams, (Integer)time, (boolean)false);
    }

    protected String getTimeTimeFormat(int time) {
        return TimeUtility.getStringJpTime((MospParams)this.mospParams, (int)time);
    }

    protected String getTimeWaveFormat(Date date1, Date date2, Date standardDate) {
        return TransStringUtility.getHourColonMinuteTerm((MospParams)this.mospParams, (Date)date1, (Date)date2, (Date)standardDate);
    }

    protected String getTimeColonFormat(int time) {
        return TimeUtility.getStringColonTime((MospParams)this.mospParams, (int)time);
    }

    protected void addCalcMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)this.mospParams.getName("TrialCalc"));
    }

    protected void addDraftMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)PfNameUtility.draft((MospParams)this.mospParams));
    }

    protected void addAppliMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)PfNameUtility.application((MospParams)this.mospParams));
    }

    protected void addCancellAppliMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)TimeNamingUtility.cancellationRequest((MospParams)this.mospParams));
    }

    protected void addTakeDownMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)PfNameUtility.withdraw((MospParams)this.mospParams));
    }

    protected String getOvertimeTypeName(int time) {
        if (1 == time) {
            return this.mospParams.getName("Work", new String[]{"Ahead"});
        }
        return this.mospParams.getName("Work", new String[]{"Later"});
    }

    protected String setWorkDateSubHolidayType(int subHolidayType) {
        return TimeRequestUtility.getSubHolidayTypeAbbr((int)subHolidayType, (MospParams)this.mospParams);
    }

    public String getStatusStageValueView(String status, int stage) {
        try {
            return this.reference().workflowIntegrate().getWorkflowStatus(status, stage);
        }
        catch (MospException e) {
            return status;
        }
    }

    protected String setHistoryDateTimeColor(int dateTimeNum) {
        String claSpan = "style=\"color: black\"";
        if (dateTimeNum < 0) {
            claSpan = "style=\"color: red\"";
        }
        return claSpan;
    }

    protected String setHistoryDateTimeDoubleColor(double dateTimeNum) {
        String claSpan = "style=\"color: black\"";
        if (dateTimeNum < 0.0) {
            claSpan = "style=\"color: red\"";
        }
        return claSpan;
    }

    protected String getFormatDaysHoursMinutes(double days, int hours, int minutes, boolean isZeroHyphen) {
        return TimeUtility.getStringDaysHoursMinutes((MospParams)this.mospParams, (double)days, (int)hours, (int)minutes, (boolean)isZeroHyphen);
    }

    public String getRequestTypeForView(ManagementRequestListDtoInterface dto) throws MospException {
        if (dto == null) {
            return "";
        }
        if ("1".equals(dto.getRequestType())) {
            return this.mospParams.getName("WorkManage");
        }
        if ("2".equals(dto.getRequestType())) {
            return this.mospParams.getName("OvertimeWork");
        }
        if ("3".equals(dto.getRequestType())) {
            return this.mospParams.getName("Holiday");
        }
        if ("4".equals(dto.getRequestType())) {
            BaseDtoInterface baseDto = this.timeReference().approvalInfo().getRequestDtoForWorkflow(dto.getWorkflow(), false);
            WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = null;
            if (baseDto instanceof WorkOnHolidayRequestDtoInterface) {
                workOnHolidayRequestDto = (WorkOnHolidayRequestDtoInterface)baseDto;
            }
            if (workOnHolidayRequestDto == null) {
                return "";
            }
            int substitute = workOnHolidayRequestDto.getSubstitute();
            if (substitute == 1 || substitute == 5 || substitute == 3 || substitute == 4) {
                return this.mospParams.getName("SubstituteAbbr", new String[]{"GoingWorkAbbr"});
            }
            if (substitute == 2) {
                return this.mospParams.getName("WorkingHoliday");
            }
            return "";
        }
        if ("5".equals(dto.getRequestType())) {
            return this.mospParams.getName("CompensatoryHoliday");
        }
        if ("6".equals(dto.getRequestType())) {
            return this.mospParams.getName("TimeDifference");
        }
        if ("7".equals(dto.getRequestType())) {
            return this.mospParams.getName("Change");
        }
        return "";
    }

    protected void addApprovalMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)PfNameUtility.approval((MospParams)this.mospParams));
    }

    protected void addSendingBackMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)PfNameUtility.reverted((MospParams)this.mospParams));
    }

    protected void addReleaseSendingBackMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)PfNameUtility.cancelWithdraw((MospParams)this.mospParams));
    }

    protected String getStringTimeMinutes(Date date) {
        if (date == null) {
            return "";
        }
        return this.getStringHour(date) + this.mospParams.getName("Hour") + this.getStringMinute(date) + this.mospParams.getName("Minutes");
    }

    protected String getHolidayType1Name(int type1, String type2) {
        if (type1 == 1) {
            if (Integer.toString(1).equals(type2)) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Salaried"));
                sb.append(this.mospParams.getName("Holiday"));
                return sb.toString();
            }
            if (Integer.toString(2).equals(type2)) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Stock"));
                sb.append(this.mospParams.getName("Holiday"));
                return sb.toString();
            }
        } else {
            if (type1 == 2) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.mospParams.getName("Specially"));
                sb.append(this.mospParams.getName("Holiday"));
                return sb.toString();
            }
            if (type1 == 3) {
                return this.mospParams.getName("Others");
            }
            if (type1 == 4) {
                return this.mospParams.getName("Absence");
            }
        }
        return "";
    }

    protected String getHolidayType2Abbr(int type1, String type2, Date date) throws MospException {
        if (type1 == 1) {
            return "";
        }
        HolidayDtoInterface dto = this.timeReference().holiday().getHolidayInfo(type2, date, type1);
        if (dto == null) {
            return type2;
        }
        return dto.getHolidayAbbr();
    }

    public String getHolidayTypeName(int holidayType1, String holidayType2, Date date) throws MospException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getHolidayType1Name(holidayType1, holidayType2));
        sb.append(" ");
        sb.append(this.getHolidayType2Abbr(holidayType1, holidayType2, date));
        return sb.toString();
    }

    protected String getTransferredYear() {
        return this.mospParams.getRequestParam("transferredYear");
    }

    protected void addTighteningMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)TimeNamingUtility.tempTighten((MospParams)this.mospParams));
    }

    protected void addReleaseMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)PfNameUtility.release((MospParams)this.mospParams));
    }

    protected String getHolidayRange(int holidayRange) {
        return TimeUtility.getHolidayRangeAbbr((MospParams)this.mospParams, (int)holidayRange);
    }

    protected void addDecideMessage() {
        PfMessageUtility.addMessageSucceed((MospParams)this.mospParams, (String)TimeNamingUtility.fixed((MospParams)this.mospParams));
    }

    protected String getWorkflowCommentDtoComment(WorkflowDtoInterface workflowDto, WorkflowCommentDtoInterface commentDto) throws MospException {
        String status = this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage());
        if (status.equals(this.mospParams.getName("WorkPaper")) || status.equals(this.mospParams.getName("Ram", new String[]{"Approval"}))) {
            return "";
        }
        return commentDto.getWorkflowComment();
    }

    protected String getWorkflowCommentDtoLastFirstName(WorkflowDtoInterface workflowDto, WorkflowCommentDtoInterface commentDto) throws MospException {
        String status = workflowDto.getWorkflowStatus();
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto)) {
            return this.reference().human().getHumanName(workflowDto.getPersonalId(), workflowDto.getWorkflowDate());
        }
        if (status.equals("1") || status.equals("2")) {
            return this.timeReference().approvalInfo().getNextApprover(workflowDto);
        }
        return this.reference().human().getHumanName(commentDto.getPersonalId(), commentDto.getWorkflowDate());
    }

    public int getTimeValue(String hours, String minutes) {
        return TimeUtility.getTime((String)hours, (String)minutes);
    }

    protected String getHolidayAbbr(String holidayCode, Date activateDate, int holidayType) throws MospException {
        HolidayDtoInterface dto = this.timeReference().holiday().getHolidayInfo(holidayCode, activateDate, holidayType);
        if (dto == null) {
            return holidayCode;
        }
        return dto.getHolidayAbbr();
    }

    protected String setButtonBackColor(int flg) {
        String buttonBackColor = "";
        if (flg == 1) {
            buttonBackColor = "style=\"background-color: yellow\"";
        }
        return buttonBackColor;
    }

    protected String getTransferredHolidayType1() {
        return this.mospParams.getRequestParam("holidayType1");
    }

    protected String getTransferredHolidayType2() {
        return this.mospParams.getRequestParam("holidayType2");
    }

    protected String getTransferredHolidayRange() {
        return this.mospParams.getRequestParam("holidayRange");
    }

    protected String getTransferredStartTime() {
        return this.mospParams.getRequestParam("StartTime");
    }

    protected String[] getSelectApproverIds() throws MospException {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        ArrayList<String> list = new ArrayList<String>();
        String[] aryApproverSetting = new String[]{vo.getPltApproverSetting1(), vo.getPltApproverSetting2(), vo.getPltApproverSetting3(), vo.getPltApproverSetting4(), vo.getPltApproverSetting5(), vo.getPltApproverSetting6(), vo.getPltApproverSetting7(), vo.getPltApproverSetting8(), vo.getPltApproverSetting9(), vo.getPltApproverSetting10()};
        for (int loopCnt = 0; loopCnt < aryApproverSetting.length && !aryApproverSetting[loopCnt].isEmpty(); ++loopCnt) {
            list.add(aryApproverSetting[loopCnt]);
        }
        return list.toArray(new String[list.size()]);
    }

    protected String getButtonOnOff(String status, int stage) {
        String on = "on";
        if ("0".equals(status)) {
            return on;
        }
        if ("3".equals(status) && stage == 0) {
            return on;
        }
        return "";
    }

    protected String getTransferredDay() {
        return this.mospParams.getRequestParam("transferredDay");
    }

    protected String getTransferredHour() {
        return this.mospParams.getRequestParam("transferredHour");
    }

    protected String getTransferredMinute() {
        return this.mospParams.getRequestParam("transferredMinute");
    }

    protected String getTransferredStartHour() {
        return this.mospParams.getRequestParam("transferredStartHour");
    }

    protected String getTransferredStartMinute() {
        return this.mospParams.getRequestParam("transferredStartMinute");
    }

    protected String getTransferredEndHour() {
        return this.mospParams.getRequestParam("transferredEndHour");
    }

    protected String getTransferredEndMinute() {
        return this.mospParams.getRequestParam("transferredEndMinute");
    }

    protected String getTransferredDirectStart() {
        return this.mospParams.getRequestParam("transferredDirectStart");
    }

    protected String getTransferredDirectEnd() {
        return this.mospParams.getRequestParam("transferredDirectEnd");
    }

    protected String getTransferredTimeComment() {
        return this.mospParams.getRequestParam("transferredTimeComment");
    }

    protected void getDifferenceRequest1(String personalId, Date date) throws MospException {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        vo.setJsModeDifferenceRequest1("");
        vo.setJsModeRequestDate1("");
        DifferenceRequestDtoInterface diffDto = this.timeReference().differenceRequest().findForKeyOnWorkflow(personalId, date);
        if (diffDto != null) {
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(diffDto.getWorkflow());
            if (workflowDto != null) {
                if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
                    return;
                }
                vo.setJsModeDifferenceRequest1("on");
                vo.setJsModeRequestDate1(this.getStringDate(date));
                return;
            }
            return;
        }
    }

    protected String getHistoryCommand(String requestType) {
        if ("1".equals(requestType)) {
            return "TM1811";
        }
        if ("2".equals(requestType)) {
            return "TM1821";
        }
        if ("3".equals(requestType)) {
            return "TM1831";
        }
        if ("4".equals(requestType)) {
            return "TM1841";
        }
        if ("5".equals(requestType)) {
            return "TM1851";
        }
        if ("7".equals(requestType)) {
            return "TM1871";
        }
        if ("6".equals(requestType)) {
            return "TM1861";
        }
        return "";
    }

    protected String getStatusColor(String status) {
        if ("0".equals(status) || "1".equals(status) || "2".equals(status) || "3".equals(status) || "4".equals(status) || "6".equals(status) || "7".equals(status)) {
            return "style=\"color: red\"";
        }
        if ("5".equals(status) || "9".equals(status)) {
            return "";
        }
        return "";
    }

    protected String getAttendanceStateColor(String state) {
        StringBuffer approved = new StringBuffer();
        approved.append(this.mospParams.getName("Approval"));
        approved.append(this.mospParams.getName("Finish"));
        if (state == null || state.isEmpty() || this.mospParams.getName("Schedule").equals(state) || approved.toString().equals(state)) {
            return "";
        }
        return "style=\"color: red\"";
    }

    protected String setBackColor(String personalId, Date requestDate, String type) throws MospException {
        DifferenceRequestReferenceBeanInterface differenceRequest = this.timeReference().differenceRequest(requestDate);
        RequestUtilBeanInterface requestUtil = this.timeReference().requestUtil();
        requestUtil.setRequests(personalId, requestDate);
        int holidayRequestRange = requestUtil.checkHolidayRangeHoliday(requestUtil.getHolidayList(false));
        boolean isHalfHoliday = holidayRequestRange == 2 || holidayRequestRange == 3;
        int subHolidayRequestRange = requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(false));
        boolean isHalfSubHoliday = subHolidayRequestRange == 2 || subHolidayRequestRange == 3;
        DifferenceRequestDtoInterface differenceRequestDto = requestUtil.getDifferenceDto(false);
        if ("3".equals(type)) {
            if (isHalfHoliday && differenceRequestDto != null) {
                return "style=\"background-color: yellow\"";
            }
        } else if ("5".equals(type)) {
            if (isHalfSubHoliday && differenceRequestDto != null) {
                return "style=\"background-color: yellow\"";
            }
        } else if ("6".equals(type)) {
            if (isHalfHoliday || isHalfSubHoliday) {
                return "style=\"background-color: yellow\"";
            }
            if (differenceRequestDto == null || !differenceRequest.isDifferenceTypeS(differenceRequestDto)) {
                return "";
            }
            int year = DateUtility.getYear((Date)differenceRequestDto.getRequestDate());
            int month = DateUtility.getMonth((Date)differenceRequestDto.getRequestDate());
            int day = DateUtility.getDay((Date)differenceRequestDto.getRequestDate());
            Date fiveHour = DateUtility.getDateTime((int)year, (int)month, (int)day, (int)5, (int)0);
            Date twentyTwoHour = DateUtility.getDateTime((int)year, (int)month, (int)day, (int)22, (int)0);
            if (!(differenceRequestDto.getRequestStart().before(fiveHour) || differenceRequestDto.getRequestStart().after(twentyTwoHour) || differenceRequestDto.getRequestEnd().before(fiveHour) || differenceRequestDto.getRequestEnd().after(twentyTwoHour))) {
                return "style=\"background-color: yellow\"";
            }
        }
        return "";
    }

    protected void addNotExistEmployeesErrorMessage() {
        this.mospParams.addErrorMessage("TMW0260", new String[0]);
    }

    protected void addEmployeeRetiredMessage() {
        PfMessageUtility.addErrorEmployeeRetired((MospParams)this.mospParams);
    }

    protected void addEmployeeSuspendedMessage() {
        PfMessageUtility.addErrorEmployeeSuspended((MospParams)this.mospParams);
    }

    protected String getWorkOnHolidaySchedule(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        WorkTypeDtoInterface workTypeDto;
        SubstituteReferenceBeanInterface substitute = this.timeReference().substitute();
        WorkTypeReferenceBeanInterface workType = this.timeReference().workType();
        ScheduleUtilBeanInterface scheduleUtil = this.timeReference().scheduleUtil();
        if (dto.getRequestDate() != null && dto.getStartTime() != null && dto.getEndTime() != null) {
            return this.getTimeWaveFormat(dto.getStartTime(), dto.getEndTime(), dto.getRequestDate());
        }
        String workTypeCode = dto.getWorkTypeCode();
        Date targetDate = dto.getRequestDate();
        if (workTypeCode.isEmpty()) {
            List list = substitute.getSubstituteList(dto.getWorkflow());
            if (list.isEmpty()) {
                return "";
            }
            targetDate = ((SubstituteDtoInterface)list.get(0)).getSubstituteDate();
            workTypeCode = scheduleUtil.getScheduledWorkTypeCodeNoMessage(dto.getPersonalId(), targetDate);
        }
        if ((workTypeDto = workType.findForInfo(workTypeCode, targetDate)) == null) {
            return "";
        }
        String base = workTypeDto.getWorkTypeAbbr();
        int substituteType = dto.getSubstitute();
        if (this.timeReference().workOnHolidayRequest().useHalfSubstitute()) {
            if (substituteType == 1 || substituteType == 3 || substituteType == 4) {
                return base + " " + this.getCodeName(substituteType, "SubstituteWorkRange");
            }
            if (substituteType == 5) {
                return base + " " + this.getCodeName(1, "SubstituteWorkRange");
            }
        }
        return base;
    }

    protected String getBeforeDifferenceRequestWorkTypeAbbr() throws MospException {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        ScheduleUtilBeanInterface scheduleUtil = this.timeReference().scheduleUtil();
        WorkTypeReferenceBeanInterface workTypeReference = this.timeReference().workType();
        RequestUtilBeanInterface requestUtil = this.timeReference().requestUtil();
        requestUtil.setRequests(vo.getPersonalId(), vo.getTargetDate());
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto != null) {
            int substitute = workOnHolidayRequestDto.getSubstitute();
            if (substitute == 1) {
                List list = this.timeReference().substitute().getSubstituteList(workOnHolidayRequestDto.getWorkflow());
                if (list.isEmpty()) {
                    return "";
                }
                SubstituteDtoInterface substituteDto = (SubstituteDtoInterface)list.get(0);
                if (substituteDto == null) {
                    return "";
                }
                personalId = substituteDto.getPersonalId();
                targetDate = substituteDto.getSubstituteDate();
            } else {
                if (substitute == 2) {
                    if ("legal_holiday".equals(workOnHolidayRequestDto.getWorkOnHolidayType())) {
                        return workTypeReference.getWorkTypeAbbr("work_on_legal", workOnHolidayRequestDto.getRequestDate());
                    }
                    if ("prescribed_holiday".equals(workOnHolidayRequestDto.getWorkOnHolidayType())) {
                        return workTypeReference.getWorkTypeAbbr("work_on_prescribed", workOnHolidayRequestDto.getRequestDate());
                    }
                    return "";
                }
                return "";
            }
        }
        String workTypeCode = scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return "";
        }
        return workTypeReference.getWorkTypeAbbr(workTypeCode, targetDate);
    }

    protected String getApplicationMode(long workflow) throws MospException {
        WorkflowDtoInterface dto = this.reference().workflow().getLatestWorkflowInfo(workflow);
        if (dto == null) {
            return null;
        }
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)dto)) {
            return "draft";
        }
        if (dto.getWorkflowStatus().equals("3")) {
            return "revert";
        }
        return null;
    }

    protected String[][] getWorkTypeArray(String patternCode, Date targetDate, boolean isName, boolean viewTime, boolean amHoliday, boolean pmHoliday) throws MospException {
        WorkTypeReferenceBeanInterface workTypeReference = this.timeReference().workType();
        WorkTypePatternItemReferenceBeanInterface workTypePatternItemReference = this.timeReference().workTypePatternItem();
        WorkTypePatternDtoInterface workTypePatternDto = this.timeReference().workTypePattern().findForInfo(patternCode, targetDate);
        boolean useWorkTypePattern = false;
        if (workTypePatternDto != null && workTypePatternDto.getInactivateFlag() == 0) {
            useWorkTypePattern = true;
        }
        if (useWorkTypePattern) {
            if (isName && viewTime) {
                return workTypePatternItemReference.getNameTimeSelectArray(workTypePatternDto.getPatternCode(), targetDate, amHoliday, pmHoliday);
            }
            if (!isName && viewTime) {
                return workTypePatternItemReference.getTimeSelectArray(workTypePatternDto.getPatternCode(), targetDate, amHoliday, pmHoliday);
            }
            if (isName && !viewTime) {
                return workTypePatternItemReference.getNameSelectArray(workTypePatternDto.getPatternCode(), targetDate);
            }
            return workTypePatternItemReference.getSelectArray(workTypePatternDto.getPatternCode(), targetDate);
        }
        if (isName && viewTime) {
            return workTypeReference.getNameTimeSelectArray(targetDate, amHoliday, pmHoliday);
        }
        if (!isName && viewTime) {
            return workTypeReference.getTimeSelectArray(targetDate, amHoliday, pmHoliday);
        }
        if (isName && !viewTime) {
            return workTypeReference.getSelectArray(targetDate);
        }
        return workTypeReference.getSelectAbbrArray(targetDate);
    }

    protected String getRequestInfo(ManagementRequestListDtoInterface dto) throws MospException {
        boolean isLeaveEarly;
        AttendanceReferenceBeanInterface attendance = this.timeReference().attendance();
        if (!"1".equals(dto.getRequestType())) {
            return HtmlUtility.escapeHTML((String)dto.getRequestInfo());
        }
        AttendanceDtoInterface attendanceDto = attendance.findForKey(dto.getPersonalId(), dto.getRequestDate());
        if (attendanceDto == null) {
            return HtmlUtility.escapeHTML((String)dto.getRequestInfo());
        }
        String[] requestInfoArray = dto.getRequestInfo().split(String.valueOf(' '));
        String regex = "\\d{2}:\\d{2}\uff5e\\d{2}:\\d{2}";
        if ("1".equals(Integer.toString(attendanceDto.getForgotRecordWorkStart())) || "1".equals(Integer.toString(attendanceDto.getNotRecordWorkStart()))) {
            ArrayList<String> list = new ArrayList<String>();
            for (String requestInfo : requestInfoArray) {
                if (requestInfo.matches(regex)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("<span ");
                    sb.append("style=\"color: red\"");
                    sb.append(">");
                    sb.append(HtmlUtility.escapeHTML((String)requestInfo));
                    sb.append("</span>");
                    list.add(sb.toString());
                    continue;
                }
                list.add(HtmlUtility.escapeHTML((String)requestInfo));
            }
            return this.concat(list);
        }
        boolean isLate = !attendanceDto.getLateReason().isEmpty();
        boolean bl = isLeaveEarly = !attendanceDto.getLeaveEarlyReason().isEmpty();
        if (!isLate && !isLeaveEarly) {
            return HtmlUtility.escapeHTML((String)dto.getRequestInfo());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String requestInfo : requestInfoArray) {
            StringBuffer sb;
            if (!requestInfo.matches(regex)) {
                list.add(HtmlUtility.escapeHTML((String)requestInfo));
                continue;
            }
            String startWork = requestInfo.substring(0, 5);
            String endWork = requestInfo.substring(6);
            if (isLate && isLeaveEarly) {
                sb = new StringBuffer();
                sb.append("<span ");
                sb.append("style=\"color: red\"");
                sb.append(">");
                sb.append(HtmlUtility.escapeHTML((String)startWork));
                sb.append("</span>");
                sb.append(HtmlUtility.escapeHTML((String)requestInfo.substring(5, 6)));
                sb.append("<span ");
                sb.append("style=\"color: red\"");
                sb.append(">");
                sb.append(HtmlUtility.escapeHTML((String)endWork));
                sb.append("</span>");
                list.add(sb.toString());
                continue;
            }
            if (isLate) {
                sb = new StringBuffer();
                sb.append("<span ");
                sb.append("style=\"color: red\"");
                sb.append(">");
                sb.append(HtmlUtility.escapeHTML((String)startWork));
                sb.append("</span>");
                sb.append(HtmlUtility.escapeHTML((String)requestInfo.substring(5)));
                list.add(sb.toString());
                continue;
            }
            if (isLeaveEarly) {
                sb = new StringBuffer();
                sb.append(HtmlUtility.escapeHTML((String)requestInfo.substring(0, 6)));
                sb.append("<span ");
                sb.append("style=\"color: red\"");
                sb.append(">");
                sb.append(HtmlUtility.escapeHTML((String)endWork));
                sb.append("</span>");
                list.add(sb.toString());
                continue;
            }
            list.add(HtmlUtility.escapeHTML((String)requestInfo));
        }
        return this.concat(list);
    }

    protected void checkSubordinateAvailable(Date targetDate) throws MospException {
        if (RoleUtility.isSuper((MospParams)this.mospParams)) {
            return;
        }
        String personalId = MospUtility.getLoginPersonalId((MospParams)this.mospParams);
        HumanDtoInterface dto = this.getHumanInfo(personalId, targetDate);
        if (dto == null) {
            TimeMessageUtility.addErrorUnsetHumanInfo((MospParams)this.mospParams, (String)PfNameUtility.humanInfo((MospParams)this.mospParams));
            return;
        }
        if (MospUtility.isEmpty((String[])new String[]{dto.getSectionCode()})) {
            TimeMessageUtility.addErrorUnsetHumanInfo((MospParams)this.mospParams, (String)PfNameUtility.sectionInfo((MospParams)this.mospParams));
        }
        if (MospUtility.isEmpty((String[])new String[]{dto.getPositionCode()})) {
            TimeMessageUtility.addErrorUnsetHumanInfo((MospParams)this.mospParams, (String)PfNameUtility.positionInfo((MospParams)this.mospParams));
        }
    }

    public boolean isAvailable(String codeKey, String personalId, Date targetDate, String ... types) throws MospException {
        boolean isAvailable = true;
        for (CheckAvailableBeanInterface addonBean : this.getBeans(CheckAvailableBeanInterface.class, codeKey)) {
            isAvailable &= addonBean.check(personalId, targetDate, types);
        }
        return isAvailable;
    }

    public boolean isAvailable(Date targetDate, String function) throws MospException {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        return this.isAvailable("CheckApplyAvailable", vo.getPersonalId(), targetDate, new String[]{function});
    }

    protected String concat(List<String> list) {
        return MospUtility.concat((String[])list.toArray(new String[0]));
    }

    protected String getFraction(Integer numerator, Integer denominator) {
        if (numerator == null || denominator == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(numerator);
        sb.append(this.mospParams.getName("Slash"));
        sb.append(denominator);
        return sb.toString();
    }

    protected String addParenthesis(String content) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("FrontParentheses"));
        sb.append(content);
        sb.append(this.mospParams.getName("BackParentheses"));
        return sb.toString();
    }

    protected Format getPercentFormat(int minimumFractionDigits) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(minimumFractionDigits);
        return nf;
    }
}

