/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.base;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.base.AttendanceListBaseVo;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.base.TimeVo;
import jp.mosp.time.dto.settings.SubordinateListDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.utils.TimeUtility;

public abstract class AttendanceListBaseAction
extends TimeAction {
    protected void initVoFields(String personalId, int targetYear, int targetMonth) {
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        vo.setPersonalId(personalId);
        vo.setPltSelectYear(MospUtility.getString((Object)targetYear));
        vo.setPltSelectMonth(MospUtility.getString((Object)targetMonth));
    }

    protected void setVoFields(List<AttendanceListDto> list) throws MospException {
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        int targetYear = this.getInt(vo.getPltSelectYear());
        int targetMonth = this.getInt(vo.getPltSelectMonth());
        int cutoffDate = vo.getCutoffDate();
        AttendanceListDto dto = (AttendanceListDto)MospUtility.getFirstValue(list);
        if (!MospUtility.isEmpty((Object[])new Object[]{dto})) {
            personalId = dto.getPersonalId();
            targetYear = dto.getTargetYear();
            targetMonth = dto.getTargetMonth();
            cutoffDate = dto.getCutoffDate();
        }
        Date targetDate = TimeUtility.getCutoffTermTargetDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        this.setVoYearMonthFields(targetYear, targetMonth);
        this.setVoThisMonthFields(cutoffDate);
        this.setVoHumanFields(dto, personalId, targetDate);
        this.setVoRollEmployeeFields();
    }

    protected void setVoYearMonthFields(int targetYear, int targetMonth) throws MospException {
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        vo.setPltSelectYear(String.valueOf(targetYear));
        vo.setPltSelectMonth(String.valueOf(targetMonth));
        vo.setAryPltSelectYear(this.getYearArray(targetYear));
        vo.setAryPltSelectMonth(this.getMonthArray());
        Date current = MonthUtility.getYearMonthTermFirstDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        Date next = DateUtility.addMonth((Date)current, (int)1);
        Date previous = DateUtility.addMonth((Date)current, (int)-1);
        vo.setNextMonthYear(DateUtility.getYear((Date)next));
        vo.setNextMonthMonth(DateUtility.getMonth((Date)next));
        vo.setPrevMonthYear(DateUtility.getYear((Date)previous));
        vo.setPrevMonthMonth(DateUtility.getMonth((Date)previous));
    }

    protected void setVoThisMonthFields(int cutoffDate) throws MospException {
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        vo.setCutoffDate(cutoffDate);
        Date systemDate = this.getSystemDate();
        Date cutoffMonth = TimeUtility.getCutoffMonth((int)cutoffDate, (Date)systemDate, (MospParams)this.mospParams);
        vo.setThisMonthYear(DateUtility.getYear((Date)cutoffMonth));
        vo.setThisMonthMonth(DateUtility.getMonth((Date)cutoffMonth));
    }

    protected void setVoHumanFields(AttendanceListDto dto, String personalId, Date targetDate) throws MospException {
        TimeVo vo = (TimeVo)this.mospParams.getVo();
        if (!MospUtility.isEmpty((Object[])new Object[]{dto}) && !MospUtility.isEmpty((String[])new String[]{dto.getEmployeeCode()})) {
            vo.setPersonalId(dto.getPersonalId());
            vo.setLblEmployeeCode(dto.getEmployeeCode());
            vo.setLblEmployeeName(dto.getEmployeeName());
            vo.setLblSectionName(dto.getSectionName());
            return;
        }
        HumanDtoInterface humanDto = this.reference().human().getHumanInfo(personalId, targetDate);
        if (humanDto == null) {
            vo.setPersonalId(personalId);
            vo.setLblEmployeeCode("");
            vo.setLblEmployeeName("");
            vo.setLblSectionName("");
            return;
        }
        vo.setPersonalId(humanDto.getPersonalId());
        vo.setLblEmployeeCode(humanDto.getEmployeeCode());
        vo.setLblEmployeeName(this.getLastFirstName(humanDto.getLastName(), humanDto.getFirstName()));
        vo.setLblSectionName(this.reference().section().getSectionName(humanDto.getSectionCode(), targetDate));
        if (this.reference().section().useDisplayName()) {
            vo.setLblSectionName(this.reference().section().getSectionDisplay(humanDto.getSectionCode(), targetDate));
        }
    }

    protected void setVoRollEmployeeFields() {
        BaseDtoInterface baseDto;
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        Object object = this.mospParams.getGeneralParam("RollArray");
        if (object != null) {
            vo.setRollArray((BaseDtoInterface[])object);
        }
        if (vo.getRollArray() == null || vo.getRollArray().length == 0) {
            return;
        }
        int i = 0;
        for (BaseDtoInterface baseDto2 : vo.getRollArray()) {
            SubordinateListDtoInterface dto = (SubordinateListDtoInterface)baseDto2;
            if (vo.getPersonalId().equals(dto.getPersonalId())) break;
            ++i;
        }
        vo.setLblPrevEmployeeCode("");
        vo.setPrevPersonalId("");
        if (i > 0) {
            baseDto = vo.getRollArray()[i - 1];
            SubordinateListDtoInterface dto = (SubordinateListDtoInterface)baseDto;
            vo.setLblPrevEmployeeCode(dto.getEmployeeCode());
            vo.setPrevPersonalId(dto.getPersonalId());
        }
        vo.setLblNextEmployeeCode("");
        vo.setNextPersonalId("");
        if (i + 1 < vo.getRollArray().length) {
            baseDto = vo.getRollArray()[i + 1];
            SubordinateListDtoInterface dto = (SubordinateListDtoInterface)baseDto;
            vo.setLblNextEmployeeCode(dto.getEmployeeCode());
            vo.setNextPersonalId(dto.getPersonalId());
        }
    }

    protected void setVoList(List<AttendanceListDto> list) {
        AttendanceListBaseVo vo = (AttendanceListBaseVo)this.mospParams.getVo();
        String[] aryLblDate = new String[list.size()];
        String[] aryLblWeek = new String[list.size()];
        String[] aryWorkDayOfWeekStyle = new String[list.size()];
        String[] aryLblWorkType = new String[list.size()];
        String[] aryLblStartTime = new String[list.size()];
        String[] aryStartTimeStyle = new String[list.size()];
        String[] aryLblEndTime = new String[list.size()];
        String[] aryEndTimeStyle = new String[list.size()];
        String[] aryLblWorkTime = new String[list.size()];
        String[] aryLblRestTime = new String[list.size()];
        String[] aryLblRemark = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            AttendanceListDto dto = list.get(i);
            aryLblDate[i] = dto.getWorkDateString();
            aryLblWeek[i] = dto.getWorkDayOfWeek();
            aryWorkDayOfWeekStyle[i] = dto.getWorkDayOfWeekStyle();
            aryLblWorkType[i] = dto.getWorkTypeAbbr();
            aryLblStartTime[i] = dto.getStartTimeString();
            aryStartTimeStyle[i] = dto.getStartTimeStyle();
            aryLblEndTime[i] = dto.getEndTimeString();
            aryEndTimeStyle[i] = dto.getEndTimeStyle();
            aryLblWorkTime[i] = dto.getWorkTimeString();
            aryLblRestTime[i] = dto.getRestTimeString();
            aryLblRemark[i] = MospUtility.concat((String[])new String[]{dto.getRemark(), dto.getTimeComment()});
        }
        vo.setAryLblDate(aryLblDate);
        vo.setAryLblWeek(aryLblWeek);
        vo.setAryWorkDayOfWeekStyle(aryWorkDayOfWeekStyle);
        vo.setAryLblWorkType(aryLblWorkType);
        vo.setAryLblStartTime(aryLblStartTime);
        vo.setAryStartTimeStyle(aryStartTimeStyle);
        vo.setAryLblEndTime(aryLblEndTime);
        vo.setAryEndTimeStyle(aryEndTimeStyle);
        vo.setAryLblWorkTime(aryLblWorkTime);
        vo.setAryLblRestTime(aryLblRestTime);
        vo.setAryLblRemark(aryLblRemark);
        if (list.isEmpty()) {
            return;
        }
        AttendanceListDto dto = list.get(list.size() - 1);
        vo.setLblTotalWork(dto.getWorkTimeTotalString());
        vo.setLblTotalRest(dto.getRestTimeTotalString());
        vo.setLblTimesWork(dto.getWorkDaysString());
        vo.setLblTimesPrescribedHoliday(dto.getPrescribedHolidaysString());
        vo.setLblTimesLegalHoliday(dto.getLegalHolidaysString());
        vo.setLblTimesHoliday(dto.getHolidayString());
        this.initCkbSelect();
    }
}

