/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.setup.bean.impl;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.EntranceRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanRegistBeanInterface;
import jp.mosp.platform.bean.system.UserAccountRegistBeanInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.setup.bean.InitialAccountCreateBeanInterface;
import jp.mosp.setup.dto.InitialAccountParameterInterface;
import jp.mosp.setup.dto.impl.InitialAccountParameter;

public class InitialAccountCreateBean
extends PlatformBean
implements InitialAccountCreateBeanInterface {
    protected UserAccountRegistBeanInterface userAccountRegist;
    protected HumanRegistBeanInterface humanRegist;
    protected EntranceRegistBeanInterface entranceRegist;

    public void initBean() throws MospException {
        this.userAccountRegist = (UserAccountRegistBeanInterface)this.createBeanInstance(UserAccountRegistBeanInterface.class);
        this.humanRegist = (HumanRegistBeanInterface)this.createBeanInstance(HumanRegistBeanInterface.class);
        this.entranceRegist = (EntranceRegistBeanInterface)this.createBeanInstance(EntranceRegistBeanInterface.class);
    }

    public InitialAccountParameterInterface getInitParameter() {
        return new InitialAccountParameter();
    }

    public void execute(InitialAccountParameterInterface parameter) throws MospException {
        HumanDtoInterface dto = this.insertHuman(parameter);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String personalId = dto.getPersonalId();
        this.insertEntrance(parameter, personalId);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.insertUser(parameter, personalId);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
    }

    protected HumanDtoInterface insertHuman(InitialAccountParameterInterface parameter) throws MospException {
        HumanDtoInterface dto = this.humanRegist.getInitDto();
        dto.setActivateDate(this.getActivateDate(parameter));
        dto.setEmployeeCode(parameter.getEmployeeCode());
        dto.setLastName(parameter.getLastName());
        dto.setFirstName(parameter.getFirstName());
        dto.setLastKana(parameter.getLastKana());
        dto.setFirstKana(parameter.getFirstKana());
        dto.setWorkPlaceCode("");
        dto.setEmploymentContractCode("");
        dto.setSectionCode("");
        dto.setPositionCode("");
        dto.setMail("");
        this.humanRegist.insert(dto);
        return dto;
    }

    protected void insertEntrance(InitialAccountParameterInterface parameter, String personalId) throws MospException {
        EntranceDtoInterface dto = this.entranceRegist.getInitDto();
        dto.setEntranceDate(parameter.getEntranceDate());
        dto.setPersonalId(personalId);
        this.entranceRegist.insert(dto);
    }

    protected void insertUser(InitialAccountParameterInterface parameter, String personalId) throws MospException {
        UserMasterDtoInterface dto = this.userAccountRegist.getInitUserDto();
        String userId = parameter.getUserId();
        dto.setUserId(userId);
        dto.setActivateDate(this.getActivateDate(parameter));
        dto.setPersonalId(personalId);
        dto.setRoleCode(parameter.getRoleCode());
        dto.setInactivateFlag(0);
        this.userAccountRegist.insert(dto, false);
    }

    protected Date getActivateDate(InitialAccountParameterInterface parameter) {
        Date entranceDate = parameter.getEntranceDate();
        Date systemDate = DateUtility.getSystemDate();
        Date activateDate = parameter.getActivateDate();
        if (!MospUtility.isEmpty((Object[])new Object[]{activateDate})) {
            return activateDate;
        }
        if (MospUtility.compare((Date)systemDate, (Date)entranceDate) < 0) {
            return systemDate;
        }
        return entranceDate;
    }
}

