/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.workflow.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBeanHandlerInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.bean.system.SectionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteSearchBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitReferenceBeanInterface;
import jp.mosp.platform.comparator.workflow.ApprovalRouteMasterRouteCodeComparator;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteUnitDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalUnitDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.workflow.vo.RouteListVo;

public class RouteListAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF3210";
    public static final String CMD_SEARCH = "PF3212";
    public static final String CMD_RE_SEARCH = "PF3213";
    public static final String CMD_SORT = "PF3218";
    public static final String CMD_PAGE = "PF3219";
    public static final String CMD_BATCH_UPDATE = "PF3285";

    public RouteListAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    protected BaseVo getSpecificVo() {
        return new RouteListVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.setVoFields();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() throws MospException {
        RouteListVo vo = (RouteListVo)this.mospParams.getVo();
        this.iniVoFields();
        vo.setModeActivateDate("fixed");
    }

    protected void setDefaultValues() {
        RouteListVo vo = (RouteListVo)this.mospParams.getVo();
        vo.setAryLblActivateDate(new String[0]);
        vo.setAryLblRouteCode(new String[0]);
        vo.setAryLblRouteName(new String[0]);
        vo.setAryLblRouteStage(new String[0]);
        vo.setAryLblFirstUnit(new String[0]);
        vo.setAryLblEndUnit(new String[0]);
        vo.setAryLblInactivate(new String[0]);
        vo.setAryCkbRouteListId(new String[0]);
        this.initCkbSelect();
    }

    protected void search() throws MospException {
        RouteListVo vo = (RouteListVo)this.mospParams.getVo();
        ApprovalRouteSearchBeanInterface search = this.reference().approvalRouteSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setApprovalCount(vo.getPltSearchRouteStage());
        search.setRouteCode(vo.getTxtSearchRouteCode());
        search.setRouteName(vo.getTxtSearchRouteName());
        search.setUnitCode(vo.getTxtSearchUnitCode());
        search.setUnitName(vo.getTxtSearchUnitName());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(ApprovalRouteMasterRouteCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void batchUpdate() throws MospException {
        RouteListVo vo = (RouteListVo)this.mospParams.getVo();
        PlatformBeanHandlerInterface platform = this.platform();
        platform.approvalRouteUnitRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        platform.approvalRouteRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        RouteListVo vo = (RouteListVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblRouteCode = new String[list.size()];
        String[] aryLblRouteName = new String[list.size()];
        String[] aryLblRouteStage = new String[list.size()];
        String[] aryLblFirstUnit = new String[list.size()];
        String[] aryLblEndUnit = new String[list.size()];
        String[] aryLblUnitInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ApprovalRouteDtoInterface dto = (ApprovalRouteDtoInterface)list.get(i);
            aryCkbRecordId[i] = String.valueOf(dto.getPfmApprovalRouteId());
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblRouteCode[i] = dto.getRouteCode();
            aryLblRouteName[i] = dto.getRouteName();
            aryLblRouteStage[i] = String.valueOf(dto.getApprovalCount());
            aryLblUnitInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
            Date date = dto.getActivateDate();
            String unitCode = "";
            if (dto.getApprovalCount() == 1) {
                aryLblFirstUnit[i] = "";
            } else {
                unitCode = this.getRouteUnit(dto.getRouteCode(), date, 1);
                aryLblFirstUnit[i] = this.getUnitApproverName(unitCode, date);
            }
            unitCode = this.getRouteUnit(dto.getRouteCode(), date, dto.getApprovalCount());
            aryLblEndUnit[i] = this.getUnitApproverName(unitCode, date);
        }
        vo.setAryCkbRouteListId(aryCkbRecordId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblRouteCode(aryLblRouteCode);
        vo.setAryLblRouteName(aryLblRouteName);
        vo.setAryLblRouteStage(aryLblRouteStage);
        vo.setAryLblFirstUnit(aryLblFirstUnit);
        vo.setAryLblEndUnit(aryLblEndUnit);
        vo.setAryLblInactivate(aryLblUnitInactivate);
    }

    private String getRouteUnit(String routeCode, Date date, int approvalStage) throws MospException {
        ApprovalRouteUnitReferenceBeanInterface getRouteUnitInfo = this.reference().approvalRouteUnit();
        ApprovalRouteUnitDtoInterface routeUnit = getRouteUnitInfo.findForKey(routeCode, date, approvalStage);
        return routeUnit.getUnitCode();
    }

    private String getUnitApproverName(String unitCode, Date date) throws MospException {
        String approverName = "";
        if (unitCode.equals("")) {
            return approverName;
        }
        ApprovalUnitReferenceBeanInterface getUnitInfo = this.reference().approvalUnit();
        HumanReferenceBeanInterface getHumanInfo = this.reference().human();
        SectionReferenceBeanInterface getSectionInfo = this.reference().section();
        PositionReferenceBeanInterface getPositionInfo = this.reference().position();
        ApprovalUnitDtoInterface unitDto = getUnitInfo.getApprovalUnitInfo(unitCode, date);
        if (unitDto.getUnitType().equals("section")) {
            String sectionAbbr = getSectionInfo.getSectionAbbr(unitDto.getApproverSectionCode(), date);
            String positionAbbr = getPositionInfo.getPositionAbbr(unitDto.getApproverPositionCode(), date);
            approverName = sectionAbbr + " " + positionAbbr;
        } else {
            String[] aryPersonalCode = unitDto.getApproverPersonalId().split(",");
            ArrayList<String> aryEmployeeCode = new ArrayList<String>();
            for (String element : aryPersonalCode) {
                String employeeCode = getHumanInfo.getEmployeeCode(element, date);
                if (employeeCode.equals("")) continue;
                aryEmployeeCode.add(employeeCode);
            }
            Collections.sort(aryEmployeeCode);
            HumanDtoInterface humanDto = getHumanInfo.getHumanInfoForEmployeeCode((String)aryEmployeeCode.get(0), date);
            approverName = MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName());
        }
        return approverName;
    }

    protected void setVoFields() throws MospException {
        RouteListVo vo = (RouteListVo)this.mospParams.getVo();
        if (null == vo.getTxtSearchActivateYear()) {
            this.iniVoFields();
        }
    }

    protected void iniVoFields() throws MospException {
        RouteListVo vo = (RouteListVo)this.mospParams.getVo();
        this.initPlatformSystemVoFields();
        this.setDefaultValues();
        vo.setPltSearchRouteStage("");
        vo.setTxtSearchRouteCode("");
        vo.setTxtSearchRouteName("");
        vo.setTxtSearchUnitCode("");
        vo.setTxtSearchUnitName("");
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(ApprovalRouteMasterRouteCodeComparator.class.getName());
    }
}

