/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.base.WorkflowNumberDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkflowUtility {
    protected static final String CODE_STATUS_FIRST_REVERT = "30";
    protected static final String CODE_STATUS_OVER_SECOND_REVERT = "31";

    private WorkflowUtility() {
    }

    public static Set<Long> getWorkflowSet(Collection<?> ... collections) {
        TreeSet<Long> set = new TreeSet<Long>();
        for (Collection<?> collection : collections) {
            for (Object obj : collection) {
                if (!(obj instanceof Collection)) {
                    set.add(WorkflowUtility.getWorkflowNumber(obj));
                    continue;
                }
                Collection dtos = (Collection)MospUtility.castObject(obj);
                for (WorkflowNumberDtoInterface dto : dtos) {
                    set.add(dto.getWorkflow());
                }
            }
        }
        return set;
    }

    public static long getWorkflowNumber(Object obj) {
        WorkflowNumberDtoInterface dto = (WorkflowNumberDtoInterface)PlatformUtility.castObject((Object)obj);
        return dto.getWorkflow();
    }

    public static boolean isApplied(WorkflowDtoInterface dto) {
        return !WorkflowUtility.isDraft((WorkflowDtoInterface)dto) && !WorkflowUtility.isWithDrawn((WorkflowDtoInterface)dto) && !WorkflowUtility.isFirstReverted((WorkflowDtoInterface)dto);
    }

    public static boolean isApprovable(WorkflowDtoInterface dto) {
        if (WorkflowUtility.isApply((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isApproved((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isCancel((WorkflowDtoInterface)dto)) {
            return true;
        }
        return WorkflowUtility.isReverted((WorkflowDtoInterface)dto);
    }

    public static boolean isNotApproved(WorkflowDtoInterface dto) {
        if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isCancel((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isReverted((WorkflowDtoInterface)dto)) {
            return true;
        }
        if (WorkflowUtility.isApproved((WorkflowDtoInterface)dto)) {
            return true;
        }
        return WorkflowUtility.isApply((WorkflowDtoInterface)dto);
    }

    public static boolean isCompleted(WorkflowNumberDtoInterface dto, Map<Long, WorkflowDtoInterface> workflows) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto, workflows})) {
            return false;
        }
        return WorkflowUtility.isCompleted((WorkflowDtoInterface)workflows.get(dto.getWorkflow()));
    }

    public static boolean isStatusMatch(WorkflowDtoInterface dto, boolean isCompleted) {
        if (isCompleted) {
            return WorkflowUtility.isCompleted((WorkflowDtoInterface)dto);
        }
        return WorkflowUtility.isApplied((WorkflowDtoInterface)dto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)dto);
    }

    public static boolean isCompleted(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"9");
    }

    public static boolean isCancelApply(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"6");
    }

    public static boolean isCancelWithDrawnApply(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"7");
    }

    public static boolean isCancel(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"4");
    }

    public static boolean isReverted(WorkflowDtoInterface dto) {
        if (!WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"3")) {
            return false;
        }
        return !WorkflowUtility.isFirstReverted((WorkflowDtoInterface)dto);
    }

    public static boolean isApproved(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"2");
    }

    public static boolean isApply(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"1");
    }

    public static boolean isWithDrawn(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"5");
    }

    public static boolean isDraft(WorkflowDtoInterface dto) {
        return WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"0");
    }

    public static boolean isFirstReverted(WorkflowDtoInterface dto) {
        if (!WorkflowUtility.isTheStatus((WorkflowDtoInterface)dto, (String)"3")) {
            return false;
        }
        return dto.getWorkflowStage() == 0;
    }

    protected static boolean isTheStatus(WorkflowDtoInterface dto, String status) {
        if (dto == null || dto.getWorkflowStatus() == null) {
            return false;
        }
        return dto.getWorkflowStatus().equals(status);
    }

    public static boolean isMatch(WorkflowDtoInterface dto, Set<String> statuses) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto, statuses})) {
            return false;
        }
        String status = dto.getWorkflowStatus();
        if (statuses.contains(status)) {
            return true;
        }
        if (WorkflowUtility.isFirstReverted((WorkflowDtoInterface)dto)) {
            return statuses.contains("30");
        }
        if (WorkflowUtility.isReverted((WorkflowDtoInterface)dto)) {
            return statuses.contains("31");
        }
        return false;
    }

    public static <T extends WorkflowNumberDtoInterface> Set<T> getRequests(Collection<T> dtos, Map<Long, WorkflowDtoInterface> workflows, Set<String> statuses) {
        LinkedHashSet<WorkflowNumberDtoInterface> requests = new LinkedHashSet<WorkflowNumberDtoInterface>();
        if (MospUtility.isEmpty((Object[])new Object[]{dtos, workflows, statuses})) {
            return requests;
        }
        for (WorkflowNumberDtoInterface dto : dtos) {
            if (!WorkflowUtility.isMatch((WorkflowDtoInterface)workflows.get(dto.getWorkflow()), statuses)) continue;
            requests.add(dto);
        }
        return requests;
    }

    public static <T extends WorkflowNumberDtoInterface> T getRequest(T dto, Map<Long, WorkflowDtoInterface> workflows, Set<String> statuses) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto, workflows, statuses})) {
            return null;
        }
        if (WorkflowUtility.isMatch((WorkflowDtoInterface)workflows.get(dto.getWorkflow()), statuses)) {
            return dto;
        }
        return null;
    }

    public static Set<String> getEffectiveStatuses() {
        Set statuses = WorkflowUtility.getAllStatuses();
        statuses.remove("0");
        statuses.remove("5");
        return statuses;
    }

    public static Set<String> getEffectiveWithoutCompletedStatuses() {
        Set statuses = WorkflowUtility.getEffectiveStatuses();
        statuses.remove("9");
        return statuses;
    }

    public static Set<String> getAppliedStatuses() {
        Set statuses = WorkflowUtility.getAllStatuses();
        statuses.remove("0");
        statuses.remove("5");
        statuses.remove("3");
        statuses.add("31");
        return statuses;
    }

    public static Set<String> getCompletedStatuses() {
        HashSet<String> statuses = new HashSet<String>();
        statuses.add("9");
        return statuses;
    }

    public static Set<String> getCompletedOrAppliedStatuses(boolean isCompleted) {
        return isCompleted ? WorkflowUtility.getCompletedStatuses() : WorkflowUtility.getAppliedStatuses();
    }

    public static Set<String> getStatusesExceptWithDrawn() {
        Set statuses = WorkflowUtility.getAllStatuses();
        statuses.remove("5");
        return statuses;
    }

    public static Set<String> getAllStatuses() {
        HashSet<String> statuses = new HashSet<String>();
        statuses.add("9");
        statuses.add("7");
        statuses.add("6");
        statuses.add("5");
        statuses.add("4");
        statuses.add("3");
        statuses.add("2");
        statuses.add("1");
        statuses.add("0");
        return statuses;
    }

    public static WorkflowDtoInterface getLowestWorkflow(WorkflowDtoInterface ... dtos) {
        if (dtos == null || dtos.length == 0) {
            return null;
        }
        ArrayList<WorkflowDtoInterface> list = new ArrayList<WorkflowDtoInterface>(Arrays.asList(dtos));
        list.removeAll(Collections.singleton(null));
        if (MospUtility.isEmpty(list)) {
            return null;
        }
        Collections.sort(list, (dto1, dto2) -> WorkflowUtility.compareStageAndStatus((WorkflowDtoInterface)dto1, (WorkflowDtoInterface)dto2));
        return (WorkflowDtoInterface)MospUtility.getFirstValue(list);
    }

    public static void sortByStatus(List<? extends WorkflowNumberDtoInterface> dtos, Map<Long, WorkflowDtoInterface> workflows) {
        Collections.sort(dtos, (dto1, dto2) -> WorkflowUtility.compareStageAndStatus((WorkflowDtoInterface)((WorkflowDtoInterface)workflows.get(dto1.getWorkflow())), (WorkflowDtoInterface)((WorkflowDtoInterface)workflows.get(dto2.getWorkflow()))));
    }

    protected static int compareStageAndStatus(WorkflowDtoInterface dto1, WorkflowDtoInterface dto2) {
        int status1 = MospUtility.getInt((Object)dto1.getWorkflowStatus());
        int status2 = MospUtility.getInt((Object)dto2.getWorkflowStatus());
        int stage1 = dto1.getWorkflowStage();
        int stage2 = dto2.getWorkflowStage();
        int status = status1 - status2;
        if (status != 0) {
            return status;
        }
        return stage1 - stage2;
    }

    public static Map<Long, WorkflowDtoInterface> getWorkflowMap(Collection<WorkflowDtoInterface> workflows) {
        TreeMap<Long, WorkflowDtoInterface> workflowMap = new TreeMap<Long, WorkflowDtoInterface>();
        for (WorkflowDtoInterface dto : workflows) {
            workflowMap.put(dto.getWorkflow(), dto);
        }
        return workflowMap;
    }

    public static Map<Long, WorkflowDtoInterface> getWorkflowMap(Collection<WorkflowDtoInterface> workflows, Set<String> functionCodes) {
        TreeMap<Long, WorkflowDtoInterface> workflowMap = new TreeMap<Long, WorkflowDtoInterface>();
        for (WorkflowDtoInterface dto : workflows) {
            if (!functionCodes.contains(dto.getFunctionCode())) continue;
            workflowMap.put(dto.getWorkflow(), dto);
        }
        return workflowMap;
    }

    public static boolean isSelfApprove(WorkflowDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return MospUtility.isEqual((Object)dto.getApproverId(), (Object)"SELF_APPRO") || MospUtility.isEqual((Object)dto.getRouteCode(), (Object)"SELF_APPRO");
    }

    public static <T extends WorkflowNumberDtoInterface> Set<T> getStatusMatchedDtos(Collection<T> dtos, Map<Long, WorkflowDtoInterface> workflows, Set<String> statuses) {
        LinkedHashSet<WorkflowNumberDtoInterface> statusMatchedDtos = new LinkedHashSet<WorkflowNumberDtoInterface>();
        if (MospUtility.isEmpty((Object[])new Object[]{dtos, statuses})) {
            return statusMatchedDtos;
        }
        for (WorkflowNumberDtoInterface dto : dtos) {
            if (!WorkflowUtility.isMatch((WorkflowDtoInterface)workflows.get(dto.getWorkflow()), statuses)) continue;
            statusMatchedDtos.add(dto);
        }
        return statusMatchedDtos;
    }

    public static <T extends WorkflowNumberDtoInterface> List<T> getStatusMatchedList(Collection<T> dtos, Map<Long, WorkflowDtoInterface> workflows, Set<String> statuses) {
        return new ArrayList(WorkflowUtility.getStatusMatchedDtos(dtos, workflows, statuses));
    }

    public static String getWorkflowStatus(MospParams mospParams, WorkflowDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        return WorkflowUtility.getWorkflowStatus((MospParams)mospParams, (String)dto.getWorkflowStatus(), (int)dto.getWorkflowStage());
    }

    public static String getWorkflowStatus(MospParams mospParams, String status, int stage) {
        if ("0".equals(status)) {
            return PfNameUtility.draft((MospParams)mospParams);
        }
        if ("1".equals(status)) {
            return PfNameUtility.notApproved((MospParams)mospParams);
        }
        if ("4".equals(status)) {
            return PfNameUtility.cancelApprovalAbbr((MospParams)mospParams);
        }
        if ("5".equals(status)) {
            return PfNameUtility.withdraw((MospParams)mospParams);
        }
        if ("9".equals(status)) {
            return PfNameUtility.completed((MospParams)mospParams);
        }
        if ("6".equals(status) || "7".equals(status)) {
            return PfNameUtility.canelApplyAbbr((MospParams)mospParams);
        }
        if ("2".equals(status)) {
            return PfNameUtility.stageApproved((MospParams)mospParams, (int)(stage - 1));
        }
        if ("3".equals(status)) {
            return PfNameUtility.stageReverted((MospParams)mospParams, (int)(stage + 1));
        }
        return status;
    }
}

