/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MenuUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.ActivateDtoInterface;
import jp.mosp.platform.base.CodeDtoInterface;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.base.PlatformVo;
import jp.mosp.platform.base.RecordDtoInterface;
import jp.mosp.platform.comparator.base.ActivateDateComparator;
import jp.mosp.platform.dto.base.ApplicationMasterDtoInterface;
import jp.mosp.platform.dto.base.PersonalIdDtoInterface;
import jp.mosp.platform.dto.base.WorkflowNumberDtoInterface;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.WorkflowUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class PlatformUtility {
    public static final String MAIN_MENU_WORKFLOW_MANAGE = "menuWorkflowManage";
    public static final String MENU_UNIT_LIST = "UnitList";
    public static final String TABLE_TYPE_UNIT_SECTION = "unit_section";
    public static final String TABLE_TYPE_UNIT_PERSON = "unit_person";

    private PlatformUtility() {
    }

    public static String getSortMark(String sortKey, MospParams mospParams) {
        return PlatformUtility.getSortMark((String)sortKey, (MospParams)mospParams, (boolean)false);
    }

    public static String getSortMark(String sortKey, MospParams mospParams, boolean needBlank) {
        PlatformVo vo = (PlatformVo)mospParams.getVo();
        if (!sortKey.equals(vo.getComparatorName())) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (needBlank) {
            sb.append(" ");
        }
        String sortMark = PfNameUtility.lowerTriangular((MospParams)mospParams);
        if (vo.isAscending()) {
            sortMark = PfNameUtility.upperTriangular((MospParams)mospParams);
        }
        return sb.append(sortMark).toString();
    }

    public static Set<String> getPersonalIdSet(List<? extends PersonalIdDtoInterface> list) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (PersonalIdDtoInterface personalIdDtoInterface : list) {
            set.add(personalIdDtoInterface.getPersonalId());
        }
        return set;
    }

    public static <T extends PersonalIdDtoInterface> Map<String, Set<T>> getPersonalIdMap(Collection<T> dtos) {
        TreeMap<String, Set<T>> map = new TreeMap<String, Set<T>>();
        for (PersonalIdDtoInterface dto : dtos) {
            String personalId = dto.getPersonalId();
            LinkedHashSet<PersonalIdDtoInterface> set = (LinkedHashSet<PersonalIdDtoInterface>)map.get(personalId);
            if (set == null) {
                set = new LinkedHashSet<PersonalIdDtoInterface>();
                map.put(personalId, set);
            }
            set.add(dto);
        }
        return map;
    }

    public static <T extends PersonalIdDtoInterface> Map<String, T> getPersonalIdDtoMap(Collection<T> dtos) {
        TreeMap<String, PersonalIdDtoInterface> map = new TreeMap<String, PersonalIdDtoInterface>();
        for (PersonalIdDtoInterface dto : dtos) {
            map.put(dto.getPersonalId(), dto);
        }
        return map;
    }

    public static <T extends PersonalIdDtoInterface & WorkflowNumberDtoInterface> Map<String, T> getPersonalIdDtoMap(Collection<T> dtos, Map<Long, WorkflowDtoInterface> workflows, Set<String> statuses) {
        return PlatformUtility.getPersonalIdDtoMap((Collection)WorkflowUtility.getStatusMatchedDtos(dtos, workflows, statuses));
    }

    public static <T extends ActivateDtoInterface> Map<Date, Set<T>> getActivateDateMap(Collection<T> dtos) {
        TreeMap<Date, Set<T>> map = new TreeMap<Date, Set<T>>();
        for (ActivateDtoInterface dto : dtos) {
            Date activateDate = dto.getActivateDate();
            LinkedHashSet<ActivateDtoInterface> set = (LinkedHashSet<ActivateDtoInterface>)map.get(activateDate);
            if (set == null) {
                set = new LinkedHashSet<ActivateDtoInterface>();
                map.put(activateDate, set);
            }
            set.add(dto);
        }
        return map;
    }

    public static Date getLatestActivateDate(Set<? extends ActivateDtoInterface> set, Date targetDate) {
        ArrayList<? extends ActivateDtoInterface> list = new ArrayList<ActivateDtoInterface>(set);
        Collections.sort(list, new ActivateDateComparator());
        return PlatformUtility.getLatestActivateDate(list, (Date)targetDate);
    }

    public static Date getLatestActivateDate(List<? extends ActivateDtoInterface> list, Date targetDate) {
        ActivateDtoInterface latestDto = PlatformUtility.getLatestDto(list, (Date)targetDate);
        if (latestDto == null) {
            return null;
        }
        return latestDto.getActivateDate();
    }

    public static <T extends ActivateDtoInterface> T getLatestDto(List<T> list, Date targetDate) {
        if (targetDate == null || list == null) {
            return null;
        }
        ActivateDtoInterface latestDto = null;
        for (ActivateDtoInterface dto : list) {
            if (targetDate.before(dto.getActivateDate())) continue;
            latestDto = dto;
        }
        return (T)latestDto;
    }

    public static <T extends PlatformDtoInterface> T getLatestActiveDto(List<T> list, Date targetDate) {
        if (targetDate == null || list == null) {
            return null;
        }
        PlatformDtoInterface latestActiveDto = null;
        for (PlatformDtoInterface dto : list) {
            if (targetDate.before(dto.getActivateDate()) || !PlatformUtility.isDtoActivate((PlatformDtoInterface)dto)) continue;
            latestActiveDto = dto;
        }
        return (T)latestActiveDto;
    }

    public static ActivateDtoInterface getDto(List<? extends ActivateDtoInterface> list, Date activateDate) {
        if (activateDate == null || list == null) {
            return null;
        }
        for (ActivateDtoInterface activateDtoInterface : list) {
            if (activateDate.compareTo(activateDtoInterface.getActivateDate()) != 0) continue;
            return activateDtoInterface;
        }
        return null;
    }

    public static <T extends CodeDtoInterface> T getCodeDto(Collection<T> dtos, String code) {
        if (MospUtility.isEmpty((Object[])new Object[]{dtos, code})) {
            return null;
        }
        for (CodeDtoInterface dto : dtos) {
            if (MospUtility.isEmpty((Object[])new Object[]{dto}) || !MospUtility.isEqual((Object)code, (Object)dto.getCode())) continue;
            return (T)dto;
        }
        return null;
    }

    public static <T extends CodeDtoInterface> Set<T> getCodeDtos(Collection<T> dtos, String code) {
        LinkedHashSet<CodeDtoInterface> set = new LinkedHashSet<CodeDtoInterface>();
        if (MospUtility.isEmpty((Object[])new Object[]{dtos, code})) {
            return set;
        }
        for (CodeDtoInterface dto : dtos) {
            if (MospUtility.isEmpty((Object[])new Object[]{dto}) || !MospUtility.isEqual((Object)code, (Object)dto.getCode())) continue;
            set.add(dto);
        }
        return set;
    }

    public static <T extends CodeDtoInterface & ActivateDtoInterface> Map<String, Map<Date, T>> getCodeActivateMap(Collection<T> dtos) throws MospException {
        TreeMap<String, Map<Date, T>> codeActivateMap = new TreeMap<String, Map<Date, T>>();
        for (CodeDtoInterface dto : dtos) {
            String code = dto.getCode();
            Date activateDate = ((ActivateDtoInterface)dto).getActivateDate();
            Map activateMap = MospUtility.getMapValue(codeActivateMap, (Object)code, TreeMap.class);
            activateMap.put(activateDate, dto);
        }
        return codeActivateMap;
    }

    public static <T extends CodeDtoInterface & ActivateDtoInterface, K extends CodeDtoInterface & ActivateDtoInterface> Optional<Set<T>> getCodeActivateDtos(Map<String, Map<Date, Set<T>>> dtos, K dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dtos, dto})) {
            return Optional.ofNullable(null);
        }
        return PlatformUtility.getCodeActivateDtos(dtos, (String)dto.getCode(), (Date)((ActivateDtoInterface)dto).getActivateDate());
    }

    public static <T extends CodeDtoInterface & ActivateDtoInterface> Optional<Set<T>> getCodeActivateDtos(Map<String, Map<Date, Set<T>>> dtos, String code, Date activateDate) {
        Map<Date, Set<T>> activateMap = dtos.get(code);
        if (MospUtility.isEmpty(activateMap)) {
            return Optional.ofNullable(null);
        }
        return Optional.ofNullable(activateMap.get(activateDate));
    }

    public static <T extends CodeDtoInterface & ActivateDtoInterface> Set<T> getActivateDtos(Map<String, Map<Date, T>> dtos, Date targetDate) {
        LinkedHashSet<CodeDtoInterface> activeDtos = new LinkedHashSet<CodeDtoInterface>();
        for (Map<Date, T> map : dtos.values()) {
            CodeDtoInterface dto = (CodeDtoInterface)PlatformUtility.getLatestDto(new ArrayList<T>(map.values()), (Date)targetDate);
            if (MospUtility.isEmpty((Object[])new Object[]{dto})) continue;
            activeDtos.add(dto);
        }
        return activeDtos;
    }

    public static <T, K1, K2> Set<T> getDtoSet(Map<K1, Map<K2, T>> dtos) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (Map<K2, T> map : dtos.values()) {
            for (T dto : map.values()) {
                set.add(dto);
            }
        }
        return set;
    }

    public static <T extends RecordDtoInterface> Map<Long, T> getRecordDtoMap(Collection<T> dtos) {
        LinkedHashMap<Long, RecordDtoInterface> map = new LinkedHashMap<Long, RecordDtoInterface>();
        for (RecordDtoInterface dto : dtos) {
            map.put(dto.getRecordId(), dto);
        }
        return map;
    }

    public static long[] getRecordIds(Collection<? extends RecordDtoInterface> dtos) {
        long[] recordIds = new long[dtos.size()];
        int idx = 0;
        for (RecordDtoInterface recordDtoInterface : dtos) {
            recordIds[idx++] = recordDtoInterface.getRecordId();
        }
        return recordIds;
    }

    public static long next(String format, long min, long max, Set<String> set) {
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        Collections.reverse(list);
        DecimalFormat decimalFormat = new DecimalFormat(format);
        for (String str : list) {
            if (str.length() != format.length()) continue;
            long seq = 0L;
            try {
                seq = decimalFormat.parse(str).longValue();
            }
            catch (Throwable t) {
                continue;
            }
            if (max < seq) continue;
            if (max == seq) {
                return max;
            }
            if (seq < min) {
                return min;
            }
            return seq + 1L;
        }
        return min;
    }

    public static ApplicationMasterDtoInterface getApplicationMaster(HumanDtoInterface humanDto, Set<? extends ApplicationMasterDtoInterface> personSet, Set<? extends ApplicationMasterDtoInterface> masterSet) {
        ApplicationMasterDtoInterface dto = null;
        if (humanDto == null) {
            return dto;
        }
        String personalId = humanDto.getPersonalId();
        String positionCode = humanDto.getPositionCode();
        String sectionCode = humanDto.getSectionCode();
        String employmentContractCode = humanDto.getEmploymentContractCode();
        String workPlaceCode = humanDto.getWorkPlaceCode();
        String blank = "";
        dto = PlatformUtility.getApplicationPerson(personSet, (String)personalId);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)employmentContractCode, (String)sectionCode, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)employmentContractCode, (String)sectionCode, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)sectionCode, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)blank, (String)positionCode);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)employmentContractCode, (String)sectionCode, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)employmentContractCode, (String)sectionCode, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)sectionCode, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)employmentContractCode, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)employmentContractCode, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)workPlaceCode, (String)blank, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        dto = PlatformUtility.getApplicationMaster(masterSet, (String)blank, (String)blank, (String)blank, (String)blank);
        if (dto != null) {
            return dto;
        }
        return dto;
    }

    protected static ApplicationMasterDtoInterface getApplicationPerson(Set<? extends ApplicationMasterDtoInterface> personSet, String personalId) {
        for (ApplicationMasterDtoInterface applicationMasterDtoInterface : personSet) {
            String personalIds = applicationMasterDtoInterface.getPersonalIds();
            if (!personalIds.contains(personalId)) continue;
            return applicationMasterDtoInterface;
        }
        return null;
    }

    protected static ApplicationMasterDtoInterface getApplicationMaster(Set<? extends ApplicationMasterDtoInterface> masterSet, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) {
        for (ApplicationMasterDtoInterface applicationMasterDtoInterface : masterSet) {
            if (!applicationMasterDtoInterface.getWorkPlaceCode().equals(workPlaceCode) || !applicationMasterDtoInterface.getEmploymentContractCode().equals(employmentContractCode) || !applicationMasterDtoInterface.getSectionCode().equals(sectionCode) || !applicationMasterDtoInterface.getPositionCode().equals(positionCode)) continue;
            return applicationMasterDtoInterface;
        }
        return null;
    }

    public static boolean isSectionDisplayName(MospParams mospParams) {
        String useDisplayName = mospParams.getApplicationProperty("SectionPulldownName");
        return MospUtility.isEqual((Object)useDisplayName, (Object)"Display");
    }

    public static String[][] getTableTypeArray(MospParams mospParams, String tableTypeCodeKey, boolean needBlank) {
        String[][] codeArray = MospUtility.getCodeArray((MospParams)mospParams, (String)tableTypeCodeKey, (boolean)needBlank);
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (String[] array : codeArray) {
            if (!PlatformUtility.isTheTableTypeAvailable((MospParams)mospParams, (String)array[0])) continue;
            list.add(array);
        }
        return (String[][])list.toArray((T[])new String[list.size()][]);
    }

    protected static boolean isTheTableTypeAvailable(MospParams mospParams, String tableType) {
        if (tableType == null) {
            return false;
        }
        return !tableType.equals("unit_section") && !tableType.equals("unit_person") || PlatformUtility.isUnitListAvailable((MospParams)mospParams);
    }

    protected static boolean isUnitListAvailable(MospParams mospParams) {
        return MenuUtility.isTheMenuAvailable((MospParams)mospParams, (String)"menuWorkflowManage", (String)"UnitList");
    }

    public static boolean isFlagOff(int flag) {
        return flag == 0;
    }

    public static boolean isFlagOn(int flag) {
        return flag == 1;
    }

    public static boolean isInactivate(int inactivateFlag) {
        return inactivateFlag == 1;
    }

    public static boolean isActivate(int inactivateFlag) {
        return inactivateFlag == 0;
    }

    public static boolean isActivateDateChanging(String modeActivateDate) {
        return MospUtility.isEqual((Object)modeActivateDate, (Object)"chaning");
    }

    public static boolean isTheFunction(WorkflowDtoInterface dto, String functionCode) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return MospUtility.isEqual((Object)dto.getFunctionCode(), (Object)functionCode);
    }

    public static boolean isDtoActivate(PlatformDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return dto.getInactivateFlag() == 0;
    }

    public static boolean isDtoDeleted(BaseDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return true;
        }
        return dto.getDeleteFlag() == 1;
    }

    public static boolean isForwardMatch(String condition, String value) {
        return value.startsWith(condition);
    }

    public static boolean isBackwardMatch(String condition, String value) {
        return value.endsWith(condition);
    }

    public static boolean isBroadMatch(String condition, String value) {
        return value.indexOf(condition) >= 0;
    }

    public static boolean isExactMatch(String condition, String value) {
        return value.equals(condition);
    }

    public static String getExportFileName(MospParams mospParams, String fileName, Date targetDate, boolean isDate) {
        StringBuilder sb = new StringBuilder();
        sb.append(DateUtility.getStringYear((Date)targetDate)).append(DateUtility.getStringMonth((Date)targetDate));
        if (isDate) {
            sb.append(DateUtility.getStringDay((Date)targetDate));
        }
        sb.append(PfNameUtility.hyphen((MospParams)mospParams));
        sb.append(fileName);
        return sb.toString();
    }

    public static String getFileExtension(ExportDtoInterface dto) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        if (MospUtility.isEqual((Object)"1", (Object)dto.getType())) {
            return ".csv";
        }
        return "";
    }

    public static void setCsvValue(String[] csvData, List<String> fieldList, String fieldName, Object value) {
        if (MospUtility.isEmpty((Object[])new Object[]{csvData, fieldList, fieldName, value})) {
            return;
        }
        int idx = fieldList.indexOf(fieldName);
        if (!MospUtility.isIndexValid((int)idx, (String[])csvData)) {
            return;
        }
        csvData[idx] = MospUtility.getString((Object)value);
    }

    public static boolean isTheFieldExit(List<String> fieldList, String ... fieldNames) {
        if (MospUtility.isEmpty(fieldList)) {
            return false;
        }
        for (String fieldName : fieldNames) {
            int idx = fieldList.indexOf(fieldName);
            if (!MospUtility.isIndexValid((int)idx)) continue;
            return true;
        }
        return false;
    }

    public static String[][] getInputActivateDatePulldown(MospParams mospParams) {
        String[][] aryPulldown = new String[][]{{"", PfNameUtility.inputActiveDate((MospParams)mospParams)}};
        return aryPulldown;
    }

    public static String getRedOrBlueClassName(boolean isBlue, boolean isRed) {
        if (isRed) {
            return "FontRed";
        }
        if (isBlue) {
            return "FontBlue";
        }
        return "";
    }

    public static <T extends BaseDtoInterface> T cloneBaseDto(T dto) throws MospException {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return null;
        }
        BaseDtoInterface clone = (BaseDtoInterface)PlatformUtility.castObject((Object)InstanceFactory.getNewInstance(dto.getClass()));
        clone.setDeleteFlag(dto.getDeleteFlag());
        clone.setInsertDate(dto.getInsertDate());
        clone.setInsertUser(dto.getInsertUser());
        clone.setUpdateDate(dto.getUpdateDate());
        clone.setUpdateUser(dto.getUpdateUser());
        return (T)clone;
    }

    public static <T> T castObject(Object obj) {
        return (T)MospUtility.castObject((Object)obj);
    }

    public static <T> List<T> castList(List<?> list) {
        ArrayList newList = new ArrayList();
        for (Object obj : list) {
            newList.add(obj);
        }
        return newList;
    }
}

