/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;

/*
 * Exception performing whole class analysis ignored.
 */
public class IpAddressUtility {
    protected static final String APP_AVAILABLE_CIDRS = "AvailableCidrs";
    protected static final String REG_IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    protected static final String REG_CIDR = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})";
    protected static final int MAX_DOT_ADDRESS = 255;
    protected static final int MIN_DOT_ADDRESS = 0;
    protected static final int MAX_CIDR_PART = 32;
    protected static final int MIN_CIDR_PART = 0;

    public static boolean isAddressAvailable(MospParams mospParams, String attAvailableCidrs) throws MospException {
        String[] cidrs;
        String ipAddress = String.valueOf(mospParams.getGeneralParam("REMOTE-ADDR"));
        if (mospParams.getApplicationProperty(attAvailableCidrs) == null) {
            return true;
        }
        if (!IpAddressUtility.isIpAddressValid((String)ipAddress)) {
            return false;
        }
        for (String cidr : cidrs = mospParams.getApplicationProperties(attAvailableCidrs)) {
            if (!IpAddressUtility.isCidrValid((String)cidr)) {
                mospParams.setErrorViewUrl();
                throw new MospException("PFW0102", attAvailableCidrs);
            }
            if (!IpAddressUtility.isAddressInRange((String)ipAddress, (String)cidr)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAddressAvailable(MospParams mospParams) throws MospException {
        return IpAddressUtility.isAddressAvailable((MospParams)mospParams, (String)"AvailableCidrs");
    }

    protected static boolean isAddressInRange(String ipAddress, String cidr) {
        int address = IpAddressUtility.getIntAddress((String)ipAddress);
        int addressPart = IpAddressUtility.getIntAddressPart((String)cidr);
        int netmask = IpAddressUtility.getNetMask((String)cidr);
        if (netmask == 0) {
            return true;
        }
        int minAddress = addressPart & netmask;
        int maxAddress = minAddress | ~netmask;
        return IpAddressUtility.isValueInRange((int)address, (int)minAddress, (int)maxAddress);
    }

    protected static boolean isIpAddressValid(String ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        Matcher matcher = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})").matcher(ipAddress);
        if (!matcher.matches()) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int dotAddress = Integer.parseInt(matcher.group(i + 1));
            if (IpAddressUtility.isValueInRange((int)dotAddress, (int)0, (int)255)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isCidrValid(String cidr) {
        if (cidr == null) {
            return false;
        }
        Matcher matcher = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})").matcher(cidr);
        if (!matcher.matches()) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int dotAddress = Integer.parseInt(matcher.group(i + 1));
            if (IpAddressUtility.isValueInRange((int)dotAddress, (int)0, (int)255)) continue;
            return false;
        }
        int cidrPart = Integer.parseInt(matcher.group(5));
        return IpAddressUtility.isValueInRange((int)cidrPart, (int)0, (int)32);
    }

    protected static int getIntAddress(String ipAddress) {
        return IpAddressUtility.getIntAddress((Matcher)Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})").matcher(ipAddress));
    }

    protected static int getIntAddressPart(String cidr) {
        return IpAddressUtility.getIntAddress((Matcher)Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})").matcher(cidr));
    }

    protected static int getIntAddress(Matcher matcher) {
        if (!matcher.matches()) {
            return 0;
        }
        int address = 0;
        for (int i = 0; i < 4; ++i) {
            int dotAddress = Integer.parseInt(matcher.group(i + 1));
            address |= (dotAddress &= 0xFF) << 8 * (4 - i - 1);
        }
        return address;
    }

    protected static int getNetMask(String cidr) {
        Matcher matcher = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})").matcher(cidr);
        if (!matcher.matches()) {
            return 0;
        }
        int cidrPart = Integer.parseInt(matcher.group(5));
        int netMask = 0;
        for (int i = 0; i < cidrPart; ++i) {
            netMask |= 1 << 31 - i;
        }
        return netMask;
    }

    protected static boolean isValueInRange(int value, int min, int max) {
        if (max < value) {
            return false;
        }
        return value >= min;
    }
}

