/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.utils;

import java.util.Date;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.ValidateUtility;
import jp.mosp.platform.utils.PfMessageUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class InputCheckUtility {
    public static void checkRequired(MospParams mospParams, Object targetValue, String fieldName) {
        if (!ValidateUtility.chkRequired((Object)targetValue)) {
            PfMessageUtility.addErrorRequired((MospParams)mospParams, (String)fieldName);
        }
    }

    public static void checkTypeCodeGeneral(MospParams mospParams, String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[A-Za-z0-9]*", (String)value)) {
            PfMessageUtility.addErrorCheckAlpNum((MospParams)mospParams, (String)fieldName, (Integer)row);
        }
    }

    public static void checkTypeKanaGeneral(MospParams mospParams, String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[\uff61-\uff9f -~]*", (String)value)) {
            PfMessageUtility.addErrorCheckForm((MospParams)mospParams, (String)fieldName, (Integer)row);
        }
    }

    public static void checkNumber(MospParams mospParams, String value, String fieldName) {
        String reqValue = value;
        if (reqValue == null) {
            reqValue = String.valueOf(0);
        }
        if (!InputCheckUtility.chkNumber((String)reqValue)) {
            PfMessageUtility.addErrorCheckNumeric((MospParams)mospParams, (String)fieldName);
        }
    }

    public static void checkCode(MospParams mospParams, String value, String fieldName) {
        String reqValue = value;
        if (reqValue == null) {
            reqValue = "";
        }
        if (!InputCheckUtility.chkCode((String)reqValue)) {
            PfMessageUtility.addErrorCheckAlpNum((MospParams)mospParams, (String)fieldName);
        }
    }

    public static void checkDate(MospParams mospParams, int year, int month, int day, String fieldName) {
        if (!ValidateUtility.chkDate((int)year, (int)(month - 1), (int)day)) {
            PfMessageUtility.addErrorCheckDate((MospParams)mospParams, (String)fieldName);
        }
    }

    public static void checkDate(MospParams mospParams, String year, String month, String day, String fieldName) {
        try {
            InputCheckUtility.checkDate((MospParams)mospParams, (int)Integer.parseInt(year), (int)Integer.parseInt(month), (int)Integer.parseInt(day), (String)fieldName);
        }
        catch (NumberFormatException e) {
            PfMessageUtility.addErrorCheckDate((MospParams)mospParams, (String)fieldName);
        }
    }

    public static void checkDateGeneral(MospParams mospParams, String year, String month, String day, String[] fieldName) {
        if (year == null || month == null || day == null) {
            return;
        }
        if (year.isEmpty() && month.isEmpty() && day.isEmpty()) {
            return;
        }
        try {
            String fieldName1 = fieldName[0];
            String fieldName2 = fieldName[0];
            String fieldName3 = fieldName[0];
            if (fieldName.length == 3) {
                fieldName2 = fieldName[1];
                fieldName3 = fieldName[2];
            }
            InputCheckUtility.checkYear((MospParams)mospParams, (String)year, (String)fieldName1);
            if (mospParams.hasErrorMessage()) {
                return;
            }
            InputCheckUtility.checkMonth((MospParams)mospParams, (String)month, (String)fieldName2);
            if (mospParams.hasErrorMessage()) {
                return;
            }
            if (!InputCheckUtility.chkNumber((String)day)) {
                PfMessageUtility.addErrorCheckForm((MospParams)mospParams, (String[])new String[]{fieldName3});
                return;
            }
            if (!ValidateUtility.chkDate((int)Integer.parseInt(year), (int)(Integer.parseInt(month) - 1), (int)Integer.parseInt(day))) {
                PfMessageUtility.addErrorCheckForm((MospParams)mospParams, (String[])fieldName);
                return;
            }
        }
        catch (NumberFormatException e) {
            PfMessageUtility.addErrorCheckForm((MospParams)mospParams, (String[])fieldName);
        }
    }

    public static void checkYear(MospParams mospParams, String year, String fieldName) {
        try {
            if (!InputCheckUtility.chkNumber((String)year)) {
                PfMessageUtility.addErrorCheckForm((MospParams)mospParams, (String[])new String[]{fieldName});
                return;
            }
            if (!ValidateUtility.chkLength((String)year, (int)4)) {
                PfMessageUtility.addErrorCheckDigit((MospParams)mospParams, (String)fieldName, (int)4);
                return;
            }
            if (Integer.parseInt(year) < 1000) {
                PfMessageUtility.addErrorCheckYesr((MospParams)mospParams, (int)1000);
                return;
            }
        }
        catch (NumberFormatException e) {
            PfMessageUtility.addErrorCheckForm((MospParams)mospParams, (String[])new String[]{fieldName});
        }
    }

    public static void checkMonth(MospParams mospParams, String month, String fieldName) {
        try {
            if (!InputCheckUtility.chkNumber((String)month)) {
                PfMessageUtility.addErrorCheckForm((MospParams)mospParams, (String[])new String[]{fieldName});
                return;
            }
            if (!ValidateUtility.chkLength((String)month, (int)2)) {
                PfMessageUtility.addErrorCheckDigit((MospParams)mospParams, (String)fieldName, (int)2);
                return;
            }
            if (Integer.parseInt(month) < 1) {
                PfMessageUtility.addErrorUnderLimit((MospParams)mospParams, (String)fieldName, (int)1, null);
            }
            if (Integer.parseInt(month) > 12) {
                PfMessageUtility.addErrorOverLimit((MospParams)mospParams, (String)fieldName, (int)12, null);
            }
        }
        catch (NumberFormatException e) {
            PfMessageUtility.addErrorCheckForm((MospParams)mospParams, (String[])new String[]{fieldName});
        }
    }

    public static void checkDateOrder(MospParams mospParams, Date beforeDate, Date afterDate, String beforName, String afterName) {
        if (MospUtility.isEmpty((Object[])new Object[]{beforeDate, afterDate})) {
            return;
        }
        if (beforeDate.after(afterDate)) {
            PfMessageUtility.addErrorDateOrder((MospParams)mospParams, (String)afterName, (String)beforName);
        }
    }

    public static void checkMaxDigit(MospParams mospParams, int value, int maxDigit, String filedName, Integer row) {
        if (ValidateUtility.chkLength((String)MospUtility.getString((Object)value), (int)maxDigit)) {
            return;
        }
        PfMessageUtility.addErrorOverDigit((MospParams)mospParams, (String)filedName, (int)maxDigit, (Integer)row);
    }

    public static void checkLength(MospParams mospParams, String value, int maxLength, String targetName) {
        if (value == null) {
            return;
        }
        if (!ValidateUtility.chkLength((String)value, (int)maxLength)) {
            PfMessageUtility.addErrorCheckDigit((MospParams)mospParams, (String)targetName, (int)maxLength);
        }
    }

    public static void checDecimal(MospParams mospParams, double value, int integerDigit, int decimalDigit, String fieldName, Integer row) {
        if (ValidateUtility.chkDecimal((double)value, (int)integerDigit, (int)decimalDigit)) {
            return;
        }
        PfMessageUtility.addErrorInvalidDecimal((MospParams)mospParams, (String)fieldName, (int)integerDigit, (int)decimalDigit, (Integer)row);
    }

    private static boolean chkCode(String value) {
        return ValidateUtility.chkRegex((String)"\\w*", (String)value);
    }

    private static boolean chkNumber(String value) {
        return ValidateUtility.chkRegex((String)"\\d*", (String)value);
    }
}

