/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.system.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.system.EmploymentContractRegistBeanInterface;
import jp.mosp.platform.bean.system.EmploymentContractSearchBeanInterface;
import jp.mosp.platform.comparator.base.EmploymentContractCodeComparator;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;
import jp.mosp.platform.system.base.PlatformSystemAction;
import jp.mosp.platform.system.vo.EmploymentMasterVo;
import jp.mosp.platform.utils.PfMessageUtility;

public class EmploymentMasterAction
extends PlatformSystemAction {
    public static final String CMD_SHOW = "PF2100";
    public static final String CMD_SEARCH = "PF2102";
    public static final String CMD_SORT = "PF2104";
    public static final String CMD_PAGE = "PF2105";
    public static final String CMD_REGIST = "PF2107";
    public static final String CMD_DELETE = "PF2109";
    public static final String CMD_INSERT_MODE = "PF2111";
    public static final String CMD_EDIT_MODE = "PF2112";
    public static final String CMD_ADD_MODE = "PF2113";
    public static final String CMD_BATCH_UPDATE = "PF2114";

    protected BaseVo getSpecificVo() {
        return new EmploymentMasterVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_INSERT_MODE)) {
            this.prepareVo();
            this.insertMode();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_MODE)) {
            this.prepareVo();
            this.editMode();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_MODE)) {
            this.prepareVo();
            this.addMode();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_BATCH_UPDATE)) {
            this.prepareVo();
            this.batchUpdate();
        }
    }

    protected void show() throws MospException {
        EmploymentMasterVo vo = (EmploymentMasterVo)this.mospParams.getVo();
        this.initPlatformSystemVoFields();
        vo.setTxtSearchEmploymentCode("");
        vo.setTxtSearchEmploymentAbbr("");
        vo.setTxtSearchEmploymentName("");
        this.insertMode();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(EmploymentContractCodeComparator.class.getName());
    }

    protected void search() throws MospException {
        EmploymentMasterVo vo = (EmploymentMasterVo)this.mospParams.getVo();
        EmploymentContractSearchBeanInterface search = this.reference().employmentContractSearch();
        search.setActivateDate(this.getSearchActivateDate());
        search.setEmploymentCode(vo.getTxtSearchEmploymentCode());
        search.setEmploymentName(vo.getTxtSearchEmploymentName());
        search.setEmploymentAbbr(vo.getTxtSearchEmploymentAbbr());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(EmploymentContractCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        this.initCkbSelect();
        if (list.size() == 0) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    protected void regist() throws MospException {
        EmploymentMasterVo vo = (EmploymentMasterVo)this.mospParams.getVo();
        if (vo.getModeCardEdit().equals("insert")) {
            this.insert();
        } else if (vo.getModeCardEdit().equals("add")) {
            this.add();
        } else if (vo.getModeCardEdit().equals("edit")) {
            this.update();
        }
    }

    protected void insert() throws MospException {
        EmploymentContractRegistBeanInterface regist = this.platform().employmentContractRegist();
        EmploymentContractDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageNewInsertSucceed((MospParams)this.mospParams);
        this.setEditUpdateMode(dto.getEmploymentContractCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void add() throws MospException {
        EmploymentContractRegistBeanInterface regist = this.platform().employmentContractRegist();
        EmploymentContractDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageAddHistorySucceed((MospParams)this.mospParams);
        this.setEditUpdateMode(dto.getEmploymentContractCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void update() throws MospException {
        EmploymentContractRegistBeanInterface regist = this.platform().employmentContractRegist();
        EmploymentContractDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageUpdateFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageEditHistorySucceed((MospParams)this.mospParams);
        this.setEditUpdateMode(dto.getEmploymentContractCode(), dto.getActivateDate());
        this.setSearchActivateDate(this.getEditActivateDate());
        this.search();
    }

    protected void delete() throws MospException {
        EmploymentMasterVo vo = (EmploymentMasterVo)this.mospParams.getVo();
        long[] idArray = this.getIdArray(vo.getCkbSelect());
        this.platform().employmentContractRegist().delete(idArray);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteHistory((MospParams)this.mospParams, (int)idArray.length);
        this.insertMode();
        this.search();
    }

    protected void batchUpdate() throws MospException {
        EmploymentMasterVo vo = (EmploymentMasterVo)this.mospParams.getVo();
        this.platform().employmentContractRegist().update(this.getIdArray(vo.getCkbSelect()), this.getUpdateActivateDate(), this.getInt(vo.getPltUpdateInactivate()));
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageBatchUpdatetFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageUpdatetSucceed((MospParams)this.mospParams);
        this.insertMode();
        this.setSearchActivateDate(this.getUpdateActivateDate());
        this.search();
    }

    protected void insertMode() {
        this.setEditInsertMode();
        EmploymentMasterVo vo = (EmploymentMasterVo)this.mospParams.getVo();
        vo.setTxtEditEmploymentCode("");
        vo.setTxtEditEmploymentAbbr("");
        vo.setTxtEditEmploymentName("");
    }

    protected void addMode() {
        this.setEditAddMode();
    }

    protected void editMode() throws MospException {
        this.setEditUpdateMode(this.getTransferredCode(), this.getDate(this.getTransferredActivateDate()));
    }

    protected void setEditUpdateMode(String employmentContractCode, Date activateDate) throws MospException {
        EmploymentContractDtoInterface dto = this.reference().employmentContract().findForKey(employmentContractCode, activateDate);
        this.checkSelectedDataExist((Object)dto);
        this.setVoFields(dto);
        this.setEditUpdateMode(this.reference().employmentContract().getContractHistory(employmentContractCode));
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        EmploymentMasterVo vo = (EmploymentMasterVo)this.mospParams.getVo();
        long[] aryCkbRecordId = new long[list.size()];
        String[] aryLblActivateDate = new String[list.size()];
        String[] aryLblEmploymentContractCode = new String[list.size()];
        String[] aryLblEmploymentContractName = new String[list.size()];
        String[] aryLblEmploymentContractAbbr = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            EmploymentContractDtoInterface dto = (EmploymentContractDtoInterface)list.get(i);
            aryCkbRecordId[i] = dto.getPfmEmploymentContractId();
            aryLblEmploymentContractCode[i] = dto.getEmploymentContractCode();
            aryLblActivateDate[i] = this.getStringDate(dto.getActivateDate());
            aryLblEmploymentContractName[i] = dto.getEmploymentContractName();
            aryLblEmploymentContractAbbr[i] = dto.getEmploymentContractAbbr();
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryCkbRecordId(aryCkbRecordId);
        vo.setAryLblActivateDate(aryLblActivateDate);
        vo.setAryLblEmploymentCode(aryLblEmploymentContractCode);
        vo.setAryLblEmploymentName(aryLblEmploymentContractName);
        vo.setAryLblEmploymentAbbr(aryLblEmploymentContractAbbr);
        vo.setAryLblInactivate(aryLblInactivate);
    }

    protected void setDtoFields(EmploymentContractDtoInterface dto) {
        EmploymentMasterVo vo = (EmploymentMasterVo)this.mospParams.getVo();
        dto.setPfmEmploymentContractId(vo.getRecordId());
        dto.setEmploymentContractCode(vo.getTxtEditEmploymentCode());
        dto.setActivateDate(this.getEditActivateDate());
        dto.setEmploymentContractName(vo.getTxtEditEmploymentName());
        dto.setEmploymentContractAbbr(vo.getTxtEditEmploymentAbbr());
        dto.setInactivateFlag(this.getInt(vo.getPltEditInactivate()));
    }

    protected void setVoFields(EmploymentContractDtoInterface dto) {
        EmploymentMasterVo vo = (EmploymentMasterVo)this.mospParams.getVo();
        vo.setRecordId(dto.getPfmEmploymentContractId());
        vo.setTxtEditEmploymentCode(dto.getEmploymentContractCode());
        vo.setTxtEditActivateYear(this.getStringYear(dto.getActivateDate()));
        vo.setTxtEditActivateMonth(this.getStringMonth(dto.getActivateDate()));
        vo.setTxtEditActivateDay(this.getStringDay(dto.getActivateDate()));
        vo.setTxtEditEmploymentName(dto.getEmploymentContractName());
        vo.setTxtEditEmploymentAbbr(dto.getEmploymentContractAbbr());
        vo.setPltEditInactivate(String.valueOf(dto.getInactivateFlag()));
    }
}

