/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.portal.action;

import java.util.ArrayList;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.platform.bean.portal.PortalBeanInterface;
import jp.mosp.platform.portal.vo.PortalVo;

public class PortalAction
extends PlatformAction {
    public static final String CMD_SHOW = "PF0040";
    public static final String CMD_AFTER_AUTH = "PF0041";
    public static final String CMD_RE_SHOW = "PF0043";
    public static final String CMD_REGIST = "PF0047";
    public static final String PRM_PORTAL_BEAN_CLASS_NAME = "portalBeanClassName";
    protected static final String APP_AFTER_AUTH_PORTAL_BEANS = "AfterAuthPortalBeans";
    protected static final String APP_PORTAL_BEANS = "PortalBeans";

    public PortalAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new PortalVo();
    }

    protected PortalVo prepareVo(boolean useStoredVo, boolean useParametersMapper) throws MospException {
        PortalVo portalVo = (PortalVo)super.prepareVo(useStoredVo, useParametersMapper);
        if (useParametersMapper) {
            portalVo.setPortalParameters(this.mospParams.getRequestParamsMap());
        }
        return portalVo;
    }

    protected String getTransferredMenuKey() {
        return null;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_AFTER_AUTH)) {
            this.mospParams.getTopicPathList().clear();
            this.prepareVo(false, false);
            this.afterAuthShow();
        } else if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.mospParams.getTopicPathList().clear();
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo(true, true);
            this.regist();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected void afterAuthShow() throws MospException {
        this.showPortalBeans(this.getAfterAuthPortalBeansClassNames());
        if (!this.mospParams.hasErrorMessage()) {
            this.commit();
        }
        this.show();
    }

    protected void show() throws MospException {
        this.showPortalBeans(this.getPortalBeansClassNames());
    }

    protected void showPortalBeans(String[] portalBeansClassNames) throws MospException {
        if (this.mospParams.getStoredInfo().getRangeMap() != null) {
            this.mospParams.getStoredInfo().setRangeMap(null);
        }
        for (String className : portalBeansClassNames) {
            PortalBeanInterface portalBean = this.platform().portal(className);
            List errorMessageList = this.mospParams.getErrorMessageList();
            ArrayList copyList = new ArrayList(errorMessageList);
            errorMessageList.clear();
            portalBean.show();
            errorMessageList.addAll(0, copyList);
        }
    }

    protected void regist() throws MospException {
        PortalVo vo = (PortalVo)this.mospParams.getVo();
        String className = vo.getPortalParameter(PRM_PORTAL_BEAN_CLASS_NAME);
        PortalBeanInterface portalBean = this.platform().portal(className);
        portalBean.regist();
        if (!this.mospParams.hasErrorMessage()) {
            this.commit();
        }
        this.rollback();
        this.show();
    }

    protected String[] getPortalBeansClassNames() {
        String portalBeans = this.mospParams.getApplicationProperty(APP_PORTAL_BEANS);
        return MospUtility.split((String)portalBeans, (String)",");
    }

    protected String[] getAfterAuthPortalBeansClassNames() {
        String afterAuthPortalBeans = this.mospParams.getApplicationProperty(APP_AFTER_AUTH_PORTAL_BEANS);
        return MospUtility.split((String)afterAuthPortalBeans, (String)",");
    }
}

